/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token operator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 241
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  Expr* yy2;
  struct {int value; int mask;} yy47;
  SrcList* yy67;
  ExprList* yy82;
  struct AttachKey yy132;
  struct TrigEvent yy210;
  IdList* yy240;
  struct LimitVal yy244;
  Token yy258;
  TriggerStep* yy347;
  int yy412;
  struct LikeOp yy438;
  Select* yy459;
  int yy481;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 565
#define YYNRULE 305
#define YYERRORSYMBOL 141
#define YYERRSYMDT yy481
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   259,  327,  257,  112,  114,  110,  116,  184,  122,  124,
 /*    10 */   126,  128,  130,  132,  134,  136,  138,  140,  215,  142,
 /*    20 */   150,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*    30 */   140,  130,  132,  134,  136,  138,  140,  108,   94,  143,
 /*    40 */   153,  158,  163,  152,  157,  118,  120,  112,  114,  110,
 /*    50 */   116,  599,  122,  124,  126,  128,  130,  132,  134,  136,
 /*    60 */   138,  140,  260,   96,  219,  258,  122,  124,  126,  128,
 /*    70 */   130,  132,  134,  136,  138,  140,  367,  324,  306,  369,
 /*    80 */   376,  381,  142,   75,   36,  336,   92,  172,  350,  352,
 /*    90 */   353,  384,  167,  331,  169,  170,  271,  393,  229,  106,
 /*   100 */   108,   94,  143,  153,  158,  163,  152,  157,  118,  120,
 /*   110 */   112,  114,  110,  116,   51,  122,  124,  126,  128,  130,
 /*   120 */   132,  134,  136,  138,  140,  797,  428,  430,  429,  341,
 /*   130 */    65,  106,  363,   95,  308,   96,   66,  212,   96,  334,
 /*   140 */    32,   33,   37,  337,   40,   59,   67,   69,  301,  332,
 /*   150 */   354,  142,  339,  342,  267,   75,  334,  383,   75,  231,
 /*   160 */   425,  341,  489,  364,  397,   95,  101,  102,  103,  108,
 /*   170 */    94,  143,  153,  158,  163,  152,  157,  118,  120,  112,
 /*   180 */   114,  110,  116,  314,  122,  124,  126,  128,  130,  132,
 /*   190 */   134,  136,  138,  140,  223,  232,  142,  721,  101,  102,
 /*   200 */   103,  343,  315,  148,  485,  159,  164,  148,  275,  159,
 /*   210 */   164,  229,   51,  467,  108,   94,  143,  153,  158,  163,
 /*   220 */   152,  157,  118,  120,  112,  114,  110,  116,   13,  122,
 /*   230 */   124,  126,  128,  130,  132,  134,  136,  138,  140,   52,
 /*   240 */    77,  142,   40,   59,   67,   69,  301,  332,  642,   13,
 /*   250 */   365,   54,  276,  254,  334,  311,   27,  277,  399,  108,
 /*   260 */    94,  143,  153,  158,  163,  152,  157,  118,  120,  112,
 /*   270 */   114,  110,  116,  261,  122,  124,  126,  128,  130,  132,
 /*   280 */   134,  136,  138,  140,  641,   48,   31,  207,  798,  863,
 /*   290 */   451,   14,   15,  367,   49,  293,  369,  376,  381,  689,
 /*   300 */   210,  246,  211,  360,  358,   50,   13,   46,  384,  257,
 /*   310 */   284,  240,   14,   15,  217,  142,  367,   47,  589,  369,
 /*   320 */   376,  381,   77,  530,  230,    2,  242,  148,    4,  159,
 /*   330 */   164,  384,  193,  108,   94,  143,  153,  158,  163,  152,
 /*   340 */   157,  118,  120,  112,  114,  110,  116,  475,  122,  124,
 /*   350 */   126,  128,  130,  132,  134,  136,  138,  140,  171,   89,
 /*   360 */   142,    6,    5,  457,    3,  563,  248,   25,  459,   14,
 /*   370 */    15,  361,  258,  503,  347,  352,  353,  155,  108,   94,
 /*   380 */   143,  153,  158,  163,  152,  157,  118,  120,  112,  114,
 /*   390 */   110,  116,  247,  122,  124,  126,  128,  130,  132,  134,
 /*   400 */   136,  138,  140,   48,  191,   77,  203,  154,  451,  871,
 /*   410 */     1,  564,   49,  299,    4,   96,  243,  167,   96,  169,
 /*   420 */   170,  565,  259,   50,  257,  197,  144,  268,  661,  269,
 /*   430 */   514,    3,  563,  142,  821,   75,  354,  849,   75,  172,
 /*   440 */    77,  574,  172,  167,   11,  169,  170,  533,  146,  147,
 /*   450 */   799,  108,   94,  143,  153,  158,  163,  152,  157,  118,
 /*   460 */   120,  112,  114,  110,  116,  475,  122,  124,  126,  128,
 /*   470 */   130,  132,  134,  136,  138,  140,  145,  294,  142,  271,
 /*   480 */   239,  461,  291,  847,  306,  363,  459,  258,  844,  213,
 /*   490 */    28,  842,  213,  398,   33,  528,  108,   94,  143,  153,
 /*   500 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   510 */   272,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   520 */   140,  456,   34,  142,  727,  362,  345,  167,  858,  169,
 /*   530 */   170,  148,  218,  159,  164,   42,  167,  432,  169,  170,
 /*   540 */   308,  108,   94,  143,  153,  158,  163,  152,  157,  118,
 /*   550 */   120,  112,  114,  110,  116,   13,  122,  124,  126,  128,
 /*   560 */   130,  132,  134,  136,  138,  140,   13,  167,  142,  169,
 /*   570 */   170,   39,  490,  462,  452,  134,  136,  138,  140,  331,
 /*   580 */   688,  403,  167,   81,  169,  170,  108,   94,  143,  153,
 /*   590 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   600 */    96,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   610 */   140,  288,   13,  142,  663,  411,  271,  406,   14,   15,
 /*   620 */    75,  395,  305,  167,  489,  169,  170,  261,  394,   14,
 /*   630 */    15,  108,  161,  143,  153,  158,  163,  152,  157,  118,
 /*   640 */   120,  112,  114,  110,  116,  529,  122,  124,  126,  128,
 /*   650 */   130,  132,  134,  136,  138,  140,  249,   72,  142,   57,
 /*   660 */    58,  531,  532,  363,  262,  167,  521,  169,  170,   44,
 /*   670 */    45,  561,   33,  495,  479,   14,   15,   94,  143,  153,
 /*   680 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   690 */    96,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   700 */   140,  814,  274,  142,   83,  297,   13,  501,  165,  497,
 /*   710 */    75,  282,   13,  167,  186,  169,  170,  168,   13,  437,
 /*   720 */   666,  327,  354,  143,  153,  158,  163,  152,  157,  118,
 /*   730 */   120,  112,  114,  110,  116,  402,  122,  124,  126,  128,
 /*   740 */   130,  132,  134,  136,  138,  140,  183,   76,   96,  597,
 /*   750 */   575,   71,  417,   96,  445,  166,  344,   13,   76,   96,
 /*   760 */    78,  187,   71,  327,  338,  327,  834,   13,   75,   14,
 /*   770 */    15,  261,  172,   75,  195,   14,   15,  292,   77,   75,
 /*   780 */    96,   14,   15,  231,  106,  195,  550,   77,  173,  499,
 /*   790 */   554,  835,   77,  448,  263,  106,  387,  328,  378,  173,
 /*   800 */    75,  244,  254,   96,  149,  179,  177,  438,  279,  551,
 /*   810 */   209,  449,   96,  175,   73,   74,  179,  177,   95,  225,
 /*   820 */    14,   15,  213,   75,  175,   73,   74,  151,  264,   95,
 /*   830 */    14,   15,   75,  290,  807,  434,  192,  289,  433,  328,
 /*   840 */   558,  328,   76,  257,  265,  327,   71,  251,   81,  435,
 /*   850 */   400,  101,  102,  103,  104,  105,  181,  185,  800,  453,
 /*   860 */    96,   96,  101,  102,  103,  104,  105,  181,  185,  195,
 /*   870 */    76,   16,   17,   18,   71,   96,  356,  357,  372,  106,
 /*   880 */    75,   75,   77,  173,  180,  160,  140,  624,  295,  323,
 /*   890 */   211,  327,   96,  841,   96,   75,  322,  195,  323,  162,
 /*   900 */   179,  177,  296,   96,  417,  246,  258,  106,  175,   73,
 /*   910 */    74,  173,   75,   95,   75,  348,  178,  349,  176,   96,
 /*   920 */    96,  328,  655,   75,  321,  313,  312,  474,  179,  177,
 /*   930 */   285,   76,  721,   96,  859,   71,  175,   73,   74,   75,
 /*   940 */    75,   95,  419,  174,  487,  544,  101,  102,  103,  104,
 /*   950 */   105,  181,  185,   75,  379,  346,  323,  470,  195,  257,
 /*   960 */   598,   96,   96,   64,  309,  316,  318,  328,  106,  269,
 /*   970 */   248,   96,  173,  690,  101,  102,  103,  104,  105,  181,
 /*   980 */   185,   75,   75,  286,  351,  423,  382,  360,  358,  179,
 /*   990 */   177,   75,   96,   96,   96,  298,  247,  175,   73,   74,
 /*  1000 */    96,  472,   95,   75,  431,   96,   96,  283,   96,  426,
 /*  1010 */   427,  417,   75,   75,   75,  422,  273,  241,   91,  388,
 /*  1020 */    75,  323,  258,   96,   93,   75,   75,  653,   75,  107,
 /*  1030 */   236,  446,  220,  323,   42,  101,  102,  103,  104,  105,
 /*  1040 */   181,  185,   96,   75,  837,   96,  240,  109,    8,  496,
 /*  1050 */    96,   96,   96,   19,   21,   23,  401,   96,  836,   96,
 /*  1060 */    96,  410,   75,  215,  466,   75,  111,  536,  690,  113,
 /*  1070 */    75,   75,   75,  546,  115,  117,  119,   75,   96,   75,
 /*  1080 */    75,  121,   81,  123,  125,  525,   96,  456,   96,   96,
 /*  1090 */   472,   96,  523,   77,  549,  483,   96,  552,   75,   96,
 /*  1100 */   690,   96,  127,  480,   96,  269,   75,  555,   75,   75,
 /*  1110 */   129,   75,  131,  133,  215,  135,   75,   96,   42,   75,
 /*  1120 */   208,   75,   96,  137,   75,  139,  857,   96,  141,  417,
 /*  1130 */   454,   45,  482,  488,  417,  486,  417,   75,  504,  508,
 /*  1140 */   452,  206,   75,  417,  494,   81,  204,   75,  417,   81,
 /*  1150 */   417,  194,  522,  512,  486,  436,  300,  224,  519,  518,
 /*  1160 */   266,  216,  542,  302,   77,  320,  439,  498,  440,  303,
 /*  1170 */   355,  864,  500,  215,  502,  441,  442,  237,  443,  304,
 /*  1180 */   444,  506,  305,  540,   43,  538,  510,  867,  516,  539,
 /*  1190 */   553,   77,  805,  359,  447,  537,  806,  450,   41,  307,
 /*  1200 */    90,   70,   79,  568,  245,  455,  728,  270,   85,  310,
 /*  1210 */   729,  100,  458,  828,  228,  460,   63,  396,   64,  843,
 /*  1220 */   366,  453,  463,   38,  464,  465,  233,  240,  368,   35,
 /*  1230 */   468,   62,  545,  471,  469,   84,  370,   82,  371,  845,
 /*  1240 */    81,  473,  588,   61,   30,   29,  476,  477,  234,  478,
 /*  1250 */   584,  374,   88,   80,  375,  373,  481,  556,   26,  484,
 /*  1260 */   377,  583,   60,  317,  582,  278,   24,  846,  581,   68,
 /*  1270 */   491,   22,  380,   20,  848,  492,  557,  865,  319,  250,
 /*  1280 */   493,  660,  820,  662,  541,  385,  559,  813,  386,  855,
 /*  1290 */   856,  280,  505,  281,  507,  562,  720,  389,  509,  390,
 /*  1300 */   511,  325,  560,   55,  326,  391,  513,  723,  515,  392,
 /*  1310 */    56,  221,  866,   54,  520,  252,  226,  517,  576,   99,
 /*  1320 */   726,  329,   12,  330,  524,  815,  253,   98,  573,  526,
 /*  1330 */    10,  816,    9,  238,  527,  817,  818,  819,  534,   53,
 /*  1340 */   547,  535,   87,  669,    7,  405,  287,  668,  333,  409,
 /*  1350 */   404,  667,  214,  335,  182,  205,  255,  188,  407,  189,
 /*  1360 */   156,  548,  190,  416,  408,  235,  256,  412,  413,  414,
 /*  1370 */   227,  415,  862,  196,   97,  222,  418,  198,  424,  421,
 /*  1380 */   200,  543,  211,  199,  202,  420,  829,  547,  547,  340,
 /*  1390 */   547,  547,  201,  547,  547,  547,  547,  547,  547,  547,
 /*  1400 */   547,  547,  547,  547,  547,  547,  547,  547,  547,  547,
 /*  1410 */   547,  547,  547,  547,  547,  547,  547,  547,   86,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    25,  150,   27,   72,   73,   74,   75,   24,   77,   78,
 /*    10 */    79,   80,   81,   82,   83,   84,   85,   86,  115,   44,
 /*    20 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    30 */    86,   81,   82,   83,   84,   85,   86,   62,   63,   64,
 /*    40 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*    50 */    75,  115,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    60 */    85,   86,  150,  150,   26,   90,   77,   78,   79,   80,
 /*    70 */    81,   82,   83,   84,   85,   86,   92,  226,   45,   95,
 /*    80 */    96,   97,   44,  170,  168,  169,   48,  174,  165,  166,
 /*    90 */   167,  107,  109,  177,  111,  112,  150,   64,   27,   60,
 /*   100 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   110 */    72,   73,   74,   75,   64,   77,   78,   79,   80,   81,
 /*   120 */    82,   83,   84,   85,   86,   18,  102,  103,  104,   90,
 /*   130 */    30,   60,  150,   94,  101,  150,   36,  224,  150,  106,
 /*   140 */   158,  159,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   150 */   227,   44,   81,   82,  208,  170,  106,  171,  170,  174,
 /*   160 */    38,   90,  174,  181,  182,   94,  127,  128,  129,   62,
 /*   170 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   180 */    73,   74,   75,   33,   77,   78,   79,   80,   81,   82,
 /*   190 */    83,   84,   85,   86,  209,  210,   44,   10,  127,  128,
 /*   200 */   129,  170,   52,  217,  216,  219,  220,  217,  157,  219,
 /*   210 */   220,   27,   64,   26,   62,   63,   64,   65,   66,   67,
 /*   220 */    68,   69,   70,   71,   72,   73,   74,   75,   27,   77,
 /*   230 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   94,
 /*   240 */   189,   44,   94,   95,   96,   97,   98,   99,   24,   27,
 /*   250 */    26,  106,  201,  202,  106,  105,   23,  206,   25,   62,
 /*   260 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   270 */    73,   74,   75,  163,   77,   78,   79,   80,   81,   82,
 /*   280 */    83,   84,   85,   86,   24,   19,   26,  135,   18,   10,
 /*   290 */   157,   90,   91,   92,   28,   24,   95,   96,   97,   24,
 /*   300 */    24,   26,   26,   81,   82,   39,   27,   41,  107,   27,
 /*   310 */   200,  124,   90,   91,  154,   44,   92,   51,   10,   95,
 /*   320 */    96,   97,  189,  101,  162,  144,   26,  217,  147,  219,
 /*   330 */   220,  107,  135,   62,   63,   64,   65,   66,   67,   68,
 /*   340 */    69,   70,   71,   72,   73,   74,   75,  214,   77,   78,
 /*   350 */    79,   80,   81,   82,   83,   84,   85,   86,   24,  198,
 /*   360 */    44,  145,  146,  230,   10,   11,   91,  151,  235,   90,
 /*   370 */    91,  163,   90,  157,  165,  166,  167,   64,   62,   63,
 /*   380 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   390 */    74,   75,  117,   77,   78,   79,   80,   81,   82,   83,
 /*   400 */    84,   85,   86,   19,  134,  189,  136,   94,  157,  142,
 /*   410 */   143,  144,   28,   24,  147,  150,  116,  109,  150,  111,
 /*   420 */   112,    0,   25,   39,   27,   41,   44,   24,   10,   26,
 /*   430 */   214,   10,   11,   44,   10,  170,  227,   10,  170,  174,
 /*   440 */   189,   10,  174,  109,   13,  111,  112,   23,   66,   67,
 /*   450 */   134,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   460 */    71,   72,   73,   74,   75,  214,   77,   78,   79,   80,
 /*   470 */    81,   82,   83,   84,   85,   86,   94,  212,   44,  150,
 /*   480 */   212,  230,   24,   10,   45,  150,  235,   90,   18,  224,
 /*   490 */   155,   12,  224,  158,  159,   71,   62,   63,   64,   65,
 /*   500 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   510 */   101,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   520 */    86,   51,  160,   44,   10,  163,  164,  109,   10,  111,
 /*   530 */   112,  217,  218,  219,  220,  101,  109,  208,  111,  112,
 /*   540 */   101,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   550 */    71,   72,   73,   74,   75,   27,   77,   78,   79,   80,
 /*   560 */    81,   82,   83,   84,   85,   86,   27,  109,   44,  111,
 /*   570 */   112,  169,  102,  103,  104,   83,   84,   85,   86,  177,
 /*   580 */    24,   21,  109,  113,  111,  112,   62,   63,   64,   65,
 /*   590 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   600 */   150,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   610 */    86,   83,   27,   44,   10,   55,  150,   57,   90,   91,
 /*   620 */   170,  177,  178,  109,  174,  111,  112,  163,  184,   90,
 /*   630 */    91,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   640 */    71,   72,   73,   74,   75,  150,   77,   78,   79,   80,
 /*   650 */    81,   82,   83,   84,   85,   86,  117,   23,   44,   14,
 /*   660 */    15,  166,  167,  150,  200,  109,  216,  111,  112,  186,
 /*   670 */   187,  158,  159,   21,  208,   90,   91,   63,   64,   65,
 /*   680 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   690 */   150,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   700 */    86,   10,   23,   44,  192,   24,   27,   55,   23,   57,
 /*   710 */   170,  199,   27,  109,  174,  111,  112,  110,   27,   22,
 /*   720 */   113,  150,  227,   64,   65,   66,   67,   68,   69,   70,
 /*   730 */    71,   72,   73,   74,   75,  153,   77,   78,   79,   80,
 /*   740 */    81,   82,   83,   84,   85,   86,  157,   23,  150,  115,
 /*   750 */    10,   27,  150,  150,  183,  157,  162,   27,   23,  150,
 /*   760 */   157,  221,   27,  150,  170,  150,  101,   27,  170,   90,
 /*   770 */    91,  163,  174,  170,   50,   90,   91,  174,  189,  170,
 /*   780 */   150,   90,   91,  174,   60,   50,  150,  189,   64,  137,
 /*   790 */   188,  101,  189,   96,  204,   60,  183,  226,  183,   64,
 /*   800 */   170,  201,  202,  150,  174,   81,   82,  225,  200,  154,
 /*   810 */   212,  229,  150,   89,   90,   91,   81,   82,   94,  210,
 /*   820 */    90,   91,  224,  170,   89,   90,   91,  174,  205,   94,
 /*   830 */    90,   91,  170,  110,  137,   29,  174,  114,   32,  226,
 /*   840 */   238,  226,   23,   27,  118,  150,   27,  117,  113,   43,
 /*   850 */   157,  127,  128,  129,  130,  131,  132,  133,  134,   62,
 /*   860 */   150,  150,  127,  128,  129,  130,  131,  132,  133,   50,
 /*   870 */    23,   14,   15,   16,   27,  150,  127,  128,  183,   60,
 /*   880 */   170,  170,  189,   64,  174,  174,   86,   24,   24,   26,
 /*   890 */    26,  150,  150,   12,  150,  170,   24,   50,   26,  174,
 /*   900 */    81,   82,   83,  150,  150,   26,   90,   60,   89,   90,
 /*   910 */    91,   64,  170,   94,  170,   24,  174,   26,  174,  150,
 /*   920 */   150,  226,  125,  170,  183,   93,   94,  174,   81,   82,
 /*   930 */    83,   23,   10,  150,   10,   27,   89,   90,   91,  170,
 /*   940 */   170,   94,  188,  174,  174,  129,  127,  128,  129,  130,
 /*   950 */   131,  132,  133,  170,   24,   23,   26,  174,   50,   27,
 /*   960 */   115,  150,  150,  100,  102,  103,  104,  226,   60,   26,
 /*   970 */    91,  150,   64,   25,  127,  128,  129,  130,  131,  132,
 /*   980 */   133,  170,  170,  150,   24,  174,  174,   81,   82,   81,
 /*   990 */    82,  170,  150,  150,  150,  174,  117,   89,   90,   91,
 /*  1000 */   150,  150,   94,  170,   47,  150,  150,  174,  150,   53,
 /*  1010 */    54,  150,  170,  170,  170,  134,  174,  174,  174,   24,
 /*  1020 */   170,   26,   90,  150,  174,  170,  170,   10,  170,  174,
 /*  1030 */   174,   24,  174,   26,  101,  127,  128,  129,  130,  131,
 /*  1040 */   132,  133,  150,  170,  101,  150,  124,  174,   12,  188,
 /*  1050 */   150,  150,  150,   17,   18,   19,   20,  150,  101,  150,
 /*  1060 */   150,  157,  170,  115,  213,  170,  174,   31,   10,  174,
 /*  1070 */   170,  170,  170,   37,  174,  174,  174,  170,  150,  170,
 /*  1080 */   170,  174,  113,  174,  174,   49,  150,   51,  150,  150,
 /*  1090 */   150,  150,   56,  189,   58,  126,  150,   61,  170,  150,
 /*  1100 */   101,  150,  174,   24,  150,   26,  170,   59,  170,  170,
 /*  1110 */   174,  170,  174,  174,  115,  174,  170,  150,  101,  170,
 /*  1120 */   174,  170,  150,  174,  170,  174,   10,  150,  174,  150,
 /*  1130 */   186,  187,  157,   24,  150,   26,  150,  170,  102,  103,
 /*  1140 */   104,  174,  170,  150,  108,  113,  174,  170,  150,  113,
 /*  1150 */   150,  174,   24,  213,   26,   47,  171,   26,  126,  157,
 /*  1160 */    23,  150,   46,  150,  189,   23,  137,  188,  150,  175,
 /*  1170 */   228,   10,  188,  115,  188,  154,  101,  121,  150,  176,
 /*  1180 */    23,  188,  178,  150,   34,  163,  188,  139,  188,   25,
 /*  1190 */    21,  189,   10,  228,  171,  236,  137,   12,  171,  150,
 /*  1200 */   123,   23,  190,   10,  203,  185,  125,  150,  194,  179,
 /*  1210 */   125,  150,   18,   10,   99,   10,  173,  182,  100,   18,
 /*  1220 */   182,   62,  185,  150,  150,  105,  211,  124,  150,  161,
 /*  1230 */   150,  171,   35,  194,   71,  193,   46,  191,   23,   10,
 /*  1240 */   113,   71,   10,  172,   24,  156,  125,  150,  172,   23,
 /*  1250 */    10,   24,  197,  189,  171,  173,  215,  138,  152,   23,
 /*  1260 */    23,   10,   46,  179,   10,   24,  149,   10,   10,  171,
 /*  1270 */   116,  149,  171,  149,   10,  150,  150,   10,  179,  150,
 /*  1280 */   194,   10,   10,   10,  237,   46,  139,   10,   23,   10,
 /*  1290 */    10,  204,  116,  205,  194,  140,   10,   98,  185,  150,
 /*  1300 */   105,  211,  239,  180,  172,  175,  194,   10,  125,  176,
 /*  1310 */    42,  119,   10,  106,   23,  150,  211,  215,   10,  115,
 /*  1320 */    10,  211,  150,  172,  150,   10,  117,  150,   10,  150,
 /*  1330 */   149,   10,  148,  120,  154,   10,   10,   10,  150,  171,
 /*  1340 */   236,   24,  196,  113,   10,  154,  115,  113,  162,   25,
 /*  1350 */   150,  113,  150,  180,   23,  134,  150,  222,  150,  223,
 /*  1360 */    94,  150,   18,  101,  154,  122,  154,  150,  154,  231,
 /*  1370 */   172,  232,   10,   23,  115,  120,  154,   24,   40,  234,
 /*  1380 */    26,  163,   26,  187,   24,  233,   12,  240,  240,  170,
 /*  1390 */   240,  240,  150,  240,  240,  240,  240,  240,  240,  240,
 /*  1400 */   240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
 /*  1410 */   240,  240,  240,  240,  240,  240,  240,  240,  195,
};
#define YY_SHIFT_USE_DFLT (-98)
static const short yy_shift_ofst[] = {
 /*     0 */   354,  421,  -98,  -98, 1036, 1193, 1334,  -98,  857,  431,
 /*    10 */  1318,  740, 1308,  -98,  -98,  -98,  -98,  -98,  -98,  431,
 /*    20 */  1258,  431, 1254,  431, 1251,  233, 1240,  585,  260, 1220,
 /*    30 */  1232,  201,  -98,  282,  -98,   50,  -98,  585,  148,  -98,
 /*    40 */   933,  -98, 1150,  266,  -98,  -98,  -98,  -98,  -98,  -98,
 /*    50 */   -98,  145,  933,  -98, 1268,  -98,  645,  -98,  -98, 1216,
 /*    60 */   100,  933, 1118,  -98,  -98,  -98,  -98,  933,  -98, 1178,
 /*    70 */   908,  634,  819,  845,  -64,  -98,  735,  -98,  458, 1127,
 /*    80 */   -98,  723,  -98,  300, 1103, 1056, 1243, 1192, 1077,  -98,
 /*    90 */   908,   38,  908,  524,  908,  -98, 1259,  585, 1204,  585,
 /*   100 */   -98,  -98,  -98,  -98,  -98,  -98,  -98,  659,  908,  614,
 /*   110 */   908,  -11,  908,  -11,  908,  -11,  908,  -11,  908,  -69,
 /*   120 */   908,  -69,  908,  -50,  908,  -50,  908,  -50,  908,  -50,
 /*   130 */   908,  492,  908,  492,  908,  800,  908,  800,  908,  800,
 /*   140 */   908,  -98,  -98,  382,  -98,  -98,  -98,  -98,  908,  -56,
 /*   150 */   908,  -11,  -98,  313,  -98, 1266,  -98,  -98,  -98,  908,
 /*   160 */   569,  908,  -69,  -98,  685,  735,  334,  607, 1238, 1234,
 /*   170 */  1230,  -98,  524,  908,  659,  908,  -98,  908,  -98,  908,
 /*   180 */   -98, 1331, 1127,  -17,  -98,  724,  316, 1221,  270, 1344,
 /*   190 */   -98,  908,  197,  908,  524, 1350,  384, 1353,  -98, 1354,
 /*   200 */   585, 1360,  -98,  908,  107,  908,  152,  908,  524,  276,
 /*   210 */   -98,  908,  -98,  -98,  -97,  585,  -98,  -98,  -98,  908,
 /*   220 */   524, 1255,  908, 1131,  908, 1115,  100,  -98,  184,  -98,
 /*   230 */   -98,  524, 1115,  100,  -98,  908,  524, 1213,  908, 1356,
 /*   240 */   908,  524,  -98,  -98,  879,  -98,  -98,  -98,  539,  -98,
 /*   250 */   730,  -98, 1209,  -98,  679,  -97,  397,  -98,  -98,  585,
 /*   260 */   -98,  -98,  409,  726,  -98, 1137,  585,  403,  -98,  585,
 /*   270 */   -98,  -98,  908,  524, 1127,  556,  275, 1241,  397,  409,
 /*   280 */   726,  -98,  847,  -25,  -98,  -98, 1231,  528,  -98,  -98,
 /*   290 */   -98,  -98,  271,  -98,  864,  -98,  681,  -98,  389,  933,
 /*   300 */   -98,  585, 1142,  -98,  439,  -98,  585,  -98,  862,  150,
 /*   310 */   -98,  832,  -98,  -98,  -98,  -98,  150,  -98,  150,  -98,
 /*   320 */   585,  872,  -98,  585, 1115,  100,  -98,  -98, 1115,  100,
 /*   330 */   -98,  -98,  184,  -98, 1268,  -98,  -98,   71,  -98,   39,
 /*   340 */   -98,  -98,   39,  -98,  -98,  932,  906,  891,  -98,  906,
 /*   350 */   960,  -98,  -98,  -98,  749,  -98,  -98,  -98,  749,  -98,
 /*   360 */   -98,  -98,  -98,  -98,  224,  -16,  -98,  585,  -98, 1190,
 /*   370 */  1215,  585,  863, 1227,  933,  -98, 1237,  585,  930,  933,
 /*   380 */   -98,  908,  434,  -98, 1239, 1265,  585,  995, 1199,  585,
 /*   390 */  1142,  -98,   33, 1207,  -98,  -98,  -98,  -98,  -98, 1127,
 /*   400 */   308,  697,  560,  585,  -97,  -98,  585,  948, 1324, 1127,
 /*   410 */   418,  585,  -97,  806,   24, 1262,  585,  -97,  -98, 1338,
 /*   420 */   881, 1374,  908,  479,  122,  956,  -98,  -98,  665,  690,
 /*   430 */   957,  585,  943,  -98,  -98, 1108,  -98,  -98, 1029,  585,
 /*   440 */   999, 1075,  585, 1157,  585, 1007, 1017, 1182, 1059, 1185,
 /*   450 */   470,  427,  797,  266,  -98, 1081, 1085, 1194, 1203, 1205,
 /*   460 */   470, 1201, 1159,  585, 1120,  585,  187,  585, 1163,  908,
 /*   470 */   524, 1229, 1170,  908,  524, 1121,  585, 1226,  585, 1079,
 /*   480 */   -98,  969,  473, 1236,  908, 1109,  908,  524, 1257,  524,
 /*   490 */  1154,  585,  922, 1264,  652,  585, 1271,  585, 1273,  585,
 /*   500 */  1277,  585, 1279,  604, 1176,  585,  922, 1286, 1159,  585,
 /*   510 */  1195,  585,  187, 1297, 1183,  585, 1226, 1032,  514, 1291,
 /*   520 */   908, 1128, 1310,  691, 1315,  585,  -97,  424,  222, 1321,
 /*   530 */  1325, 1326, 1327,  585, 1317, 1272, 1197,  282, 1164,  585,
 /*   540 */  1116, 1280,  816,  518,  924,  -98, 1197,  585, 1362,  279,
 /*   550 */  1058, 1161, 1169,  585, 1048, 1119,  585, 1267, 1147, 1155,
 /*   560 */   585, 1302,  -98,  -98,  -98,
};
#define YY_REDUCE_USE_DFLT (-150)
static const short yy_reduce_ofst[] = {
 /*     0 */   267,  181, -150, -150,  216, -150, -150, -150, 1184, 1181,
 /*    10 */  -150, 1172, -150, -150, -150, -150, -150, -150, -150, 1124,
 /*    20 */  -150, 1122, -150, 1117, -150, 1106, -150,  335, 1089, -150,
 /*    30 */  -150,  -18, -150,  362, 1068,  -84, -150, 1073,  402, -150,
 /*    40 */  1027, -150, -150,  483, -150, -150, -150, -150, -150, -150,
 /*    50 */  -150, -150, 1168, -150, 1123, -150, -150, -150, -150, -150,
 /*    60 */  1071, 1060, 1043, -150, -150, -150, -150, 1098, -150, -150,
 /*    70 */   821, -150,  265, -150, -150, -150,  603, -150, 1012, 1064,
 /*    80 */  -150, 1046,  512, 1042, 1014, 1223, 1146, 1055,  161, -150,
 /*    90 */   844,  -10,  850,  -10,  855, -150, -150, 1177, -150, 1061,
 /*   100 */  -150, -150, -150, -150, -150, -150, -150,  -10,  873,  -10,
 /*   110 */   892,  -10,  895,  -10,  900,  -10,  901,  -10,  902,  -10,
 /*   120 */   907,  -10,  909,  -10,  910,  -10,  928,  -10,  936,  -10,
 /*   130 */   938,  -10,  939,  -10,  941,  -10,  949,  -10,  951,  -10,
 /*   140 */   954,  -10, -150, -150, -150, -150, -150, -150,  630,  314,
 /*   150 */   653,  -10, -150, -150, -150, -150, -150, -150, -150,  711,
 /*   160 */   -10,  725,  -10, -150, 1202,  598, 1012, -150, -150, -150,
 /*   170 */  -150, -150,  -10,  769,  -10,  744,  -10,  742,  -10,  710,
 /*   180 */   -10, -150,  589, 1012, -150,  540,  -10, 1135, 1136, -150,
 /*   190 */  -150,  662,  -10,  977,  -10, -150, 1196, -150, -150, -150,
 /*   200 */  1242, -150, -150,  972,  -10,  967,  -10,  946,  -10, -150,
 /*   210 */  -150,  -87, -150, -150,  160, 1011, -150, -150, -150,  858,
 /*   220 */   -10, -150,  -15, -150,  609, 1105, 1198, -150,  162, -150,
 /*   230 */  -150,  -10, 1015, 1076, -150,  856,  -10, -150,  268, -150,
 /*   240 */   843,  -10, -150,  600, 1001, -150, -150, -150, 1129, -150,
 /*   250 */  1165, -150, -150, -150, 1206, 1212,  464, -150, -150,  -88,
 /*   260 */  -150, -150,  590,  623, -150, -150,  -54, -150, -150, 1057,
 /*   270 */  -150, -150,  842,  -10,   51, 1012, 1001, -150,  608, 1087,
 /*   280 */  1088, -150,  833,  110, -150, -150, -150, 1177, -150, -150,
 /*   290 */  -150, -150,  -10, -150, -150, -150, -150, -150,  -10,  985,
 /*   300 */  -150, 1013,  994, 1003, 1004, -150, 1049, -150, -150, 1030,
 /*   310 */  -150, -150, -150, -150, -150, -150, 1084, -150, 1099, -150,
 /*   320 */   741, -150, -150, -149, 1090, 1132, -150, -150, 1110, 1151,
 /*   330 */  -150, -150, 1186, -150, 1173, -150, -150,  594, -150, 1219,
 /*   340 */  -150, -150,   31, -150, -150,  208,  209, -150, -150,  -77,
 /*   350 */  -150, -150, -150, -150,  942, -150, -150, -150,  965, -150,
 /*   360 */  -150, -150, -150, -150, 1035, 1038, -150, 1078, -150, -150,
 /*   370 */  -150,  695, 1082, -150, 1083, -150, -150,  615, -150, 1101,
 /*   380 */  -150,  812,  -14, -150, -150, -150,  613, -150, -150, 1149,
 /*   390 */  1130, 1133,  444, -150, -150, -150, -150, -150, -150,  693,
 /*   400 */  1012,  582, -150, 1200, 1191, -150, 1208, 1210, -150,  904,
 /*   410 */  1012, 1217, 1214, 1138, 1139, -150,  754, 1222, -150, 1152,
 /*   420 */  1145, -150,  811,  -10, -150, -150, -150, -150, -150, -150,
 /*   430 */  -150,  329, -150, -150, -150, -150, -150, -150, -150, 1018,
 /*   440 */  1021, -150, 1028, -150,  571, -150, 1023, -150, -150, -150,
 /*   450 */   133, 1012, 1020,  944, -150, -150, -150, -150, -150, -150,
 /*   460 */   251, -150, 1037, 1074, -150,  851, 1039, 1080, -150,  783,
 /*   470 */   -10, -150, -150,  753,  -10, -150, 1097, 1041,  466, -150,
 /*   480 */  -150,  975, 1012, -150,  -12, -150,  770,  -10, -150,  -10,
 /*   490 */  -150, 1125, 1086, -150, -150,  861, -150,  979, -150,  984,
 /*   500 */  -150,  986, -150, 1012, -150,  993, 1100, -150, 1113,  998,
 /*   510 */  -150,  940, 1112, -150, -150, 1000, 1102, 1002, 1012, -150,
 /*   520 */   450, -150, -150, 1174, -150, 1179, 1180, -150,  495, -150,
 /*   530 */  -150, -150, -150, 1188, -150, -150,  959, 1022, -150, 1033,
 /*   540 */  1047, -150, 1218, -150, -150, -150, 1104, 1211, -150,  636,
 /*   550 */   655, -150, -150,  602, -150, -150, 1126, -150, -150, 1063,
 /*   560 */   513, -150, -150, -150, -150,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   571,  571,  566,  569,  870,  870,  870,  570,  577,  870,
 /*    10 */   870,  870,  870,  597,  598,  599,  578,  579,  580,  870,
 /*    20 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    30 */   870,  870,  590,  600,  609,  592,  608,  870,  870,  610,
 /*    40 */   653,  616,  870,  870,  654,  657,  658,  659,  852,  853,
 /*    50 */   854,  870,  653,  617,  638,  636,  870,  639,  640,  870,
 /*    60 */   709,  653,  624,  618,  625,  707,  708,  653,  619,  870,
 /*    70 */   870,  739,  804,  745,  740,  736,  870,  664,  870,  870,
 /*    80 */   665,  673,  675,  682,  721,  712,  714,  702,  716,  670,
 /*    90 */   870,  717,  870,  718,  870,  738,  870,  870,  741,  870,
 /*   100 */   742,  743,  744,  746,  747,  748,  751,  752,  870,  753,
 /*   110 */   870,  754,  870,  755,  870,  756,  870,  757,  870,  758,
 /*   120 */   870,  759,  870,  760,  870,  761,  870,  762,  870,  763,
 /*   130 */   870,  764,  870,  765,  870,  766,  870,  767,  870,  768,
 /*   140 */   870,  769,  770,  870,  771,  778,  785,  788,  870,  773,
 /*   150 */   870,  772,  775,  870,  776,  870,  779,  777,  784,  870,
 /*   160 */   870,  870,  786,  787,  870,  804,  870,  870,  870,  870,
 /*   170 */   870,  791,  803,  870,  780,  870,  781,  870,  782,  870,
 /*   180 */   783,  870,  870,  870,  793,  870,  870,  870,  870,  870,
 /*   190 */   794,  870,  870,  870,  795,  870,  870,  870,  850,  870,
 /*   200 */   870,  870,  851,  870,  870,  870,  870,  870,  796,  870,
 /*   210 */   789,  804,  801,  802,  690,  870,  691,  792,  774,  870,
 /*   220 */   719,  870,  870,  703,  870,  710,  709,  704,  870,  594,
 /*   230 */   711,  706,  710,  709,  705,  870,  715,  870,  804,  713,
 /*   240 */   870,  722,  674,  685,  683,  684,  693,  694,  870,  695,
 /*   250 */   870,  696,  870,  697,  870,  690,  681,  595,  596,  870,
 /*   260 */   679,  680,  699,  701,  686,  870,  870,  870,  700,  870,
 /*   270 */   734,  735,  870,  698,  685,  870,  870,  870,  681,  699,
 /*   280 */   701,  687,  870,  681,  676,  677,  870,  870,  678,  671,
 /*   290 */   672,  790,  870,  737,  870,  749,  870,  750,  870,  653,
 /*   300 */   620,  870,  808,  626,  621,  627,  870,  628,  870,  870,
 /*   310 */   629,  870,  632,  633,  634,  635,  870,  630,  870,  631,
 /*   320 */   870,  870,  809,  870,  710,  709,  810,  812,  710,  709,
 /*   330 */   811,  622,  870,  623,  638,  637,  611,  870,  612,  870,
 /*   340 */   613,  745,  870,  614,  615,  601,  827,  870,  602,  827,
 /*   350 */   870,  603,  606,  607,  870,  822,  824,  825,  870,  823,
 /*   360 */   826,  605,  604,  593,  870,  870,  643,  870,  646,  870,
 /*   370 */   870,  870,  870,  870,  653,  647,  870,  870,  870,  653,
 /*   380 */   648,  870,  653,  649,  870,  870,  870,  870,  870,  870,
 /*   390 */   808,  626,  651,  870,  650,  652,  644,  645,  591,  870,
 /*   400 */   870,  587,  870,  870,  690,  585,  870,  870,  870,  870,
 /*   410 */   870,  870,  690,  833,  870,  870,  870,  690,  692,  838,
 /*   420 */   870,  870,  870,  870,  870,  870,  839,  840,  870,  870,
 /*   430 */   870,  870,  870,  830,  831,  870,  832,  586,  870,  870,
 /*   440 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   450 */   870,  870,  870,  870,  656,  870,  870,  870,  870,  870,
 /*   460 */   870,  870,  655,  870,  870,  870,  870,  870,  870,  870,
 /*   470 */   724,  870,  870,  870,  725,  870,  870,  732,  870,  870,
 /*   480 */   733,  870,  870,  870,  870,  870,  870,  730,  870,  731,
 /*   490 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   500 */   870,  870,  870,  870,  870,  870,  870,  870,  655,  870,
 /*   510 */   870,  870,  870,  870,  870,  870,  732,  870,  870,  870,
 /*   520 */   870,  870,  870,  870,  870,  870,  690,  870,  827,  870,
 /*   530 */   870,  870,  870,  870,  870,  870,  861,  870,  870,  870,
 /*   540 */   870,  870,  870,  870,  870,  860,  861,  870,  870,  870,
 /*   550 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  868,
 /*   560 */   870,  870,  869,  572,  567,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /* CONST_FUNC => nothing */
    0,  /*       SEMI => nothing */
   27,  /*    EXPLAIN => ID */
   27,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   27,  /*   DEFERRED => ID */
   27,  /*  IMMEDIATE => ID */
   27,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   27,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   27,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   27,  /*      ABORT => ID */
   27,  /*      AFTER => ID */
   27,  /*        ASC => ID */
   27,  /*     ATTACH => ID */
   27,  /*     BEFORE => ID */
   27,  /*    CASCADE => ID */
   27,  /*   CONFLICT => ID */
   27,  /*   DATABASE => ID */
   27,  /*       DESC => ID */
   27,  /*     DETACH => ID */
   27,  /*       EACH => ID */
   27,  /*       FAIL => ID */
   27,  /*        FOR => ID */
   27,  /*     IGNORE => ID */
   27,  /*  INITIALLY => ID */
   27,  /*    INSTEAD => ID */
   27,  /*    LIKE_KW => ID */
   27,  /*      MATCH => ID */
   27,  /*        KEY => ID */
   27,  /*         OF => ID */
   27,  /*     OFFSET => ID */
   27,  /*     PRAGMA => ID */
   27,  /*      RAISE => ID */
   27,  /*    REPLACE => ID */
   27,  /*   RESTRICT => ID */
   27,  /*        ROW => ID */
   27,  /*  STATEMENT => ID */
   27,  /*    TRIGGER => ID */
   27,  /*     VACUUM => ID */
   27,  /*       VIEW => ID */
   27,  /*    REINDEX => ID */
   27,  /*     RENAME => ID */
   27,  /*   CTIME_KW => ID */
   27,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "CONST_FUNC",    "SEMI",          "EXPLAIN",     
  "BEGIN",         "TRANSACTION",   "DEFERRED",      "IMMEDIATE",   
  "EXCLUSIVE",     "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CONFLICT",      "DATABASE",    
  "DESC",          "DETACH",        "EACH",          "FAIL",        
  "FOR",           "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE_KW",       "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "REINDEX",       "RENAME",      
  "CTIME_KW",      "ALTER",         "OR",            "AND",         
  "NOT",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "COLLATE",     
  "AUTOINCR",      "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "INTERSECT",   
  "EXCEPT",        "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "INTEGER",     
  "FLOAT",         "BLOB",          "REGISTER",      "VARIABLE",    
  "EXISTS",        "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "TO",            "ADD",         
  "COLUMNKW",      "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "onconf",      
  "sortorder",     "autoinc",       "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "collate",     
  "exprlist",      "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT term",
 /*  48 */ "carg ::= DEFAULT PLUS term",
 /*  49 */ "carg ::= DEFAULT MINUS term",
 /*  50 */ "carg ::= DEFAULT id",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "autoinc ::=",
 /*  60 */ "autoinc ::= AUTOINCR",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= raisetype",
 /*  93 */ "resolvetype ::= IGNORE",
 /*  94 */ "resolvetype ::= REPLACE",
 /*  95 */ "cmd ::= DROP TABLE fullname",
 /*  96 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  97 */ "cmd ::= DROP VIEW fullname",
 /*  98 */ "cmd ::= select",
 /*  99 */ "select ::= oneselect",
 /* 100 */ "select ::= select multiselect_op oneselect",
 /* 101 */ "multiselect_op ::= UNION",
 /* 102 */ "multiselect_op ::= UNION ALL",
 /* 103 */ "multiselect_op ::= INTERSECT",
 /* 104 */ "multiselect_op ::= EXCEPT",
 /* 105 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 106 */ "distinct ::= DISTINCT",
 /* 107 */ "distinct ::= ALL",
 /* 108 */ "distinct ::=",
 /* 109 */ "sclp ::= selcollist COMMA",
 /* 110 */ "sclp ::=",
 /* 111 */ "selcollist ::= sclp expr as",
 /* 112 */ "selcollist ::= sclp STAR",
 /* 113 */ "selcollist ::= sclp nm DOT STAR",
 /* 114 */ "as ::= AS nm",
 /* 115 */ "as ::= ids",
 /* 116 */ "as ::=",
 /* 117 */ "from ::=",
 /* 118 */ "from ::= FROM seltablist",
 /* 119 */ "stl_prefix ::= seltablist joinop",
 /* 120 */ "stl_prefix ::=",
 /* 121 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 122 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 123 */ "seltablist_paren ::= select",
 /* 124 */ "seltablist_paren ::= seltablist",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "fullname ::= nm dbnm",
 /* 128 */ "joinop ::= COMMA",
 /* 129 */ "joinop ::= JOIN",
 /* 130 */ "joinop ::= JOIN_KW JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 133 */ "on_opt ::= ON expr",
 /* 134 */ "on_opt ::=",
 /* 135 */ "using_opt ::= USING LP inscollist RP",
 /* 136 */ "using_opt ::=",
 /* 137 */ "orderby_opt ::=",
 /* 138 */ "orderby_opt ::= ORDER BY sortlist",
 /* 139 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 140 */ "sortlist ::= sortitem collate sortorder",
 /* 141 */ "sortitem ::= expr",
 /* 142 */ "sortorder ::= ASC",
 /* 143 */ "sortorder ::= DESC",
 /* 144 */ "sortorder ::=",
 /* 145 */ "collate ::=",
 /* 146 */ "collate ::= COLLATE id",
 /* 147 */ "groupby_opt ::=",
 /* 148 */ "groupby_opt ::= GROUP BY exprlist",
 /* 149 */ "having_opt ::=",
 /* 150 */ "having_opt ::= HAVING expr",
 /* 151 */ "limit_opt ::=",
 /* 152 */ "limit_opt ::= LIMIT expr",
 /* 153 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 154 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 155 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 156 */ "where_opt ::=",
 /* 157 */ "where_opt ::= WHERE expr",
 /* 158 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 159 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 160 */ "setlist ::= nm EQ expr",
 /* 161 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 162 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 163 */ "insert_cmd ::= INSERT orconf",
 /* 164 */ "insert_cmd ::= REPLACE",
 /* 165 */ "itemlist ::= itemlist COMMA expr",
 /* 166 */ "itemlist ::= expr",
 /* 167 */ "inscollist_opt ::=",
 /* 168 */ "inscollist_opt ::= LP inscollist RP",
 /* 169 */ "inscollist ::= inscollist COMMA nm",
 /* 170 */ "inscollist ::= nm",
 /* 171 */ "expr ::= term",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "term ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "term ::= INTEGER",
 /* 179 */ "term ::= FLOAT",
 /* 180 */ "term ::= STRING",
 /* 181 */ "term ::= BLOB",
 /* 182 */ "expr ::= REGISTER",
 /* 183 */ "expr ::= VARIABLE",
 /* 184 */ "expr ::= ID LP exprlist RP",
 /* 185 */ "expr ::= ID LP STAR RP",
 /* 186 */ "term ::= CTIME_KW",
 /* 187 */ "expr ::= expr AND expr",
 /* 188 */ "expr ::= expr OR expr",
 /* 189 */ "expr ::= expr LT expr",
 /* 190 */ "expr ::= expr GT expr",
 /* 191 */ "expr ::= expr LE expr",
 /* 192 */ "expr ::= expr GE expr",
 /* 193 */ "expr ::= expr NE expr",
 /* 194 */ "expr ::= expr EQ expr",
 /* 195 */ "expr ::= expr BITAND expr",
 /* 196 */ "expr ::= expr BITOR expr",
 /* 197 */ "expr ::= expr LSHIFT expr",
 /* 198 */ "expr ::= expr RSHIFT expr",
 /* 199 */ "expr ::= expr PLUS expr",
 /* 200 */ "expr ::= expr MINUS expr",
 /* 201 */ "expr ::= expr STAR expr",
 /* 202 */ "expr ::= expr SLASH expr",
 /* 203 */ "expr ::= expr REM expr",
 /* 204 */ "expr ::= expr CONCAT expr",
 /* 205 */ "likeop ::= LIKE_KW",
 /* 206 */ "likeop ::= NOT LIKE_KW",
 /* 207 */ "escape ::= ESCAPE expr",
 /* 208 */ "escape ::=",
 /* 209 */ "expr ::= expr likeop expr escape",
 /* 210 */ "expr ::= expr ISNULL",
 /* 211 */ "expr ::= expr IS NULL",
 /* 212 */ "expr ::= expr NOTNULL",
 /* 213 */ "expr ::= expr NOT NULL",
 /* 214 */ "expr ::= expr IS NOT NULL",
 /* 215 */ "expr ::= NOT expr",
 /* 216 */ "expr ::= BITNOT expr",
 /* 217 */ "expr ::= MINUS expr",
 /* 218 */ "expr ::= PLUS expr",
 /* 219 */ "between_op ::= BETWEEN",
 /* 220 */ "between_op ::= NOT BETWEEN",
 /* 221 */ "expr ::= expr between_op expr AND expr",
 /* 222 */ "in_op ::= IN",
 /* 223 */ "in_op ::= NOT IN",
 /* 224 */ "expr ::= expr in_op LP exprlist RP",
 /* 225 */ "expr ::= LP select RP",
 /* 226 */ "expr ::= expr in_op LP select RP",
 /* 227 */ "expr ::= expr in_op nm dbnm",
 /* 228 */ "expr ::= EXISTS LP select RP",
 /* 229 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 230 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 231 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 232 */ "case_else ::= ELSE expr",
 /* 233 */ "case_else ::=",
 /* 234 */ "case_operand ::= expr",
 /* 235 */ "case_operand ::=",
 /* 236 */ "exprlist ::= exprlist COMMA expritem",
 /* 237 */ "exprlist ::= expritem",
 /* 238 */ "expritem ::= expr",
 /* 239 */ "expritem ::=",
 /* 240 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 241 */ "uniqueflag ::= UNIQUE",
 /* 242 */ "uniqueflag ::=",
 /* 243 */ "idxlist_opt ::=",
 /* 244 */ "idxlist_opt ::= LP idxlist RP",
 /* 245 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 246 */ "idxlist ::= idxitem collate sortorder",
 /* 247 */ "idxitem ::= nm",
 /* 248 */ "cmd ::= DROP INDEX fullname",
 /* 249 */ "cmd ::= VACUUM",
 /* 250 */ "cmd ::= VACUUM nm",
 /* 251 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 252 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 253 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 254 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 255 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 256 */ "cmd ::= PRAGMA nm dbnm",
 /* 257 */ "plus_num ::= plus_opt number",
 /* 258 */ "minus_num ::= MINUS number",
 /* 259 */ "number ::= INTEGER",
 /* 260 */ "number ::= FLOAT",
 /* 261 */ "plus_opt ::= PLUS",
 /* 262 */ "plus_opt ::=",
 /* 263 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 264 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 265 */ "trigger_time ::= BEFORE",
 /* 266 */ "trigger_time ::= AFTER",
 /* 267 */ "trigger_time ::= INSTEAD OF",
 /* 268 */ "trigger_time ::=",
 /* 269 */ "trigger_event ::= DELETE",
 /* 270 */ "trigger_event ::= INSERT",
 /* 271 */ "trigger_event ::= UPDATE",
 /* 272 */ "trigger_event ::= UPDATE OF inscollist",
 /* 273 */ "foreach_clause ::=",
 /* 274 */ "foreach_clause ::= FOR EACH ROW",
 /* 275 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 276 */ "when_clause ::=",
 /* 277 */ "when_clause ::= WHEN expr",
 /* 278 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 279 */ "trigger_cmd_list ::=",
 /* 280 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 281 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 282 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 283 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 284 */ "trigger_cmd ::= select",
 /* 285 */ "expr ::= RAISE LP IGNORE RP",
 /* 286 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 287 */ "raisetype ::= ROLLBACK",
 /* 288 */ "raisetype ::= ABORT",
 /* 289 */ "raisetype ::= FAIL",
 /* 290 */ "cmd ::= DROP TRIGGER fullname",
 /* 291 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 292 */ "key_opt ::=",
 /* 293 */ "key_opt ::= KEY ids",
 /* 294 */ "key_opt ::= KEY BLOB",
 /* 295 */ "database_kw_opt ::= DATABASE",
 /* 296 */ "database_kw_opt ::=",
 /* 297 */ "cmd ::= DETACH database_kw_opt nm",
 /* 298 */ "cmd ::= REINDEX",
 /* 299 */ "cmd ::= REINDEX nm dbnm",
 /* 300 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 301 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 302 */ "add_column_fullname ::= fullname",
 /* 303 */ "kwcolumn_opt ::=",
 /* 304 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 157:
    case 189:
    case 206:
#line 334 "parse.y"
{sqlite3SelectDelete((yypminor->yy459));}
#line 1305 "parse.c"
      break;
    case 170:
    case 174:
    case 194:
    case 196:
    case 204:
    case 210:
    case 224:
#line 593 "parse.y"
{sqlite3ExprDelete((yypminor->yy2));}
#line 1316 "parse.c"
      break;
    case 175:
    case 183:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 212:
    case 213:
    case 216:
    case 222:
#line 812 "parse.y"
{sqlite3ExprListDelete((yypminor->yy82));}
#line 1331 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 463 "parse.y"
{sqlite3SrcListDelete((yypminor->yy67));}
#line 1339 "parse.c"
      break;
    case 198:
#line 525 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy244).pLimit);
  sqlite3ExprDelete((yypminor->yy244).pOffset);
}
#line 1347 "parse.c"
      break;
    case 205:
    case 208:
    case 215:
#line 481 "parse.y"
{sqlite3IdListDelete((yypminor->yy240));}
#line 1354 "parse.c"
      break;
    case 230:
    case 235:
#line 905 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy347));}
#line 1360 "parse.c"
      break;
    case 232:
#line 889 "parse.y"
{sqlite3IdListDelete((yypminor->yy210).b);}
#line 1365 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 145, 1 },
  { 144, 1 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 146, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 151, 5 },
  { 153, 1 },
  { 153, 0 },
  { 152, 4 },
  { 152, 2 },
  { 155, 3 },
  { 155, 1 },
  { 158, 3 },
  { 159, 1 },
  { 162, 1 },
  { 163, 1 },
  { 163, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 160, 0 },
  { 160, 1 },
  { 160, 4 },
  { 160, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 161, 2 },
  { 161, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 5 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 173, 0 },
  { 173, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 156, 0 },
  { 156, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 3 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 171, 0 },
  { 171, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 146, 3 },
  { 146, 7 },
  { 146, 3 },
  { 146, 1 },
  { 157, 1 },
  { 157, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 154, 0 },
  { 154, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 5 },
  { 209, 3 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 211, 0 },
  { 211, 2 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 146, 4 },
  { 194, 0 },
  { 194, 2 },
  { 146, 6 },
  { 213, 5 },
  { 213, 3 },
  { 146, 8 },
  { 146, 5 },
  { 214, 2 },
  { 214, 1 },
  { 216, 3 },
  { 216, 1 },
  { 215, 0 },
  { 215, 3 },
  { 208, 3 },
  { 208, 1 },
  { 174, 1 },
  { 174, 3 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 4 },
  { 174, 4 },
  { 170, 1 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 174, 4 },
  { 174, 2 },
  { 174, 3 },
  { 174, 2 },
  { 174, 3 },
  { 174, 4 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 219, 1 },
  { 219, 2 },
  { 174, 5 },
  { 220, 1 },
  { 220, 2 },
  { 174, 5 },
  { 174, 3 },
  { 174, 5 },
  { 174, 4 },
  { 174, 4 },
  { 174, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 212, 3 },
  { 212, 1 },
  { 224, 1 },
  { 224, 0 },
  { 146, 11 },
  { 225, 1 },
  { 225, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 226, 1 },
  { 146, 3 },
  { 146, 1 },
  { 146, 2 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 6 },
  { 146, 3 },
  { 166, 2 },
  { 167, 2 },
  { 228, 1 },
  { 228, 1 },
  { 227, 1 },
  { 227, 0 },
  { 146, 5 },
  { 229, 10 },
  { 231, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 0 },
  { 232, 1 },
  { 232, 1 },
  { 232, 1 },
  { 232, 3 },
  { 233, 0 },
  { 233, 3 },
  { 233, 3 },
  { 234, 0 },
  { 234, 2 },
  { 230, 3 },
  { 230, 0 },
  { 235, 6 },
  { 235, 8 },
  { 235, 5 },
  { 235, 4 },
  { 235, 1 },
  { 174, 4 },
  { 174, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 146, 3 },
  { 146, 6 },
  { 237, 0 },
  { 237, 2 },
  { 237, 2 },
  { 236, 1 },
  { 236, 0 },
  { 146, 3 },
  { 146, 1 },
  { 146, 3 },
  { 146, 6 },
  { 146, 6 },
  { 238, 1 },
  { 239, 0 },
  { 239, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 84 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1897 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1902 "parse.c"
        break;
      case 7:
#line 89 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1907 "parse.c"
        break;
      case 8:
#line 95 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy412);}
#line 1912 "parse.c"
        break;
      case 12:
#line 100 "parse.y"
{yygotominor.yy412 = TK_DEFERRED;}
#line 1917 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 101:
      case 103:
      case 104:
#line 101 "parse.y"
{yygotominor.yy412 = yymsp[0].major;}
#line 1927 "parse.c"
        break;
      case 16:
      case 17:
#line 104 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1933 "parse.c"
        break;
      case 18:
#line 106 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1938 "parse.c"
        break;
      case 20:
#line 111 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258,yymsp[-3].minor.yy412,0);
}
#line 1945 "parse.c"
        break;
      case 21:
      case 60:
      case 74:
      case 106:
      case 220:
      case 223:
#line 116 "parse.y"
{yygotominor.yy412 = 1;}
#line 1955 "parse.c"
        break;
      case 22:
      case 59:
      case 73:
      case 75:
      case 86:
      case 107:
      case 108:
      case 219:
      case 222:
#line 118 "parse.y"
{yygotominor.yy412 = 0;}
#line 1968 "parse.c"
        break;
      case 23:
#line 119 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy0,0);
}
#line 1975 "parse.c"
        break;
      case 24:
#line 122 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy459);
  sqlite3SelectDelete(yymsp[0].minor.yy459);
}
#line 1983 "parse.c"
        break;
      case 27:
#line 133 "parse.y"
{
  yygotominor.yy258.z = yymsp[-2].minor.yy258.z;
  yygotominor.yy258.n = (pParse->sLastToken.z-yymsp[-2].minor.yy258.z) + pParse->sLastToken.n;
}
#line 1991 "parse.c"
        break;
      case 28:
#line 137 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy258);
  yygotominor.yy258 = yymsp[0].minor.yy258;
}
#line 1999 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 259:
      case 260:
#line 147 "parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 2011 "parse.c"
        break;
      case 36:
#line 202 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy258,&yymsp[0].minor.yy258);}
#line 2016 "parse.c"
        break;
      case 37:
#line 203 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy258,&yymsp[0].minor.yy0);}
#line 2021 "parse.c"
        break;
      case 38:
#line 205 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy258,&yymsp[0].minor.yy0);}
#line 2026 "parse.c"
        break;
      case 39:
      case 114:
      case 115:
      case 126:
      case 146:
      case 247:
      case 257:
      case 258:
#line 207 "parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 2038 "parse.c"
        break;
      case 40:
#line 208 "parse.y"
{yygotominor.yy258.z=yymsp[-1].minor.yy258.z; yygotominor.yy258.n=yymsp[0].minor.yy258.n+(yymsp[0].minor.yy258.z-yymsp[-1].minor.yy258.z);}
#line 2043 "parse.c"
        break;
      case 41:
#line 210 "parse.y"
{ yygotominor.yy412 = atoi(yymsp[0].minor.yy258.z); }
#line 2048 "parse.c"
        break;
      case 42:
#line 211 "parse.y"
{ yygotominor.yy412 = -atoi(yymsp[0].minor.yy258.z); }
#line 2053 "parse.c"
        break;
      case 47:
      case 48:
#line 216 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy2);}
#line 2059 "parse.c"
        break;
      case 49:
#line 218 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2067 "parse.c"
        break;
      case 50:
#line 222 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy258);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2075 "parse.c"
        break;
      case 52:
#line 231 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy412);}
#line 2080 "parse.c"
        break;
      case 53:
#line 233 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy412,yymsp[0].minor.yy412);}
#line 2085 "parse.c"
        break;
      case 54:
#line 234 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy412,0,0);}
#line 2090 "parse.c"
        break;
      case 55:
#line 235 "parse.y"
{sqlite3ExprDelete(yymsp[-2].minor.yy2);}
#line 2095 "parse.c"
        break;
      case 56:
#line 237 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy258,yymsp[-1].minor.yy82,yymsp[0].minor.yy412);}
#line 2100 "parse.c"
        break;
      case 57:
#line 238 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy412);}
#line 2105 "parse.c"
        break;
      case 58:
#line 239 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy258.z, yymsp[0].minor.yy258.n);}
#line 2110 "parse.c"
        break;
      case 61:
#line 252 "parse.y"
{ yygotominor.yy412 = OE_Restrict * 0x010101; }
#line 2115 "parse.c"
        break;
      case 62:
#line 253 "parse.y"
{ yygotominor.yy412 = (yymsp[-1].minor.yy412 & yymsp[0].minor.yy47.mask) | yymsp[0].minor.yy47.value; }
#line 2120 "parse.c"
        break;
      case 63:
#line 255 "parse.y"
{ yygotominor.yy47.value = 0;     yygotominor.yy47.mask = 0x000000; }
#line 2125 "parse.c"
        break;
      case 64:
#line 256 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412;     yygotominor.yy47.mask = 0x0000ff; }
#line 2130 "parse.c"
        break;
      case 65:
#line 257 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412<<8;  yygotominor.yy47.mask = 0x00ff00; }
#line 2135 "parse.c"
        break;
      case 66:
#line 258 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412<<16; yygotominor.yy47.mask = 0xff0000; }
#line 2140 "parse.c"
        break;
      case 67:
#line 260 "parse.y"
{ yygotominor.yy412 = OE_SetNull; }
#line 2145 "parse.c"
        break;
      case 68:
#line 261 "parse.y"
{ yygotominor.yy412 = OE_SetDflt; }
#line 2150 "parse.c"
        break;
      case 69:
#line 262 "parse.y"
{ yygotominor.yy412 = OE_Cascade; }
#line 2155 "parse.c"
        break;
      case 70:
#line 263 "parse.y"
{ yygotominor.yy412 = OE_Restrict; }
#line 2160 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 89:
      case 91:
      case 92:
      case 163:
#line 265 "parse.y"
{yygotominor.yy412 = yymsp[0].minor.yy412;}
#line 2171 "parse.c"
        break;
      case 76:
#line 275 "parse.y"
{yygotominor.yy258.n = 0; yygotominor.yy258.z = 0;}
#line 2176 "parse.c"
        break;
      case 77:
#line 276 "parse.y"
{yygotominor.yy258 = yymsp[-1].minor.yy0;}
#line 2181 "parse.c"
        break;
      case 82:
#line 282 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy82,yymsp[0].minor.yy412,yymsp[-2].minor.yy412);}
#line 2186 "parse.c"
        break;
      case 83:
#line 284 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy82,yymsp[0].minor.yy412,0,0);}
#line 2191 "parse.c"
        break;
      case 85:
#line 287 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy82, &yymsp[-3].minor.yy258, yymsp[-2].minor.yy82, yymsp[-1].minor.yy412);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy412);
}
#line 2199 "parse.c"
        break;
      case 88:
      case 90:
#line 301 "parse.y"
{yygotominor.yy412 = OE_Default;}
#line 2205 "parse.c"
        break;
      case 93:
#line 306 "parse.y"
{yygotominor.yy412 = OE_Ignore;}
#line 2210 "parse.c"
        break;
      case 94:
      case 164:
#line 307 "parse.y"
{yygotominor.yy412 = OE_Replace;}
#line 2216 "parse.c"
        break;
      case 95:
#line 311 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy67, 0);
}
#line 2223 "parse.c"
        break;
      case 96:
#line 318 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy258, &yymsp[-2].minor.yy258, yymsp[0].minor.yy459, yymsp[-5].minor.yy412);
}
#line 2230 "parse.c"
        break;
      case 97:
#line 321 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy67, 1);
}
#line 2237 "parse.c"
        break;
      case 98:
#line 328 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy459, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy459);
}
#line 2245 "parse.c"
        break;
      case 99:
      case 123:
#line 338 "parse.y"
{yygotominor.yy459 = yymsp[0].minor.yy459;}
#line 2251 "parse.c"
        break;
      case 100:
#line 340 "parse.y"
{
  if( yymsp[0].minor.yy459 ){
    yymsp[0].minor.yy459->op = yymsp[-1].minor.yy412;
    yymsp[0].minor.yy459->pPrior = yymsp[-2].minor.yy459;
  }
  yygotominor.yy459 = yymsp[0].minor.yy459;
}
#line 2262 "parse.c"
        break;
      case 102:
#line 349 "parse.y"
{yygotominor.yy412 = TK_ALL;}
#line 2267 "parse.c"
        break;
      case 105:
#line 354 "parse.y"
{
  yygotominor.yy459 = sqlite3SelectNew(yymsp[-6].minor.yy82,yymsp[-5].minor.yy67,yymsp[-4].minor.yy2,yymsp[-3].minor.yy82,yymsp[-2].minor.yy2,yymsp[-1].minor.yy82,yymsp[-7].minor.yy412,yymsp[0].minor.yy244.pLimit,yymsp[0].minor.yy244.pOffset);
}
#line 2274 "parse.c"
        break;
      case 109:
      case 244:
#line 375 "parse.y"
{yygotominor.yy82 = yymsp[-1].minor.yy82;}
#line 2280 "parse.c"
        break;
      case 110:
      case 137:
      case 147:
      case 243:
#line 376 "parse.y"
{yygotominor.yy82 = 0;}
#line 2288 "parse.c"
        break;
      case 111:
#line 377 "parse.y"
{
   yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-2].minor.yy82,yymsp[-1].minor.yy2,yymsp[0].minor.yy258.n?&yymsp[0].minor.yy258:0);
}
#line 2295 "parse.c"
        break;
      case 112:
#line 380 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-1].minor.yy82, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2302 "parse.c"
        break;
      case 113:
#line 383 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-3].minor.yy82, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2311 "parse.c"
        break;
      case 116:
#line 395 "parse.y"
{yygotominor.yy258.n = 0;}
#line 2316 "parse.c"
        break;
      case 117:
#line 407 "parse.y"
{yygotominor.yy67 = sqliteMalloc(sizeof(*yygotominor.yy67));}
#line 2321 "parse.c"
        break;
      case 118:
#line 408 "parse.y"
{yygotominor.yy67 = yymsp[0].minor.yy67;}
#line 2326 "parse.c"
        break;
      case 119:
#line 413 "parse.y"
{
   yygotominor.yy67 = yymsp[-1].minor.yy67;
   if( yygotominor.yy67 && yygotominor.yy67->nSrc>0 ) yygotominor.yy67->a[yygotominor.yy67->nSrc-1].jointype = yymsp[0].minor.yy412;
}
#line 2334 "parse.c"
        break;
      case 120:
#line 417 "parse.y"
{yygotominor.yy67 = 0;}
#line 2339 "parse.c"
        break;
      case 121:
#line 418 "parse.y"
{
  yygotominor.yy67 = sqlite3SrcListAppend(yymsp[-5].minor.yy67,&yymsp[-4].minor.yy258,&yymsp[-3].minor.yy258);
  if( yymsp[-2].minor.yy258.n ) sqlite3SrcListAddAlias(yygotominor.yy67,&yymsp[-2].minor.yy258);
  if( yymsp[-1].minor.yy2 ){
    if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pOn = yymsp[-1].minor.yy2; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy2); }
  }
  if( yymsp[0].minor.yy240 ){
    if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pUsing = yymsp[0].minor.yy240; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
  }
}
#line 2355 "parse.c"
        break;
      case 122:
#line 432 "parse.y"
{
    yygotominor.yy67 = sqlite3SrcListAppend(yymsp[-6].minor.yy67,0,0);
    yygotominor.yy67->a[yygotominor.yy67->nSrc-1].pSelect = yymsp[-4].minor.yy459;
    if( yymsp[-2].minor.yy258.n ) sqlite3SrcListAddAlias(yygotominor.yy67,&yymsp[-2].minor.yy258);
    if( yymsp[-1].minor.yy2 ){
      if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pOn = yymsp[-1].minor.yy2; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy2); }
    }
    if( yymsp[0].minor.yy240 ){
      if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pUsing = yymsp[0].minor.yy240; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
    }
  }
#line 2372 "parse.c"
        break;
      case 124:
#line 453 "parse.y"
{
     yygotominor.yy459 = sqlite3SelectNew(0,yymsp[0].minor.yy67,0,0,0,0,0,0,0);
  }
#line 2379 "parse.c"
        break;
      case 125:
#line 459 "parse.y"
{yygotominor.yy258.z=0; yygotominor.yy258.n=0;}
#line 2384 "parse.c"
        break;
      case 127:
#line 464 "parse.y"
{yygotominor.yy67 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258);}
#line 2389 "parse.c"
        break;
      case 128:
      case 129:
#line 468 "parse.y"
{ yygotominor.yy412 = JT_INNER; }
#line 2395 "parse.c"
        break;
      case 130:
#line 470 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2400 "parse.c"
        break;
      case 131:
#line 471 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy258,0); }
#line 2405 "parse.c"
        break;
      case 132:
#line 473 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy258,&yymsp[-1].minor.yy258); }
#line 2410 "parse.c"
        break;
      case 133:
      case 141:
      case 150:
      case 157:
      case 171:
      case 207:
      case 232:
      case 234:
      case 238:
#line 477 "parse.y"
{yygotominor.yy2 = yymsp[0].minor.yy2;}
#line 2423 "parse.c"
        break;
      case 134:
      case 149:
      case 156:
      case 208:
      case 233:
      case 235:
      case 239:
#line 478 "parse.y"
{yygotominor.yy2 = 0;}
#line 2434 "parse.c"
        break;
      case 135:
      case 168:
#line 482 "parse.y"
{yygotominor.yy240 = yymsp[-1].minor.yy240;}
#line 2440 "parse.c"
        break;
      case 136:
      case 167:
#line 483 "parse.y"
{yygotominor.yy240 = 0;}
#line 2446 "parse.c"
        break;
      case 138:
      case 148:
#line 494 "parse.y"
{yygotominor.yy82 = yymsp[0].minor.yy82;}
#line 2452 "parse.c"
        break;
      case 139:
#line 495 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82,yymsp[-2].minor.yy2,yymsp[-1].minor.yy258.n>0?&yymsp[-1].minor.yy258:0);
  if( yygotominor.yy82 ) yygotominor.yy82->a[yygotominor.yy82->nExpr-1].sortOrder = yymsp[0].minor.yy412;
}
#line 2460 "parse.c"
        break;
      case 140:
#line 499 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy2,yymsp[-1].minor.yy258.n>0?&yymsp[-1].minor.yy258:0);
  if( yygotominor.yy82 && yygotominor.yy82->a ) yygotominor.yy82->a[0].sortOrder = yymsp[0].minor.yy412;
}
#line 2468 "parse.c"
        break;
      case 142:
      case 144:
#line 508 "parse.y"
{yygotominor.yy412 = SQLITE_SO_ASC;}
#line 2474 "parse.c"
        break;
      case 143:
#line 509 "parse.y"
{yygotominor.yy412 = SQLITE_SO_DESC;}
#line 2479 "parse.c"
        break;
      case 145:
#line 511 "parse.y"
{yygotominor.yy258.z = 0; yygotominor.yy258.n = 0;}
#line 2484 "parse.c"
        break;
      case 151:
#line 529 "parse.y"
{yygotominor.yy244.pLimit = 0; yygotominor.yy244.pOffset = 0;}
#line 2489 "parse.c"
        break;
      case 152:
#line 530 "parse.y"
{yygotominor.yy244.pLimit = yymsp[0].minor.yy2; yygotominor.yy244.pOffset = 0;}
#line 2494 "parse.c"
        break;
      case 153:
#line 532 "parse.y"
{yygotominor.yy244.pLimit = yymsp[-2].minor.yy2; yygotominor.yy244.pOffset = yymsp[0].minor.yy2;}
#line 2499 "parse.c"
        break;
      case 154:
#line 534 "parse.y"
{yygotominor.yy244.pOffset = yymsp[-2].minor.yy2; yygotominor.yy244.pLimit = yymsp[0].minor.yy2;}
#line 2504 "parse.c"
        break;
      case 155:
#line 538 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy67,yymsp[0].minor.yy2);}
#line 2509 "parse.c"
        break;
      case 158:
#line 549 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy67,yymsp[-1].minor.yy82,yymsp[0].minor.yy2,yymsp[-4].minor.yy412);}
#line 2514 "parse.c"
        break;
      case 159:
#line 555 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82,yymsp[0].minor.yy2,&yymsp[-2].minor.yy258);}
#line 2519 "parse.c"
        break;
      case 160:
#line 556 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(0,yymsp[0].minor.yy2,&yymsp[-2].minor.yy258);}
#line 2524 "parse.c"
        break;
      case 161:
#line 562 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy67, yymsp[-1].minor.yy82, 0, yymsp[-4].minor.yy240, yymsp[-7].minor.yy412);}
#line 2529 "parse.c"
        break;
      case 162:
#line 564 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy67, 0, yymsp[0].minor.yy459, yymsp[-1].minor.yy240, yymsp[-4].minor.yy412);}
#line 2534 "parse.c"
        break;
      case 165:
      case 236:
#line 574 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-2].minor.yy82,yymsp[0].minor.yy2,0);}
#line 2540 "parse.c"
        break;
      case 166:
      case 237:
#line 575 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(0,yymsp[0].minor.yy2,0);}
#line 2546 "parse.c"
        break;
      case 169:
#line 584 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(yymsp[-2].minor.yy240,&yymsp[0].minor.yy258);}
#line 2551 "parse.c"
        break;
      case 170:
#line 585 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(0,&yymsp[0].minor.yy258);}
#line 2556 "parse.c"
        break;
      case 172:
#line 596 "parse.y"
{yygotominor.yy2 = yymsp[-1].minor.yy2; sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2561 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 597 "parse.y"
{yygotominor.yy2 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2570 "parse.c"
        break;
      case 174:
      case 175:
#line 598 "parse.y"
{yygotominor.yy2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2576 "parse.c"
        break;
      case 176:
#line 600 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy258);
  yygotominor.yy2 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2585 "parse.c"
        break;
      case 177:
#line 605 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy258);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy258);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy2 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2596 "parse.c"
        break;
      case 182:
#line 616 "parse.y"
{yygotominor.yy2 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2601 "parse.c"
        break;
      case 183:
#line 617 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy2 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2610 "parse.c"
        break;
      case 184:
#line 622 "parse.y"
{
  yygotominor.yy2 = sqlite3ExprFunction(yymsp[-1].minor.yy82, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2618 "parse.c"
        break;
      case 185:
#line 626 "parse.y"
{
  yygotominor.yy2 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2626 "parse.c"
        break;
      case 186:
#line 630 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy2 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy2 ) yygotominor.yy2->op = TK_CONST_FUNC;  
}
#line 2636 "parse.c"
        break;
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
#line 636 "parse.y"
{yygotominor.yy2 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy2, yymsp[0].minor.yy2, 0);}
#line 2658 "parse.c"
        break;
      case 205:
#line 655 "parse.y"
{yygotominor.yy438.operator = yymsp[0].minor.yy0; yygotominor.yy438.not = 0;}
#line 2663 "parse.c"
        break;
      case 206:
#line 656 "parse.y"
{yygotominor.yy438.operator = yymsp[0].minor.yy0; yygotominor.yy438.not = 1;}
#line 2668 "parse.c"
        break;
      case 209:
#line 660 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy2, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy2, 0);
  if( yymsp[0].minor.yy2 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy2, 0);
  }
  yygotominor.yy2 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy438.operator);
  if( yymsp[-2].minor.yy438.not ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-3].minor.yy2->span, &yymsp[-1].minor.yy2->span);
}
#line 2682 "parse.c"
        break;
      case 210:
#line 671 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2690 "parse.c"
        break;
      case 211:
#line 675 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2698 "parse.c"
        break;
      case 212:
#line 679 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2706 "parse.c"
        break;
      case 213:
#line 683 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2714 "parse.c"
        break;
      case 214:
#line 687 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2722 "parse.c"
        break;
      case 215:
      case 216:
#line 691 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2731 "parse.c"
        break;
      case 217:
#line 699 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2739 "parse.c"
        break;
      case 218:
#line 703 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2747 "parse.c"
        break;
      case 221:
#line 710 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy2, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy2, 0);
  yygotominor.yy2 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy2, 0, 0);
  if( yygotominor.yy2 ) yygotominor.yy2->pList = pList;
  if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy2->span);
}
#line 2759 "parse.c"
        break;
      case 224:
#line 722 "parse.y"
{
    yygotominor.yy2 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy2, 0, 0);
    if( yygotominor.yy2 ){
      yygotominor.yy2->pList = yymsp[-1].minor.yy82;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy82);
    }
    if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy0);
  }
#line 2773 "parse.c"
        break;
      case 225:
#line 732 "parse.y"
{
    yygotominor.yy2 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy2 ) yygotominor.yy2->pSelect = yymsp[-1].minor.yy459;
    if( !yygotominor.yy2 ) sqlite3SelectDelete(yymsp[-1].minor.yy459);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2783 "parse.c"
        break;
      case 226:
#line 738 "parse.y"
{
    yygotominor.yy2 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy2, 0, 0);
    if( yygotominor.yy2 ) yygotominor.yy2->pSelect = yymsp[-1].minor.yy459;
    if( !yygotominor.yy2 ) sqlite3SelectDelete(yymsp[-1].minor.yy459);
    if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy0);
  }
#line 2794 "parse.c"
        break;
      case 227:
#line 745 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258);
    yygotominor.yy2 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy2, 0, 0);
    if( yygotominor.yy2 ) yygotominor.yy2->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    if( yymsp[-2].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy2->span,yymsp[0].minor.yy258.z?&yymsp[0].minor.yy258:&yymsp[-1].minor.yy258);
  }
#line 2805 "parse.c"
        break;
      case 228:
#line 752 "parse.y"
{
    Expr *p = yygotominor.yy2 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy459;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }
    if( !p ) sqlite3SelectDelete(yymsp[-1].minor.yy459);
  }
#line 2817 "parse.c"
        break;
      case 229:
#line 763 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy2, yymsp[-1].minor.yy2, 0);
  if( yygotominor.yy2 ) yygotominor.yy2->pList = yymsp[-2].minor.yy82;
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2826 "parse.c"
        break;
      case 230:
#line 770 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82, yymsp[-2].minor.yy2, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(yygotominor.yy82, yymsp[0].minor.yy2, 0);
}
#line 2834 "parse.c"
        break;
      case 231:
#line 774 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy2, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(yygotominor.yy82, yymsp[0].minor.yy2, 0);
}
#line 2842 "parse.c"
        break;
      case 240:
#line 799 "parse.y"
{
  if( yymsp[-9].minor.yy412!=OE_None ) yymsp[-9].minor.yy412 = yymsp[0].minor.yy412;
  if( yymsp[-9].minor.yy412==OE_Default) yymsp[-9].minor.yy412 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy258, &yymsp[-6].minor.yy258, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy258,0),yymsp[-2].minor.yy82,yymsp[-9].minor.yy412, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2851 "parse.c"
        break;
      case 241:
      case 288:
#line 806 "parse.y"
{yygotominor.yy412 = OE_Abort;}
#line 2857 "parse.c"
        break;
      case 242:
#line 807 "parse.y"
{yygotominor.yy412 = OE_None;}
#line 2862 "parse.c"
        break;
      case 245:
#line 817 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy258.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy258.z, yymsp[-1].minor.yy258.n);
  }
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82, p, &yymsp[-2].minor.yy258);
}
#line 2874 "parse.c"
        break;
      case 246:
#line 825 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy258.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy258.z, yymsp[-1].minor.yy258.n);
  }
  yygotominor.yy82 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy258);
}
#line 2886 "parse.c"
        break;
      case 248:
#line 838 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy67);}
#line 2891 "parse.c"
        break;
      case 249:
      case 250:
#line 842 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2897 "parse.c"
        break;
      case 251:
      case 253:
#line 848 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,0);}
#line 2903 "parse.c"
        break;
      case 252:
#line 849 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy0,0);}
#line 2908 "parse.c"
        break;
      case 254:
#line 851 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,1);
}
#line 2915 "parse.c"
        break;
      case 255:
#line 854 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy258,&yymsp[-3].minor.yy258,&yymsp[-1].minor.yy258,0);}
#line 2920 "parse.c"
        break;
      case 256:
#line 855 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258,0,0);}
#line 2925 "parse.c"
        break;
      case 263:
#line 868 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy258.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy258.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy347, &all);
}
#line 2935 "parse.c"
        break;
      case 264:
#line 877 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy258, &yymsp[-6].minor.yy258, yymsp[-5].minor.yy412, yymsp[-4].minor.yy210.a, yymsp[-4].minor.yy210.b, yymsp[-2].minor.yy67, yymsp[-1].minor.yy412, yymsp[0].minor.yy2, yymsp[-9].minor.yy412);
  yygotominor.yy258 = (yymsp[-6].minor.yy258.n==0?yymsp[-7].minor.yy258:yymsp[-6].minor.yy258);
}
#line 2943 "parse.c"
        break;
      case 265:
      case 268:
#line 883 "parse.y"
{ yygotominor.yy412 = TK_BEFORE; }
#line 2949 "parse.c"
        break;
      case 266:
#line 884 "parse.y"
{ yygotominor.yy412 = TK_AFTER;  }
#line 2954 "parse.c"
        break;
      case 267:
#line 885 "parse.y"
{ yygotominor.yy412 = TK_INSTEAD;}
#line 2959 "parse.c"
        break;
      case 269:
      case 270:
      case 271:
#line 890 "parse.y"
{yygotominor.yy210.a = yymsp[0].major; yygotominor.yy210.b = 0;}
#line 2966 "parse.c"
        break;
      case 272:
#line 893 "parse.y"
{yygotominor.yy210.a = TK_UPDATE; yygotominor.yy210.b = yymsp[0].minor.yy240;}
#line 2971 "parse.c"
        break;
      case 273:
      case 274:
#line 896 "parse.y"
{ yygotominor.yy412 = TK_ROW; }
#line 2977 "parse.c"
        break;
      case 275:
#line 898 "parse.y"
{ yygotominor.yy412 = TK_STATEMENT; }
#line 2982 "parse.c"
        break;
      case 276:
#line 901 "parse.y"
{ yygotominor.yy2 = 0; }
#line 2987 "parse.c"
        break;
      case 277:
#line 902 "parse.y"
{ yygotominor.yy2 = yymsp[0].minor.yy2; }
#line 2992 "parse.c"
        break;
      case 278:
#line 906 "parse.y"
{
  yymsp[-2].minor.yy347->pNext = yymsp[0].minor.yy347;
  yygotominor.yy347 = yymsp[-2].minor.yy347;
}
#line 3000 "parse.c"
        break;
      case 279:
#line 910 "parse.y"
{ yygotominor.yy347 = 0; }
#line 3005 "parse.c"
        break;
      case 280:
#line 916 "parse.y"
{ yygotominor.yy347 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy258, yymsp[-1].minor.yy82, yymsp[0].minor.yy2, yymsp[-4].minor.yy412); }
#line 3010 "parse.c"
        break;
      case 281:
#line 921 "parse.y"
{yygotominor.yy347 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy258, yymsp[-4].minor.yy240, yymsp[-1].minor.yy82, 0, yymsp[-7].minor.yy412);}
#line 3015 "parse.c"
        break;
      case 282:
#line 924 "parse.y"
{yygotominor.yy347 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy258, yymsp[-1].minor.yy240, 0, yymsp[0].minor.yy459, yymsp[-4].minor.yy412);}
#line 3020 "parse.c"
        break;
      case 283:
#line 928 "parse.y"
{yygotominor.yy347 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy258, yymsp[0].minor.yy2);}
#line 3025 "parse.c"
        break;
      case 284:
#line 931 "parse.y"
{yygotominor.yy347 = sqlite3TriggerSelectStep(yymsp[0].minor.yy459); }
#line 3030 "parse.c"
        break;
      case 285:
#line 934 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy2->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3039 "parse.c"
        break;
      case 286:
#line 939 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy258); 
  yygotominor.yy2->iColumn = yymsp[-3].minor.yy412;
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3048 "parse.c"
        break;
      case 287:
#line 947 "parse.y"
{yygotominor.yy412 = OE_Rollback;}
#line 3053 "parse.c"
        break;
      case 289:
#line 949 "parse.y"
{yygotominor.yy412 = OE_Fail;}
#line 3058 "parse.c"
        break;
      case 290:
#line 954 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy67);
}
#line 3065 "parse.c"
        break;
      case 291:
#line 960 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy258, &yymsp[-1].minor.yy258, yymsp[0].minor.yy132.type, &yymsp[0].minor.yy132.key);
}
#line 3072 "parse.c"
        break;
      case 292:
#line 964 "parse.y"
{ yygotominor.yy132.type = 0; }
#line 3077 "parse.c"
        break;
      case 293:
#line 965 "parse.y"
{ yygotominor.yy132.type=1; yygotominor.yy132.key = yymsp[0].minor.yy258; }
#line 3082 "parse.c"
        break;
      case 294:
#line 966 "parse.y"
{ yygotominor.yy132.type=2; yygotominor.yy132.key = yymsp[0].minor.yy0; }
#line 3087 "parse.c"
        break;
      case 297:
#line 972 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy258);
}
#line 3094 "parse.c"
        break;
      case 298:
#line 978 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3099 "parse.c"
        break;
      case 299:
#line 979 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy258, &yymsp[0].minor.yy258);}
#line 3104 "parse.c"
        break;
      case 300:
#line 984 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy67,&yymsp[0].minor.yy258);
}
#line 3111 "parse.c"
        break;
      case 301:
#line 987 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy258);
}
#line 3118 "parse.c"
        break;
      case 302:
#line 990 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy67);
}
#line 3125 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3192 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
