use ExtUtils::MakeMaker;

# Read OpenSSL install path from file generated by ../Makefile
open(F,"./openssl_path") or die "Run ../Makefile.PL first\n";
my $openssl = <F>;
close(F);

print "Using OpenSSL from '$openssl' (cached)\n";

my $define = '-DNet -DDUFF';
$define .= ' -DWIN32 -DPERL_STATIC_SYMS' if ($^O eq 'MSWin32');


if ($^O eq 'VMS') {  # Old VAXC compiler can't handle Duff's device
    require Config;
    $define =~ s/\s+-DDUFF// if $Config::Config{'vms_cc_type'} eq 'vaxc';
}

my $libs = $ms ? "-llibeay32 -lssleay32" : "-lssl -lcrypto",

WriteMakefile(
	NAME		=> 'libnet',
#	LINKTYPE	=> 'static',
	DEFINE		=> $define,


	LIBS		=> ["-L$openssl -L$openssl/lib $libs"],
	INC			=> "-I$openssl/include",

	INST_ARCHLIB=> '.',
	SKIP		=> [qw(dynamic dynamic_lib dlsyms)],
	OBJECT		=> '$(O_FILES)',
	clean		=> {'FILES' => "libnet$LIB_EXT"},
	H			=> [qw(net.h $(PERL_INC)/config.h)],
	C			=> [qw(net.c unix.c inet.c ssl.c tcp.c)],
);

sub MY::constants {
  package MY;
  my $r = shift->SUPER::constants();
  if ($^O eq 'VMS') {
    $r =~ s/^INST_STATIC =.*$/INST_STATIC = libnet\$(LIB_EXT)/m
  }
  return $r;
}

sub MY::post_constants {
  package MY;
  if ($^O eq 'VMS') {
    shift->SUPER::post_constants();
  } else {
'
INST_STATIC = libnet$(LIB_EXT)
'
  }
}

sub MY::top_targets {
    my $noecho = shift->{NOECHO};
    
    my $r = '
all :: static
	' . $noecho . '$(NOOP)

config ::
	' . $noecho . '$(NOOP)

lint:
	lint -abchx $(LIBSRCS)

pureall:

';
    $r .= '
# This is a workaround, the problem is that our old GNU make exports
# variables into the environment so $(MYEXTLIB) is set in here to this
# value which can not be built.
libnet/libnet.a:
	' . $noecho . '$(NOOP)
' unless $^O eq 'VMS';

    return $r;
}
