# cvswebconfig.pl

################# Configuration section: ##################

$cvswebview_url = '/cgi-bin/cvsweb.pl';
$cvswebview_dbg = '/tmp/cvswebview.out';

$cvswebedit_url = '/cgi-bin/cvswebedit.pl';
$cvswebedit_state = '/disk2/mrjc/cvsweb_upload';
$cvswebedit_dbg = '/tmp/cvswebedit.out';
$cvswebedit_userdb = '/disk2/mrjc/cvsweb_upload/userdb';
$cvswebedit_cookie_name = 'cvswebedit';

$cvstreedefault = 'rweb_entl';
$administrator = 'Martin.Cleaver@BCS.org.uk';

###########################################################

# Set $cvsroot to the root of the CVS tree
%CVSROOT = (
            'freebsd', '/home/ncvs',
            'openbsd', '/home/OpenBSD/cvs',
            'learn', '/c/learncvs',
	    'rweb_entl', '/usr/cvs_base',
            );

$cvstree = $cvstreedefault;
$cvsroot = $CVSROOT{"$cvstree"} || "/home/ncvs";

$config = '/usr/local/etc/cvsweb';
do "$config" if -f $config;

if ($input{'cvsroot'}) {
    if ($CVSROOT{$input{'cvsroot'}}) {
        $cvstree = $input{'cvsroot'};
        $cvsroot = $CVSROOT{"$cvstree"};
    }
}
do "$config-$cvstree" if -f "$config-$cvstree";

#
# Settings for the META information page
#

$metaprogs{WHAT} = '/usr/ccs/bin/what';
$metaprogs{IDENT} = '/usr/local/bin/ident';
$metaprogs{SORT} = 'sort -u';
$metaprogs{LDD} = 'ldd';
#$metaprogs{FILE} = 'file';

#
# Modify environment if necessary #FIXME: delete this.
#

# Set $rcsbinaries to the location of the RCS binaries, if they're
# not in the web server's $PATH
$rcsbinaries = '/usr/local/bin';
if (defined($rcsbinaries)) {
	$ENV{'PATH'} = $rcsbinaries . ":" . $ENV{'PATH'};
}

# The HTML title will be $title: /pathname
$title = "Entitlements Team CVS Tree";

# The HTML to go inside the <H1> tag
$h1 = "Entitlements Team CVS Tree";

# $intro is the HTML that is displayed along with the
# top-level tree
$intro = <<EOM;

This is a WWW interface to the Entitlements Team CVS tree.
You can browse the file hierarchy by picking directories
(which have slashes after them, e.g. <b>src/</b>).
If you pick a file, you will see the revision history
for that file.
<p>
Selecting a revision number will download that revision of
the file.  There is a link at each revision to display
diffs between that revision and the previous one, and
a form at the bottom of the page that allows you to
display diffs between arbitrary revisions.
<p>
Please send any suggestions, comments, etc. to:
EOM

$intro .="<A HREF=\"mailto:".$administrator."\">".$administrator."</A>\n";
#

# $shortinstr is the HTML displayed at the top of non-top-level
# directory listings.
$shortinstr = <<EOM;
Click on a directory to enter that directory. Click on a file to display
its revision history and to get a
chance to display diffs between revisions. 
EOM


#
# $backicon is the icon to be used for the previous directory, if any
$backicon = "/icons/back.gif";

# $diricon is the icon to be used for a directory, if any
$diricon = "/icons/dir.gif";

# $texticon is the icon to be used for a text file, if any
$texticon = "/icons/text.gif";
#

# $tailhtml is the html for the bottom of the page
$tailhtml ="
<ADDRESS>
  <A HREF=\"mailto:$ENV{SERVER_ADMIN}\">$ENV{SERVER_ADMIN}</A>
</ADDRESS>";

1;


