/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileDiamond
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock north;
    private final TextBlock south;
    private final TextBlock west1;
    private final TextBlock east1;

    public FtileDiamond(boolean bl, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane) {
        this(bl, htmlColor, htmlColor2, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamond withNorth(TextBlock textBlock) {
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, textBlock, this.south, this.east1, this.west1);
    }

    public FtileDiamond withWest(TextBlock textBlock) {
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, this.east1, textBlock);
    }

    public FtileDiamond withEast(TextBlock textBlock) {
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, textBlock, this.west1);
    }

    public FtileDiamond withSouth(TextBlock textBlock) {
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.north, textBlock, this.east1, this.west1);
    }

    private FtileDiamond(boolean bl, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane, TextBlock textBlock, TextBlock textBlock2, TextBlock textBlock3, TextBlock textBlock4) {
        super(bl);
        this.backColor = htmlColor;
        this.swimlane = swimlane;
        this.borderColor = htmlColor2;
        this.north = textBlock;
        this.west1 = textBlock4;
        this.east1 = textBlock3;
        this.south = textBlock2;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor)).draw(Diamond.asPolygon(this.shadowing()));
        Dimension2D dimension2D = this.north.calculateDimension(uGraphic.getStringBounder());
        this.north.drawU(uGraphic.apply(new UTranslate(18.0, -dimension2D.getHeight() - 12.0)));
        Dimension2D dimension2D2 = this.south.calculateDimension(uGraphic.getStringBounder());
        this.south.drawU(uGraphic.apply(new UTranslate(-(dimension2D2.getWidth() - 24.0) / 2.0, 24.0)));
        Dimension2D dimension2D3 = this.west1.calculateDimension(uGraphic.getStringBounder());
        this.west1.drawU(uGraphic.apply(new UTranslate(-dimension2D3.getWidth(), -dimension2D3.getHeight() + 12.0)));
        Dimension2D dimension2D4 = this.east1.calculateDimension(uGraphic.getStringBounder());
        this.east1.drawU(uGraphic.apply(new UTranslate(24.0, -dimension2D4.getHeight() + 12.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(24.0, 24.0);
        return new FtileGeometry(dimension2DDouble, ((Dimension2D)dimension2DDouble).getWidth() / 2.0, 0.0, ((Dimension2D)dimension2DDouble).getHeight());
    }

    @Override
    public boolean isKilled() {
        return false;
    }
}

