use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

##-- argh argh argh: NetServer::Generic doesn't work in PREREQ_PM (at least on 2011-11-15 / svn rev 7)
#BEGIN {
#  use NetServer::Generic;
#  die("ERROR: Prerequisite module NetServer::Generic not found")
#    if (!defined($NetServer::Generic::VERSION));
#}

WriteMakefile
  (
   NAME         => 'DDC',
   DISTNAME     => 'ddc-perl',
   VERSION_FROM => 'DDC/Concordance.pm', # finds $VERSION
   LICENSE      => 'perl',
   AUTHOR       => 'Bryan Jurish <moocow@cpan.org>',
   ABSTRACT     => 'Query utilities for DDC concordance search engine',

   PREREQ_PM    => {
		    'IO::Socket::INET'=>0,
		    'NetServer::Generic'=>1.03, ##-- for drop-in server replacement
		    'Text::Wrap'=>0,
		    #'Lingua::LTS'=>0.01, ##-- needed for LTS stuff
		    'JSON::XS' => 0,
		    ##
		    'Parse::Yapp' => 0, ##-- tested v1.05
		   },

   EXE_FILES    => [
		    grep {$_ !~ /-lts-/}
		    glob("ddc-*.perl")
		   ],
  );

##---------------------------------------------------------------
sub MY::depend {
  package MY;
  my $inherited = shift->SUPER::depend(@_);
  $inherited .= (
		 ###-- depends -> README.txt
		 "\n\n"
		 ."dist: README.txt DDC/Query/yyparser.pm\n"
		 ."\n"
		 ."create_distdir: README.txt DDC/Query/yyparser.pm\n"
		 #."distdir_am: README.txt\n"
		 ."\n"
		 ."distcheck: README.txt DDC/Query/yyparser.pm\n"
		 ."\n"
		 ."manicheck: README.txt DDC/Query/yyparser.pm\n"
		 ."\n"
		);
  return $inherited;
}

##---------------------------------------------------------------
sub MY::postamble {
  # how to format the README file
  package MY;
  my $inherited = shift->SUPER::postamble(@_);
  (''
   ##-- format README.txt
   ."README.txt : README.rpod\n"
   ."\tpod2text README.rpod README.txt\n"
   ."\n"
   ##-- compile yapp parser
   ."DDC/Query/yyparser.pm: DDC/Query/yyparser.yp\n"
   ."\t yapp -v -m DDC::Query::yyparser -o \$@ \$<\n"
   ."\n"
  );
}

##---------------------------------------------------------------
sub MY::special_targets {
  package MY;
  my $inherited = shift->SUPER::special_targets(@_);
  $inherited .=
"
.SUFFIXES: .pm .pod .POD .rpod .man .txt .html

##-- yapp alias
yapp:
\trm -f DDC/Query/yyparser.pm
\t\$(MAKE) DDC/Query/yyparser.pm

##-- README: special handling
README.html : README.POD
\tpod2html --infile=README.POD --outfile=README.html --title='DDC-perl README'

.pm.html:
\tpod2html --css=\$(CSS) --title=\$@ --infile=\$< --outfile=\$@

.pm.txt:
\tpod2text \$< \$@

.pod.html:
\tpod2html --css=\$(CSS) --title=\$@ --infile=\$< --outfile=\$@

.pod.txt:
\tpod2text \$< \$@

.POD.html:
\tpod2html --css=\$(CSS) --title=\$@ --infile=\$< --outfile=\$@

.POD.txt:
\tpod2text \$< \$@

.rpod.html:
\tpod2html --css=\$(CSS) --title=\$@ --infile=\$< --outfile=\$@

.rpod.txt:
\tpod2text \$< \$@

";
  return $inherited;
}

