##-*- Mode: CPerl -*-

## File: DDC::Query::Filter.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: DDC Query utilities: query filters (e.g. client-side term expansion) [DEPRECATED]
##======================================================================

package DDC::Query::Filter;
use DDC::Utils qw(:escape);
use strict;

##======================================================================
## Globals etc.
our @ISA = qw();

##======================================================================
## $qf = $CLASS_OR_OBJ->new(%args)
##  + %$qf, %args =
##    (
##     class => $class,     ##-- subclass
##     name  =>$name,  ##-- filter name (with leading '#')
##     args  =>\@args, ##-- filter args
##    )
sub new {
  my ($that,%args) = @_;
  my $class = $args{class};
  my ($new);
  if ($class && defined($new=UNIVERSAL::can((__PACKAGE__ . "::$class"), 'new'))) {
    delete($args{class});
    return $new->((__PACKAGE__ . "::$class"),%args) if ($new ne __PACKAGE__->can('new'));
  }
  return bless(\%args,
	       ($class ? (__PACKAGE__ . "::$class") : (ref($that)||$that))
	      );
}

## $str = $qf->toString()
##  + stringification operator
sub toString {
  my $qf = shift;
  my $s = (uc($qf->{name})
	   .'['
	   .join(',',
		 map {defined($_) ? escapeq($_) : ''}
		 @{$qf->{args}}
		)
	   .']');
  $s =~ s/\[\]$//;
  return $s;
}

##======================================================================
package DDC::Query::Filter::Sort;
our @ISA = qw(DDC::Query::Filter);

##======================================================================
package DDC::Query::Filter::Flag;
our @ISA = qw(DDC::Query::Filter);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#FLAG',arg=>undef,@_);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return (
	  ($qf->{negated} ? '!' : '')
	  .uc($qf->{name})
	  .(defined($qf->{arg}) ? " $qf->{arg}" : '')
	 );
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Subcorpora;
use DDC::Utils qw(:escape);
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>':',args=>[],@_);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return ":".join(',',map {escapeq($_)} @{$qf->{args}});
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Context;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#CNTXT',arg=>0,@_);
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Within;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#WITHIN',arg=>'s',@_);
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Filenames;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#FILENAMES',arg=>undef,negated=>undef,@_);
}

##----------------------------------------------------------------------
package DDC::Query::Filter::DebugRank;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#DEBUG_RANK',arg=>undef,@_);
}


##======================================================================
package DDC::Query::Filter::HasField;
use DDC::Utils qw(:escape);
our @ISA = qw(DDC::Query::Filter);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#HAS_FIELD',field=>undef,value=>undef,@_);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return "#HAS_FIELD[".escapeq($qf->{field}).','.escapeq($qf->{value}).']';
}

##======================================================================
## HasFieldRegex
##  + value is assumed to be pre-quoted and escaped!
package DDC::Query::Filter::HasFieldRegex;
use DDC::Utils qw(:escape);
our @ISA = qw(DDC::Query::Filter::HasField);

sub new {
  my ($that,%args) = @_;
  return $that->SUPER::new(%args);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return "#HAS_FIELD[".escapeq($qf->{field}).','.$qf->{value}.']';
}

1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl

##========================================================================
## NAME
=pod

=head1 NAME

DDC::Query::Filter - DDC Query utilities: query filters (e.g. client-side term expansion) [DEPRECATED]

=cut

##========================================================================
## PACKAGES
=pod

=head1 PACKAGES

=over 4

=item DDC::Query::Filter

=item DDC::Query::Filter::Sort

=item DDC::Query::Filter::Flag

=item DDC::Query::Filter::Subcorpora

=item DDC::Query::Filter::Context

=item DDC::Query::Filter::Within

=item DDC::Query::Filter::Filenames

=item DDC::Query::Filter::DebugRank

=item DDC::Query::Filter::HasField

=item DDC::Query::Filter::HasFieldRegex

=back

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 ##========================================================================
 ## PRELIMINARIES
 
 use DDC::Query::Filter;
 

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter
=pod

=head2 DDC::Query::Filter Synopsis

 ##========================================================================
 ## Constructors etc.
 
 $qf = $CLASS_OR_OBJ->new(%args);
 $str = $qf->toString();
 $str = $qf->toString();
 $str = $qf->toString();
 $str = $qf->toString();
 

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::Sort
=pod

=head2 DDC::Query::Filter::Sort Synopsis

(no documentation found for package DDC::Query::Filter::Sort)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::Flag
=pod

=head2 DDC::Query::Filter::Flag Synopsis

(no documentation found for package DDC::Query::Filter::Flag)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::Subcorpora
=pod

=head2 DDC::Query::Filter::Subcorpora Synopsis

(no documentation found for package DDC::Query::Filter::Subcorpora)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::Context
=pod

=head2 DDC::Query::Filter::Context Synopsis

(no documentation found for package DDC::Query::Filter::Context)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::Within
=pod

=head2 DDC::Query::Filter::Within Synopsis

(no documentation found for package DDC::Query::Filter::Within)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::Filenames
=pod

=head2 DDC::Query::Filter::Filenames Synopsis

(no documentation found for package DDC::Query::Filter::Filenames)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::DebugRank
=pod

=head2 DDC::Query::Filter::DebugRank Synopsis

(no documentation found for package DDC::Query::Filter::DebugRank)

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::HasField
=pod

=head2 DDC::Query::Filter::HasField Synopsis

 ##========================================================================
 ## HasFieldRegex
 
 $str = $qf->toString();
 

=cut

##------------------------------------------------------------------------
## SYNOPSIS: DDC::Query::Filter::HasFieldRegex
=pod

=head2 DDC::Query::Filter::HasFieldRegex Synopsis

(no documentation found for package DDC::Query::Filter::HasFieldRegex)

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

The DDC::Query::Filter module provides hooks for client-side DDC query expansion.
Its use is deprecated in favor of the L<DDC::XS::CQuery|DDC::XS::CQuery>
module providing direct access to the underlying C++ libraries; in particular
the method L<DDC::XS::Object::mapTraverse()|DDC::XS::Object>.

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter
=pod

=head2 DDC::Query::Filter Description

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter: Globals etc.
=pod

=head3 Globals etc.

=over 4

=item Variable: @ISA

(undocumented)

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter: Constructors etc.
=pod

=head3 Constructors etc.

=over 4

=item new

 $qf = $CLASS_OR_OBJ->new(%args);

%$qf, %args =

    (
     class => $class,     ##-- subclass
     name  =>$name,  ##-- filter name (with leading '#')
     args  =>\@args, ##-- filter args
    )

=item toString

 $str = $qf->toString();

stringification operator

=item new



(undocumented)

=item toString

 $str = $qf->toString();

(undocumented)

=item new



(undocumented)

=item toString

 $str = $qf->toString();

(undocumented)

=item new



(undocumented)

=item new



(undocumented)

=item new



(undocumented)

=item new



(undocumented)

=item new



(undocumented)

=item toString

 $str = $qf->toString();

(undocumented)

=back

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::Sort
=pod

=head2 DDC::Query::Filter::Sort Description

(no documentation found for package DDC::Query::Filter::Sort)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::Flag
=pod

=head2 DDC::Query::Filter::Flag Description

(no documentation found for package DDC::Query::Filter::Flag)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::Subcorpora
=pod

=head2 DDC::Query::Filter::Subcorpora Description

(no documentation found for package DDC::Query::Filter::Subcorpora)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::Context
=pod

=head2 DDC::Query::Filter::Context Description

(no documentation found for package DDC::Query::Filter::Context)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::Within
=pod

=head2 DDC::Query::Filter::Within Description

(no documentation found for package DDC::Query::Filter::Within)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::Filenames
=pod

=head2 DDC::Query::Filter::Filenames Description

(no documentation found for package DDC::Query::Filter::Filenames)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::DebugRank
=pod

=head2 DDC::Query::Filter::DebugRank Description

(no documentation found for package DDC::Query::Filter::DebugRank)

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::HasField
=pod

=head2 DDC::Query::Filter::HasField Description

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::HasField: HasFieldRegex
=pod

=head3 HasFieldRegex

=over 4

=item Variable: @ISA

(undocumented)

=item new



(undocumented)

=item toString

 $str = $qf->toString();

(undocumented)

=back

=cut

##------------------------------------------------------------------------
## DESCRIPTION: DDC::Query::Filter::HasFieldRegex
=pod

=head2 DDC::Query::Filter::HasFieldRegex Description

(no documentation found for package DDC::Query::Filter::HasFieldRegex)

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
=pod

=head1 ACKNOWLEDGEMENTS

perl by Larry Wall.

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT

Copyright (c) 2011-2015, Bryan Jurish.  All rights reserved.

This package is free software.  You may redistribute it
and/or modify it under the same terms as Perl itself.

=head1 SEE ALSO

perl(1)

=cut
