#-*- Mode: CPerl -*-

## File: DDC::HitList.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + DDC Query utilities: query response structure
##======================================================================

package DDC::HitList;
use DDC::Hit;
use strict;

##======================================================================
## Globals

##======================================================================
## Constructors, etc.

## $hits = $CLASS_OR_OBJ->new(%args)
##  + %$hits, %args:
##    (
##     hits_ => \@hits,                      ##-- ARRAY-ref of DDC::Hit objects
##
##     ##-- administrative data returned by DDC server (from ConcordDmnLib/Corpora.cpp: CDDCServerListenHost::ProcessSocketString())
##     istatus_ => $InternalError,           ##-- int InternalError (0=success)
##     nstatus_ => $NetworkError,            ##-- int iNetworkError (0=success)
##     end_     => $EndHitNo,                ##-- DWORD EndHitNo
##     nhits_   => $HitsCount,               ##-- DWORD HitsCount
##     ndocs_   => $DocsCount,               ##-- DWORD RelevantDocsCount
##     dhits_   => $HitDistribution,         ##-- string N1+N2+N3+...+NN=N*
##     ddocs_   => $DocDistribution,         ##-- string N1+N2+N3+...+NN=N*
##     error_   => $errorMessage,            ##-- error message if $hits->{istatus_}!=0 or $hits->{nstatus_}!=0 (empty: success)
##    )
sub new {
  my $that = shift;
  return bless {
		hits_=>[],
		@_
	       }, ref($that)||$that;
}

## $hits = $hits->expandFields()
## $hits = $hits->expandFields(\@fieldNames)
##  + just calls $hit->expandFields() on every hit in $hits->{hits_}
sub expandFields {
  my ($hl,$names) = @_;
  $_->expandFields($names) foreach (@{$hl->{hits_}||[]});
  return $hl;
}

## $thingy = $obj->TO_JSON()
##  + annoying wrapper for JSON::XS
sub TO_JSON {
  return { %{$_[0]} };
}


1; ##-- be happy

__END__

##======================================================================
## Docs
=pod

=head1 NAME

DDC::HitList - query response structure for DDC query utilities

=head1 SYNOPSIS

 use DDC::HitList;

 $hit = DDC::HitList->new(hits=>\@hits);

=cut

##======================================================================
## Description
=pod

=head1 DESCRIPTION

DDC::Hit is the underlying structure for a query response returned by DDC::Client.

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Hit: Methods
=pod

=head2 Methods

=over 4

=item new

 $hit = $CLASS_OR_OBJ->new(%args);

Object structure / accepted keyword %args:

 hits  => \@hits,    ##-- array of DDC::Hit objects

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl
=pod



##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.10.0 or,
at your option, any later version of Perl 5 you may have available.

=cut
