use strict;
use warnings;
use Test::More;
require "t/exercises.tt";

if (! eval "use DBD::SQLite;1") {
    ok(1, "# skip - DBD::SQLite required for Forks::Queue::SQLite");
    done_testing;
    exit;
}

use_ok('Forks::Queue::SQLite');

########

my $q = Forks::Queue::SQLite->new;

ok($q, 'got queue object');
ok(ref($q) eq 'Forks::Queue::SQLite', 'has correct object type');

exercise_fifo($q);

undef $q;

#####

unlink "t/q2";
ok(-d 't', 'queue directory exists');
ok(! -f "t/q2", 'queue file does not exist yet');

$q = Forks::Queue::SQLite->new( db_file => 't/q2', style => 'lifo' );

ok($q && ref($q) eq 'Forks::Queue::SQLite', 'got queue with correct type');
ok(-f "t/q2", 'queue db file created');
ok(-s "t/q2" > 1024, 'queue header section created');

exercise_lifo($q);

undef $q;
ok(! -f "t/q2", 'queue file destroyed when queue object left scope');

#####

my $TEMP = TEMP_DIR();

unlink "$TEMP/q3a", "$TEMP/q3b";
ok(-d $TEMP, 'queue directory exists');
ok(! -f "$TEMP/q3a", 'queue file does not exist yet');
ok(! -f "$TEMP/q3b", 'queue file does not exist yet');

my $q1 = Forks::Queue->new( impl => 'SQLite', db_file => "$TEMP/q3a" );
my $q2 = Forks::Queue::SQLite->new( db_file => "$TEMP/q3b", persist => 1 );

ok($q1 && ref($q1) eq 'Forks::Queue::SQLite', 'got queue with correct type');

exercise_forks($q1);

undef $q1;
ok(! -f "$TEMP/q3a", 'queue file destroyed when object left scope');

exercise_forks($q2);
undef $q2;
ok(-f "$TEMP/q3b", 'queue with persist option not destroyed');
unlink("$TEMP/q3b");
ok(! -f "$TEMP/q3b", 'queue file removed manually');

#####

unlink "$TEMP/q4";
ok(-d $TEMP, 'queue directory exists');
ok(! -f "$TEMP/q4", 'queue file does not exist yet');

$q = Forks::Queue->new( impl => 'SQLite', limit => 5, on_limit => 'fail' );

exercise_limits($q, 'fail');

$q->{on_limit} = 'block';
exercise_limits($q, 'block');

undef $q;
ok(! -f "$TEMP/q4", 'queue file deleted on queue destruction');

#####

exercise_join( impl => 'SQLite', db_file1 => "$TEMP/q11a.sq3",
               db_file2 => "$TEMP/q11b.sq3",
               file1 => "$TEMP/q11a.sq3", file2 => "$TEMP/q11b.sq3" );

#####

done_testing;
