use strict;
use warnings;
use Test::More;
require "t/exercises.tt";

use_ok('Forks::Queue::File');

unlink 't/q1';
ok(-d 't', 'queue directory exists');
ok(! -f 't/q1', 'queue file does not exist yet');

########

my $q = Forks::Queue::File->new( file => 't/q1', style => 'fifo' );

ok($q, 'got queue object');
ok(ref($q) eq 'Forks::Queue::File', 'has correct object type');
ok(-f 't/q1', 'queue file created');
ok(-s 't/q1' > 1024, 'queue header section created');

exercise_fifo($q);

undef $q;
ok(! -f 't/q1', 'queue file destroyed when queue object was out of scope');

#####

unlink 't/q2';
ok(-d 't', 'queue directory exists');
ok(! -f 't/q2', 'queue file does not exist yet');

$q = Forks::Queue::File->new( file => 't/q2', style => 'lifo' );

ok($q && ref($q) eq 'Forks::Queue::File', 'got queue with correct type');
ok(-f 't/q2', 'queue file created');
ok(-s 't/q2' > 1024, 'queue header section created');

exercise_lifo($q);

undef $q;
ok(! -f 't/q2', 'queue file destroyed when queue object left scope');

#####

my $TEMP = TEMP_DIR();


# avoiding 't' here just in case it is an NFS filesystem

unlink "$TEMP/q3a", "$TEMP/q3b";
ok(-d $TEMP, 'queue directory exists');
ok(! -f "$TEMP/q3a", 'queue file does not exist yet');
ok(! -f "$TEMP/q3b", 'queue file does not exist yet');

my $q1 = Forks::Queue->new( impl => 'File', file => "$TEMP/q3a" );
my $q2 = Forks::Queue->new( impl => 'File', file => "$TEMP/q3b", persist => 1 );

ok($q1 && ref($q1) eq 'Forks::Queue::File', 'got queue with correct type');

exercise_forks($q1);

undef $q1;
ok(! -f "$TEMP/q3a", 'queue file destroyed when object left scope');

exercise_forks($q2);
undef $q2;
ok(-f "$TEMP/q3b", 'queue with persist option not destroyed');
unlink("$TEMP/q3b");
ok(! -f "$TEMP/q3b", 'queue file removed manually');

#####

unlink "$TEMP/q4";
ok(-d $TEMP, 'queue directory exists');
ok(! -f "$TEMP/q4", 'queue file does not exist yet');

$q = Forks::Queue->new( impl => 'File', limit => 5, on_limit => 'fail' );

exercise_limits($q, 'fail');

$q->{on_limit} = 'block';
exercise_limits($q, 'block');

undef $q;
ok(! -f "$TEMP/q4", 'queue file deleted on queue destruction');

#####

exercise_join( impl => 'File', file1 => "$TEMP/q11a", file2 => "$TEMP/q11b" );

#####

done_testing;
