/* wether word reads are potentially non-atomic.
 * this is conservatice, likely most arches this runs
 * on have atomic word read/writes.
 */
#ifndef WORDACCESS_UNSAFE
# if __i386 || __x86_64
#  define WORDACCESS_UNSAFE 0
# else
#  define WORDACCESS_UNSAFE 1
# endif
#endif

/////////////////////////////////////////////////////////////////////////////

#ifdef _WIN32
typedef int ssize_t;

#define NTDDI_VERSION NTDDI_WIN2K // needed to get win2000 api calls
#define _WIN32_WINNT 0x400
#include <stdio.h>//D
#include <fcntl.h>
#include <io.h>
#include <time.h>
#include <winsock2.h>
#include <process.h>
#include <windows.h>
#include <pthread.h>
#define sigset_t int
#define sigfillset(a)
#define pthread_sigmask(a,b,c)
#define sigaddset(a,b)
#define sigemptyset(s)
#define sigfillset(s)

typedef pthread_mutex_t mutex_t;
#define X_MUTEX_INIT           PTHREAD_MUTEX_INITIALIZER
#define X_MUTEX_CHECK(mutex)   
#define X_LOCK(mutex)          pthread_mutex_lock (&(mutex))
#define X_UNLOCK(mutex)        pthread_mutex_unlock (&(mutex))

typedef pthread_cond_t cond_t;
#define X_COND_INIT                     PTHREAD_COND_INITIALIZER
#define X_COND_CHECK(cond)              
#define X_COND_SIGNAL(cond)             pthread_cond_signal (&(cond))
#define X_COND_WAIT(cond,mutex)         pthread_cond_wait (&(cond), &(mutex))
#define X_COND_TIMEDWAIT(cond,mutex,to) pthread_cond_timedwait (&(cond), &(mutex), &(to))

typedef pthread_t thread_t;
#define X_THREAD_PROC(name) void *name (void *thr_arg)
#define X_THREAD_ATFORK(a,b,c)

static int
thread_create (thread_t *tid, void *(*proc)(void *), void *arg)
{
  pthread_attr_t attr;

  pthread_attr_init (&attr);
  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_DETACHED);

  return pthread_create (tid, &attr, proc, arg) == 0;
}

#define respipe_read(a,b,c)  PerlSock_recv ((a), (b), (c), 0)
#define respipe_write(a,b,c) send ((a), (b), (c), 0)
#define respipe_close(a)     PerlSock_closesocket ((a))

#else
/////////////////////////////////////////////////////////////////////////////

/* solaris */
#define _POSIX_PTHREAD_SEMANTICS 1

#if __linux && !defined(_GNU_SOURCE)
# define _GNU_SOURCE
#endif

/* just in case */
#define _REENTRANT 1

#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <limits.h>
#include <pthread.h>

typedef pthread_mutex_t mutex_t;
#if __linux && defined (PTHREAD_ADAPTIVE_MUTEX_INITIALIZER_NP)
# define X_MUTEX_INIT PTHREAD_ADAPTIVE_MUTEX_INITIALIZER_NP
#else
# define X_MUTEX_INIT PTHREAD_MUTEX_INITIALIZER
#endif
#define X_LOCK(mutex)   pthread_mutex_lock   (&(mutex))
#define X_UNLOCK(mutex) pthread_mutex_unlock (&(mutex))

typedef pthread_cond_t cond_t;
#define X_COND_INIT PTHREAD_COND_INITIALIZER
#define X_COND_SIGNAL(cond) pthread_cond_signal (&(cond))
#define X_COND_WAIT(cond,mutex) pthread_cond_wait (&(cond), &(mutex))
#define X_COND_TIMEDWAIT(cond,mutex,to) pthread_cond_timedwait (&(cond), &(mutex), &(to))

typedef pthread_t thread_t;
#define X_THREAD_PROC(name) static void *name (void *thr_arg)
#define X_THREAD_ATFORK(prepare,parent,child) pthread_atfork (prepare, parent, child)

static int
thread_create (thread_t *tid, void *(*proc)(void *), void *arg)
{
  int retval;
  sigset_t fullsigset, oldsigset;
  pthread_attr_t attr;

  pthread_attr_init (&attr);
  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_DETACHED);
  pthread_attr_setstacksize (&attr, PTHREAD_STACK_MIN < sizeof (long) * 4096
                                    ? sizeof (long) * 4096 : PTHREAD_STACK_MIN);
#ifdef PTHREAD_SCOPE_PROCESS
  pthread_attr_setscope (&attr, PTHREAD_SCOPE_PROCESS);
#endif

  sigfillset (&fullsigset);

  pthread_sigmask (SIG_SETMASK, &fullsigset, &oldsigset);
  retval = pthread_create (tid, &attr, proc, arg) == 0;
  pthread_sigmask (SIG_SETMASK, &oldsigset, 0);

  return retval;
}

#define respipe_read(a,b,c)  read  ((a), (b), (c))
#define respipe_write(a,b,c) write ((a), (b), (c))
#define respipe_close(a)     close ((a))

#endif



