=head1 NAME

Deliantra::Data - various data structures useful for understanding archs and objects

=head1

THIS FILE IS AUTOGENERATED, DO NOT EDIT!

It's a translation of the following files:

 res/spells.xml
 res/types.xml
 res/typenumbers.xml

See F<res/README> for more info.

=cut

package Deliantra::Data;

our %BITMASK = (
  attacktype => {
    0 => 'Physical',
    1 => 'Magical',
    2 => 'Fire',
    3 => 'Electricity',
    4 => 'Cold',
    5 => 'Confusion',
    6 => 'Acid',
    7 => 'Drain',
    8 => 'Weaponmagic',
    9 => 'Ghosthit',
    10 => 'Poison',
    11 => 'Slow',
    12 => 'Paralyze',
    13 => 'Turn Undead',
    14 => 'Fear',
    15 => 'Cancellation',
    16 => 'Depletion',
    17 => 'Death',
    18 => 'Chaos',
    19 => 'Counterspell',
    20 => 'God Power',
    21 => 'Holy Power',
    22 => 'Blinding'
  },
  material => {
    0 => 'Paper',
    1 => 'Iron',
    2 => 'Glass',
    3 => 'Leather',
    4 => 'Wood',
    5 => 'Organics',
    6 => 'Stone',
    7 => 'Cloth',
    8 => 'Adamantite',
    9 => 'Liquid',
    10 => 'Soft Metal',
    11 => 'Bone',
    12 => 'Ice',
    13 => '(supress name on display)'
  },
  movement_type => {
    0 => 'Walk',
    1 => 'Fly Low',
    2 => 'Fly High',
    3 => 'Swim',
    4 => 'Boat',
    16 => 'Other'
  },
  pick_up => {
    0 => 'Nothing',
    1 => 'Wealth',
    2 => 'Food',
    3 => 'Weapons',
    4 => 'Armour',
    5 => 'Inverse',
    6 => 'All'
  },
  spellpath => {
    0 => 'Protection',
    1 => 'Fire',
    2 => 'Frost',
    3 => 'Electricity',
    4 => 'Missiles',
    5 => 'Self',
    6 => 'Summoning',
    7 => 'Abjuration',
    8 => 'Restoration',
    9 => 'Detonation',
    10 => 'Mind',
    11 => 'Creation',
    12 => 'Teleportation',
    13 => 'Information',
    14 => 'Transmutation',
    15 => 'Transferrence',
    16 => 'Turning',
    17 => 'Wounding',
    18 => 'Death',
    19 => 'Light'
  },
  will_apply => {
    0 => 'Apply Handles',
    1 => 'Open Chests',
    2 => 'Break Walls',
    3 => 'Open Doors'
  }
);

our %LIST = (
  attack_movement_bits_0_3 => {
    0 => 'default',
    1 => 'attack from distance',
    2 => 'run away',
    3 => 'hit and run',
    4 => 'wait, then hit, then move',
    5 => 'rush blindly',
    6 => 'always run',
    7 => 'attack from distance if hit',
    8 => 'do not approach'
  },
  attack_movement_bits_4_7 => {
    0 => 'none',
    16 => 'pet',
    32 => 'small circle',
    48 => 'large circle',
    64 => 'small horizontal',
    80 => 'large horizontal',
    96 => 'random direction',
    112 => 'random movement',
    128 => 'small vertical',
    144 => 'large vertical'
  },
  direction => {
    0 => '<none>',
    1 => 'north',
    2 => 'northeast',
    3 => 'east',
    4 => 'southeast',
    5 => 'south',
    6 => 'southwest',
    7 => 'west',
    8 => 'northwest'
  },
  event_type => {
    0 => 'none',
    1 => 'apply',
    2 => 'attack',
    3 => 'death',
    4 => 'drop',
    5 => 'pickup',
    6 => 'say',
    7 => 'stop',
    8 => 'time',
    9 => 'throw',
    10 => 'trigger',
    11 => 'close',
    12 => 'timer',
    28 => 'move',
    41 => 'drop_on'
  },
  mood => {
    0 => 'furious',
    1 => 'angry',
    2 => 'calm',
    3 => 'sleep',
    4 => 'charm',
    5 => 'destroy monster',
    6 => 'destroy pet'
  },
  potion_effect => {
    0 => '<none>',
    65536 => 'life restoration',
    1048576 => 'improvement'
  },
  skill_type => {
    1 => 'lockpicking',
    2 => 'hiding',
    3 => 'smithery',
    4 => 'bowyer',
    5 => 'jeweler',
    6 => 'alchemy',
    7 => 'stealing',
    8 => 'literacy',
    9 => 'bargaining',
    10 => 'jumping',
    11 => 'detect magic',
    12 => 'oratory',
    13 => 'singing',
    14 => 'detect curse',
    15 => 'find traps',
    16 => 'mediatation',
    17 => 'punching',
    18 => 'flame touch',
    19 => 'karate',
    20 => 'climbing',
    21 => 'woodsman',
    22 => 'inscription',
    23 => 'one handed weapons',
    24 => 'missile weapons',
    25 => 'throwing',
    26 => 'use magic item',
    27 => 'disarm traps',
    28 => 'set traps',
    29 => 'thaumaturgy',
    30 => 'praying',
    31 => 'clawing',
    32 => 'levitation',
    33 => 'summoning',
    34 => 'pyromancy',
    35 => 'evocation',
    36 => 'sorcery',
    37 => 'two handed weapons'
  },
  spell_type => {
    1 => 'raise dead',
    2 => 'rune',
    3 => 'make mark',
    4 => 'bolt',
    5 => 'bullet',
    6 => 'explosion',
    7 => 'cone',
    8 => 'bomb',
    9 => 'wonder',
    10 => 'smite',
    11 => 'magic missile',
    12 => 'summon golem',
    13 => 'dimension door',
    14 => 'magic mapping',
    15 => 'magic wall',
    16 => 'destruction',
    17 => 'perceive self',
    18 => 'word of recall',
    19 => 'invisible',
    20 => 'probe',
    21 => 'healing',
    22 => 'create food',
    23 => 'earth to dust',
    24 => 'change ability',
    25 => 'bless',
    26 => 'curse',
    27 => 'summon monster',
    28 => 'recharge',
    29 => 'polymorph',
    30 => 'alchemy',
    31 => 'remove curse',
    32 => 'identify',
    33 => 'detection',
    34 => 'mood change',
    35 => 'moving ball',
    36 => 'swarm',
    37 => 'charge mana',
    38 => 'dispel rune',
    39 => 'create missile',
    40 => 'consecrate',
    41 => 'animate weapon',
    42 => 'light',
    43 => 'change map light',
    44 => 'faery fire',
    45 => 'disease',
    46 => 'aura',
    47 => 'town portal'
  },
  weapon_type => {
    0 => '<unknown>',
    1 => 'sword',
    2 => 'arrows',
    3 => 'axe',
    4 => 'katana',
    5 => 'knife, dagger',
    6 => 'whip, chain',
    7 => 'hammer, flail',
    8 => 'club, stick'
  }
);

our %IGNORE_LIST = (
  non_pickable => [
    'value',
    'nrof',
    'weight',
    'name_pl',
    'material',
    'no_pick',
    'unpaid',
    'title',
    'identified'
  ],
  system_object => [
    'value',
    'nrof',
    'weight',
    'name_pl',
    'material',
    'no_pick',
    'unpaid',
    'title',
    'glow_radius',
    'identified',
    'blocksview',
    'invisible'
  ]
);

our %DEFAULT_ATTR = (
  attr => [
    [
      'name',
      {
	desc => 'This is the name of the object, displayed to the player.',
	name => 'name',
	type => 'string'
      }
    ],
    [
      'name_pl',
      {
	desc => 'This is the plural name of the object. A plural name must be set for all items that can be picked up and collected by the player.',
	name => 'plural name',
	type => 'string'
      }
    ],
    [
      'title',
      {
	desc => 'This is the object\'s title. Once an object is identified the title is attached to the name. Typical titles are "of Mostrai", "of xray vision" etc.',
	name => 'title',
	type => 'string'
      }
    ],
    [
      'face',
      {
	desc => 'The image-name defines what image is displayed for this object in-game. Take care if the archetype of the object has an animation! See also the \'animation\' attribute.',
	name => 'image',
	type => 'string'
      }
    ],
    [
      'animation',
      {
	desc => 'The animation-name of the object. If you assign custom faces and the archetype defines an animation you can disable the animation of an archetype by setting this field to NONE.',
	name => 'animation',
	type => 'string'
      }
    ],
    [
      'tag',
      {
	desc => 'You can tag objects with an identifier. Tagged objects can be found quickly from their tag, which makes them useful to tag exits and refer to those by their name.',
	name => 'tag',
	type => 'string'
      }
    ],
    [
      'nrof',
      {
	desc => 'This value determines the number of objects in one stack (for example: 100 goldcoins => "number = 100"). You should set this at least to one, for any pickable object - otherwise it won\'t be mergeable into a stack.',
	name => 'number',
	type => 'int'
      }
    ],
    [
      'weight',
      {
	desc => 'This value defines the object\'s weight in grams (1000g is 1kg). Objects with zero weight are not pickable for players. Still, set the "non-pickable"-flag for explicitly non-pickable objects (hey, this is opensource.. you never know ;) ).',
	name => 'weight',
	type => 'int'
      }
    ],
    [
      'value',
      {
	desc => 'Determines the value of the object, in units of silver coins (one platinum coin == 50 silver coins). Value for buying/selling will be further modified by various factors. Hence, testing values in-game is usually inevitable.',
	name => 'value',
	type => 'int'
      }
    ],
    [
      'glow_radius',
      {
	desc => 'If <glow radius> is set to a value greater zero, the object appears lit up on dark maps. <glow radius> can be a value between 0 and 9, the higher, the more light does the object emit.',
	name => 'glow radius',
	type => 'int'
      }
    ],
    [
      'material',
      {
	desc => 'This bitmask-value informs the player of which material(s) the object consists. Material does also affect how likely the object can be destroyed by hazardous spell-effects.',
	name => 'material',
	type => 'bitmask',
	value => $BITMASK{material}
      }
    ],
    [
      'no_pick',
      {
	desc => 'If set, the object cannot be picked up (Neither by players nor monsters).',
	name => 'non-pickable',
	type => 'bool'
      }
    ],
    [
      'invisible',
      {
	desc => 'Generally makes the object invisible. Depending on the object-type, some can be made visible by the show_invisible spell. If in doubt, test it. Putting an invisible object under the floor always prevents it from being shown.',
	name => 'invisible',
	type => 'bool'
      }
    ],
    [
      'blocksview',
      {
	desc => 'If an item is set to block view, players (and monsters) cannot see beyond it unless they cross it or manage to stand ontop.',
	name => 'block view',
	type => 'bool'
      }
    ],
    [
      'identified',
      {
	desc => 'If an item is identified, the player has full knowledge about it.',
	name => 'identified',
	type => 'bool'
      }
    ],
    [
      'unpaid',
      {
	desc => 'An <unpaid> item cannot be used unless a player carried it over a shop mat, paying the demanded price. Setting this flag makes sense only for pickable items inside shops.',
	name => 'unpaid',
	type => 'bool'
      }
    ],
    [
      'sound',
      {
	desc => 'The sound this objects makes on a map. Enter either a sound alias from arch/res/sound.conf.res or a path. If you enter <path> in this field it will point to sound/<path>.ext',
	name => 'sound',
	type => 'string'
      }
    ],
    [
      'sound_destroy',
      {
	desc => 'The sound this objects makes when it is destroyed. Enter either a sound alias from arch/res/sound.conf.res or a path. If you enter <path> in this field it will point to sound/<path>.ext',
	name => 'destroy sound',
	type => 'string'
      }
    ]
  ]
);

our %TYPE = (
  Ability => {
    attr => [
      [
	'invisible',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_drop',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'sp',
	{
	  desc => 'The monster will use the specified <short range spell> when the player is within 6-square radius (of the monster\'s head).',
	  name => 'short range spell',
	  type => 'spell'
	}
      ],
      [
	'hp',
	{
	  desc => 'The monster will use the specified <long range spell> when the player is at least 6 squares away (from the monster\'s head). Setting a <long range spell> is optional. If unset, the <short range spell> gets used all the time.',
	  name => 'long range spell',
	  type => 'nz_spell'
	}
      ],
      [
	'maxsp',
	{
	  desc => 'Sometimes you\'ll want a monster to use one ability more than others. To achieve this, set the <importance> to a value greater than one. Abilities with this value zero/unset are counted to be of <importance> one. Example: A monster with "small fireball" of <importance> 3 and "paralyze" of <importance> 1 will averagely cast three out of four times the "small fireball".',
	  name => 'importance',
	  type => 'int'
	}
      ],
      [
	'attacktype',
	{
	  desc => 'This flag specifies whether the ability <is magical> in nature. If enabled, all spells produced by this ability will have magic attacktype added to the usual attacktypes. This should always be set for spell-like abilities. "Natural" abilities like a dragon\'s firebreath are an exception. Note that non-magical abilities are more dangerous because magic resistance does not protect from those.',
	  name => 'is magical',
	  type => 'bool',
	  value => [
	    0,
	    2
	  ]
	}
      ]
    ],
    desc => 'Abilities are to be put in a monster\'s inventory. They grant monsters the knowledge to cast spells. Spells from abilities are usually magical in nature, thus adding magic attacktype to the spell-damage they produce. <br><br> A particularly nice feature of abilities is that they can hold two spells: One for short range - and one for long range use. \\n\\n You should know that spellcasting monsters receive abilities via &lt;treasurelist&gt;.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Ability',
    use => 'If you want to create "customized" spellcasting monsters, you should use abilities (rather than spellbooks/wands or something). The long/short-range spell feature can make boss-monsters more interesting and challenging. <br><br> You should keep in mind that magic abilities allow players to get better resistance. You can turn off the magic part to make the spells more dangerous. However, this really shouldn\'t be neccessary unless you work on very high level maps. And what fun is a magic resistance cloak when it has no effect?'
  },
  Altar => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'slaying',
	{
	  desc => 'This string specifies the item that must be put on the altar to activate it. It can either be the name of an archetype, or directly the name of an object. Yet, titles are not recognized by altars. If you want the player to have to drop a specific amount of money use "money". See also the "drop amount" attribute. If the string starts with \'match \', then it is interpreted as a match expression (e.g. \'match type=POTION\', or \'match type=SPELL in applied type=CONTAINER in inv in originator\'). For details, see http://pod.tst.eu/http://cvs.schmorp.de/deliantra/server/lib/cf/match.pm',
	  name => 'match item name',
	  type => 'string'
	}
      ],
      [
	'food',
	{
	  desc => 'The drop amount specifies the amount of items (specified in <match item name>) that must be dropped to activate the altar. If <match item name> is set to "money", then the value of the sacrificed money must be equal to <drop amount> (ie, if food=200, then 200 silver, 20 gold, or 4 platinum will all work.) Note that the maximum possible for <drop amount> is 32767.',
	  name => 'drop amount',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'If a connection value is set, the altar will trigger all objects with the same value, when activated. This will only work once.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'sp',
	{
	  desc => 'When activated, the selected <spell> will be casted (once, on the player). This should work for any given spell. The altar will work infinitely in this way. Don\'t set both <spell> and <connection> for one altar.',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text will be displayed to the player in the exact moment when the altar is activated.',
	  end => 'endmsg',
	  name => 'message',
	  type => 'text'
	}
      ]
    ],
    desc => 'When a player puts a defined number of certain items on the altar, then either a spell is casted (on the player) or a connector is triggered. If the latter is the case, the altar works only once. Either way, the sacrificed item disappears.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Altar'
  },
  'Altar Trigger' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'This string specifies the item that must be put on the altar to activate it. It can either be the name of an archetype, or directly the name of an object. Yet, titles are not recognized by altars. If you want the player to have to drop a specific amount of money use "money". See also the "drop amount" attribute. If the string starts with \'match \', then it is interpreted as a match expression (e.g. \'match type=POTION\', or \'match type=SPELL in applied type=CONTAINER in inv in originator\'). For details, see http://pod.tst.eu/http://cvs.schmorp.de/deliantra/server/lib/cf/match.pm',
	  name => 'match item name',
	  type => 'string'
	}
      ],
      [
	'food',
	{
	  desc => 'The drop amount specifies the amount of items (specified in <match item name>) that must be dropped to activate the altar. If <match item name> is set to "money", then the value of the sacrificed money must be equal to <drop amount> (ie, if food=200, then 200 silver, 20 gold, or 4 platinum will all work.) Note that the maximum possible for <drop amount> is 32767.',
	  name => 'drop amount',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'If a connection value is set, the altar will trigger all objects with the same value, when activated. This will only work once.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'sp',
	{
	  desc => 'When activated, this <spell> will be casted (once, on the player). This should work for any given spell. The altar will work infinitely in this way. Don\'t set both <spell> and <connection> for one altar.',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'exp',
	{
	  desc => 'Being activated, the altar will reset after <reset time> ticks. After reset, the altar is ready to be activated once again. The default <reset time> is 30.',
	  name => 'reset time',
	  type => 'int'
	}
      ],
      [
	'last_sp',
	{
	  desc => 'If this attribute is enabled, the altar_trigger won\'t push the connected value by altar reset. Only ONCE by dropping the sacrifice. This is typically used when the altar is connected to a creator, e.g. for selling tickets. If this attribute is disabled (default), the altar_trigger will push the connected value TWICE per sacrifice: First by dropping sacrifice, second by reset. This mode is typically used for altars being connected to gates, resulting in the gate being opened and closed again.',
	  name => 'ignore reset',
	  type => 'bool'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text will be displayed to the player in the exact moment when the altar is activated.',
	  end => 'endmsg',
	  name => 'message',
	  type => 'text'
	}
      ]
    ],
    desc => 'Altar_triggers work pretty much like normal altars (drop sacrifice -> connection activated), except for the fact that they reset after usage. Hence, altar_triggers can be used infinitely.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Altar Trigger',
    use => 'Altar_triggers are very useful if you want to charge a price for... <UL> <LI> ...an item. -> Connect the altar_trigger (set "last_sp 1") to a creator. <LI> ...opening a gate. -> Connect the altar_trigger (set "last_sp 0") to the gate. <LI> ...information. -> Connect the altar_trigger (set "last_sp 1") to a magic_mouth. </UL> The big advantage over normal altars is the infinite usability of altar_triggers! If there are ten players on one server, they\'re quite grateful if things work more than once. =)'
  },
  Amulet => {
    attr => [
      [
	'ac',
	{
	  desc => 'This value defines the amount of armour-class bonus for wearing this item. <Armour class> lessens the chance of being hit. Lower values are better. It should usually be set only for armour-like equipment.',
	  name => 'armour class',
	  type => 'int'
	}
      ],
      [
	'wc',
	{
	  desc => 'The <weapon class> value adds to the overall weapon class of the wielder\'s melee attacks. Weapon class improves the chance of hitting the opponent. Weapon class is the "counterpiece" of <armour class>. It should usually be set only for weapon-like items. Lower values are better.',
	  name => 'weapon class',
	  type => 'int'
	}
      ],
      [
	'item_power',
	{
	  desc => 'The <item power> value measures how "powerful" an artifact is. Players will only be able to wear equipment with a certain total amount of <item power>, depending on their own level. This is the only way to prevent low level players to wear "undeserved" equipment (like gifts from other players or cheated items). It is very important to adjust the <item power> value carefully for every artifact you create! If zero/unset, the Deliantra server will calculate a provisional value at runtime, but this is never going to be an accurate measurement of <item power>.',
	  name => 'item power',
	  type => 'int'
	}
      ],
      [
	'damned',
	{
	  desc => 'A damned piece of equipment cannot be unwielded unless the curse is removed. Removing damnations is a tick harder than removing curses.',
	  name => 'damnation',
	  type => 'bool'
	}
      ],
      [
	'cursed',
	{
	  desc => 'A cursed piece of equipment cannot be unwielded unless the curse is removed.',
	  name => 'curse',
	  type => 'bool'
	}
      ],
      [
	'lifesave',
	{
	  desc => 'An item with this flag enabled will save the players life for one time: When the player is wearing this item and his health points reach zero, the item disappears, replenishing half of the player\'s health. An item with <save life> should not have any decent additional bonuses!',
	  name => 'save life',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'applied',
	{
	  desc => 'If you put this item into the inventory of a monster, and you want the monster to use/wear the item - you must set <is applied>. Enabling this flag doesn\'t make any sense if the item is NOT in a monster\'s inventory.',
	  name => 'is applied',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text describes the item\'s "story". Every decent artifact should have such a description.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Wearing an amulet, the object\'s stats will directly be inherited to the player. Amulets are usually meant for protection and defense.',
    name => 'Amulet',
    section => [
      [
	'stats',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'misc',
	[
	  [
	    'luck',
	    {
	      desc => 'With positive luck bonus, the player is more likely to succeed in all sorts of things (spellcasting, praying,...). Unless the <luck bonus> is very high, the effect will be barely visible in-game. Luck bonus on one piece of equipment should never exceed 3, and such bonus should not be too frequently available.',
	      name => 'luck bonus',
	      type => 'int'
	    }
	  ],
	  [
	    'hp',
	    {
	      desc => 'Positive <health regen.> bonus speeds up the player\'s healing process. Negative values slow it down.',
	      name => 'health regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'sp',
	    {
	      desc => 'Positive <mana regen.> bonus speeds up the player\'s mana regeneration. Negative values slow it down.',
	      name => 'mana regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'grace',
	    {
	      desc => 'Positive <grace regen.> bonus speeds up the player\'s grace regeneration. Negative values slow it down. Since grace can be regenerated rather easy with praying, additional <grace regen.> bonus should be VERY RARE!!',
	      name => 'grace regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'food',
	    {
	      desc => 'Positive <food bonus> slows down the player\'s digestion, thus he consumes less food. Negative values speed it up. Note that food is consumed not only for "being alive", but also for healing and mana-regeneration. <food bonus> only affects the amount of food consumed for "being alive". Hence, even with high <food bonus>, during a fight a player can run out of food quickly.',
	      name => 'food bonus',
	      type => 'int'
	    }
	  ],
	  [
	    'xrays',
	    {
	      desc => 'Xray vision allows the player to see through obstacles in a two-square-wide radius. This is extremely helpful and desirable, so don\'t give it away for cheap on equipment.',
	      name => 'xray vision',
	      type => 'bool'
	    }
	  ],
	  [
	    'stealth',
	    {
	      desc => 'Stealth allows the player to move silently. This comes to effect if a player turns himself invisible and tries to sneak around monsters. (At least that was the idea behind it)',
	      name => 'stealth',
	      type => 'bool'
	    }
	  ],
	  [
	    'reflect_spell',
	    {
	      desc => 'If a player is wearing any piece of equipment with the ability to <reflect spells>, all kinds of spell-bullets and -beams will bounce off him. This works only about 90% of all times, to avoid players being completely immune to certain types of attacks. This is a very powerful ability and it shouldn\'t be handed out cheap!',
	      name => 'reflect spells',
	      type => 'bool'
	    }
	  ],
	  [
	    'reflect_missile',
	    {
	      desc => 'If a player is wearing any piece of equipment with the ability to <reflect missiles>, all kinds of projectiles (e.g. arrows, bolts, boulders) will bounce off him. This works only about 90% of all times, to avoid players being completely immune to certain types of attacks.',
	      name => 'reflect missiles',
	      type => 'bool'
	    }
	  ],
	  [
	    'move_type',
	    {
	      desc => 'Determines which kinds of movement this object can use (e.g. for monsters) or grants (e.g. for amulets).',
	      name => 'movement type',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'path_attuned',
	    {
	      desc => 'Click on the <attuned paths> button to select spellpaths. The player will get attuned to the specified spellpaths while wearing this item.',
	      name => 'attuned paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ],
	  [
	    'path_repelled',
	    {
	      desc => 'Click on the <repelled paths> button to select spellpaths. The player will get repelled to the specified spellpaths while wearing this item.',
	      name => 'repelled paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ],
	  [
	    'path_denied',
	    {
	      desc => 'Click on the <denied paths> button to select spellpaths. The specified spellpaths will be denied to the player while wearing this item.',
	      name => 'denied paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ]
	]
      ]
    ],
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  Battleground => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'is_floor',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'hp',
	{
	  desc => 'The exit destinations define the (x, y)-coordinates where players get teleported after they died on this battleground.',
	  name => 'destination X',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'The exit destinations define the (x, y)-coordinates where players get teleported after they died on this battleground.',
	  name => 'destination Y',
	  type => 'int'
	}
      ]
    ],
    desc => 'Battleground is very special: In short, players can die on battleground without any death penalties. They don\'t loose or gain experience while on battleground. Acid, draining and depletion effects don\'t work either. When a player dies on battleground, he gets teleported to an exit location which is defined in the battleground object.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Battleground',
    use => 'Battleground is only meant for player vs. player duels. You can design combat arenas similiar to the one in scorn.<br> What should NEVER be done is placing battleground tiles in open dungeons or other free kinds of land. It must not be possible to gain significant treasure for fighting on battleground, because it bears no risk.<br><br> (Battleground will cease to work when the image or name is changed, or when it is placed beneath another floor tile. This is not a bug, it is there to prevent any attempts of placing "hidden" battleground tiles anywhere.)'
  },
  Book => {
    attr => [
      [
	'level',
	{
	  desc => 'If this value is set to be greater than zero, the player needs a certain literacy level to succeed reading the book. The book can be read if: mental_level greater <literacy level> - 5. Adding level to a book can be a nice idea, personally I like it when a player needs more than his fighting skills to solve a quest. However, keep the booklevel at least below 15 because it is quite hard to gain high mental levels.',
	  name => 'literacy level',
	  type => 'int'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This is the text that appears "written" in the book.',
	  end => 'endmsg',
	  name => 'book content',
	  type => 'text'
	}
      ],
      [
	'slaying',
	{
	  desc => 'This is the key string of the book. The key string is checked by an inventory checker. (This is used eg. for the gate/port passes in scorn)',
	  name => 'key string',
	  type => 'string'
	}
      ],
      [
	'no_skill_ident',
	{
	  desc => 'If this flag is true the player won\'t be able to identify this item with by using a skill.',
	  name => 'no skill ident',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Applying a book, the containing message is displayed to the player.',
    name => 'Book'
  },
  Boots => {
    attr => [
      [
	'exp',
	{
	  desc => 'Boots with <speed bonus> will increase the player\'s walking speed while worn. This kind of bonus is quite desirable for players of low- and medium level. High level players usually have fastest possible walking speed and thus don\'t need <speed bonus> anymore. Still, this bonus is good for nice artifacts - not everything has to be for highest level.',
	  name => 'speed bonus',
	  type => 'int'
	}
      ],
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the boots. Important: <magic bonus> on boots has no effect if there is no <armour class> set. It only works in combination with <armour class>.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing boots, the object\'s stats will directly be inherited to the player. Usually enhancing his speed, or granting some minor protection bonus.',
    import => [
      'Amulet'
    ],
    name => 'Boots',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  Bracers => {
    attr => [
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the bracers.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Bracers are armour-plates worn around the wrists. Wearing bracer, the object\'s stats will directly be inherited to the player. Usually enhancing his defense.',
    import => [
      'Amulet'
    ],
    name => 'Bracers',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  'Brestplate Armour' => {
    attr => [
      [
	'last_heal',
	{
	  desc => 'This poses a penalty to spell regeneration speed, for wearing the armour. The bigger the spellpoint penalty, the worse.',
	  name => 'spellpoint penalty',
	  type => 'int'
	}
      ],
      [
	'last_sp',
	{
	  desc => 'Slowdown penalty reduces the player\'s walking speed when wearing the armour. Bigger values are worse - zero is best.',
	  name => 'slowdown penalty',
	  type => 'int'
	}
      ],
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the armour.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing an armour, the object\'s stats will directly be inherited to the player. Usually enhancing his defense.',
    import => [
      'Amulet'
    ],
    name => 'Brestplate Armour',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  Button => {
    attr => [
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'move_off',
	{
	  desc => 'Which movement types deactivate this object (e.g. button).',
	  name => 'movement off',
	  type => 'movement_type'
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'weight',
	{
	  desc => 'The button is pressed (triggered), as soon as <press weigh> gram are placed ontop of it.',
	  name => 'press weight',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'Every time the button is pressed or released, all objects with the same <connection> value are activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the item. You can use this message to explain the button\'s purpose to the player.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'When a predefined amount of weigh is placed on a button, the &lt;connection&gt; value is triggered. In most cases this happens when a player or monster steps on it. When the button is "released", the &lt;connection&gt; value get\'s triggered a second time.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Button'
  },
  'Button Trigger' => {
    desc => 'Handle buttons are buttons which reset after a short period of time. Every time it is either applied or reset, the &lt;connection&gt; value is triggered.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    import => [
      'Button'
    ],
    name => 'Button Trigger'
  },
  'Class Changer' => {
    attr => [
      [
	'randomitems',
	{
	  desc => 'This entry determines which initial items the character receives.',
	  name => 'class items',
	  type => 'treasurelist'
	}
      ]
    ],
    desc => 'Class changer are used while creating a character.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Class Changer',
    section => [
      [
	'stats',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strength will rise by the given value if he chooses this class. (Negative values make strength fall)',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s dexterity will rise by the given value if he chooses this class. (Negative values make dexterity fall)',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s constitution will rise by the given value if he chooses this class. (Negative values make constitution fall)',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s intelligence will rise by the given value if he chooses this class. (Negative values make intelligence fall)',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s power will rise by the given value if he chooses this class. (Negative values make power fall)',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s wisdom will rise by the given value if he chooses this class. (Negative values make wisdom fall)',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s charisma will rise by the given value if he chooses this class. (Negative values make charisma fall)',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ]
    ]
  },
  Cloak => {
    attr => [
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the cloak. Important: <magic bonus> on cloaks has no effect if there is no <armour class> set. It only works in combination with <armour class>.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing a cloak, the object\'s stats will directly be inherited to the player. Cloaks usually add minor &lt;armour class&gt; and sometimes a bit of resistance.',
    import => [
      'Amulet'
    ],
    name => 'Cloak',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  Clock => {
    attr => [
      [
	'msg',
	{
	  desc => 'This text may describe the item',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Applying a clock, the time is displayed to the player.',
    name => 'Clock'
  },
  Container => {
    attr => [
      [
	'race',
	{
	  desc => 'If set, the container will hold only certain types of objects. Possible choices for <container class> are: "gold and jewels", "arrows" and "keys". Unfortunately it is not easy to create new container classes, because items need a matching counterpiece-attribute to the <container class> before they can be put inside a container. This attribute ("race") is set only for the existing container classes.',
	  name => 'container class',
	  type => 'string'
	}
      ],
      [
	'slaying',
	{
	  desc => 'If <key string> is set, only players with a special key of matching <key string> are able to open the container. When the key string starts with "match ", then it is expected to be a match expression, which will be applied to the player, so you can use e.g. (match type=POTION in inv). Note that the matched object will be removed.',
	  name => 'key string',
	  type => 'string'
	}
      ],
      [
	'container',
	{
	  desc => 'The container can hold a maximum total weight of the given value in gram. Note that this weight limit is calculated *after* the weight reduction (<reduce weight>) has been applied.',
	  name => 'maximum weight',
	  type => 'int'
	}
      ],
      [
	'Str',
	{
	  desc => 'This value determines how much the weight of items is reduced in percent, when put inside the container. <reduce weight %> 0 means no reduction, <reduce weight %> 100 means items are weightless inside. Most default values are in the range of ten.',
	  name => 'reduce weight %',
	  type => 'int'
	}
      ],
      [
	'is_cauldron',
	{
	  desc => 'If set, the container can be used as alchemy-cauldron. The player can put ingredients inside, close it, cast alchemy and if his formulae is true, he\'ll get what he longed for.',
	  name => 'alchemy cauldron',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good. All contents of a unique container are unique as well.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'other_arch',
	{
	  desc => 'This is used for a certain kind of... "animation" when opening the container. Stick to the default arches here and you won\'t get into trouble.',
	  name => 'animation arch',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a description of the container.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'A player can put (certain kinds of) items in the container. The overall weight of items is reduced when put inside a container, depending on the settings. <br><br> A special feature of containers is the "cauldron", capable of mixing alchemical receipes.',
    name => 'Container',
    use => 'Note on chests - There are two types of chests: <UL> <LI> First the random treasure chests - Those are NOT containers (but object type Treasure), they create random treasures when applied. Archetype name is "chest". <LI> Second there are the permanent chests - Those are containers, they can be opened and closed again. Archetype name is "chest_2". </UL>'
  },
  Converter => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => '<cost arch> is the name of the archetype the player has to put on the converter, as payment.',
	  name => 'cost arch',
	  type => 'string'
	}
      ],
      [
	'food',
	{
	  desc => 'The player has to put <cost number> items of <cost arch> on the converter, in order to get <receive number> items of <receive arch>.',
	  name => 'cost number',
	  type => 'int'
	}
      ],
      [
	'other_arch',
	{
	  desc => '<receive arch> is the name of the archetype to convert into. This field is ignored if the converter has items in inventory. In this case one of the inventory items is duplicated. The duplicated item is randomly chosen from all items present.',
	  name => 'receive arch',
	  type => 'string'
	}
      ],
      [
	'sp',
	{
	  desc => 'The player has to put <cost number> items of <cost arch> on the converter, in order to get <receive number> items of <receive arch>.',
	  name => 'receive number',
	  type => 'int'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a description of the converter.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ],
      [
	'precious',
	{
	  desc => 'If the converter has this flag set the generated items will be flagged as unpaid. Useful if you want to make a converter in a shop. (For instance for \'dragon scale\' to \'dragon shield\' converters in some armour shops.)',
	  name => 'output unpaid',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Converters are like "exchange tables". When the player drops a specific type of items, they get converted into other items, at a predefined exchange-ratio.',
    ignore => [
      'value',
      'nrof',
      'name_pl',
      'no_pick',
      'unpaid',
      'title'
    ],
    name => 'Converter',
    use => 'Converters are better than shopping with doormats, because the converters never get sold out. For some items like food or jewels those "exchange tables" are really nice, while for the more important stuff like potions converters should not exist. <br><br> VERY IMPORTANT: Be careful with the exchange-ratio! When you drop items on a converter, the stuff you get must be of equal or lesser value than before! (Except if you are using "rare" items like dragonscales for payment). The code will not check if your ratio is sane, so the player could gain infinite wealth by using your converter.'
  },
  Creator => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'other_arch',
	{
	  desc => 'This string defines the object that will be created. You can choose any of the existing arches. This field is ignored if the creator has items in inventory. In this case one of the inventory items is duplicated. The duplicated item is randomly chosen from all items present.',
	  name => 'create arch',
	  type => 'string'
	}
      ],
      [
	'connected',
	{
	  desc => 'Whenever the connection value is activated, the creator gets triggered.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'lifesave',
	{
	  desc => 'If <unlimited uses> is set, the creator will work infinitely, regardless of the value in <number of uses>.',
	  name => 'unlimited uses',
	  type => 'bool'
	}
      ],
      [
	'speed',
	{
	  desc => 'When this field is set the creator will periodically create stuff (and will still do so when the connection is triggered). A value of 1 means roughly 8 times a second.',
	  name => 'speed',
	  type => 'float'
	}
      ],
      [
	'hp',
	{
	  desc => 'The creator can be triggered <number of uses> times, thus creating that many objects, before it dissappears. Default is <number of uses> 1 (-> one-time usage).',
	  name => 'number of uses',
	  type => 'int'
	}
      ],
      [
	'slaying',
	{
	  desc => 'The created object will bear the name and title specified in <name of creation>. If nothing is set, the standard name and title of the archetype is used.',
	  name => 'name of creation',
	  type => 'string'
	}
      ],
      [
	'level',
	{
	  desc => 'The created object will be of that level. If zero/unset, the standard level of the archetype is used.',
	  name => 'level of creation',
	  type => 'int'
	}
      ]
    ],
    desc => 'A creator is an object which creates another object when it is triggered. The child object can be anything. Creators are VERY useful for all kinds of map-mechanisms. They can even periodically create things.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Creator',
    use => 'Don\'t hesitate to hide your creators under the floor. The created items will still always appear ontop of the floor.'
  },
  Detector => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => '<match name> specifies the name of the object we are looking for. Actually it does also check for the <key string> in key-objects, but for this case inventory checkers are often more powerful to use.',
	  name => 'match name',
	  type => 'string'
	}
      ],
      [
	'connected',
	{
	  desc => 'When the detector is triggered, all objects with the same connection value get activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'speed',
	{
	  desc => 'This value defines the time between two detector-checks. If you want the detector to behave almost like pedestals/buttons, set speed rather high, like <detection speed> 1.0.',
	  name => 'detection speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left. This value is incremented by <speed> on every tick. If it is larger than 0, the detector checks, and the speed is decremented by 1.',
	  name => 'speed left',
	  type => 'float'
	}
      ]
    ],
    desc => 'Detectors work quite much like inv. checkers/pedestals: If the detector finds a specific object, it toggles its connected value. <br><br> What is "unique" about them, compared to inv. checkers/ pedestals? - First, detectors check their square for a match periodically, not instantly, so generate much higher server load Second, detectors check directly for object names. Third, detectors do not check the inventory of players/monsters.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Detector',
    use => 'Best avoid this type at all costs, use a pedestal instead.'
  },
  Director => {
    attr => [
      [
	'sp',
	{
	  desc => 'Projectiles will leave the director flying in the selected <direction>. A director with direction <none> simply stops projectiles. (The latter works out a bit strange for some spells).',
	  name => 'direction',
	  type => 'list',
	  value => $LIST{direction}
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ]
    ],
    desc => 'Directors change the direction of spell objects and other projectiles that fly past. Unlike spinners, directors always move objects in the same direction. It does not make a difference from what angle you shoot into it.<br> Directors are visible per default.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Director',
    use => 'Directors are rarely used in maps. Sometimes they are placed to change the direction of spells coming out of magic walls, "channeling" spell-projectiles in some direction. When doing this, <B>never place directors facing each other with magic walls fireing into them!</B> The spell-projectiles bouncing between the directors would accumulate to huge numbers and at some point slow down the server by eating memory- and CPU-time. <br><br> You\'d better not place directors in monster vs. player combat areas too much, because that freaks out wizard-type players.'
  },
  Disease => {
    attr => [
      [
	'invisible',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'level',
	{
	  desc => 'The <plaque level> is proportional to the disease\'s deadliness. This mainly reflects in the <damage>. It has no effect on most other symptoms. Neverthless, it is a very important value for all damage-inflicting diseases.',
	  name => 'plaque level',
	  type => 'int'
	}
      ],
      [
	'race',
	{
	  desc => 'The disease will only infect creatures of the specified <race>. "<race> *" means every creature can be infected.',
	  name => 'infect race',
	  type => 'string'
	}
      ],
      [
	'ac',
	{
	  desc => 'Every time the disease "moves" the severity of the symptoms are increased by <progressiveness>/100. (severity = 1 + (accumlated progression)/100)',
	  name => 'progressiveness',
	  type => 'int'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text is displayed to the player every time the symptoms strike.',
	  end => 'endmsg',
	  name => 'message',
	  type => 'text'
	}
      ]
    ],
    desc => 'Diseases are an intersting form of spellcraft in Deliantra. Once casted, they can spread out and infect creatures in a large area. Being infected can have various effects, from amusing farts to horrible damage - almost everything is possible.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Disease',
    section => [
      [
	'spreading',
	[
	  [
	    'wc',
	    {
	      desc => 'The <infectiosness> defines the chance of new creatures getting infected. If you set this too high, the disease is very likely to be too effective. <infectiosness>/127 is the chance of someone in range catching it.',
	      name => 'infectiosness',
	      type => 'int'
	    }
	  ],
	  [
	    'last_grace',
	    {
	      desc => 'The <attenuation> value reduces the diseases\' <infectiosness> everytime it infects someone new. This limits how many generations a disease can propagate.',
	      name => 'attenuation',
	      type => 'int'
	    }
	  ],
	  [
	    'magic',
	    {
	      desc => '<infection range> sets the range at which infection may occur. If positive, the <infection range> is level dependant - If negative, it is not: E.g. "<infection range> -6" means creatures can be infected in six square range, and <plaque level> doesn\'t modify that.',
	      name => 'infection range',
	      type => 'int'
	    }
	  ],
	  [
	    'maxhp',
	    {
	      desc => '<persistence> defines how long the disease can persist OUTSIDE a host. The disease can "move" <persistence> times outside a host before it vanishes. A negative value means the disease lasts for permanent (which is only recommended to use in maps without monsters).',
	      name => 'persistence',
	      type => 'int'
	    }
	  ],
	  [
	    'maxgrace',
	    {
	      desc => 'The disease will last in the host for <curing duration> "disease moves" (Assuming the host survives and doesn\'t use a curing spell). After this period the disease is naturally cured, which provides the host with immunity from this particular disease of lower or equal level. A negative value means the disease can never be cured naturally. Note that this value can be further modulated by spell-parameters, if the disease is registered as spell in the code. Due to that, most default diseases take a lot longer to cure than it seems.',
	      name => 'curing duration',
	      type => 'int'
	    }
	  ],
	  [
	    'speed',
	    {
	      desc => 'The <speed> of the disease determines how fast the disease will "move", thus how fast the symptoms strike the host.',
	      name => 'moving speed',
	      type => 'float'
	    }
	  ],
	  [
	    'speed_left',
	    {
	      desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	      name => 'speed left',
	      type => 'float'
	    }
	  ]
	]
      ],
      [
	'symptoms',
	[
	  [
	    'attacktype',
	    {
	      desc => 'The disease will attack the host with the given <attacktype>. Godpower attacktype is commonly used for "unresistable" diseases.',
	      name => 'attacktype',
	      type => 'bitmask',
	      value => $BITMASK{attacktype}
	    }
	  ],
	  [
	    'dam',
	    {
	      desc => 'A disease with a positive <damage> value will strike the player for that amount of damage every time the symptoms occur. A negative <damage> value produces %-based damage: "<damage> -10" means the player\'s health is reduced by 10% every time the symptoms strike. Diseases with %-based damage can be dangerous - but not deadly - for players of all levels.',
	      name => 'damage',
	      type => 'int'
	    }
	  ],
	  [
	    'other_arch',
	    {
	      desc => 'If set, the specified arch is created and dropped every time the symptoms strike. This can be various things: farts, body pieces, eggs ... Even monsters can be created that way. You could also make a disease where some exotic stuff like money/gems is created.',
	      name => 'create arch',
	      type => 'string'
	    }
	  ],
	  [
	    'last_sp',
	    {
	      desc => 'If set, the disease imposes a <slowdown penalty> while being infected. The player\'s speed is reduced by <slowdown penalty> % of normal value.',
	      name => 'slowdown penalty',
	      type => 'int'
	    }
	  ],
	  [
	    'exp',
	    {
	      desc => 'When the player manages to cure this disease (with a curing spell), he is awarded with <exp. for curing> experience.',
	      name => 'exp. for curing',
	      type => 'int'
	    }
	  ],
	  [
	    'maxsp',
	    {
	      desc => 'Every time the disease "moves", the player\'s mana is reduced by the value of <mana depletion>. For negative values, a %-based amount is taken.',
	      name => 'mana depletion',
	      type => 'int'
	    }
	  ],
	  [
	    'last_eat',
	    {
	      desc => 'Every time the disease "moves", the player\'s food is reduced by the value of <food depletion>. For negative values, a %-based amount is taken.',
	      name => 'food depletion',
	      type => 'int'
	    }
	  ],
	  [
	    'hp',
	    {
	      desc => 'This value increases the player\'s healing rate. Negative values decrease it.',
	      name => 'health regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'sp',
	    {
	      desc => 'This value increases the player\'s rate of mana regeneration. Negative values decrease it.',
	      name => 'mana regen.',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'disability',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strength will rise by the given value while being infected. (Negative values make strength fall)',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s dexterity will rise by the given value while being infected. (Negative values make dexterity fall)',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s constitution will rise by the given value while being infected. (Negative values make constitution fall)',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s intelligence will rise by the given value while being infected. (Negative values make intelligence fall)',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s power will rise by the given value while being infected. (Negative values make power fall)',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s wisdom will rise by the given value while being infected. (Negative values make wisdom fall)',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s charisma will rise by the given value while being infected. (Negative values make charisma fall)',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'Diseases are extremely flexible and usable in a many ways. So far they are mostly used for causing bad, unwanted effects. You could just as well create a disease which helps the player (recharging mana for example). Infection with a "positive disease" could even be a quest reward.'
  },
  Door => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'alive',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'The more <hitpoints> the door has, the longer it takes to be broken.',
	  name => 'hitpoints',
	  type => 'int'
	}
      ],
      [
	'ac',
	{
	  desc => 'Doors of high <armour class> are less likely to get hit. <armour class> can be considered the "counterpiece" to <weapon class>.',
	  name => 'armour class',
	  type => 'int'
	}
      ],
      [
	'other_arch',
	{
	  desc => 'This string defines the object that will be created when the door was defeated.',
	  name => 'drop arch',
	  type => 'string'
	}
      ],
      [
	'randomitems',
	{
	  desc => 'This entry determines what kind of traps will appear in the door.',
	  name => 'treasurelist',
	  type => 'treasurelist'
	}
      ],
      [
	'treasure_env',
	{
	  desc => 'Set this flag to move treasure items created into the environment (map) instead of putting them into the object.',
	  name => 'treasure in env',
	  type => 'bool'
	}
      ]
    ],
    desc => 'A door can be opened with any normal key. It also can be broken by attacking it, and it can be defeated with the lockpicking skill. If a door is defeated, horizontally and vertically adjacent doors are automatically removed.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Door'
  },
  Duplicator => {
    attr => [
      [
	'other_arch',
	{
	  desc => 'Only objects of matching archtype, lying ontop of the duplicator will be duplicated, multiplied or removed. All other objects will be ignored.',
	  name => 'target arch',
	  type => 'string'
	}
      ],
      [
	'level',
	{
	  desc => 'The number of items in the target pile will be multiplied by the <multiply factor>. If it is set to zero, all target objects will be destroyed.',
	  name => 'multiply factor',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'An activator (lever, altar, button, etc) with matching connection value is able to trigger this duplicator. Be very careful that players cannot abuse it to create endless amounts of money or other valuable stuff!',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ]
    ],
    desc => 'When activated, a duplicator can duplicate, multiply or destroy a pile of objects which lies somewhere on top of the duplicator. The duplicator has one arch name specified as &lt;target arch&gt;, and only objects of this archetype can be affected.<br> It will multiply the number of items in the pile, by the &lt;multiply factor&gt;. If the latter is set to zero, it will destroy objects.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Duplicator',
    use => 'I hope it is clear that one must be very cautious when inserting a duplicator anywhere with &lt;multiply factor&gt; greater than one. It is designed to be used for betting mechanisms only (bet -&gt; win/loose). It is <b>not acceptable</b> to allow duplication of anything other than coins, gold and jewels. Besides, it is very important that the chance to loose the input matches the chance to earn winnings.<br> A duplicator with &lt;multiply factor&gt; 3 for example should have a loosing rate of 2/3 = 67%.'
  },
  'Event Connector' => {
    desc => 'Event connectors link specific events that happen to objects to a crossfire plug-in. They are not used at all in Deliantra.',
    name => 'Event Connector'
  },
  Exit => {
    attr => [
      [
	'slaying',
	{
	  desc => 'The exit path defines the map that the player is transferred to. You can enter an absolute path, beginning with \'/\' (for example "/peterm/FireTemple/fire1"). It can also be a relative path, not beginning with \'/\' (On the map "/peterm/FireTemple/Fire2" for example I could use the relative path "Fire1"). Use relative paths whenever possible! Note that upper/lower case must always be set correctly. However, please use lower case only. It is well possible to have an exit pointing to the same map that the exit is on. If slaying is not set in an exit, the player will see a message like "the exit is closed".',
	  name => 'exit path',
	  type => 'string'
	}
      ],
      [
	'hp',
	{
	  desc => 'The exit destinations define the (x, y)-coordinates where the exit leads to. If both are set to zero, the player will be transferred to the "default enter location" of the destined map. The latter can be set in the map- properties as "Enter X/Y". Though, please DO NOT use that. It turned out to be a source for numerous map-bugs.',
	  name => 'destination X',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'The exit destinations define the (x, y)-coordinates where the exit leads to. If both are set to zero, the player will be transferred to the "default enter location" of the destined map. The latter can be set in the map- properties as "Enter X/Y". Though, please DO NOT use that. It turned out to be a source for numerous map-bugs.',
	  name => 'destination Y',
	  type => 'int'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'msg',
	{
	  desc => 'If set, this message will be displayed to the player when he applies the exit. This is quite useful to throw in some "role-play feeling": "As you enter the dark cave you hear the sound of rustling dragonscales...". Well, my english is poor, but you get the point. =)',
	  end => 'endmsg',
	  name => 'exit message',
	  type => 'text'
	}
      ],
      [
	'damned',
	{
	  desc => 'If set, then players using this exit will have their savebed position set to the destination of the exit when passing through.',
	  name => 'set savebed',
	  type => 'bool'
	}
      ]
    ],
    desc => 'When the player applies an exit, he is transferred to a different location. (Monsters cannot use exits.) Depending on how it is set, the player applies the exit just by walking into it, or by pressing &lt;a&gt;pply when standing on the exit.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Exit',
    use => 'If you want to have an invisible exit, set &lt;invisible&gt; (, of course &lt;apply by walking&gt;), and put it *under* the floor. Otherwise it could be detected with the show_invisible spell. <br><br> You can be quite creative with the outlook of secret exits (their "face"). Don\'t forget to give the player relyable hints about them though.'
  },
  Flesh => {
    attr => [
      [
	'food',
	{
	  desc => 'The player\'s stomache will get filled with this amount of foodpoints. The player\'s health will increase by <foodpoints>/50 hp.',
	  name => 'foodpoints',
	  type => 'int'
	}
      ],
      [
	'level',
	{
	  desc => 'The <flesh level> is not visible to the players and it affects only dragon players. Normally this value reflects the level of the monster from which the flesh item originates. Dragon players always search for flesh of highest level possible, because it bears the best chance to gain high resistances.',
	  name => 'flesh level',
	  type => 'int'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the item.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Just like with food, the player can fill his stomache and gain a little health by eating flesh-objects. <br> For dragon players, flesh plays a very special role though: If the flesh has resistances set, a dragon player has a chance to gain resistance in those categories. The only constraint to this process is the &lt;flesh level&gt;. Don\'t forget that flesh items with resistances have to be balanced according to map/monster difficulty.',
    name => 'Flesh',
    section => [
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      desc => 'Resistances on flesh items make them more durable against spellcraft of the appropriate kind. It also allows dragon players to eventually gain resistance by eating it. Usually resistance should only be set for flesh items in a monster\'s inventory.',
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'For dragon players, flesh items can be highly valuable. Note that many standard monsters carry flesh items from their &lt;treasurelist&gt;. These flesh items "inherit" resistances and level from the monster they belong to. When you add special flesh items to the inventory of a monster, this is not the case - so you have to set it manually. <br><br> Generally adding special flesh-treaties for dragon players is a great thing to do. Always consider that dragon players might really not be interested in that special piece of weapon or armour, so don\'t let the dragon-fellows miss out on the reward completely.'
  },
  Floor => {
    attr => [
      [
	'is_floor',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_magic',
	{
	  desc => 'If enabled, it is impossible for players to use (wizard-) spells on that spot.',
	  name => 'no spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'If enabled, it is impossible for players to use prayers on that spot. It also prevents players from saving.',
	  name => 'no prayers',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique floor means that any items dropped on that spot will be saved beyond map reset. For permanent apartments, all floor tiles must be set <unique map>.',
	  name => 'unique map',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the object.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Floor is a very basic thing whithout too much functionality. It\'s a floor - you stand on it.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Floor',
    section => [
      [
	'terrain',
	[
	  [
	    'move_block',
	    {
	      desc => 'Objects using these movement types cannot move over this space.',
	      name => 'blocked movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_allow',
	    {
	      desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	      name => 'allowed movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_slow',
	    {
	      desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	      name => 'slowed movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_slow_penalty',
	    {
	      desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	      name => 'slow movement penalty',
	      type => 'int'
	    }
	  ],
	  [
	    'is_wooded',
	    {
	      desc => 'This flag indicates this spot contains wood or high grass. Players with activated woodsman skill can move faster here.',
	      name => 'wooded terrain',
	      type => 'bool'
	    }
	  ],
	  [
	    'is_hilly',
	    {
	      desc => 'This flag indicates this spot contains hills or large rocks. Players with activated mountaineer skill can move faster here.',
	      name => 'hilly terrain',
	      type => 'bool'
	    }
	  ]
	]
      ]
    ]
  },
  'Floor (Encounter)' => {
    attr => [
      [
	'is_floor',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_magic',
	{
	  desc => 'If enabled, it is impossible for players to use (wizard-) spells on that spot.',
	  name => 'no spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'If enabled, it is impossible for players to use prayers on that spot. It also prevents players from saving.',
	  name => 'no prayers',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique floor means that any items dropped on that spot will be saved beyond map reset. For permanent apartments, all floor tiles must be set <unique map>.',
	  name => 'unique map',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the object.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Encounter-Floor is pretty much the same as normal floor. Most outdoor floor/ground-arches are set to be "encounters". That is kind of a relict from former code: When walking over encounter-floor, players sometimes got beamed to little maps with monsters on them. Nowadays this feature is disabled - Hence encounter floor is not different from normal floor.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Floor (Encounter)',
    section => [
      [
	'terrain',
	[
	  [
	    'move_block',
	    {
	      desc => 'Objects using these movement types cannot move over this space.',
	      name => 'blocked movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_allow',
	    {
	      desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	      name => 'allowed movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_slow',
	    {
	      desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	      name => 'slowed movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_slow_penalty',
	    {
	      desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	      name => 'slow movement penalty',
	      type => 'int'
	    }
	  ],
	  [
	    'is_wooded',
	    {
	      desc => 'This flag indicates this spot contains wood or high grass. Players with activated woodsman skill can move faster here.',
	      name => 'wooded terrain',
	      type => 'bool'
	    }
	  ],
	  [
	    'is_hilly',
	    {
	      desc => 'This flag indicates this spot contains hills or large rocks. Players with activated mountaineer skill can move faster here.',
	      name => 'hilly terrain',
	      type => 'bool'
	    }
	  ]
	]
      ]
    ]
  },
  Food => {
    attr => [
      [
	'food',
	{
	  desc => 'The player\'s stomache will get filled with this amount of foodpoints. The player\'s health will increase by <foodpoints>/50 hp.',
	  name => 'foodpoints',
	  type => 'int'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ]
    ],
    desc => 'By eating/drinking food-objects, the player can fill his stomache and gain a little health.',
    name => 'Food'
  },
  Gate => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'speed',
	{
	  desc => 'The speed of the gate affects how fast it is closing/opening.',
	  type => 'float'
	}
      ],
      [
	'connected',
	{
	  desc => 'Whenever the inventory checker is triggered, all objects with identical <connection> value get activated. This only makes sense together with <blocking passage> disabled.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'wc',
	{
	  desc => 'The <position state> defines the position of the gate: Zero means completely open/down, the "number of animation-steps" (usually about 6 or 7) means completely closed/up state. I suggest you don\'t mess with this value - Leave the default in place.',
	  name => 'position state',
	  type => 'int'
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'Restricting the use of spells to pass this gate. This has an effect only if <block view> is disabled.',
	  name => 'restrict spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'Restricting the use of prayers to pass this door. This has an effect only if <block view> is disabled.',
	  name => 'restrict prayers',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Gates play an important role in Deliantra. Gates can be opened by activating a button/trigger, by speaking passwords (-> magic_ear) or carrying special key-objects (-> inventory checker). Unlike locked doors, gates can get shut again after a player has passed, which makes them more practical in many cases.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Gate',
    use => 'Use gates to divide your maps into seperated areas. After solving area A, the player gains access to area B, and so on. Make your maps more complex than "one-way".'
  },
  Girdle => {
    attr => [
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the helmet. Important: <magic bonus> on girdles has no effect if there is no <armour class> set. Girdles shouldn\'t have <armour class>, thus <magic bonus> is pointless here.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing a girdle, the object\'s stats will directly be inherited to the player. Girdles usually provide stats- or damage bonuses and no defense.',
    import => [
      'Amulet'
    ],
    name => 'Girdle',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  Gloves => {
    attr => [
      [
	'magic',
	{
	  desc => 'If the gloves provide <armour class>, <magic bonus> will increase it. If the gloves have <weapon class> instead, then <magic bonus> will increase that.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing gloves, the object\'s stats will directly be inherited to the player. Gloves can add defense or damage bonuses.',
    import => [
      'Amulet'
    ],
    name => 'Gloves',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  Handle => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'connected',
	{
	  desc => 'Every time the handle is applied, all objects with the same <connection> value are activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the item. You can use this message to explain the handle\'s purpose to the player.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'A handle can be applied by players and (certain) monsters. Every time it is applied, the &lt;connection&gt; value is triggered.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Handle',
    use => 'Handles are commonly used to move gates. When placing your lever, don\'t forget that some monsters are able to apply it. The ability to apply levers is rare among monsters - but vampires can do it for example.'
  },
  'Handle Trigger' => {
    desc => 'Handle triggers are handles which reset after a short period of time. Every time it is either applied or reset, the &lt;connection&gt; value is triggered.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    import => [
      'Handle'
    ],
    name => 'Handle Trigger',
    use => 'When you connect an ordinary handle to a gate, the gate normally remains opened after the first player passed. If you want to keep the gate shut, connecting it to a handle trigger is an easy solution.'
  },
  'Hazard Floor' => {
    attr => [
      [
	'is_floor',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'lifesave',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'attacktype',
	{
	  desc => 'This attribute specifys the attacktypes that this floor uses to damage it\'s victims. Attacktypes are: physical, fire, cold.. etc. If you want a real tough hazard floor, add more than just one attacktype.',
	  name => 'attacktype',
	  type => 'bitmask',
	  value => $BITMASK{attacktype}
	}
      ],
      [
	'dam',
	{
	  desc => 'The <base damage> defines how much damage is inflicted to the victim per hit. The final damage is influenced by several other factors like the victim\'s resistance and level.',
	  name => 'base damage',
	  type => 'int'
	}
      ],
      [
	'wc',
	{
	  desc => '<weapon class> improves the chance of hitting the victim. Lower values are better. Usually, hazard floors like lava are supposed to hit the victim all the time. Therefore, <weaponclass> should be set to something like -30.',
	  name => 'weaponclass',
	  type => 'int'
	}
      ],
      [
	'level',
	{
	  desc => 'I guess this value is supposed to work similar to monster levels. But in fact, it does not seem to have an effect. Set any non-zero value to be on the safe side.',
	  name => 'attack level',
	  type => 'int'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'If enabled, it is impossible for players to use (wizard-) spells on that spot.',
	  name => 'no spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'If enabled, it is impossible for players to use prayers on that spot. It also prevents players from saving.',
	  name => 'no prayers',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique floor means that any items dropped on that spot will be saved beyond map reset. For permanent apartments, all floor tiles must be set <unique map>.',
	  name => 'unique map',
	  type => 'bool'
	}
      ]
    ],
    desc => 'The best example for Hazard Floor is lava. It works like standard floor, but damages all creatures standing on it. Damage is taken in regular time intervals.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Hazard Floor',
    section => [
      [
	'terrain',
	[
	  [
	    'move_block',
	    {
	      desc => 'Objects using these movement types cannot move over this space.',
	      name => 'blocked movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_allow',
	    {
	      desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	      name => 'allowed movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_slow',
	    {
	      desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	      name => 'slowed movement',
	      type => 'movement_type'
	    }
	  ],
	  [
	    'move_slow_penalty',
	    {
	      desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	      name => 'slow movement penalty',
	      type => 'int'
	    }
	  ],
	  [
	    'is_wooded',
	    {
	      desc => 'This flag indicates this spot contains wood or high grass. Players with activated woodsman skill can move faster here.',
	      name => 'wooded terrain',
	      type => 'bool'
	    }
	  ],
	  [
	    'is_hilly',
	    {
	      desc => 'This flag indicates this spot contains hills or large rocks. Players with activated mountaineer skill can move faster here.',
	      name => 'hilly terrain',
	      type => 'bool'
	    }
	  ]
	]
      ]
    ],
    use => 'The default lava for example does minor damage. But you can turn it up so that your hazard floor poses a real threat.<br> Like magic walls, such floors add a permanent thrill to your map. You can use that to safely chase off too-weak players, or just to have something different.'
  },
  Helmet => {
    attr => [
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the helmet. Important: <magic bonus> on helmets has no effect if there is no <armour class> set. It only works in combination with <armour class>. Crowns for instance typically provide no <amour class>.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing a helmet, the object\'s stats will directly be inherited to the player. Normal helmets usually increase defense, while crowns add more special bonuses like stats/resistances paired with low defense.',
    import => [
      'Amulet'
    ],
    name => 'Helmet',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  'Holy Altar' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'other_arch',
	{
	  desc => 'The altar belongs to the god of the given name. Possible options for <god name> are: Devourers, Lythander, Mostrai, Gaea, Ruggilli, Gnarg, Gorokh, Valriel and Sorig. If you want to have an unconsecrated altar, set <god name> 0 and eventually <reconsecrate level> 0.',
	  name => 'god name',
	  type => 'string'
	}
      ],
      [
	'level',
	{
	  desc => 'To re-consecrate an altar, the player\'s wisdom level must be as high or higher than this value. In that way, some altars can not be re-consecrated, while other altars, like those in dungeons, could be. Altars located in temples should have at least <reconsecrate level> 120. Some characters might need those altars, they would be very unhappy to see them re-consecrated to another cult.',
	  name => 'reconsecrate level',
	  type => 'int'
	}
      ]
    ],
    desc => 'Holy Altars are altars for the various religions. Praying at a Holy_altar will make you a follower of that god, and if you already follow that god, you may get some extra bonus.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Holy Altar'
  },
  Horn => {
    attr => [
      [
	'sp',
	{
	  desc => 'Sets the <spell> of the horn. Consider twice before handing out any horns to players, since they can be used endlessly without any mana cost! Horns with heal/ restoration/ protection spells, IF available, MUST be very very VERY hard to get!',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'level',
	{
	  desc => 'The casting level of the <spell> determines it\'s power. For attack spells, level should not be set too high.',
	  name => 'casting level',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'This value represents the initial amount of spellpoints in the horn. Naturally, this is quite unimportant.',
	  name => 'initial spellpoints',
	  type => 'int'
	}
      ],
      [
	'maxhp',
	{
	  desc => 'When the horn is fully charged up, it will hold this maximum amount of spellpoints. Make sure it is enough to cast the contained spell at least once. But don\'t set the value too high, as that might make the horn way too effective.',
	  name => 'max. spellpoints',
	  type => 'int'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a description of the horn.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Horns are very similar to rods. The difference is that horns regenerate spellpoints faster and thus are more valuable than rods. <br><br> A horn contains a spell. The player can use this spell by applying and "fireing" (blowing) the horn. Unlike wands/scrolls, horns can be used endlessly.',
    ignore => [
      'title'
    ],
    name => 'Horn',
    use => 'Horns are powerful due to their fast recharge rate. They should never contain high level attacking spells. Even curing/healing spells are almost too good on a horn.'
  },
  Inorganic => {
    attr => [
      [
	'is_dust',
	{
	  name => 'is dust',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Inorganic materials are generally used as ingredients for alchemical receipes. By themselves, they have no special functionalities.',
    name => 'Inorganic',
    section => [
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ]
  },
  Inscribable => {
    attr => [
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'other_arch',
	{
	  desc => 'This is the item created after being inscribed - scrolls are treated like spell scrolls, all else will have it\'s message replaced.',
	  name => 'book/scroll arch',
	  type => 'string'
	}
      ]
    ],
    desc => 'Inscribable Item - when inscribed, it becomes another object.',
    name => 'Inscribable'
  },
  'Inventory Checker' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'This string specifies the object we are looking for: We have a match if the player does/don\'t carry a key object or a mark with identical <key string>. Note that key objects usually appear as "passports" in this context. A typical example is the city gate mechanism of scorn.',
	  name => 'match key string',
	  type => 'string'
	}
      ],
      [
	'race',
	{
	  desc => 'This string specifies the object we are looking for: We have a match if the player does/don\'t carry an object of archtype <match arch name>.',
	  name => 'match arch name',
	  type => 'string'
	}
      ],
      [
	'hp',
	{
	  desc => 'This value specifies the object we are looking for: We have a match if the player does/don\'t carry an object that is of type <match type>. Example: Set <match type> 15 (type 15 => weapon) and <blocking passage> enabled. Now you have an inv. checker blocking all players that carry any kind of melee weapon. To pass, a player is forced to leave behind all his weaponry... bad news for a warrior. ;)',
	  name => 'match type',
	  type => 'int'
	}
      ],
      [
	'last_sp',
	{
	  desc => 'Enabled means having that object is a match. Disabled means not having that object is a match.',
	  name => 'match = having',
	  type => 'bool'
	}
      ],
      [
	'connected',
	{
	  desc => 'Whenever the inventory checker is triggered, all objects with identical <connection> value get activated. This only makes sense together with <blocking passage> disabled.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'last_heal',
	{
	  desc => '<remove match> means remove object if found. Setting this is usually not recommended because inv. checkers are in general invisible. So, unlike for altars/ locked doors, the player won\'t expect to lose an object when walking over that square. And he doesn\'t even get a message either. So, *if* you enable <remove match>, make sure to inform the player what\'s going on!',
	  name => 'remove match',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Inventory checkers passively check the players inventory for a specific object. You can set a connected value that is triggered either if that object is present or missing (-&gt; "last_sp") when a player walks over the inv. checker. A valid option is to remove the matching object (usually not recommended, see "last_heal"). <br><br> Alternatively, you can set your inv. checker to block all players that do/don\'t carry the matching object. <br><br> As you can see, inv. checkers are quite powerful, holding a great variety of possibilities.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Inventory Checker',
    use => 'Putting a check_inventory space in front of a gate (one below) and one on the opposite side works reasonably well as a control mechanism. Unlike the key/door-combo, this one works infinite since it is independant from map reset. Use it to put a "structure" into your maps: Player must solve area A to gain access to area B. This concept can be found in nearly every RPG - simple but effective.'
  },
  'Item Match' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'If the string starts with \'match \', then it is interpreted as a match expression (e.g. \'match type=POTION\', or \'match type=SPELL in applied type=CONTAINER in inv in originator\'). For details, see http://pod.tst.eu/http://cvs.schmorp.de/deliantra/server/lib/cf/match.pm Optionally you can leave out the "match " prefix.',
	  name => 'match expression',
	  type => 'string'
	}
      ],
      [
	'connected',
	{
	  desc => 'When the match is triggered, all objects with the same connection value get activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'move_off',
	{
	  desc => 'Which movement types deactivate this object (e.g. button).',
	  name => 'movement off',
	  type => 'movement_type'
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ]
    ],
    desc => 'Match objects use the deliantra matching language (http://pod.tst.eu/http://cvs.schmorp.de/deliantra/server/lib/cf/match.pm) to match items on the same mapspace (if move_on/off are unset) or items trying to enter (if move_blocked is set). If a connected value is given, then it is triggered if the first object matching the expression is put on it, and the last is removed.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Item Match',
    use => 'If you want to trigger something else (e.g. a gate) when an item is above this object, use the move_on/move_off settings. If you want to keep something from entering if it has (or lacks) a specific item, use the move_blocked setting.'
  },
  'Item Transformer' => {
    attr => [
      [
	'food',
	{
	  desc => '<number of uses> controls how many times the item transformer can be used. The value 0 means "unlimited"',
	  name => 'number of uses',
	  type => 'int'
	}
      ],
      [
	'slaying',
	{
	  desc => 'Contains the verb that is used to construct a message to the player applying the item transformer.',
	  name => 'verb',
	  type => 'string'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a description of the item transformer.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'An item transformer is simply applied, after having marked a \'victim\' item. If the victim is suitable, it will be transformed into something else.',
    name => 'Item Transformer',
    use => 'To make an item transformable, you just have to fill the \'slaying\' field. The syntax is: <br> <pre>slaying slayer:[yield ]new_item[;slayer:[yield ]new_item]*</pre> <br> with [] denoting optional part, and * any number of preceding []. \'new_item\' must be the name of an existing archetype. <br><br> Example, for object apple: slaying knife:2 half_apple <br><br> This means that, when applying a knife (should be an Item Transformer), one \'apple\' will be transformed into 2 \'half_apple\'.'
  },
  Jewel => {
    attr => [
      [
	'race',
	{
	  type => 'fixed',
	  value => 'gold and jewels'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the object.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Items of the type Gold &amp; Jewels are handled like a currency. Unlike for any other type of item, in shops, the buy- and selling prices differ only marginally.',
    name => 'Jewel'
  },
  Key => {
    attr => [
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ]
    ],
    desc => 'When carrying a key, a normal door can be opened. The key will disappear.',
    name => 'Key'
  },
  Lamp => {
    attr => [
      [
	'speed',
	{
	  desc => 'This field is the speed of the lamp. (If the value 0.00208 is given here the fuel field will specify the burning duration in minutes.)',
	  name => 'burn speed',
	  type => 'float'
	}
      ],
      [
	'food',
	{
	  desc => 'This field sets the burning duration of the lamp, which depends on the speed field of this object.',
	  name => 'fuel',
	  type => 'int'
	}
      ],
      [
	'range',
	{
	  desc => 'This field sets the glow radius of the lamp if it is enabled. If you want to make a lamp that is already burning set the "glow radius" field.',
	  name => 'enabled glow radius',
	  type => 'int'
	}
      ],
      [
	'level',
	{
	  desc => 'If this field specyfies the cursed effect\'s level. If it is 0 no cursed effect will be generate. See also the "cursed" flag.',
	  name => 'level',
	  type => 'int'
	}
      ],
      [
	'cursed',
	{
	  desc => 'Cursed lamps, which have a level above 0, explode if the player applies them.',
	  name => 'cursed',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Lamps are carryable light sources for players with a fuel tank.',
    name => 'Lamp'
  },
  'Locked Door' => {
    attr => [
      [
	'move_type',
	{
	  type => 'fixed',
	  value => 0
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'The <key string> in the door must be identical with the <key string> in the special key, then the door is unlocked. It is VERY important to set the <key string> to something that is unique among the Deliantra mapset. DONT EVER USE the default string "set_individual_value". When the key string starts with "match ", then it is expected to be a match expression, which will be applied to the player, so you can use e.g. (match type=POTION in inv). Note that the matched object will be removed.',
	  name => 'key string',
	  type => 'string'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'Restricting the use of spells to pass this door. This should be set in most cases. (Don\'t forget that the spell "dimension door" is easily available at about wisdom level 10).',
	  name => 'restrict spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'Restricting the use of prayers to pass this door. This should be set in most cases.',
	  name => 'restrict prayers',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'When a player is trying to open the door without carrying the appropriate key, this text is displayed to the player. This is a good opportunity to place hints about the special key needed to unlock the door.',
	  end => 'endmsg',
	  name => 'lock message',
	  type => 'text'
	}
      ]
    ],
    desc => 'A locked door can be opened only when carrying the appropriate special key.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Locked Door',
    use => 'If you want to create a locked door that cannot be opened (no key), set a &lt;key string&gt; like "no_key_available". This will clearify things and only a fool would create a key matching that string. Door-objects can not only be used for "doors". In many maps these are used with all kinds of faces/names, especially often as "magic force". A good example is the map "Lake_Country/ebony/masterlev". There you have magic forces (door objects) put under certain artifact items. To get your hands on the artifacts, you need to bring up the appropriate quest items (key objects).'
  },
  'Magic Ear' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'connected',
	{
	  desc => 'The Magic_ear will trigger all objects with the same connection value, every time it is activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'This textfield contains the keyword-matching-syntax. The text should have the following format: "@match <keyword1>|<keyword2>|... ". Any number of keywords from one to infinite is allowed. Make sure they are seperated by a \'|\'. Examples: "@match yes", "@match gold|treasure". The connected value will be triggerd when the player speaks any of the given keywords within a two-square radius. IMPORTANT: Upper/lower case does not make a difference!',
	  end => 'endmsg',
	  name => 'keyword-matching',
	  type => 'text'
	}
      ]
    ],
    desc => 'Magic_ears trigger a connected value when the player speaks a specific keyword.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Magic Ear',
    use => 'Whenever you put magic_ears on your maps, make sure there are CLEAR and RELYABLE hints about the keywords somewhere. Don\'t make something like a gate that is opened by speaking "open" or "sesame", expecting the player to figure this out all by himself. <br><br> Magic_ears are typically used for interaction with NPCs. You can create the impression that the NPC actually *does* something according to his conversation with a player. Mostly this means opening a gate or handing out some item, but you could be quite creative here.'
  },
  'Magic Wall' => {
    attr => [
      [
	'dam',
	{
	  desc => 'The magic wall will cast this <spell>.',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'level',
	{
	  desc => 'The wall will cast it\'s spells at level <spell level>. "level 1" walls cast spells at minimal strength. "level 100" walls cast deadly spells. Arch default is level 1 - you should always set this value to meet the overall difficulty of your map.',
	  name => 'spell level',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'Every time the <connection> value is triggered, the wall will cast it\'s spell. You should set <casting speed> to zero, or this won\'t have much visible effect.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'speed',
	{
	  desc => 'The <casting speed> defines the spellcasting speed of the wall. You can fine-tune how long the duration between two casts shall be. If you want to create a wall that can be activated (cast per trigger) via connected lever/button/etc, you must set "speed 0".',
	  name => 'casting speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ],
      [
	'sp',
	{
	  desc => 'The magic wall will cast it\'s spells always in the specified <direction>. A magic wall with direction set to <none> will always fire in a random direction.',
	  name => 'direction',
	  type => 'list',
	  value => $LIST{direction}
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ]
    ],
    desc => 'Magic walls fire spells in a given direction, in regular intervals. Magic walls can contain any spell. However, some spells do not operate very successfully in them. The only way to know is to test the spell you want to use with a wall. <br><br> Several types of magical walls are predefined for you in the archetypes, and can be found on the "connected" Pickmap.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Magic Wall',
    section => [
      [
	'destroyable',
	[
	  [
	    'alive',
	    {
	      desc => 'Walls with <is destroyable> enabled can be attacked and (eventually) destroyed by the player. If disabled, all other attributes on this tab, as well as resistances, are meaningless.',
	      name => 'is destroyable',
	      type => 'bool'
	    }
	  ],
	  [
	    'hp',
	    {
	      desc => 'The more <hitpoints> the wall has, the longer it takes to be destroyed.',
	      name => 'hitpoints',
	      type => 'int'
	    }
	  ],
	  [
	    'maxhp',
	    {
	      desc => '<max hitpoints> are the maximum amount of hitpoints the wall can have. This only makes sense if the wall can regain health.',
	      name => 'max hitpoints',
	      type => 'int'
	    }
	  ],
	  [
	    'ac',
	    {
	      desc => 'A magic wall of high <armour class> is less likely to get hit from an opponent. <armour class> can be considered the "counterpiece" to <weapon class>.',
	      name => 'armour class',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'Spellcasting walls pose an interesting alternative to monsters. Usually they are set to be undestroyable. Thus, while monsters in a map can be cleared out, the magic walls remain. Low level characters for example will not be able to pass through their spell-area, hence they cannot loot a map that a high level character might have cleared out. <br><br> Another point of magic walls is that if the player dies, he has to face them all again. Magic walls can add a kind of "permanent thrill" to your maps. <br><br> Be careful that your magic walls don\'t kill the monsters on a map. If placing monsters, eventually take ones that are immune to the walls\' spell(s). <br><br> It is possible to make walls rotate when triggered. But that is so confusing (and useless IMHO) that I did not mention it above. You can find a working example on the map "/pup_land/castle_eureca/castle_eureca8".'
  },
  'Map Script' => {
    attr => [
      [
	'connected',
	{
	  desc => 'When the map script object is triggered, it will execute the perl script with the triggering object as $activator.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This perl script will be executed each time the objetc is triggered.',
	  end => 'endmsg',
	  name => 'script',
	  type => 'text'
	}
      ]
    ],
    desc => 'The map script object is a very special object that can react to connected events and executes a perl script in the msg slot.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Map Script',
    use => 'The perl script gets passed a $state value and $activator, $self, $originator objects and can use the set/get/find/timer functions to react to/trigger other objects. See http://pod.tst.eu/http://cvs.schmorp.de/deliantra/server/lib/cf/mapscript.pm for details.'
  },
  Marker => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'The <key string> can be detected by inv. checkers/detectors. If the player already has a force with that <key string>, there won\'t be inserted a second one.',
	  name => 'key string',
	  type => 'string'
	}
      ],
      [
	'connected',
	{
	  desc => 'When the detector is triggered, all objects with the same connection value get activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'speed',
	{
	  desc => 'The <marking speed> defines how quickly it will mark something standing on the marker. Set this value rather high to make sure the player really gets his mark. I think <marking speed> 1.0 should do fine.',
	  name => 'marking speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ],
      [
	'food',
	{
	  desc => 'This value defines the duration of the force it inserts. If nonzero, the duration of the player\'s mark is finite: about 1 food per 10 seconds. <mark duration> zero/unset means the mark will stay on the player forever.',
	  name => 'mark duration',
	  type => 'int'
	}
      ],
      [
	'name',
	{
	  desc => 'When the player steps onto the marker, all existing forces in the players inventory with a <key string> matching <delete mark> will be removed. If you don\'t want to remove any marks, leave this textfield empty. Note that the string <delete mark> is set as the name of this marker. So don\'t be confused, and remember changing the name will take effect on the marker\'s functionality.',
	  name => 'delete mark',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'In the moment when the player gets marked, this text is displayed to him. You should really set a message in any marker you create, because it\'s the only way for the player to notice what\'s going on.',
	  end => 'endmsg',
	  name => 'marking message',
	  type => 'text'
	}
      ]
    ],
    desc => 'A marker is an object that inserts an invisible force (a mark) into a player stepping on it. This force does nothing except containing a &lt;key string&gt; which can be discovered by detectors or inventory checkers. It is also possible to use markers for removing marks again (by setting the "name" slot to the name of the marker to be removed). <br><br> Note that the player has no possibility to "see" his own marks, except by the effect that they cause on the maps.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Marker',
    use => 'Markers hold real cool possibilities for map-making. I encourage you to use them frequently. However there is one negative point about markers: Players don\'t "see" what\'s going on with them. It is your task, as map-creator, to make sure the player is always well informed and never confused. <br><br> Please avoid infinite markers when they aren\'t needed. They\'re using a little space in the player file after all, so if there is no real purpose, set an expire time.'
  },
  Misc => {
    attr => [
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'cursed',
	{
	  desc => 'Curses can have various effects: On equipment and food, they generally harm the player in some way.',
	  name => 'cursed',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'A damned item/floor on the ground makes it impossible for players to use prayers on that spot. It also prevents players from saving. Damnation on equipment works similar to a curse.',
	  name => 'damned',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the object.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    name => 'Misc'
  },
  Money => {
    attr => [
      [
	'race',
	{
	  type => 'fixed',
	  value => 'gold and jewels'
	}
      ]
    ],
    desc => 'Items of the type Money are handled as currency. Money cannot be sold/bought in shops. When money is dropped in a shop, it stays the same.<br> When a player picks an item from a shop and attempts to walk over the shop mat, the item\'s selling-price is automatically subtracted from the player\'s money. <br><br> For money, always use the default arches. Don\'t modify them.',
    ignore => [
      'unpaid'
    ],
    name => 'Money'
  },
  'Monster & NPC' => {
    attr => [
      [
	'alive',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'randomitems',
	{
	  desc => 'When the monster is killed, items from the treasurelist will drop to the ground. This is a common way to reward players for killing (masses of) monsters. Note that you can always put items into the monster\'s inventory. Those will drop-at-kill just like the stuff from the <treasurelist>.',
	  name => 'treasurelist',
	  type => 'treasurelist'
	}
      ],
      [
	'treasure_env',
	{
	  desc => 'Set this flag to move treasure items created into the environment (map) instead of putting them into the object.',
	  name => 'treasure in env',
	  type => 'bool'
	}
      ],
      [
	'level',
	{
	  desc => 'A monster\'s <level> is the most important attribute. <level> affects the power of a monster in various ways.',
	  name => 'level',
	  type => 'int'
	}
      ],
      [
	'race',
	{
	  desc => 'Every monster should have a race set to categorize it. The monster\'s <race> can have different effects: Slaying weapons inflict tripple damage against enemy races and holy word kills only enemy races of the god.',
	  name => 'race',
	  type => 'string'
	}
      ],
      [
	'exp',
	{
	  desc => 'When a player kills this monster, he will get exactly this amount of <experience>. The experience will flow into the skill-category the player used for the kill. If you create special monsters of tweaked strenght/abilities, always make sure that the <experience> is set to a reasonable value. Compare with existing arches to get a feeling what reasonable means. Keep in mind that spellcasting monsters are a lot harder to kill than non-spellcasters!',
	  name => 'experience',
	  type => 'int'
	}
      ],
      [
	'speed',
	{
	  desc => 'The <speed> determines how fast a monster will both move and fight. High <speed> makes a monster considerably stronger.',
	  name => 'speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ],
      [
	'other_arch',
	{
	  desc => 'This only takes effect if <multiply> is enabled. The monster will create a <breed monster> every once in a while. <breed monster> can be set to any valid arch-name of a monster. Multipart monster should not be used.',
	  name => 'breed monster',
	  type => 'string'
	}
      ],
      [
	'generator',
	{
	  desc => 'Monsters with <generator> enabled will create a <breed monster> every once in a while. Mice are a good example for this effect. If enabled, you must also set <breed monster> or check <template generation> and put other monsters in the inventory.',
	  name => 'multiply',
	  type => 'bool'
	}
      ],
      [
	'use_content_on_gen',
	{
	  desc => 'This only takes effect if <multiply> is enabled. The monster will create a new monster every once in a while by duplicating it\'s inventory. In this case, the <breed monster> value is never used and can be forgotten. Each time the monster need to generate an object, it will be a randomly chosen item from the inventory. When generator is destroyed, inventory is destroyed.',
	  name => 'template generation',
	  type => 'bool'
	}
      ],
      [
	'move_type',
	{
	  desc => 'Determines which kinds of movement this object can use (e.g. for monsters) or grants (e.g. for amulets).',
	  name => 'movement type',
	  type => 'movement_type'
	}
      ],
      [
	'undead',
	{
	  desc => 'Several spells only affect undead monsters: turn undead, banish undead, holy word, etc.',
	  name => 'undead',
	  type => 'bool'
	}
      ],
      [
	'carrying',
	{
	  desc => 'If a monster has something in the inventory, this value can be set to reflect the slowdown due to the carried weight.',
	  name => 'carries weight',
	  type => 'int'
	}
      ],
      [
	'precious',
	{
	  desc => 'Set this flag to indicate that this monster is precious, i.e. it should not be lightly destroyed. This is most useful on pets and keeps the server from destroying them on destroy_pets/monster floors and will try to save them when the player logs out.',
	  name => 'precious',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  end => 'endmsg',
	  name => 'npc message',
	  type => 'text'
	}
      ]
    ],
    desc => 'Monsters can behave in various kinds of ways. They can be aggressive, attacking the player. Or peaceful, helping the player - maybe joining him as pet. The unagressive creatures who communicate with players are usually called "NPCs" (Non Player Character), a well-known term in role-play environments.',
    ignore => [
      'material',
      'name_pl',
      'nrof',
      'value',
      'unpaid'
    ],
    name => 'Monster & NPC',
    section => [
      [
	'melee',
	[
	  [
	    'attacktype',
	    {
	      desc => 'This number is a bitmask, specifying the monster\'s attacktypes for melee damage. Attacktypes are: physical, magical, fire, cold.. etc. Strong monsters often have more than just physical attacktype. When a monster with multiple attacktypes hits aan oponent, it will do as much damage as the "best" of it\'s attacktypes does. So, the more attacktypes, the more dangerous. Attacktypes "magic" and "chaos" are somehow exceptions.',
	      name => 'attacktype',
	      type => 'bitmask',
	      value => $BITMASK{attacktype}
	    }
	  ],
	  [
	    'dam',
	    {
	      desc => 'Among other parameters, <damage> affects how much melee damage a monster inflicts. <damage> is used as base value for damage per hit. <level>, <speed>, <weapon class> and resistances also take effect on the melee damage of a monster.',
	      name => 'damage',
	      type => 'int'
	    }
	  ],
	  [
	    'wc',
	    {
	      desc => 'Monsters of high <weapon class> are more likely to really hit their opponent. <weapon class> can be considered the "counterpiece" to <armour class>.',
	      name => 'weapon class',
	      type => 'int'
	    }
	  ],
	  [
	    'hp',
	    {
	      desc => 'The <health points> of a monster define how long it takes to kill it. With every successful hit from an opponent, <health points> get drained - The monster dies by zero <health points>.',
	      name => 'health points',
	      type => 'int'
	    }
	  ],
	  [
	    'maxhp',
	    {
	      desc => '<max health> is the maximum amount of <health points> this monster can have.',
	      name => 'max health',
	      type => 'int'
	    }
	  ],
	  [
	    'ac',
	    {
	      desc => 'Monsters of low <armour class> are less likely to get hit from their opponent. <armour class> can be considered the "counterpiece" to <weapon class>. Values typically range between +20 (very bad) to -20 (quite good).',
	      name => 'armour class',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'Monsters regenerate this many health points each 4 ticks. Hence, the healing rate is independent of <speed>.',
	      name => 'healing rate',
	      type => 'int'
	    }
	  ],
	  [
	    'reflect_missile',
	    {
	      desc => 'A monster with this flag has the ability to <reflect missiles>, all kinds of projectiles (e.g. arrows, bolts, boulders) will bounce off.',
	      name => 'reflect missiles',
	      type => 'bool'
	    }
	  ],
	  [
	    'hitback',
	    {
	      desc => 'Monsters with <hitback> enabled hurt the attacker in proportion to the amount of damage the *attacker* inflicted. This damage is additional to the regular melee damage of the monster. As far as I know, hitback uses acid attacktype, and it only takes effect if the monster actually has acid attacktype at it\'s disposal. Acid spheres for example use this feature.',
	      name => 'hitback',
	      type => 'bool'
	    }
	  ],
	  [
	    'one_hit',
	    {
	      desc => 'Monsters with <one hit only> dissapear after one successful hit to a player.',
	      name => 'one hit only',
	      type => 'bool'
	    }
	  ]
	]
      ],
      [
	'spellcraft',
	[
	  [
	    'can_cast_spell',
	    {
	      desc => 'If <can cast spell> is disabled, the monster cannot cast any spell. Only wands/rods/etc can be used, given the appropriate abilities.',
	      name => 'can cast spell',
	      type => 'bool'
	    }
	  ],
	  [
	    'reflect_spell',
	    {
	      desc => 'A monster with this flag has the ability to <reflect spells>, all kinds of spell-bullets and -beams will bounce off. Generally this flag should not be set because it puts wizard-type players at an unfair disadvantage.',
	      name => 'reflect spells',
	      type => 'bool'
	    }
	  ],
	  [
	    'sp',
	    {
	      desc => 'Like players, monsters need <spellpoints> to do magic. Monsters use them for both wizard- and prayer-spells. However, this value defines only the amount of *initial* spellpoints the monster starts with. When creating a spellcasting monster, remember that <max spellpoints> and <spellpoint regen.> are more important than just initial <spellpoints>.',
	      name => 'spellpoints',
	      type => 'int'
	    }
	  ],
	  [
	    'maxsp',
	    {
	      desc => '<max spellpoints> is the maximum number of spellpoints a monster can hold. Setting this to high values has little effect unless the monster has a decent <spellpoint regen.>, or the spell "regenerate mana" at it\'s disposal.',
	      name => 'max spellpoints',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'Monsters regenerate this many spellpoints each 16 ticks. Hence, the spellpoint regeneration rate is independent of <speed>. To make a real tough spellcasting monster, the rate of spellpoint regeneration is most important. If your monster is still not casting fast enough, give it the spell-ability of "regenerate mana". That, paired with high <max spellpoints>, is the ultimate thing.',
	      name => 'spellpoint regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'path_attuned',
	    {
	      desc => 'Click on the <attuned paths> button to select spellpaths. The creature will get attuned to the specified spellpaths.',
	      name => 'attuned paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ],
	  [
	    'path_repelled',
	    {
	      desc => 'Click on the <repelled paths> button to select spellpaths. The creature will get repelled to the specified spellpaths.',
	      name => 'repelled paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ],
	  [
	    'path_denied',
	    {
	      desc => 'Click on the <denied paths> button to select spellpaths. The creature won\'t be able to cast spells of the specified paths.',
	      name => 'denied paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ]
	]
      ],
      [
	'ability',
	[
	  [
	    'Int',
	    {
	      desc => 'The <detect hidden> value gives monsters the ablitity to find hidden/invisible creatures. Higher values make for better detection-skills. Enabling <see invisible> makes this value obsolete.',
	      name => 'detect hidden',
	      type => 'int'
	    }
	  ],
	  [
	    'see_invisible',
	    {
	      desc => 'A monster with the ability to <see invisible> cannot be fooled with by invisible or hiding players. This flag is a must-have for high-level monsters. When a monster is unable to detect invisible players, it can be killed without fighting back.',
	      name => 'see invisible',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_see_in_dark',
	    {
	      desc => 'A monster with the ability to <see in darkness> cannot be fooled by spells of darkness or dark maps. This flag is a "should-have" for high-level monsters. When a monster is unable to see in darkness, players can cast darkness and sneak around it safely.',
	      name => 'see in darkness',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_weapon',
	    {
	      desc => 'Monster is able to wield weapon type objects.',
	      name => 'can use weapons',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_bow',
	    {
	      desc => 'Monster is able to use missile-weapon type objects.',
	      name => 'can use bows',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_armour',
	    {
	      desc => 'Monster is able to wear protective equipment like brestplate armour, shields, helmets etc.',
	      name => 'can use armour',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_ring',
	    {
	      desc => 'Monster is able to wear rings.',
	      name => 'can use rings',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_wand',
	    {
	      desc => 'Monster is able to use wands and staves.',
	      name => 'can use wands',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_rod',
	    {
	      desc => 'Monster is able to use rods.',
	      name => 'can use rods',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_scroll',
	    {
	      desc => 'Monster is able to read scrolls.',
	      name => 'can use scrolls',
	      type => 'bool'
	    }
	  ],
	  [
	    'can_use_skill',
	    {
	      desc => 'Monster is able to use skills from it\'s inventory. For example, you can put a throwing skill object and some boulders into the monster\'s object and set <can use skills>.',
	      name => 'can use skills',
	      type => 'bool'
	    }
	  ]
	]
      ],
      [
	'behave',
	[
	  [
	    'monster',
	    {
	      desc => 'When <monster behaviour> is enabled, this object will behave like a monster: It can move and attack enemies (which are typically players). This flag should be set for all monsters as-such. Monsters which don\'t move, like guards, should also have <monster behaviour>, but in combination with <stand still>. It should *not* be set for things like immobile generators.',
	      name => 'monster behaviour',
	      type => 'bool'
	    }
	  ],
	  [
	    'unaggressive',
	    {
	      desc => '<unaggressive> monsters do not attack players unless attacked first.',
	      name => 'unaggressive',
	      type => 'bool'
	    }
	  ],
	  [
	    'friendly',
	    {
	      desc => '<friendly> monsters help the player, attacking any non-friendly monsters in range.',
	      name => 'friendly',
	      type => 'bool'
	    }
	  ],
	  [
	    'stand_still',
	    {
	      desc => 'Monsters which <stand still> won\'t move to leave their position. When agressive, they will attack all enemies who get close to them. This behaviour is commonly known from castle guards. In older versions of Deliantra it was possible to eventually push a <stand still>-monster out of position by force. I believe this is no longer possible. Neverthless, you should still be cautious when lining up <stand still>-monster in order to "defend" something: Such monsters are rather easy to kill. It\'s good for low level maps, but not much more.',
	      name => 'stand still',
	      type => 'bool'
	    }
	  ],
	  [
	    'sleep',
	    {
	      desc => 'Being <asleep>, a monster won\'t move unless a player enters the <sensing range> of the monster. Usually the sensing range is larger than the players line of sight. Due to that, in most cases the player won\'t ever notice weither a monster was asleep or not.',
	      name => 'asleep',
	      type => 'bool'
	    }
	  ],
	  [
	    'will_apply',
	    {
	      desc => 'This entry defines which kinds of environment actions the creature is able to perform.',
	      name => 'misc. actions',
	      type => 'bitmask',
	      value => $BITMASK{will_apply}
	    }
	  ],
	  [
	    'pick_up',
	    {
	      desc => 'Click on the <pick up> button and select which types of objects the creature should try to pick up. Note also that if <can use armor>, <can use weapon>, <can use ring>... etc are set, then the creature will pick up the matching items even if this is not set here.',
	      name => 'pick up',
	      type => 'bitmask',
	      value => $BITMASK{pick_up}
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => '<sensing range> determines how close a player needs to be before the creature wakes up. This is done as a square, for reasons of speed. Thus, if the <sensing range> is 11, any player that moves within the 11x11 square of the monster will wake the monster up. If the player has stealth, the size of this square is reduced in half plus 1.',
	      name => 'sensing range',
	      type => 'int'
	    }
	  ],
	  [
	    'attack_movement_bits_0_3',
	    {
	      desc => 'If this is set to default, the standard mode of movement will be used.',
	      name => 'attack movement',
	      type => 'list',
	      value => $LIST{attack_movement_bits_0_3}
	    }
	  ],
	  [
	    'attack_movement_bits_4_7',
	    {
	      desc => 'This movement is not in effect when the monster has an enemy and should only be used for non agressive monsters.',
	      name => 'normal movement',
	      type => 'list',
	      value => $LIST{attack_movement_bits_4_7}
	    }
	  ],
	  [
	    'run_away',
	    {
	      desc => 'This is a percentage value in the range 0-100. When the monster\'s health points drop below this percentage (relative to max health), it attempts to run away from the attacker.',
	      name => 'run at % health',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'Monsters play a central role in most maps. Choosing the right combination of monsters for your map is vital: <UL> <LI> Place only monsters of slightly varying (increasing) strength. It\'s no fun to play for two hours just to find out the last monster is unbeatable. Similar, it\'s not exciting to fight orcs after passing a room of dragons.<br> This rule applies only for linear maps (one room after the other), with treasure at the end. You can sprinkle the treasure around, or make non-linear maps - That is often more entertaining. <LI> Places with high level monsters must not be easy to reach. Balrogs, Dragonmen and the likes should be at the end of a quest, not at the beginning. <LI> Don\'t stick monsters together that tend to kill each other. Fire- and cold dragons in one room for example is a bad idea. By weakening and killing each other they are easy prey for players, not worth the experience they hold. <LI> Create your own monsters, especially for "boss"-type monsters. Having stage-bosses guarding treasure is a lot of fun when done right. Avoid to create monsters with completely non-intuitive abilities: Don\'t give ice-spells to firedragons or vice versa. Don\'t add draining attack to trolls, etc. Additionally, you should inform the player before he bumps right into some very special/unusual monster. <LI> Last but not least: Always keep an eye on the experience your monsters hold. Design your maps in a way that high experience is always well-defended. Don\'t make large rooms full with only one kind of monster. Keep in mind the different abilities/techniques players can use. </UL> I know it\'s impossible to make the perfectly balanced map. There\'s always some part which is found too easy or too hard for a certain kind of player. Just give it your best shot. And listen to feedback from players if you receive some. :-)'
  },
  'Monster (Grimreaper)' => {
    desc => 'A grimreaper is a monster that vanishes after it did some number of draining attacks.',
    ignore => [
      'material',
      'name_pl',
      'nrof',
      'value',
      'unpaid'
    ],
    import => [
      'Monster & NPC'
    ],
    name => 'Monster (Grimreaper)',
    section => [
      [
	'grimreaper',
	[
	  [
	    'value',
	    {
	      desc => 'The object vanishes after this number of draining attacks.',
	      name => 'attacks',
	      type => 'int'
	    }
	  ]
	]
      ]
    ]
  },
  'Mood Floor' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'last_sp',
	{
	  desc => '<mood> is used to determine what will happen to the monster when affected by the mood floor: <mood> \'furious\': Makes all monsters aggressive <mood> \'angry\': As above but pets are unaffected <mood> \'calm\': Makes all monsters unaggressive <mood> \'sleep\': Puts all monsters to sleep <mood> \'charm\': Turns monster into a pet of person who triggers the square. This setting is not enabled for continous operation, you need to insert a <connection> value!',
	  name => 'mood',
	  type => 'list',
	  value => $LIST{mood}
	}
      ],
      [
	'connected',
	{
	  desc => 'This should only be set in combination with <mood number> 4. Normally, monsters are affected by the mood floor as soon as they step on it. But charming (monster -> pet) is too powerful, so it needs to be activated. Typically it is connected to an altar, for buying a "hireling". But a powerful pet could as well be the reward for solving a quest. Or even better: It could be *part* of a quest!',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'If enabled, it is impossible for players to use (wizard-) spells on that spot.',
	  name => 'no spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'If enabled, it is impossible for players to use prayers on that spot. It also prevents players from saving.',
	  name => 'no prayers',
	  type => 'bool'
	}
      ]
    ],
    desc => 'As the name implies, mood floors can change the "mood" of a monsters/NPC. For example, an unagressive monster could be turned mad to start attacking. Similar, an agressive monster could be calmed.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Mood Floor',
    use => 'Mood floors are absolutely cool for NPC interaction. To make an unaggressive monster/NPC attack, put a creator with "other_arch furious_floor" under it. Connect the creator to a magic_ear, so the player speaks a keyword like "stupid sucker" - and the monster attacks. <br><br> To turn an NPC into a pet, put a charm_floor under it and connect it directly to a magic_ear. Then the player speaks a keyword like "help me" - and the NPC joins him as pet. <br><br> (Of course you must always give clear hints about keywords! And there is no reason why you couldn\'t use a button/lever/pedestal etc. instead of a magic_ear.)'
  },
  Mover => {
    attr => [
      [
	'attacktype',
	{
	  desc => 'If forced movement is enabled, the mover "freezes" anyone it moves (so they are forced to move along a chain). For players there is no way to escape this forced movement, except being pushed by a second player.',
	  name => 'forced movement',
	  type => 'bool'
	}
      ],
      [
	'maxsp',
	{
	  desc => 'The player will be "frozen" for that many moves. If <freeze duration> is zero, with <forced movement> enabled, then <freeze duration> gets assigned the "default value" 2 automatically.',
	  name => 'freeze duration',
	  type => 'int'
	}
      ],
      [
	'speed',
	{
	  desc => 'The movement speed value determines how fast a chain of these movers will push a player along (default is -0.2).',
	  name => 'movement speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ],
      [
	'sp',
	{
	  desc => 'The mover will push creatures in the specified <direction>. A mover with direction set to <none> will spin clockwise, thus pushing creatures in unpredictable directions.',
	  name => 'direction',
	  type => 'list',
	  value => $LIST{direction}
	}
      ],
      [
	'lifesave',
	{
	  desc => 'If enabled, the mover gets "used up" after a certain number of moves (specified by <number of uses>). If disabled, the mover works infinitely.',
	  name => 'gets used up',
	  type => 'bool'
	}
      ],
      [
	'hp',
	{
	  desc => 'This value has only a meaning if <gets used up> is set: <number of uses> is the number of times minus one, that it will move a creature before disappearing. (It will move someone <number of uses>+1 times, then vanish).',
	  name => 'number of uses',
	  type => 'int'
	}
      ]
    ],
    desc => 'Movers move the objects above them. However, only living objects are affected (monsters/NPCs always, players optional). Movers have a direction, so players can be made to move in a pattern, and so can monsters. Motion is involuntary. Additionally, players or monsters can be "frozen" while ontop of movers so that they MUST move along a chain of them. <br><br> Multisquare monsters can be moved as well, given enough space. Movers are usually invisible.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Mover',
    section => [
      [
	'targets',
	[
	  [
	    'level',
	    {
	      desc => 'If <move players> is enabled, both players and monsters will be moved. In the arches\' default it is disabled - thus ONLY monsters get moved. Remember that "monsters" includes NPCs! This feature provides you with the possibility to make NPCs literally "come to life". Example: The player is talking with an NPC, speaking a certain keyword. This triggers a magic_ear and activates creators, creating (per default: monster-only) movers under the NPC\'s feet. The NPC starts "walking" on a predefined route! Note that it\'s useful to set this NPC immune to everything, preventing the player to push the NPC off his trace.',
	      name => 'move players',
	      type => 'bool'
	    }
	  ],
	  [
	    'move_on',
	    {
	      desc => 'Which movement types activate the mover.',
	      name => 'movement type',
	      type => 'movement_type'
	    }
	  ]
	]
      ]
    ],
    use => 'NEVER EVER consider a mover being unpassable in the backwards direction. Setting "forced movement" makes it seemingly impossible but there is still a trick: One player can push a second player past the mover, in opposite to the mover\'s direction! The more movers, the more players needed. Hence, don\'t make a treasure room that is surrounded by movers instead of solid walls/gates. <br><br> Btw, it does not make a difference putting movers above or below the floor. Moreover, movers that are set to be invisible cannot be discovered with the show_invisible spell. <br><br> Note that Movers and Directors are seperate objects, even though they look and act similar. Directors only do spells/missiles, while movers only do living creatures (depending on how it is set: monsters and players).'
  },
  Pedestal => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'the <match race> defines the object we\'re looking for. If <match race> matches the monster\'s or the player\'s race, we have a match. Yes, pedestals can detect a player\'s race! E.g. you could create a place where only fireborns can enter, by setting "slaying unnatural". If it is set to "player", any player stepping on the pedestal is a match. Very useful if you want to open a gate for players but not for monsters. If the string starts with \'match \', then it is interpreted as a match expression (e.g. \'match type=POTION\', or \'match type=SPELL in applied type=CONTAINER in inv in originator\'). For details, see http://pod.tst.eu/http://cvs.schmorp.de/deliantra/server/lib/cf/match.pm',
	  name => 'match race',
	  type => 'string'
	}
      ],
      [
	'connected',
	{
	  desc => 'When the pedestal is triggered, all objects with the same connection value get activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ]
    ],
    desc => 'Pedestals are designed to detect certain types of living objects. When a predefined type of living creature steps on the pedestal, the connected value is triggered.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Pedestal',
    use => 'If you want to create a place where only players of a certain race can enter, put a teleporter over your pedestal. So the teleporter is only activated for players of the matching race. Do not use gates, because many other players could sneak in. If you put powerful artifacts into such places, generally set "startequip 1", so that they are preserved for that one race and can\'t be traded to others.'
  },
  'Pedestal Trigger' => {
    desc => 'Pedestal triggers are pedestals which reset after a short period of time. Every time it is either applied or reset, the &lt;connection&gt; value is triggered.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    import => [
      'Pedestal'
    ],
    name => 'Pedestal Trigger'
  },
  Pit => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'range',
	{
	  desc => 'The radius of the square area that the pit will randomly put the player into (0 to 3, default 1).',
	  name => 'spread radius',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'When a <connection> value is set, the pit can be opened/closed by activating the connection.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'hp',
	{
	  desc => 'The pit will transport creatures (and items) randomly into a two-square radius of the destination coordinates. If the destination square becomes blocked, the pit will act like being filled up and not work anymore!',
	  name => 'destination X',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'The pit will transport creatures (and items) randomly into a two-square radius of the destination coordinates. If the destination square becomes blocked, the pit will act like being filled up and not work anymore!',
	  name => 'destination Y',
	  type => 'int'
	}
      ],
      [
	'wc',
	{
	  desc => 'The <position state> defines the position of the gate: Zero means completely open/down, the "number of animation-steps" (usually about 6 or 7) means completely closed/up state. I suggest you don\'t mess with this value - Leave the default in place.',
	  name => 'position state',
	  type => 'int'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ]
    ],
    desc => 'Pits are holes, transporting the player when he walks (and falls) into them. A speciality about pits is that they don\'t transport the player to the exact destination, but within a configurable radius of the destination (never on blocked squares).<br> Optionally, pits can get closed and opened, similar to gates.<br><br> Monsters and items are affected by pits just as well as players. Even multipart monsters can fall through them, given enough space.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Pit',
    use => 'Pits can add interesting effects to your map. When using them, make sure to use them in a "logical way": Pits should always drop the player to some kind of lower level. They should not be used to randomly interconnect maps like teleporters do.'
  },
  'Poison Food' => {
    desc => 'When eating, the player\'s stomache is drained by 1/4 of food. If his food drops to zero, the player might even die.',
    name => 'Poison Food'
  },
  Potion => {
    attr => [
      [
	'level',
	{
	  desc => 'If the potion contains a spell, the spell is cast at this level. For other potions it should be set at least to 1.',
	  name => 'potion level',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'When a player drinks this potion, the selected spell will be casted (once). This should work for any given spell. E.g. heal is "sp 35", magic power is "sp 67".',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'attacktype',
	{
	  desc => 'There are two types of special effects for potions: \'life restoration\' - restore the player\'s stats lost by death or draining (this has nothing in common with the restoration spell!) \'improvement\' - increase the player\'s maximum health/mana/grace by a very small amount.',
	  name => 'special effect',
	  type => 'list',
	  value => $LIST{potion_effect}
	}
      ],
      [
	'cursed',
	{
	  desc => 'If a potion is cursed, benefits generally turn into penalties. Note that potions can be "uncursed" by praying over an altar, with relative ease. *But* the potion must be identified to notice that it is cursed >:)',
	  name => 'cursed',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ]
    ],
    desc => 'The player can drink these and gain various kinds of benefits (/penalties) by doing so.',
    name => 'Potion',
    section => [
      [
	'stats',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'One potion should never give multiple benefits at once.'
  },
  'Power Crystal' => {
    attr => [
      [
	'sp',
	{
	  desc => '<initial mana> is the amount of spellpoints that the crystal holds when the map is loaded.',
	  name => 'initial mana',
	  type => 'int'
	}
      ],
      [
	'maxsp',
	{
	  desc => 'The <mana capacity> defines how much mana can be stored in the crystal. This is what makes the crystal interesting. Wizard-players will always seek for crystals with large capacities.',
	  name => 'mana capacity',
	  type => 'int'
	}
      ]
    ],
    desc => 'Power crystals can store a player\'s mana: When the player applies the crystal with full mana, half of it flows into the crystal. When the player applies it with lacking mana, the crystal replenishes the player\'s mana.',
    name => 'Power Crystal'
  },
  Projectile => {
    attr => [
      [
	'attacktype',
	{
	  desc => 'This number is a bitmask, specifying the projectile\'s attacktypes. Attacktypes are: physical, magical, fire, cold.. etc. This works identical to melee weapons. Note that shooting weapons cannot have attacktypes.',
	  name => 'attacktype',
	  type => 'bitmask',
	  value => $BITMASK{attacktype}
	}
      ],
      [
	'race',
	{
	  desc => 'Only shooting weapons with matching <ammunition class> can fire these projectiles. For arrows set "arrows", for crossbow bolts set "crossbow bolts" (big surprise). In certain cases, the ammunition class is displayed in the game. Hence, when you create a new ammunition class, choose an intuitive name like "missiles", "spirit bolts" - whatever. You can also make special containers holding these projectiles by setting the <container class> to match your <ammunition class>.',
	  name => 'ammunition class',
	  type => 'string'
	}
      ],
      [
	'slaying',
	{
	  desc => 'Slaying means the weapon does tripple (3x) damage to monsters of the specified race. If <slaying race> matches an arch name, only monsters of that archtype receive tripple damage. Tripple damage is very effective.',
	  name => 'slaying race',
	  type => 'string'
	}
      ],
      [
	'dam',
	{
	  desc => 'The projectile <damage> significantly affects the damage done. Damage can be further increased by the shooting weapon\'s attributes.',
	  name => 'damage',
	  type => 'int'
	}
      ],
      [
	'wc',
	{
	  desc => 'This value is supposed to be the base <weaponclass>, but it seems to have rather little effect. High values are good here, low values bad.',
	  name => 'weaponclass',
	  type => 'int'
	}
      ],
      [
	'food',
	{
	  desc => 'The <chance to break> defines the breaking probability when this projectile hits an obstacle, e.g. wall or monster. The value is the %-chance to break, ranging from 0 (never breaking) to 100 (breaking at first shot).',
	  name => 'chance to break',
	  type => 'int'
	}
      ],
      [
	'magic',
	{
	  desc => 'Magic bonus increases chance to hit and damage a little bit.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'no_drop',
	{
	  desc => 'When a monster carries a projectile with <don\'t drop>, this item will never drop to the ground but vanish instead. If this object is shot, it can still drop after hitting an obstacle. You can prevent this by setting <chance to break> 100.',
	  name => 'don\'t drop',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may describe the projectile. This could be nice for very special ones.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Projectiles like arrows/crossbow bolts are used as ammunition for shooting weapons. <br><br> It\'s very easy to add new pairs of weapons &amp; projectiles. Just set matching &lt;ammunition class&gt; both for shooting weapon and projectile.',
    name => 'Projectile',
    use => 'If you want to create new kinds of projectiles, you could add an alchemical receipe to create these. Don\'t create new pairs of weapons &amp; projectiles unless they really fullfill a useful purpose. In fact, even bows and crossbows are rarely ever used.'
  },
  Ring => {
    desc => 'Rings are worn on the hands - one ring each. Wearing rings, the object\'s stats will directly be inherited to the player. Usually enhancing his spellcasting potential.',
    import => [
      'Amulet'
    ],
    name => 'Ring',
    use => 'When you create an artifact ring, never forget that players can wear <B>two</B> rings! Due to that it is extremely important to keep rings in balance with the game. <br><br> Also keep in mind that rings are generally the wizard\'s tools. They should primarily grant bonuses to spellcasting abilities and non-physical resistances.'
  },
  Rod => {
    attr => [
      [
	'sp',
	{
	  desc => 'Sets the <spell> of the rod. Consider twice before handing out special rods to players, since they can be used endlessly without any mana cost! Rods with heal/ restoration/ protection spells, IF available, MUST be very very VERY hard to get!',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'level',
	{
	  desc => 'The casting level of the <spell> determines it\'s power. For attack spells, level should be set to something reasonable.',
	  name => 'casting level',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'This value represents the initial amount of spellpoints in the rod. Naturally, this is quite unimportant.',
	  name => 'initial spellpoints',
	  type => 'int'
	}
      ],
      [
	'maxhp',
	{
	  desc => 'When the rod is fully charged up, it will hold this maximum amount of spellpoints. Make sure it is enough to cast the contained spell at least once. But don\'t set the value too high, as that might make the rod too effective.',
	  name => 'max. spellpoints',
	  type => 'int'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a description of the rod.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'A rod contains a spell. The player can use this spell by applying and fireing the rod. Rods need time to regenerate their "internal" spellpoints, lowering the effectiveness in combat. But unlike wands/scrolls, rods can be used endlessly.',
    ignore => [
      'title'
    ],
    name => 'Rod',
    use => 'Rods with healing/curing spells are extremely powerful. Usually, potions have to be used for that purpose. Though, potions are expensive and only good for one-time-use.<br>'
  },
  Rune => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'level',
	{
	  desc => 'This value sets the level the rune will cast the spell it contains at, if applicable. A level 99 rune casts a very, very mean spell of whatever. (<rune level> 0 runes won\'t detonate at all!) Level Also effects how easily a rune may be found and disarmed, and how much experience the player gets for doing so. Beware: High level runes can be quite a cheap source of experience! So either make them tough, or keep the level low.',
	  name => 'rune level',
	  type => 'int'
	}
      ],
      [
	'Cha',
	{
	  desc => 'This value determines what fraction of the time the rune is visible: It\'ll be randomly visible 1/<visibility> of the time. Also effects how easily the rune may be found.',
	  name => 'visibility',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'The rune will detonate <number of charges> times before disappearing.',
	  name => 'number of charges',
	  type => 'int'
	}
      ],
      [
	'dam',
	{
	  desc => '<direct damage> specifies how much damage is done by the rune, if it doesn\'t contain a spell. This should be set in reasonable relation to the rune\'s level.',
	  name => 'direct damage',
	  type => 'int'
	}
      ],
      [
	'attacktype',
	{
	  desc => 'If there isn\'t any spell (and <summon monster> is unset), this attribute defines what attacktype to use for direct damage when the rune detonates.',
	  name => 'attacktype',
	  type => 'bitmask',
	  value => $BITMASK{attacktype}
	}
      ],
      [
	'msg',
	{
	  desc => 'When the rune detonates, this text is displayed to the victim. For especially powerful runes, create an appropriate thrilling description. ;)',
	  end => 'endmsg',
	  name => 'detonation text',
	  type => 'text'
	}
      ]
    ],
    desc => 'A rune is a magical enscription on the dungeon floor. <br><br> Runes hit any monster or person who steps on them for \'dam\' damage in \'attacktype\' attacktype. Alternatively, the rune could contain any spell, and will cast this spell when it detonates. Yet another kind is the "summoning rune", summoning predefined monsters of any kind, at detonation. <br><br> Many runes are already defined in the archetypes.',
    ignore => [
      'no_pick',
      'title',
      'name_pl',
      'weight',
      'value',
      'material',
      'unpaid'
    ],
    name => 'Rune',
    section => [
      [
	'spellcraft',
	[
	  [
	    'sp',
	    {
	      desc => 'The selected <spell> defines the spell in the rune, if any. (Many runes do direct damage).',
	      name => 'spell',
	      type => 'spell'
	    }
	  ],
	  [
	    'slaying',
	    {
	      desc => 'Name of the spell in the rune, if any. <spell name> is optional, but if present, overrides the <spell> setting.',
	      name => 'spell name',
	      type => 'string'
	    }
	  ],
	  [
	    'other_arch',
	    {
	      desc => 'This string defines the spell in the rune, if any. <spell arch> is optional, but if present, overrides the <spell> setting. You can choose any of the existing arches.',
	      name => 'spell arch',
	      type => 'string'
	    }
	  ],
	  [
	    'maxsp',
	    {
	      desc => 'If set, the rune will cast it\'s containing spell (if any) in this <direction>.In most cases this appears useless because the spell directly hits the player.',
	      name => 'direction',
	      type => 'list',
	      value => $LIST{direction}
	    }
	  ],
	  [
	    'race',
	    {
	      desc => 'If this is set to the arch name of any monster, together with <spell name> "summon evil monster", the rune will summon a bunch of those on detonation. (dam and attacktype will still be ignored in this case). Runes are even capable of summoning multi-square monsters, given enough space. You\'d better test it though.',
	      name => 'summon monster',
	      type => 'string'
	    }
	  ],
	  [
	    'maxhp',
	    {
	      desc => 'This should only be set to a summoning rune. It will then summon that many creatures of the kind <summon monster>.',
	      name => 'summon amount',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'Avoid monsters stepping on your runes. For example, summoning runes together with spellcasting- and attack-runes is usually a bad idea.'
  },
  'Safe ground' => {
    attr => [
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ]
    ],
    desc => 'Safe ground is a special object that prevents any effects that might be harmful for the map, other players or items on the map. It blocks all magic and prayers, usage of alchemy, prevents potions from being used and blocks bombs from exploding. Note that altars that do cast spells still work.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Safe ground',
    use => 'Safe ground can be used to prevents any means of burning or destroying the items in a shop. Put this object below all floor tiles in your map and your shop will be safe. It\'s generally useful for making areas where really no kind of spell should be invoked by a player.'
  },
  Savebed => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_magic',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'damned',
	{
	  type => 'fixed',
	  value => 1
	}
      ]
    ],
    desc => 'When the player applies a savebed, he is not only saved. Both his respawn-after-death and his word-of-recall positions are pointing to the last-applied savebed.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Savebed',
    use => 'Put savebed locations in towns, do not put them into dungeons. It is absolutely neccessary that a place with savebeds is 100% secure. That means: <UL> <LI> Monsters must not be able to reach the savebeds under any circumstances! <LI> If there are NPCs around, make sure they have the friendly-flag set. <LI> Insert a reliable exit! Make sure there is no possibility that players get trapped in a savebed location. <LI> If possible, mark the whole site as no-spell area (Insert this arch called "dungeon_magic" everywhere). This is not required, but it makes the place much more safe. </UL>'
  },
  Scroll => {
    attr => [
      [
	'level',
	{
	  desc => 'The spell of the scroll will be casted at this level. This value should always be set, at least to 1.',
	  name => 'casting level',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'When a player/monster applies this scroll, the selected <spell> will be casted (once). This should work for any given spell.',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Scrolls contain spells (similar to spell-potions). Unlike potions, scrolls require a certain literacy skill to read successfully. Accordingly, for a successful reading, a small amount of experience is gained. Scrolls allow only one time usage, but usually they are sold in bulks.',
    ignore => [
      'title'
    ],
    name => 'Scroll',
    use => 'For low level quests, scrolls of healing/curing-spells can be a nice reward. At higher levels, scrolls become less and less useful.'
  },
  Shield => {
    attr => [
      [
	'magic',
	{
	  desc => '<magic bonus> works just like ac, except that it can be improved by "scrolls of Enchant Armour" or reduced by acid. It is less useful than direct armour-class bonus on the shield.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ]
    ],
    desc => 'Wearing a shield, the object\'s stats will directly be inherited to the player. Shields usually provide good defense, only surpassed by brestplate armour. Resistances on shields aren\'t uncommon either.',
    import => [
      'Amulet'
    ],
    name => 'Shield',
    use => 'Feel free to create your own special artifacts. However, it is very important that you keep your artifact in balance with existing maps.'
  },
  'Shooting Weapon' => {
    attr => [
      [
	'race',
	{
	  desc => 'Only projectiles with matching <ammunition class> can be fired with this weapon. For normal bows set "arrows", for normal crossbows set "crossbow bolts". In certain cases, the ammunition class is displayed in the game. Hence, when you create a new ammunition class, choose an intuitive name like "missiles", "spirit bolts" - whatever.',
	  name => 'ammunition class',
	  type => 'string'
	}
      ],
      [
	'sp',
	{
	  desc => 'After shooting a projectile, the player is frozen for a short period of time (to prevent shooting arrows machine-gun-like). The greater <shooting speed>, the shorter this period of time. 1 is minimum (=worst) and 100 is maximum (=best) value. You shouldn\'t set <shooting speed> lower than 10. YOU MUST NOT SET IT TO ZERO! (That would freeze the player for eternety).',
	  name => 'shooting speed',
	  type => 'int'
	}
      ],
      [
	'dam',
	{
	  desc => 'The <base damage> significantly affects the damage done by using this weapon. This damage is added to the projectile damage and then (if <ignore strength> disabled) a bonus according to the player\'s strength is added.',
	  name => 'base damage',
	  type => 'int'
	}
      ],
      [
	'wc',
	{
	  desc => 'This value is supposed to be the base <weaponclass>, but it seems to have rather little effect. High values are good here, low values bad.',
	  name => 'weaponclass',
	  type => 'int'
	}
      ],
      [
	'item_power',
	{
	  desc => 'The <item power> value measures how "powerful" an artifact is. Players will only be able to wear equipment with a certain total amount of <item power>, depending on their own level. This is the only way to prevent low level players to wear "undeserved" equipment (like gifts from other players or cheated items). It is very important to adjust the <item power> value carefully for every artifact you create! If zero/unset, the Deliantra server will calculate a provisional value at runtime, but this is never going to be an accurate measurement of <item power>.',
	  name => 'item power',
	  type => 'int'
	}
      ],
      [
	'no_strength',
	{
	  desc => 'Usually the player\'s strentgh takes effect on the damage done by the shooting weapon. If <ignore strength> is set, the player\'s strength is ignored.',
	  name => 'ignore strength',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'A damned shooting weapon cannot be unwielded unless the curse is removed. Removing damnations is a tick harder than removing curses.',
	  name => 'damnation',
	  type => 'bool'
	}
      ],
      [
	'cursed',
	{
	  desc => 'A cursed shooting weapon cannot be unwielded unless the curse is removed.',
	  name => 'curse',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text describes the weapons\'s "story". Every decent artifact weapon should have such a description.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Shooting weapons like bows/crossbows are used to shoot projectiles (arrows/bolts). Shooting weapons and normal (melee) weapons can be wielded both at the same time. Like with any other equipment, stats/bonuses from shooting weapons are directly inherited to the player. <br><br> It\'s very easy to add new pairs of weapons &amp; projectiles. Just set matching &lt;ammunition class&gt; both for shooting weapon and projectile.',
    name => 'Shooting Weapon',
    section => [
      [
	'stats',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s dexterity will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s constitution will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s intelligence will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s power will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s wisdom will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s charisma will rise/fall by the given value while wearing this shooting weapon.',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'bonus',
	[
	  [
	    'luck',
	    {
	      desc => 'With positive luck bonus, the player is more likely to succeed in all sorts of things (spellcasting, praying,...). Unless the <luck bonus> is very high, the effect will be barely visible in-game. Luck bonus on one piece of equipment should never exceed 3, and such bonus should not be too frequently available.',
	      name => 'luck bonus',
	      type => 'int'
	    }
	  ],
	  [
	    'magic',
	    {
	      desc => '<Magic bonus> improves the quality of the shooting weapon. I\'m not sure what exactly is increased - maybe weaponclass? However, <magic bonus> seems to have a little bit of positive influence on your chance to hit.',
	      name => 'magic bonus',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'Shooting weapons should not add bonuses in general. There\'s already enough "equipment-slots" doing that: swords, rings, amulets, girdles etc. Shooting weapons should especially not add bonuses to the player that have nothing to do with schooting. A Wisdom bonus on a bow is crap for example! A name like "Longbow of great Wisdom" doesn\'t help - still crap.'
  },
  'Shop Floor' => {
    attr => [
      [
	'is_floor',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_magic',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'auto_apply',
	{
	  desc => 'If enabled, items will appear on this square when the map is loaded. You need to specify a <treasurelist> to define what kinds of items are generated. The items will be unpaid.',
	  name => 'generate goods',
	  type => 'bool'
	}
      ],
      [
	'randomitems',
	{
	  desc => 'This entry determines what kind of treasure will appear, when <generate goods> is enabled. Look into /crossfire/share/crossfire/treasures for details about existing treasurelists.',
	  name => 'treasurelist',
	  type => 'treasurelist'
	}
      ],
      [
	'exp',
	{
	  desc => 'The <quality level> will be used for the quality of the generated goods. If zero/unset, <quality level> 5 is used. Usually this value doesn\'t need to be set, unless you want extraordinarily good/bad quality. If you want to make a shop with very high quality, meaybe charge an entrance fee, or make the shop hard-to-come-by. Note that <quality level> mainly affects chance of magic bonus and appearance of artifact-items.',
	  name => 'quality level',
	  type => 'int'
	}
      ],
      [
	'damned',
	{
	  desc => 'If enabled, it is impossible for players to use prayers on that spot. It also prevents players from saving. (Remember that <no magic> is always set for shop floors.)',
	  name => 'no prayers',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Shop floor is used for shops. It acts like a combination of the common floor- and the treasure type: When the map is loaded, randomitems (depending on the setings) are generated on it. These items are all flagged as unpaid. When a player drops an item onto shop floor, the item becomes unpaid and the player receives payment according to the item\'s selling-value. Shopfloor always prevents magic (To hinder players from burning or freezing the goods).',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Shop Floor',
    use => 'Tile your whole shop-interior space which shop floor. (That assures players receive payment for dropping items). Place shop mats to enter/leave the shop, and make sure there is no other exit than the shop mat.'
  },
  'Shop Inventory' => {
    attr => [
      [
	'shop_coords',
	{
	  desc => 'The format of this field is: \'x1,y1,x2,y2\'. It defines a rectangle on the map that will be searched for unpaid items.',
	  name => 'shop rectangle',
	  type => 'string'
	}
      ]
    ],
    desc => 'The purpose of a sign is to display the contents of a shop.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Shop Inventory',
    use => 'Use these signs to present the player a list of the items in the shop'
  },
  'Shop Mat' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ]
    ],
    desc => 'Shop mats are used for entering/leaving shops. You should always have exactly TWO shop mats on your shop-map: One inside the "shopping-area" and one outside. Shop mats don\'t use exit paths/ or -destinations. When stepping onto a shopmat the player gets beamed to the nearest other mat. If the player has unpaid items in his inventory, the price gets charged from his coins automatically. If the player has insufficient coins to buy his unpaid items, he is unable to pass any shopmat (So he has to drop unpaid items).',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Shop Mat',
    use => 'As stated above, always place TWO shop mats into your shop. Not more and not less than that.'
  },
  'Sign & MagicMouth' => {
    attr => [
      [
	'connected',
	{
	  desc => 'When a connection value is set, the message will be printed whenever the connection is triggered. This should be used in combination with <invisible> enabled and <activate by walking/flying> disabled. If activating your magic_mouth this way, the message will not only be printed to one player, but all players on the current map.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'food',
	{
	  desc => 'If a counter-value is set (greater zero), the sign/magic_mouth can be applied (printing the message) only that many times. For signs this really shouldn\'t be used, while for magic_mouths it is extremely helpful. Monsters walking over the magic_mouth do not decrease the counter. Often, you might want to have a message displayed only one time. For example: The player enters your map and you put a magic_mouth to tell him about the monsters and how dangerous they look and all. Later, when all the monsters are killed and the player leaves the map, displaying the same message a second time would be silly. <counter> 1 does a perfect job in such cases. Otherwise set <counter> zero/unset for infinite use (that is the default).',
	  name => 'counter',
	  type => 'int'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text will be displayed to the player.',
	  end => 'endmsg',
	  name => 'message',
	  type => 'text'
	}
      ]
    ],
    desc => 'The purpose of a sign or magic_mouth is to display a certain message to the player. There are three ways to have the player get this message: The player walking onto it (-&gt; magic_mouth), the player pressing &lt;a&gt;pply (-&gt; sign) or the player triggering a button/handle/etc (-&gt; magic_mouth).',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Sign & MagicMouth',
    use => 'Use signs and magic_mouths, plenty of them! Place magic_mouths to add some true roleplay feeling to your maps, support your storyline or give hints about hidden secrets/dangers. Place signs to provide the player with all kinds of useful information for getting along in your maps.'
  },
  Skill => {
    attr => [
      [
	'invisible',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_drop',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'skill',
	{
	  desc => 'The <skill name> is used for matchings. When a usable object has an identical <skill name>, players (or monsters) will need this skill to apply/use the object.',
	  name => 'skill name',
	  type => 'string'
	}
      ],
      [
	'expmul',
	{
	  desc => 'This is the ratio of experience the players total should increase by when this skill is used. If this is zero, then experience only goes to to the skill. Values higher than 1 are allowed. Note that experience rewarded to the players total is in addition to that given to the skill. Eg, if player should get 500 exp for using a skill, and expmul is 1, the player will get 500 added to that skill as well as 500 to their total.',
	  name => 'exp multiplier',
	  type => 'float'
	}
      ],
      [
	'subtype',
	{
	  desc => 'The <skill type> defines the base functionality of the skill. Skill types are hardcoded in the Deliantra server. It isn\'t hard to create new skill types, but it requires a bit of server-coding.',
	  name => 'skill type',
	  type => 'list',
	  value => $LIST{skill_type}
	}
      ],
      [
	'level',
	{
	  name => 'level',
	  type => 'int'
	}
      ],
      [
	'exp',
	{
	  name => 'experience',
	  type => 'int'
	}
      ],
      [
	'can_use_skill',
	{
	  desc => 'The <is native skill> flag has an effect only when this skill object is placed in the inventory of a monster (or player). If it is set, the monster or player knows the skill natively, which means he does not need a skill tool to use it.',
	  name => 'is native skill',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Skills are objects which exist in the player/monster inventory. Both NPC/monsters and players use the same skill archetypes. Not all skills are enabled for monster use however.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Skill',
    use => 'For mapmaking, Skill objects serve two purposes: <p>First, the predefined skill archtypes (in the \'skills\' directory) can be seen as the global skill definitions. A skill which doesn\'t exists as an archtype cannot be learned or used by players. When you want to use skills in your maps, you may need to look up the &lt;skill name&gt;s of defined skill archtypes, because those strings are used as a reference in many skill-related objects. </p><p> Secondly, in order to enable monsters to use skills, you will need to copy default skill archtypes into the monsters\' inventories. You can even customize the skills by changing stats. It is not recommended however, to use skills in your maps which are totally unrelated to any predefined skill archtype.</p>'
  },
  'Skill Scroll' => {
    attr => [
      [
	'race',
	{
	  type => 'fixed',
	  value => 'scrolls'
	}
      ],
      [
	'skill',
	{
	  desc => 'The <skill name> matches the skill object that can be learned from this scroll.',
	  name => 'skill name',
	  type => 'string'
	}
      ]
    ],
    desc => 'By reading a skill scroll, a player has a chance to learn the contained skill.',
    name => 'Skill Scroll',
    use => 'Skill scrolls are very much sought for by players. Currently, all skill scrolls are sold in shops randomly, which is in fact not a good system. It would be nice to have some cool quests with skill scrolls rewarded at the end.'
  },
  'Skill Tool' => {
    attr => [
      [
	'skill',
	{
	  desc => 'This field describes which skill the player will be able to use wearing this item.',
	  name => 'skill name',
	  type => 'string'
	}
      ]
    ],
    desc => 'Wearing a skill tool will give the player the ability to use a skill.',
    name => 'Skill Tool',
    section => [
      [
	'stats',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'Feel free to assign resistancies and stats to a skill tools or change the skill that is given.'
  },
  'Special Key' => {
    attr => [
      [
	'slaying',
	{
	  desc => 'This string must be identical with the <key string> in the locked door, then it can be unlocked. It can also be used to trigger inventory checkers.',
	  name => 'key string',
	  type => 'string'
	}
      ],
      [
	'material',
	{
	  desc => 'For Special Keys, material should always be unset or set to Adamantite. This prevents the key from getting burned or otherwise destroyed.',
	  name => 'material',
	  type => 'bitmask',
	  value => $BITMASK{material}
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good. This can be used if you want to sell apartments on your map: Simply sell a unique passport/key, and place an inventory checker at the entrance of your apartment.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This will add a description to the object. The player can read this text by clicking on the item in his inventory. Use this message to describe what the key/passport is good for. A player might have 50 different keys on his key-ring. Don\'t expect players to recall their purpose just by their names.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'When carrying the appropriate special key, a locked door can be opened. The key will dissapear. <br><br> This object-type can also be used for "passport"-like items: When walking onto an invetory checker, a gate for example might get opened. The "passport" will stay in the player\'s inventory.',
    ignore => [
      'material'
    ],
    name => 'Special Key',
    use => 'How to make a "passport": You take the special key arch (archetype name is "key2"), set the face to something like card.111 and the name to "passport" - that\'s all. The &lt;key string&gt; certainly must match with the appropiate inventory checker. <br><br> Of course you can be creative with names and faces of key-objects. A "mysterious crystal" or a "big dragon claw" (with appropriate faces) appear more interesting than just a "strange key", or "passport".'
  },
  Spell => {
    attr => [
      [
	'no_drop',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'invisible',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'skill',
	{
	  desc => 'The <skill name> matches the skill which is needed to cast this spell. This should be one out of "sorcery", "pyromancy", "evocation", "summoning" or "praying". If you want to fiddle with these, please take care not to upset the concept and balance of the various skills.',
	  name => 'skill name',
	  type => 'string'
	}
      ],
      [
	'subtype',
	{
	  desc => 'The <spell type> defines the basic type of spell. Some of these types are of a more generic nature than others.',
	  name => 'spell type',
	  type => 'list',
	  value => $LIST{spell_type}
	}
      ],
      [
	'level',
	{
	  name => 'spell level',
	  type => 'int'
	}
      ],
      [
	'casting_time',
	{
	  name => 'casting time',
	  type => 'int'
	}
      ],
      [
	'duration',
	{
	  name => 'duration',
	  type => 'int'
	}
      ],
      [
	'other_arch',
	{
	  name => 'create object',
	  type => 'string'
	}
      ],
      [
	'sp',
	{
	  name => 'cost spellpoints',
	  type => 'int'
	}
      ],
      [
	'grace',
	{
	  name => 'cost grace',
	  type => 'int'
	}
      ],
      [
	'maxsp',
	{
	  name => 'double cost per level',
	  type => 'int'
	}
      ]
    ],
    desc => 'Spell objects define a spell. When a spell is put in a spellbook, players can learn it by reading the book. Once learned, players can use the spell as often as they like. With increasing skill level of the player, spells may gain power but also increase cost.<br> Monsters can use spells which are put in their inventory (provided that certain "enabling" settings are correct). The monster\'s &lt;treasurelist&gt; can also be used to provide it with spells.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Spell',
    use => 'A lot of the spells\' settings can be tuned and customized. When creating new spells which are accessible to players, it is important to think about balance. A single spell which is too powerful and/or too easy to use can eventually toss the whole skill and magic school system out of whack. Testing new spells is quite important therefore.'
  },
  Spellbook => {
    attr => [
      [
	'skill',
	{
	  type => 'fixed',
	  value => 'literacy'
	}
      ],
      [
	'randomitems',
	{
	  desc => 'There are two ways to put spells into a spellbook: 1. Put a spell object in the books inventory. In this case, treasurelist must be set to <none>. 2. Choose a treasurelist which contains spells. In that way, a spell will be chosen randomly from the list.',
	  name => 'treasurelist',
	  type => 'treasurelist'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a nice description of the spellbook\'s cover or something.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'By reading a spellbook, the player has a chance of learning the contained spell. Once learned from a book, the spell is available forever. Spellbooks with high level spells require some skill-level to read.<br><br> You can create widely customized spells only by adjusting the spell object in the spellbooks inventory. Refer to the description of spell objects for detailed information how to customize spells.<br> If you want to have a random spellbook instead, choose a &lt;treasurelist&gt; with a compilation of spells that the book may contain.',
    name => 'Spellbook',
    use => 'Don\'t put any of the godgiven spells into a spellbook! These are reserved for the followers of the appropriate cults. Handing them out in a spellbook would violate the balance between different religions. <br><br> Note that there is no fundamental difference between the spellbooks of varying schools (pyromancy, sorcery, evocation, summoning, and even praying). The difference lies only in the spells they contain. It is up to you, the mapmaker, to pick the right type of book for your spells.'
  },
  Spinner => {
    attr => [
      [
	'sp',
	{
	  desc => 'The spinner will change the direction of flying objects by 45 degrees per <direction number>. Negative values spin clockwise, positive values counter clockwise. Example: <direction number> -2 means spin 90 degrees clockwise.',
	  name => 'direction number',
	  type => 'int'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ]
    ],
    desc => 'Spinners change the direction of spell objects and other projectiles that fly past. Unlike directors, it does make a difference from what angle you shoot into the spinner. The direction of objects flying past is always changed by a certain degree.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Spinner',
    use => 'Spinners are very rarely used. I believe they are quite confusing and pointless. The only use I can think of is building some puzzle about where to shoot into spinners to shoot somewhere you otherwise couldn\'t. When placing spinners on a map with magic walls, make sure the spell- projectiles from magic walls don\'t get to fly in loops.'
  },
  Swamp => {
    attr => [
      [
	'is_floor',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'is_wooded',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'speed',
	{
	  desc => 'The higher the <drowning speed>, the faster will players and items sink into the swamp. Swamp with very high <drowning speed> can be a nasty and unexpected death-trap. Players should get a warning before such areas.',
	  name => 'drowning speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'If enabled, it is impossible for players to use (wizard-) spells on that spot.',
	  name => 'no spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'If enabled, it is impossible for players to use prayers on that spot. It also prevents players from saving.',
	  name => 'no prayers',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Swamp areas show a special behaviour: When a player stands still on a swamp-square for too long, he will start to sink in and eventually drown and die. Items dropped on the swamp sink in and dissapear. Players with knowledge of the woodsman skill are a lot less likely to die in the swamp.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Swamp'
  },
  Teleporter => {
    attr => [
      [
	'slaying',
	{
	  desc => 'The exit path specifies the map that the player is transferred to. <exit path> can be an absolute path, beginning with \'/\' (for example "/peterm/FireTemple/fire1"). It can also be a relative path, not beginning with \'/\' (On the map "/peterm/FireTemple/Fire2" for example I could use the relative path "Fire1"). Use relative paths whenever possible! Note that upper/lower case must always be set correctly. However, please use lower case only. If the <exit path> is set, ONLY players can get teleported. If the <exit path> is unset (empty), anything can get teleported: Players, monsters and items. In this case, the destined map is automatically the same map the teleporter is on.',
	  name => 'exit path',
	  type => 'string'
	}
      ],
      [
	'hp',
	{
	  desc => 'The exit destinations define the (x, y)-coordinates where the exit leads to. If both are set to zero and <exit path> is empty, the player will get teleported to another, randomly chosen teleporter on the same map (Slightly confusing for the player though). Make sure there actually *is* a second one in that case. If both are set to zero and <exit path> is set, the player will be transferred to the "default enter location" of the destined map. The latter can be set in the map-properties as "Enter X/Y". Though, please DO NOT use that. It turned out to be a source for numerous map-bugs.',
	  name => 'destination X',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'The exit destinations define the (x, y)-coordinates where the exit leads to. If both are set to zero and <exit path> is empty, the player will get teleported to another, randomly chosen teleporter on the same map (Slightly confusing for the player though). Make sure there actually *is* a second one in that case. If both are set to zero and <exit path> is set, the player will be transferred to the "default enter location" of the destined map. The latter can be set in the map-properties as "Enter X/Y". Though, please DO NOT use that. It turned out to be a source for numerous map-bugs.',
	  name => 'destination Y',
	  type => 'int'
	}
      ],
      [
	'connected',
	{
	  desc => 'If a connection value is set, the teleporter will be activated whenever the connection is triggered. To use this properly, <activation speed> must be zero.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'speed',
	{
	  desc => 'If the <activation speed> is nonzero, the teleporter will automatically be activated in regular time-intervals. Hence, the player can just step on it and gets teleported sooner or later. The duration between two activates depends on the given value. Default in the teleporter arch is <activation speed> 0.1. VERY IMPORTANT: If you want to have your teleporter activated via button/handle/magic_ear/etc, you must set <activation speed> to zero!',
	  name => 'activation speed',
	  type => 'float'
	}
      ],
      [
	'speed_left',
	{
	  desc => 'The speed left to the object. On every tick, if this value is higher than 0, the object acts/triggers/moves etc. and the value gets decremented by 1. Otherwise, it is incremented by <speed> on every tick.',
	  name => 'speed left',
	  type => 'float'
	}
      ]
    ],
    desc => 'When the player walks into a teleporter, he is transferred to a different location. The main difference to the object-type exit is the possibility to have teleporters connected to levers/buttons/etc. Sometimes teleporters are activated even against the players will. <br><br> Unlike exits, teleporters can also transfer items and monsters to different locations on the same map.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Teleporter',
    use => 'When creating maps, I guess sooner or later you\'ll want to have an invisible teleporter. If using "invisible 1", the teleporter can still be discovered with the show_invisible spell. And in some cases you can\'t place it under the floor to prevent this. <br><br> Fortunately, there is a cool trick to make a perfectly invisible teleporter: You simply add teleporter functionality to the floor itself. That means: You take the floor arch (e.g. "flagstone"), set "type 41", and add slaying/hp/sp/connected... everything you need.'
  },
  'Timed Gate' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'connected',
	{
	  desc => 'Whenever the inventory checker is triggered, all objects with identical <connection> value get activated. This only makes sense together with <blocking passage> disabled. If unset, the gate opens automatically after some time.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'activate_on_push',
	{
	  desc => 'Whether the teleporter should only be activated on push.',
	  name => 'activate on push',
	  type => 'bool'
	}
      ],
      [
	'activate_on_release',
	{
	  desc => 'Whether the teleporter should only be activated on release.',
	  name => 'activate on release',
	  type => 'bool'
	}
      ],
      [
	'wc',
	{
	  desc => 'The <position state> defines the position of the gate: Zero means completely open/down, the "number of animation-steps" (usually about 6 or 7) means completely closed/up state. I suggest you don\'t mess with this value - Leave the default in place.',
	  name => 'position state',
	  type => 'int'
	}
      ],
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'Restricting the use of spells to pass this gate. This has an effect only if <block view> is disabled.',
	  name => 'restrict spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'Restricting the use of prayers to pass this door. This has an effect only if <block view> is disabled.',
	  name => 'restrict prayers',
	  type => 'bool'
	}
      ],
      [
	'hp',
	{
	  desc => 'Defines the duration the gate remains closed. This only takes effect if the gate is not connected.',
	  name => 'open duration',
	  type => 'int'
	}
      ]
    ],
    desc => 'Gates play an important role in Deliantra. Gates can be opened by activating a button/trigger, by speaking passwords (-> magic_ear) or carrying special key-objects (-> inventory checker). Unlike locked doors, gates can get shut again after a player has passed, which makes them more practical in many cases. Unlike normal gates, timed gates open when triggered but automatically close again after some time.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Timed Gate',
    use => 'Use gates to divide your maps into separated areas. After solving area A, the player gains access to area B, and so on. Make your maps more complex than "one-way".'
  },
  Torch => {
    attr => [
      [
	'is_lightable',
	{
	  desc => 'This flag controls whether the torch can be lit up again using a lighter or whether it can only be used once, in which case they can be enabled by simply applying them without any special tools.',
	  name => 'reignitable',
	  type => 'bool'
	}
      ],
      [
	'food',
	{
	  desc => 'This field specifies the burning duration of the torch.',
	  name => 'burning duration',
	  type => 'int'
	}
      ],
      [
	'range',
	{
	  desc => 'This field sets the glow radius of the torch if it is enabled. If you want to make a torch that is already burning set the "glow radius" field.',
	  name => 'enabled glow radius',
	  type => 'int'
	}
      ],
      [
	'level',
	{
	  desc => 'If this field specyfies the cursed effect\'s level. If it is 0 no cursed effect will be generate. See also the "cursed" flag.',
	  name => 'level',
	  type => 'int'
	}
      ],
      [
	'cursed',
	{
	  desc => 'Cursed torches, which have a level above 0, explode if the player applies them.',
	  name => 'cursed',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Torches are a special kind of Lamp that offer the option of lighting them up without using a lighter (These torches are usually called \'pyrophor torches\'. See also the \'reignitable\' setting). The other kind of torches, that are reignitable, can be put out and put on again using a lighter.',
    name => 'Torch'
  },
  Trap => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'level',
	{
	  desc => 'Level effects how easily a trap may be found and disarmed, and how much experience the player gets for doing so. Beware: High level traps can be quite a cheap source of experience! So either make them tough, or keep the level low.',
	  name => 'trap level',
	  type => 'int'
	}
      ],
      [
	'Cha',
	{
	  desc => 'This value determines what fraction of the time the trap is visible: It\'ll be randomly visible 1/<visibility> of the time. Also effects how easily the trap may be found.',
	  name => 'visibility',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'The trap will detonate <number of charges> times before disappearing.',
	  name => 'number of charges',
	  type => 'int'
	}
      ],
      [
	'dam',
	{
	  desc => '<direct damage> specifies how much damage is done by the trap. This should be set in reasonable relation to the trap\'s level.',
	  name => 'direct damage',
	  type => 'int'
	}
      ],
      [
	'attacktype',
	{
	  desc => 'This attribute defines what attacktype to use for direct damage when the trap detonates.',
	  name => 'attacktype',
	  type => 'bitmask',
	  value => $BITMASK{attacktype}
	}
      ],
      [
	'connected',
	{
	  desc => 'When the trap is detonated, all objects with the same connection value get activated.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'When the trap detonates, this text is displayed to the victim. For especially powerful or complex traps, create an appropriate and thrilling description. ;)',
	  end => 'endmsg',
	  name => 'detonation text',
	  type => 'text'
	}
      ]
    ],
    desc => 'A trap is a object that can either do damage or trigger another connected object when detonated. Traps are like runes except they are not magical in nature, and generally have either a physical attack or trigger a reaction. <br><br> Traps hit any monster or person who steps on them for \'dam\' damage in \'attacktype\' attacktype and/or trigger a reaction. <br><br> Many traps are already defined in the archetypes.',
    ignore => [
      'no_pick',
      'title',
      'name_pl',
      'weight',
      'value',
      'material',
      'unpaid'
    ],
    name => 'Trap',
    use => 'Avoid monsters stepping on your traps. For example, a party of orcs setting off your lightning wall and pit trap is usually a bad idea.'
  },
  Trapdoor => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'move_on',
	{
	  desc => 'Which movement types automatically (as opposed to manually) activate this object.',
	  name => 'movement on',
	  type => 'movement_type'
	}
      ],
      [
	'weight',
	{
	  desc => 'This value defines how much weight the trapdoor can hold. Once items or creatures are gathered on the trapdoor, with a total weight surpassing this value, then the trapdoor will open and things start falling through.',
	  name => 'hold weight',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'The trapdoor will transport creatures (and items) randomly into a two-square radius of the destination coordinates. If the destination square becomes blocked, the trapdoor will act like being filled up and not work anymore!',
	  name => 'destination X',
	  type => 'int'
	}
      ],
      [
	'sp',
	{
	  desc => 'The trapdoor will transport creatures (and items) randomly into a two-square radius of the destination coordinates. If the destination square becomes blocked, the trapdoor will act like being filled up and not work anymore!',
	  name => 'destination Y',
	  type => 'int'
	}
      ]
    ],
    desc => 'Trapdoors are very similar to pits. The difference is that they can not be closed. Instead, the weight of the object on the trapdoor determines weither it slams the trapdoor open and falls through or not.<br> Once a trapdoor has been opened (by a creature or items of sufficient weight,) it remains open, acting like an opened pit.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Trapdoor',
    use => 'Trapdoors should be used in the same fashion as pits: They should always drop the victims to some kind of lower level. They are not supposed to be used to randomly interconnect maps like teleporters.'
  },
  Treasure => {
    attr => [
      [
	'randomitems',
	{
	  desc => 'This entry determines what kind of treasure will appear. Look into /crossfire/share/crossfire/treasures for details about existing treasurelists.',
	  name => 'treasurelist',
	  type => 'treasurelist'
	}
      ],
      [
	'auto_apply',
	{
	  desc => '"Auto-generate" must be set in order to have the treasure be created when the map is loaded. If you want to create a random treasure chest, you unset this flag. That way, the player has to apply the object (the chest), then the treasure is generated.',
	  name => 'auto-generate',
	  type => 'bool'
	}
      ],
      [
	'hp',
	{
	  desc => '"Create number" specifies how many pieces of the given treasurelist will appear. Note that for every piece there is a chance that nothing is generated. Also, sometimes there can be stacks of items generated, like for gems/money.',
	  name => 'create number',
	  type => 'int'
	}
      ],
      [
	'exp',
	{
	  desc => 'The <quality level> will be used for the quality of the generated treasure instead of the map difficulty (as was done with shops). If zero/unset, the map difficulty will instead be used. (Example for comparison: Shop floors generate treasure of <quality level> 5 per default).',
	  name => 'quality level',
	  type => 'int'
	}
      ]
    ],
    desc => 'A treasure-object turns into certain randomitems when the map is loaded into the game.',
    ignore => [
      'nrof',
      'title',
      'name_pl',
      'weight',
      'value',
      'material'
    ],
    name => 'Treasure',
    use => 'About usage of the "random-artifact" treasurelist: This will generate powerful stuff like girdles, xray helmets, special swords etc. If you put this as reward to your quest, players might be motivated to do it more than once. BUT, by doing so they will get a huge number of different artifacts! Besides, players will always seek the place with the most easy-to-get random artifact and ignore all others. My advice: Don\'t use it! Attract players with good fighting experience (from monsters), potions, spellbooks, money, and non-random artifacts.'
  },
  'Trigger Marker' => {
    attr => [
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'slaying',
	{
	  desc => 'The <key string> can be detected by inv. checkers/detectors. If the player already has a force with that <key string>, there won\'t be inserted a second one.',
	  name => 'key string',
	  type => 'string'
	}
      ],
      [
	'connected',
	{
	  desc => 'Unlike a regular marker this is the connection that triggers this marker to activate.',
	  name => 'connection',
	  type => 'string'
	}
      ],
      [
	'food',
	{
	  desc => 'This value defines the duration of the force it inserts. If nonzero, the duration of the player\'s mark is finite: about 1 food per 10 seconds. <mark duration> zero/unset means the mark will stay on the player forever.',
	  name => 'mark duration',
	  type => 'int'
	}
      ],
      [
	'name',
	{
	  desc => 'When the player steps onto the marker, all existing forces in the players inventory with a <key string> matching <delete mark> will be removed. If you don\'t want to remove any marks, leave this textfield empty. Note that the string <delete mark> is set as the name of this marker. So don\'t be confused, and remember changing the name will take effect on the marker\'s functionality.',
	  name => 'delete mark',
	  type => 'string'
	}
      ],
      [
	'msg',
	{
	  desc => 'In the moment when the player gets marked, this text is displayed to him. You should really set a message in any marker you create, because it\'s the only way for the player to notice what\'s going on.',
	  end => 'endmsg',
	  name => 'marking message',
	  type => 'text'
	}
      ]
    ],
    desc => 'A trigger marker is an object that inserts an invisible force (a mark) into a player stepping on it WHEN TRIGGERED. This force does nothing except containing a &lt;key string&gt; which can be discovered by detectors or inventory checkers. It is also possible to use markers for removing marks again. (by setting the "name" slot to the name of the marker to be removed). <br><br> Note that the player has no possibility to "see" his own marks, except by the effect that they cause on the maps.',
    ignore => [
      $IGNORE_LIST{system_object}
    ],
    name => 'Trigger Marker',
    use => 'Markers hold real cool possibilities for map-making. I encourage you to use them frequently. However there is one negative point about markers: Players don\'t "see" what\'s going on with them. It is your task, as map-creator, to make sure the player is always well informed and never confused. <br><br> Please avoid infinite markers when they aren\'t needed. They\'re using a little space in the player file after all, so if there is no real purpose, set an expire time.'
  },
  Wall => {
    attr => [
      [
	'move_block',
	{
	  desc => 'Objects using these movement types cannot move over this space.',
	  name => 'blocked movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_allow',
	{
	  desc => 'Objects using these movement types are allowed to move over this space. Takes precedence over \'blocked movements\'.',
	  name => 'allowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow',
	{
	  desc => 'The types of movement that should by slowed down by the \'slow movement penalty\'.',
	  name => 'slowed movement',
	  type => 'movement_type'
	}
      ],
      [
	'move_slow_penalty',
	{
	  desc => 'If <slow movement> is set to a value greater zero, all creatures matching \'slow move\' will be slower than normal on this spot. <slow movement> 1 - rough terrain <slow movement> 2 - very rough terrain ... <slow movement> 5 - default for deep swamp ... <slow movement> 7 - spider web (sticky as hell)',
	  name => 'slow movement penalty',
	  type => 'int'
	}
      ],
      [
	'can_roll',
	{
	  desc => 'If set, the object is able to "roll", so it can be pushed around. This setting is used for boulders and barrels.',
	  name => 'moveable',
	  type => 'bool'
	}
      ],
      [
	'no_magic',
	{
	  desc => 'This takes effect only with <blocksview> disabled. Restricting the use of spells to pass this wall.',
	  name => 'restrict spells',
	  type => 'bool'
	}
      ],
      [
	'damned',
	{
	  desc => 'This takes effect only with <blocksview> disabled. Restricting the use of spells to pass this wall.',
	  name => 'restrict prayers',
	  type => 'bool'
	}
      ]
    ],
    desc => 'Walls usually block passage and sight.',
    ignore => [
      'nrof',
      'title',
      'name_pl',
      'value',
      'unpaid'
    ],
    name => 'Wall'
  },
  'Wand & Staff' => {
    attr => [
      [
	'sp',
	{
	  desc => 'The <spell> specifies the contained spell.',
	  name => 'spell',
	  type => 'spell'
	}
      ],
      [
	'level',
	{
	  desc => 'The <casting level> of the wand determines it\'s power. An average level for wands in shops is about 10.',
	  name => 'casting level',
	  type => 'int'
	}
      ],
      [
	'food',
	{
	  desc => 'The wand can be used <number of charges> times before it is used up. It can be recharged with scrolls of charging.',
	  name => 'number of charges',
	  type => 'int'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text may contain a description of the wand.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Wands contain a certain spell. The player can apply (ready) and fire the wand. After a defined number of casts, the wand is "used up". It is possible to recharge a wand with scrolls of charging, but usually that isn\'t worth the cost.',
    name => 'Wand & Staff',
    use => 'Wands are quite seldomly used. The reason prolly is that they\'re generally not cost-efficient. Handing out high-level wands with powerful special spells isn\'t a good idea either, because of the recharge ability. <br><br> For low levels, staffs of healing/cure and word of recall are quite desirable though. Ideal rewards for low level quests.'
  },
  'Weak Wall' => {
    attr => [
      [
	'alive',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'no_pick',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'tear_down',
	{
	  type => 'fixed',
	  value => 1
	}
      ],
      [
	'race',
	{
	  desc => 'For weak walls, <race> should always be set to "wall", unless you create something fancy like a building which is in fact meant to be a huge animal. Note that shovels slay walls, so they do tripple damage against weak walls.',
	  name => 'race',
	  type => 'string'
	}
      ],
      [
	'level',
	{
	  desc => 'The <level> of a weak wall works similar to monster levels. Due to the fact that weak walls cannot attack, the level is much less important though.',
	  name => 'level',
	  type => 'int'
	}
      ],
      [
	'hp',
	{
	  desc => 'The <health points> of a weak wall define how long it takes to tear it down. With every successful hit from an opponent, <health points> get drained.',
	  name => 'health points',
	  type => 'int'
	}
      ],
      [
	'maxhp',
	{
	  desc => '<max health> is the maximum amount of <health points> this weak wall can have. Since walls generally don\'t heal, I doubt this has much real effect.',
	  name => 'max health',
	  type => 'int'
	}
      ],
      [
	'ac',
	{
	  desc => 'Weak walls of high <armour class> are less likely to get hit. <armour class> can be considered the "counterpiece" to <weapon class>.',
	  name => 'armour class',
	  type => 'int'
	}
      ]
    ],
    desc => 'A weak wall is a breakable spot amidsts a solid wall. Typically these weak walls look similar to their solid "relatives" except for a small crack or little chunks of wall on the ground.',
    ignore => [
      $IGNORE_LIST{non_pickable}
    ],
    name => 'Weak Wall',
    section => [
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ]
	]
      ]
    ],
    use => 'If you want to create hidden rooms, using weak walls is alot better than completely indiscernible passages in a wall.<br> Anyways, there can be a lot more to weak walls than just finding them: Rising their defensive stats, weak walls can become a serious obstacle. An ice wall might only be torn down by a fire attack for example. A granite wall for instance might be very hard to destroy.'
  },
  Weapon => {
    attr => [
      [
	'attacktype',
	{
	  desc => 'This number is a bitmask, specifying the weapon\'s attacktypes. Attacktypes are: physical, magical, fire, cold.. etc. Most artifact weapons have no more than one or two attacktypes. Keep in mind that all weapons can be blessed by the player\'s diety, thus adding an additional attacktype. When a player hits a monster with a weapon that has more than one attacktype, then he will do as much damage as the "best" of his attacktypes does. So, the more attacktypes you\'ve got, the better your chance to take advantage of a monster\'s vulnerabilities. (Btw: Same rule applies for monster vs. player.). Attacktypes "magic" and "chaos" are somehow exceptions.',
	  name => 'attacktype',
	  type => 'bitmask',
	  value => $BITMASK{attacktype}
	}
      ],
      [
	'weapontype',
	{
	  desc => 'The <weapontype> characterizes the weapon\'s type of physical attack. It could best be considered a "subclassification" of the physical attacktype. For now, this is only used for attack messages! You should always set this correctly when creating new weapons for your maps.',
	  name => 'weapontype',
	  type => 'list',
	  value => $LIST{weapon_type}
	}
      ],
      [
	'skill',
	{
	  desc => 'Matching <skill name> of the skill that is required to use this weapon.',
	  name => 'skill name',
	  type => 'string'
	}
      ],
      [
	'dam',
	{
	  desc => 'The damage value is used as base value for how much damage the weapon does per hit. The actual damage involves more dependencies, like wielder\'s level and defender\'s level. Look at existing weapons to get a feel for the range of weapon damage values.',
	  name => 'damage',
	  type => 'int'
	}
      ],
      [
	'slaying',
	{
	  desc => 'Slaying means the weapon does tripple (3x) damage to monsters of the specified race. If <slaying race> matches an arch name (e.g. "big_dragon"), only monsters of that archtype are hit with tripple damage. No god blessings are possible for weapons with a race set in this entry (That\'s because god blessings add tripple damage against their own enemy races). Tripple damage is very effective.',
	  name => 'slaying race',
	  type => 'string'
	}
      ],
      [
	'last_sp',
	{
	  desc => 'The weapon speed determines how often the wielder can swing the weapon during a certain period of time. The lower the faster, <weapon speed> 1 is best (that is lightning- fast). A typical average value is 8. Speed and damage should be kept in reasonable relation.',
	  name => 'weapon speed',
	  type => 'int'
	}
      ],
      [
	'wc',
	{
	  desc => 'The weapon class value adds to the overall weapon class of the wielder\'s melee attacks. Weapon class improves the chance of hitting the opponent.',
	  name => 'weapon class',
	  type => 'int'
	}
      ],
      [
	'magic',
	{
	  desc => 'For a weapon, magic bonus works just like weapon class, except that magic bonus can be improved by the gods or reduced by acid. Hence, it is less useful than direct weapon class value on a weapon.',
	  name => 'magic bonus',
	  type => 'int'
	}
      ],
      [
	'item_power',
	{
	  desc => 'The <item power> value measures how "powerful" an artifact is. Players will only be able to wear equipment with a certain total amount of <item power>, depending on their own level. This is the only way to prevent low level players to wear "undeserved" equipment (like gifts from other players or cheated items). It is very important to adjust the <item power> value carefully for every artifact you create! If zero/unset, the Deliantra server will calculate a provisional value at runtime, but this is never going to be an accurate measurement of <item power>.',
	  name => 'item power',
	  type => 'int'
	}
      ],
      [
	'damned',
	{
	  desc => 'A damned weapon cannot be unwielded unless the curse is removed. Removing damnations is a tick harder than removing curses.',
	  name => 'damnation',
	  type => 'bool'
	}
      ],
      [
	'cursed',
	{
	  desc => 'A cursed weapon cannot be unwielded unless the curse is removed.',
	  name => 'curse',
	  type => 'bool'
	}
      ],
      [
	'lifesave',
	{
	  desc => 'An item with this flag enabled will save the players life for one time: When the player is wearing this item and his health points reach zero, the item disappears, replenishing half of the player\'s health. An item with <save life> should not have any decent additional bonuses!',
	  name => 'save life',
	  type => 'bool'
	}
      ],
      [
	'unique',
	{
	  desc => 'Unique items exist only one time on a server. If the item is taken, lost or destroyed - it\'s gone for good.',
	  name => 'unique item',
	  type => 'bool'
	}
      ],
      [
	'startequip',
	{
	  desc => 'A godgiven item vanishes as soon as the player drops it to the ground.',
	  name => 'godgiven item',
	  type => 'bool'
	}
      ],
      [
	'msg',
	{
	  desc => 'This text describes the weapons\'s "story". Every decent artifact weapon should have such a description.',
	  end => 'endmsg',
	  name => 'description',
	  type => 'text'
	}
      ]
    ],
    desc => 'Wielding a weapon, the object\'s stats will directly be inherited to the player. Usually enhancing his fighting-abilities. Non-magical weapons can be improved with scrolls.',
    name => 'Weapon',
    section => [
      [
	'stats',
	[
	  [
	    'Str',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'strength',
	      type => 'int'
	    }
	  ],
	  [
	    'Dex',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'dexterity',
	      type => 'int'
	    }
	  ],
	  [
	    'Con',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'constitution',
	      type => 'int'
	    }
	  ],
	  [
	    'Int',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'intelligence',
	      type => 'int'
	    }
	  ],
	  [
	    'Pow',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'power',
	      type => 'int'
	    }
	  ],
	  [
	    'Wis',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'wisdom',
	      type => 'int'
	    }
	  ],
	  [
	    'Cha',
	    {
	      desc => 'The player\'s strentgh will rise/fall by the given value for permanent (of course there is an upper limit). Generally there shouldn\'t be stat potions granting more than one stat. Cursed potions will subtract the stats if positive.',
	      name => 'charisma',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'resistance',
	[
	  [
	    'resist_physical',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist physical %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_magic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist magic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fire',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fire %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_electricity',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist electricity %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_cold',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist cold %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_acid',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist acid %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_confusion',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist confusion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_weaponmagic',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist weaponmagic %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_ghosthit',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist ghosthit %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_slow',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist slow %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_fear',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist fear %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_death',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist death-attack %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_chaos',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist chaos %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_blind',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist blinding %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_holyword',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist holy power %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_godpower',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist godpower %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_paralyze',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist paralyze %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_drain',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist draining %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_deplete',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist depletion %',
	      type => 'int'
	    }
	  ],
	  [
	    'resist_poison',
	    {
	      desc => 'The player\'s resistance to physical will rise by this value in percent (range -100 till +100). The effect is only temporare, and it does NOT add on the values from the player\'s equipment. Cursed potions will make negative resistance.. very nasty in combat!',
	      name => 'resist poison %',
	      type => 'int'
	    }
	  ]
	]
      ],
      [
	'misc',
	[
	  [
	    'luck',
	    {
	      desc => 'With positive luck bonus, the player is more likely to succeed in all sorts of things (spellcasting, praying,...). Unless the <luck bonus> is very high, the effect will be barely visible in-game. Luck bonus on one piece of equipment should never exceed 3, and such bonus should not be too frequently available.',
	      name => 'luck bonus',
	      type => 'int'
	    }
	  ],
	  [
	    'hp',
	    {
	      desc => 'Positive <health regen.> bonus speeds up the player\'s healing process. Negative values slow it down.',
	      name => 'health regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'sp',
	    {
	      desc => 'Positive <mana regen.> bonus speeds up the player\'s mana regeneration. Negative values slow it down.',
	      name => 'mana regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'grace',
	    {
	      desc => 'Positive <grace regen.> bonus speeds up the player\'s grace regeneration. Negative values slow it down. Since grace can be regenerated rather easy with praying, additional <grace regen.> bonus should be VERY RARE!!',
	      name => 'grace regen.',
	      type => 'int'
	    }
	  ],
	  [
	    'food',
	    {
	      desc => 'Positive <food bonus> slows down the player\'s digestion, thus he consumes less food. Negative values speed it up. Note that food is consumed not only for "being alive", but also for healing and mana-regeneration. <food bonus> only affects the amount of food consumed for "being alive". Hence, even with high <food bonus>, during a fight a player can run out of food quickly.',
	      name => 'food bonus',
	      type => 'int'
	    }
	  ],
	  [
	    'xrays',
	    {
	      desc => 'Xray vision allows the player to see through obstacles in a two-square-wide radius. This is extremely helpful and desirable, so don\'t give it away for cheap on equipment.',
	      name => 'xray vision',
	      type => 'bool'
	    }
	  ],
	  [
	    'stealth',
	    {
	      desc => 'Stealth allows the player to move silently. This comes to effect if a player turns himself invisible and tries to sneak around monsters. (At least that was the idea behind it)',
	      name => 'stealth',
	      type => 'bool'
	    }
	  ],
	  [
	    'reflect_spell',
	    {
	      desc => 'If a player is wearing any piece of equipment with the ability to <reflect spells>, all kinds of spell-bullets and -beams will bounce off him. This works only about 90% of all times, to avoid players being completely immune to certain types of attacks. This is a very powerful ability and it shouldn\'t be handed out cheap!',
	      name => 'reflect spells',
	      type => 'bool'
	    }
	  ],
	  [
	    'reflect_missile',
	    {
	      desc => 'If a player is wearing any piece of equipment with the ability to <reflect missiles>, all kinds of projectiles (e.g. arrows, bolts, boulders) will bounce off him. This works only about 90% of all times, to avoid players being completely immune to certain types of attacks.',
	      name => 'reflect missiles',
	      type => 'bool'
	    }
	  ],
	  [
	    'path_attuned',
	    {
	      desc => 'Click on the <attuned paths> button to select spellpaths. The player will get attuned to the specified spellpaths while wearing this weapon.',
	      name => 'attuned paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ],
	  [
	    'path_repelled',
	    {
	      desc => 'Click on the <repelled paths> button to select spellpaths. The player will get repelled to the specified spellpaths while wearing this weapon.',
	      name => 'repelled paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ],
	  [
	    'path_denied',
	    {
	      desc => 'Click on the <denied paths> button to select spellpaths. The specified spellpaths will be denied to the player while wearing this weapon.',
	      name => 'denied paths',
	      type => 'bitmask',
	      value => $BITMASK{spellpath}
	    }
	  ]
	]
      ]
    ],
    use => 'If you create artifacts (equipment) with stats- or resistance-bonus: Keep playbalance in mind! Such items mustn\'t be reachable without hard fighting AND questing.'
  }
);

our %ATTR = (
  3 => $TYPE{Rod},
  4 => $TYPE{Treasure},
  5 => $TYPE{Potion},
  6 => $TYPE{Food},
  7 => $TYPE{'Poison Food'},
  8 => $TYPE{Book},
  9 => $TYPE{Clock},
  13 => $TYPE{Projectile},
  14 => $TYPE{'Shooting Weapon'},
  15 => $TYPE{Weapon},
  16 => $TYPE{'Brestplate Armour'},
  17 => $TYPE{Pedestal},
  18 => $TYPE{Altar},
  19 => $TYPE{'Item Match'},
  20 => $TYPE{'Locked Door'},
  21 => $TYPE{'Special Key'},
  23 => $TYPE{Door},
  24 => $TYPE{Key},
  26 => $TYPE{'Timed Gate'},
  27 => $TYPE{'Handle Trigger'},
  28 => $TYPE{'Monster (Grimreaper)'},
  29 => $TYPE{'Magic Ear'},
  30 => $TYPE{'Button Trigger'},
  31 => $TYPE{'Altar Trigger'},
  32 => $TYPE{'Pedestal Trigger'},
  33 => $TYPE{Shield},
  34 => $TYPE{Helmet},
  35 => $TYPE{Horn},
  36 => $TYPE{Money},
  37 => $TYPE{'Class Changer'},
  39 => $TYPE{Amulet},
  40 => $TYPE{Mover},
  41 => $TYPE{Teleporter},
  42 => $TYPE{Creator},
  43 => $TYPE{Skill},
  51 => $TYPE{Detector},
  52 => $TYPE{'Trigger Marker'},
  55 => $TYPE{Marker},
  56 => $TYPE{'Holy Altar'},
  58 => $TYPE{Battleground},
  60 => $TYPE{Jewel},
  62 => $TYPE{'Magic Wall'},
  64 => $TYPE{'Inventory Checker'},
  65 => $TYPE{'Mood Floor'},
  66 => $TYPE{Exit},
  67 => $TYPE{'Floor (Encounter)'},
  68 => $TYPE{'Shop Floor'},
  69 => $TYPE{'Shop Mat'},
  70 => $TYPE{Ring},
  72 => $TYPE{Flesh},
  73 => $TYPE{Inorganic},
  74 => $TYPE{'Skill Tool'},
  81 => $TYPE{Torch},
  82 => $TYPE{Lamp},
  83 => $TYPE{Duplicator},
  85 => $TYPE{Spellbook},
  87 => $TYPE{Cloak},
  88 => $TYPE{'Hazard Floor'},
  90 => $TYPE{Spinner},
  91 => $TYPE{Gate},
  92 => $TYPE{Button},
  93 => $TYPE{Handle},
  94 => $TYPE{Pit},
  95 => $TYPE{Trapdoor},
  98 => $TYPE{'Sign & MagicMouth'},
  99 => $TYPE{Boots},
  100 => $TYPE{Gloves},
  101 => $TYPE{Spell},
  103 => $TYPE{Converter},
  104 => $TYPE{Bracers},
  106 => $TYPE{Savebed},
  109 => $TYPE{'Wand & Staff'},
  110 => $TYPE{Inscribable},
  111 => $TYPE{Scroll},
  112 => $TYPE{Director},
  113 => $TYPE{Girdle},
  116 => $TYPE{'Event Connector'},
  122 => $TYPE{Container},
  130 => $TYPE{'Skill Scroll'},
  138 => $TYPE{Swamp},
  150 => $TYPE{'Shop Inventory'},
  154 => $TYPE{Rune},
  155 => $TYPE{Trap},
  156 => $TYPE{'Power Crystal'},
  158 => $TYPE{Disease},
  163 => $TYPE{'Item Transformer'},
  164 => $TYPE{'Map Script'},
  165 => $TYPE{'Safe ground'},
  999 => $TYPE{Ability}
);

our %TYPENAME = (
  0 => '*NONE*',
  1 => 'PLAYER',
  2 => 'TRANSPORT',
  3 => 'ROD',
  4 => 'TREASURE',
  5 => 'POTION',
  6 => 'FOOD',
  7 => 'POISON',
  8 => 'BOOK',
  9 => 'CLOCK',
  12 => 'LIGHTNING',
  13 => 'ARROW',
  14 => 'BOW',
  15 => 'WEAPON',
  16 => 'ARMOUR',
  17 => 'PEDESTAL',
  18 => 'ALTAR',
  20 => 'LOCKED_DOOR',
  21 => 'SPECIAL_KEY',
  22 => 'MAP',
  23 => 'DOOR',
  24 => 'KEY',
  26 => 'TIMED_GATE',
  27 => 'TRIGGER',
  28 => 'GRIMREAPER',
  29 => 'MAGIC_EAR',
  30 => 'TRIGGER_BUTTON',
  31 => 'TRIGGER_ALTAR',
  32 => 'TRIGGER_PEDESTAL',
  33 => 'SHIELD',
  34 => 'HELMET',
  35 => 'HORN',
  36 => 'MONEY',
  37 => 'CLASS',
  38 => 'GRAVESTONE',
  39 => 'AMULET',
  40 => 'PLAYERMOVER',
  41 => 'TELEPORTER',
  42 => 'CREATOR',
  43 => 'SKILL',
  44 => 'EXPERIENCE',
  45 => 'EARTHWALL',
  46 => 'GOLEM',
  48 => 'THROWN_OBJ',
  49 => 'BLINDNESS',
  50 => 'GOD',
  51 => 'DETECTOR',
  52 => 'TRIGGER_MARKER',
  53 => 'DEAD_OBJECT',
  54 => 'DRINK',
  55 => 'MARKER',
  56 => 'HOLY_ALTAR',
  57 => 'PLAYER_CHANGER',
  58 => 'BATTLEGROUND',
  59 => 'PEACEMAKER',
  60 => 'GEM',
  62 => 'FIREWALL',
  63 => 'ANVIL',
  64 => 'CHECK_INV',
  65 => 'MOOD_FLOOR',
  66 => 'EXIT',
  67 => 'ENCOUNTER',
  68 => 'SHOP_FLOOR',
  69 => 'SHOP_MAT',
  70 => 'RING',
  71 => 'FLOOR',
  72 => 'FLESH',
  73 => 'INORGANIC',
  74 => 'SKILL_TOOL',
  75 => 'LIGHTER',
  76 => 'TRAP_PART',
  77 => 'WALL',
  78 => 'LIGHT_SOURCE',
  79 => 'MISC_OBJECT',
  80 => 'MONSTER',
  81 => 'SPAWN_GENERATOR',
  82 => 'LAMP',
  83 => 'DUPLICATOR',
  84 => 'TOOL',
  85 => 'SPELLBOOK',
  86 => 'BUILDFAC',
  87 => 'CLOAK',
  90 => 'SPINNER',
  91 => 'GATE',
  92 => 'BUTTON',
  93 => 'CF_HANDLE',
  94 => 'HOLE',
  95 => 'TRAPDOOR',
  98 => 'SIGN',
  99 => 'BOOTS',
  100 => 'GLOVES',
  101 => 'SPELL',
  102 => 'SPELL_EFFECT',
  103 => 'CONVERTER',
  104 => 'BRACERS',
  105 => 'POISONING',
  106 => 'SAVEBED',
  107 => 'POISONCLOUD',
  108 => 'FIREHOLES',
  109 => 'WAND',
  110 => 'INSCRIBABLE',
  111 => 'SCROLL',
  112 => 'DIRECTOR',
  113 => 'GIRDLE',
  114 => 'FORCE',
  115 => 'POTION_EFFECT',
  116 => 'EVENT_CONNECTOR',
  121 => 'CLOSE_CON',
  122 => 'CONTAINER',
  123 => 'ARMOUR_IMPROVER',
  124 => 'WEAPON_IMPROVER',
  130 => 'SKILLSCROLL',
  138 => 'DEEP_SWAMP',
  139 => 'IDENTIFY_ALTAR',
  150 => 'MENU',
  154 => 'RUNE',
  155 => 'TRAP',
  156 => 'POWER_CRYSTAL',
  157 => 'CORPSE',
  158 => 'DISEASE',
  159 => 'SYMPTOM',
  160 => 'BUILDER',
  161 => 'MATERIAL',
  162 => 'GPS',
  163 => 'ITEM_TRANSFORMER',
  164 => 'QUEST'
);

our %SPELL = (
  0 => 'magic bullet',
  1 => 'small fireball',
  2 => 'medium fireball',
  3 => 'large fireball',
  4 => 'burning hands',
  5 => 'small lightning',
  6 => 'large lightning',
  7 => 'magic missile',
  8 => 'create bomb',
  9 => 'summon golem',
  10 => 'summon fire elemental',
  11 => 'summon earth elemental',
  12 => 'summon water elemental',
  13 => 'summon air elemental',
  14 => 'dimension door',
  15 => 'create earth wall',
  16 => 'paralyze',
  17 => 'icestorm',
  18 => 'magic mapping',
  19 => 'turn undead',
  20 => 'fear',
  21 => 'poison cloud',
  22 => 'wonder',
  23 => 'destruction',
  24 => 'perceive self',
  25 => 'word of recall',
  26 => 'invisible',
  27 => 'invisible to undead',
  28 => 'probe',
  29 => 'large bullet',
  30 => 'improved invisibility',
  31 => 'holy word',
  32 => 'minor healing',
  33 => 'medium healing',
  34 => 'major healing',
  35 => 'heal',
  36 => 'create food',
  37 => 'earth to dust',
  38 => 'armour',
  39 => 'strength',
  40 => 'dexterity',
  41 => 'constitution',
  42 => 'charisma',
  43 => 'create fire wall',
  44 => 'create frost wall',
  45 => 'protection from cold',
  46 => 'protection from electricity',
  47 => 'protection from fire',
  48 => 'protection from poison',
  49 => 'protection from slow',
  50 => 'protection from paralysis',
  51 => 'protection from draining',
  52 => 'protection from magic',
  53 => 'protection from attack',
  54 => 'levitate',
  55 => 'small speedball',
  56 => 'large speedball',
  57 => 'hellfire',
  58 => 'dragonbreath',
  59 => 'large icestorm',
  60 => 'charging',
  61 => 'polymorph',
  62 => 'cancellation',
  63 => 'confusion',
  64 => 'mass confusion',
  65 => 'summon pet monster',
  66 => 'slow',
  67 => 'regenerate spellpoints',
  68 => 'cure poison',
  69 => 'protection from confusion',
  70 => 'protection from cancellation',
  71 => 'protection from depletion',
  72 => 'alchemy',
  73 => 'remove curse',
  74 => 'remove damnation',
  75 => 'identify',
  76 => 'detect magic',
  77 => 'detect monster',
  78 => 'detect evil',
  79 => 'detect curse',
  80 => 'heroism',
  81 => 'aggravation',
  82 => 'firebolt',
  83 => 'frostbolt',
  84 => 'shockwave',
  85 => 'color spray',
  86 => 'haste',
  87 => 'face of death',
  88 => 'ball lightning',
  89 => 'meteor swarm',
  90 => 'comet',
  91 => 'mystic fist',
  92 => 'raise dead',
  93 => 'resurrection',
  94 => 'reincarnation',
  95 => 'immunity to cold',
  96 => 'immunity to electricity',
  97 => 'immunity to fire',
  98 => 'immunity to poison',
  99 => 'immunity to slow',
  100 => 'immunity to paralysis',
  101 => 'immunity to draining',
  102 => 'immunity to magic',
  103 => 'immunity to attack',
  104 => 'invulnerability',
  105 => 'defense',
  106 => 'rune of fire',
  107 => 'rune of frost',
  108 => 'rune of shocking',
  109 => 'rune of blasting',
  110 => 'rune of death',
  111 => 'marking rune',
  112 => 'build director',
  113 => 'create pool of chaos',
  114 => 'build bullet wall',
  115 => 'build lightning wall',
  116 => 'build fireball wall',
  117 => 'magic rune',
  118 => 'rune of magic drain',
  119 => 'antimagic rune',
  120 => 'rune of transferrence',
  121 => 'transferrence',
  122 => 'magic drain',
  123 => 'counterspell',
  124 => 'disarm',
  125 => 'cure confusion',
  126 => 'restoration',
  127 => 'summon evil monster',
  128 => 'counterwall',
  129 => 'cause light wounds',
  130 => 'cause medium wounds',
  131 => 'cause serious wounds',
  132 => 'charm monsters',
  133 => 'banishment',
  134 => 'create missile',
  135 => 'show invisible',
  136 => 'xray',
  137 => 'pacify',
  138 => 'summon fog',
  139 => 'steambolt',
  140 => 'command undead',
  141 => 'holy orb',
  142 => 'summon avatar',
  143 => 'holy possession',
  144 => 'bless',
  145 => 'curse',
  146 => 'regeneration',
  147 => 'consecrate',
  148 => 'summon cult monsters',
  149 => 'cause critical wounds',
  150 => 'holy wrath',
  151 => 'retributive strike',
  152 => 'finger of death',
  153 => 'insect plague',
  154 => 'call holy servant',
  155 => 'wall of thorns',
  156 => 'staff to snake',
  157 => 'light',
  158 => 'darkness',
  159 => 'nightfall',
  160 => 'daylight',
  161 => 'sunspear',
  162 => 'faery fire',
  163 => 'cure blindness',
  164 => 'dark vision',
  165 => 'bullet swarm',
  166 => 'bullet storm',
  167 => 'cause many wounds',
  168 => 'small snowstorm',
  169 => 'medium snowstorm',
  170 => 'large snowstorm',
  171 => 'cure disease',
  172 => 'cause red death',
  173 => 'cause flu',
  174 => 'cause black death',
  175 => 'cause leprosy',
  176 => 'cause smallpox',
  177 => 'cause white death',
  178 => 'cause anthrax',
  179 => 'cause typhoid',
  180 => 'mana blast',
  181 => 'small manaball',
  182 => 'medium manaball',
  183 => 'large manaball',
  184 => 'mana bolt',
  185 => 'dancing sword',
  186 => 'animate weapon',
  187 => 'cause cold',
  188 => 'divine shock',
  189 => 'windstorm',
  190 => 'sanctuary',
  191 => 'peace',
  192 => 'spiderweb',
  193 => 'conflict',
  194 => 'rage',
  195 => 'forked lightning',
  196 => 'poison fog',
  197 => 'flaming aura',
  198 => 'vitriol',
  199 => 'vitriol splash',
  200 => 'ironwood skin',
  201 => 'wrathful eye',
  202 => 'town portal',
  203 => 'missile swarm',
  204 => 'cause rabies',
  205 => 'glyph'
);


=head1 AUTHOR

 Marc Lehmann <schmorp.de>
 http://home.schmorp.de/

 The source files are part of the CFJavaEditor.

=cut

1
