CREATE TABLE func_import_new_topic(
    link_topic_uuid VARCHAR(40) NOT NULL,
    project_uuid VARCHAR(40) NOT NULL,
    topic_status_uuid VARCHAR(40) NOT NULL,
    tkind VARCHAR NOT NULL,
    title VARCHAR(1024) NOT NULL,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_new_topic_bi_1
BEFORE INSERT ON
    func_import_new_topic
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.link_topic_uuid,
        NEW.project_uuid,
        NEW.topic_status_uuid,
        NEW.tkind,
        NEW.title,
        NEW.uuid
    );

    INSERT INTO
        func_new_topic(
            change_id,
            id,
            link_topic_id,
            project_id,
            topic_status_id,
            tkind,
            title,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('nodes'),
        lt.id,
        p.id,
        ts.id,
        NEW.tkind,
        NEW.title,
        NEW.uuid
    FROM
        nodes ts
    INNER JOIN
        nodes lt
    ON
        lt.uuid = NEW.link_topic_uuid
    INNER JOIN
        nodes p
    ON
        p.uuid = NEW.project_uuid
    WHERE
        ts.uuid = NEW.topic_status_uuid
    ;

    SELECT RAISE(IGNORE);
END;
