CREATE TABLE func_new_task(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    task_status_id INTEGER NOT NULL,
    title VARCHAR(1024) NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_new_task_bi_1
BEFORE INSERT ON
    func_new_task
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.task_status_id,
        NEW.title,
        NEW.change_id
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_task' || x'0A'
                || '  task_status_uuid: ' || s.uuid || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
            FROM
                nodes s
            WHERE
                s.id = NEW.task_status_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO
        func_new_node(
            change_id,
            id,
            parent_id,
            name,
            kind
        )
    SELECT
        NEW.change_id,
        NEW.id,
        ts.project_id,
        NEW.id,
        'task'
    FROM
        task_status ts
    WHERE
        ts.id = NEW.task_status_id
    ;

    INSERT INTO tasks(
        id,
        task_status_id,
        title,
        change_id
    )
    VALUES(
        NEW.id,
        NEW.task_status_id,
        NEW.title,
        NEW.change_id
    );

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_task'
    );

    INSERT INTO
        node_deltas(
            id,
            change_id,
            node_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id
    );

    INSERT INTO
        task_deltas(
            id,
            task_status_id,
            task_id,
            new,
            title,
            change_id
        )
    VALUES(
        currval('deltas'),
        NEW.task_status_id,
        NEW.id,
        1,
        NEW.title,
        NEW.change_id
    );

    SELECT RAISE(IGNORE);
END;
