package App::bif::update::project;
use strict;
use warnings;
use Bif::Mo;
use DBIx::ThinSQL qw/sq qv/;
use IO::Prompt::Tiny qw/prompt/;

our $VERSION = '0.1.5_5';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;

    $dbw->txn(
        sub {
            my $info =
              $self->get_project( $opts->{id} ? $opts->{id} : $opts->{path} );

            $self->start_work(
                node_id       => $info->{id},
                start         => time,
                start_comment => "update project",
                billable      => 1,
                save          => 1,
            );

            my ( $status_ids, $invalid );
            if ( $opts->{status} ) {

                ( $status_ids, $invalid ) =
                  $dbw->status_ids( $info->{id}, 'project', $opts->{status} );

                return $self->err( 'InvalidStatus',
                    'unknown status(s): ' . join( ', ', @$invalid ) )
                  if @$invalid;
            }

            if ( $opts->{reply} ) {
                my $uinfo =
                  $self->get_change( $opts->{reply}, $info->{first_change_id} );
                $opts->{parent_uid} = $uinfo->{id};
            }
            else {
                $opts->{parent_uid} = $info->{first_change_id};
            }

            $opts->{message} ||=
              $self->prompt_edit( opts => $self, id => $info->{id} );

            $opts->{change_id} =
              $self->new_change( parent_id => $opts->{parent_uid}, );

            $dbw->xdo(
                insert_into => 'func_update_project',
                values      => {
                    id                => $info->{id},
                    change_id         => $opts->{change_id},
                    title             => $opts->{title},
                    project_status_id => $status_ids->[0],
                }
            );

            $self->stop_work(
                stop    => time,
                restore => 1,
            );

            $self->save_work(
                node_id   => $info->{id},
                change_id => $opts->{change_id},
            );

            $self->end_change(
                id               => $opts->{change_id},
                action_format    => "update project $info->{path} (%s)",
                action_node_id_1 => $info->{id},
                message          => $opts->{message},
            );

        }
    );

    return $self->ok('ChangeProject');
}

1;
__END__

=head1 NAME

=for bif-doc #modify

bif-update-project - update a project

=head1 VERSION

0.1.5_5 (2015-08-13)

=head1 SYNOPSIS

    bif update project ID [STATUS] [OPTIONS...]

=head1 DESCRIPTION

Add a comment to a project, possibly setting a new status at the same
time. Valid values for a project's status depend on the project it is
associated with. The list of valid status for a project can be found
using L<bif-list-status>(1).

=head1 ARGUMENTS

=over

=item PATH

A project PATH. Required.

=item STATUS

The new status for the node.

=back

=head1 OPTIONS

=over

=item --title, -t

The new title for the node.

=item --message, -m

The message describing this issue in detail. If this option is not used
an editor will be invoked.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

