CREATE TABLE topic_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    topic_id INTEGER NOT NULL,
    parent_id INTEGER,
    name VARCHAR(1024), -- TODO same constraint as topics table
    FOREIGN KEY(id) REFERENCES deltas(id) ON DELETE CASCADE,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(topic_id) REFERENCES topics(id) ON DELETE CASCADE,
    FOREIGN KEY(parent_id) REFERENCES topics(id) ON DELETE CASCADE
);


CREATE TRIGGER
    topic_deltas_ai_1
AFTER INSERT ON
    topic_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.topic_id,
        NEW.parent_id,
        NEW.name
    );

    UPDATE
        topics
    SET
        last_change_id = NEW.change_id
    WHERE
        id = NEW.topic_id
    ;


    INSERT OR IGNORE INTO
        topics_tomerge(
            topic_id
        )
    VALUES(
        NEW.topic_id
    );


    UPDATE
        topics_tomerge
    SET
        parent_id = parent_id + (NEW.parent_id IS NOT NULL),
        name = name + (NEW.name IS NOT NULL)
    WHERE
        topic_id = NEW.topic_id
    ;

    INSERT INTO
        change_topics(
            change_id,
            topic_id
        )
    VALUES(
        NEW.change_id,
        NEW.topic_id
    );

END;


CREATE TRIGGER
    topic_deltas_ad_1
AFTER DELETE ON
    topic_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.id,
        OLD.name
    );

    INSERT OR IGNORE INTO
        topics_tomerge(topic_id)
    VALUES
        (OLD.topic_id)
    ;

    UPDATE
        topics_tomerge
    SET
        parent_id = parent_id + (OLD.parent_id IS NOT NULL),
        name = name + (OLD.name IS NOT NULL)
    WHERE
        topic_id = OLD.topic_id
    ;

END;
