package App::bif::list::tables;
use strict;
use warnings;
use Bif::Mo;
use DBIx::ThinSQL qw/case count sum/;

our $VERSION = '0.1.5_4';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;

    my $data = $db->xarrayrefs(
        select => [
            'sm.name AS name',
            sum(
                case (
                    when => 'sm2.type="index"',
                    then => 1,
                    else => 0,
                )
              )->as('indexes'),
            sum(
                case (
                    when => 'sm2.type="trigger"',
                    then => 1,
                    else => 0,
                )
              )->as('triggers'),
            sum(
                case (
                    when =>
                      'sm2.type="trigger" AND sm2.sql LIKE "%BEFORE INSERT%"',
                    then => 1,
                    else => 0,
                )
              )->as('bi'),
            sum(
                case (
                    when =>
                      'sm2.type="trigger" AND sm2.sql LIKE "%AFTER INSERT%"',
                    then => 1,
                    else => 0,
                )
              )->as('ai'),
            sum(
                case (
                    when =>
                      'sm2.type="trigger" AND sm2.sql LIKE "%BEFORE UPDATE%"',
                    then => 1,
                    else => 0,
                )
              )->as('bu'),
            sum(
                case (
                    when => 'sm2.type="trigger" AND sm2.sql LIKE
                    "%AFTER UPDATE%"',
                    then => 1,
                    else => 0,
                )
              )->as('au'),
            sum(
                case (
                    when =>
                      'sm2.type="trigger" AND sm2.sql LIKE "%BEFORE DELETE%"',
                    then => 1,
                    else => 0,
                )
              )->as('bd'),
            sum(
                case (
                    when =>
                      'sm2.type="trigger" AND sm2.sql LIKE "%AFTER DELETE%"',
                    then => 1,
                    else => 0,
                )
            )->as('ad'),
        ],
        from      => 'sqlite_master sm',
        left_join => 'sqlite_master sm2',
        on        => 'sm2.tbl_name = sm.tbl_name',
        where     => { 'sm.tbl_name !LIKE' => 'func%', 'sm.type' => 'table' },
        group_by  => 'sm.name',
        order_by  => 'sm.name',
    );

    $self->start_pager( scalar @$data );

    print $self->render_table( ' l  r  r  r  r  r  r  r  r ',
        [qw/Table Indexes Triggers BI AI BU AU BD AD/], $data );

    return $self->ok('ListPlans');
}

1;
__END__

=head1 NAME

=for bif-doc #devadmin

bif-list-tables - list tables present in database

=head1 VERSION

0.1.5_4 (2015-08-04)

=head1 SYNOPSIS

    bif list tables

=head1 DESCRIPTION

The B<bif-list-tables> command lists the tables present in the
database, along with their index and trigger counts.

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

