CREATE VIEW
    topic_path
AS SELECT
    t.id AS id,
    t.kind AS kind,
    COALESCE(
        SUBSTR(tid.uuid,1,8),
        pi.path || '/' || SUBSTR(t.uuid,1,8),
        pp.path,
        pt.path || '/' || SUBSTR(t.uuid,1,8),
        '*UNKNOWN*'
        ) AS path
FROM
    topics t

-- IDENTITY
LEFT JOIN
    identities id
ON
    id.id = t.id
LEFT JOIN
    topics tid
ON
    tid.id = id.id

-- ISSUE
LEFT JOIN
    issues i
ON
    i.id = t.id
LEFT JOIN
    issue_status ist
ON
    ist.id = i.issue_status_id
LEFT JOIN
    projects pi
ON
    pi.id = ist.project_id

-- PROJECT

LEFT JOIN
    projects pp
ON
    pp.id = t.id

-- TASK
LEFT JOIN
    tasks ta
ON
    ta.id = t.id
LEFT JOIN
    task_status ts
ON
    ts.id = ta.task_status_id
LEFT JOIN
    projects pt
ON
    pt.id = ts.project_id

;
