package WebService::Mattermost::V4::API::Object::Role::Value;

# ABSTRACT: Adds a "value" field to an object.

use Moo::Role;
use Types::Standard qw(Maybe Str);

################################################################################

has value => (is => 'ro', isa => Maybe[Str], lazy => 1, builder => 1);

################################################################################

sub _build_value {
    my $self = shift;

    return $self->raw_data->{value};
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Role::Value - Adds a "value" field to an object.

=head1 VERSION

version 0.27

=head1 DESCRIPTION

Attach a value to a v4::Object object.

=head2 ATTRIBUTES

=over 4

=item C<value>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
