use strict;
use warnings;
package MetaCPAN::Client::DownloadURL;
# ABSTRACT: A Rating data object
$MetaCPAN::Client::DownloadURL::VERSION = '1.018000';
use Moo;

with 'MetaCPAN::Client::Role::Entity';

my @known_fields = qw<
    date download_url status version
>;

foreach my $field (@known_fields) {
    has $field => (
        is      => 'ro',
        lazy    => 1,
        default => sub {
            my $self = shift;
            return $self->data->{$field};
        },
    );
}

sub _known_fields { return \@known_fields }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

MetaCPAN::Client::DownloadURL - A Rating data object

=head1 VERSION

version 1.018000

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head2 date

=head2 download_url

=head2 status

=head2 version

=head1 AUTHORS

=over 4

=item *

Sawyer X <xsawyerx@cpan.org>

=item *

Mickey Nasriachi <mickey@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Sawyer X.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
