---
title: Raku GTK+ Design
#nav_title: Examples
nav_menu: default-nav
sidebar_menu: design-sidebar
layout: sidebar
---

# Design of the Raku modules

## Introduction

Despite some thinking about the setup, a lot of changes already happened. See the history on the Home page. In time, the following notes crystallized in the 'making of' the set of Raku packages. First what became clear is that there was a need to separate the modules in several packages like Gtk has done. There is glib, gobject, gdk, gtk, cairo, pango, etc. It was important to keep the same separation among the Raku packages.
All these libraries come from **Gnome** and the Gtk version to adhere to was 3. So the Raku packages became **Gnome::Glib**, **Gnome::GObject**, **Gnome::Gdk3** and **Gnome::Gtk3**. Note that gdk is also following the same version as gtk.
Now it is possible to extend the lot with new packages for cairo and pango like **Gnome::Cairo** and **Gnome::Pango**. These packages are not yet available so every use of the subs from these libraries are not yet supported by the Raku libraries.

An extension to the **Gnome::Gtk3** package is available to handle *XML* files generated by *Glade*, a user interface designer program. It is called **Gnome::Gtk3::Glade**. All things can be programmed using **Gnome::Gtk3** and **XML** alone but there are helpful ways to connect to signals for example.

A package is added to make the native libraries available to the other packages. This package is called **Gnome::N**. There is also a bit of debugging added to that package. This may change later to be defined in another package. E.g. *Gnome::T* for test user interface purposes. At the moment UI testing is possible in **Gnome::Gtk3::Glade**.


## Errors and crashes
Some errors are mentioned by GTK+ on the command line. These are important messages which can lead up to other problems, even crashes.

When an exception is thrown, the library captures it to process and create another exception to be (re)thrown. Sometimes it behaves odd and most of the errors end up in **MoarVM panic: Internal error: Unwound entire stack and missed handler**. I found that these occasions are always happening within callback handlers where Raku code is run from C. This needs a rewrite to handle things more elegantly.

Other times it ends in just a plain crash. Some of the crashes are happening within GTK and cannot be captured by Raku. One of those moments are the use of GTK calls without initializing GTK with `gtk_init()`.

A few measures are implemented to help a bit to prevent problems;

* The failure to initialize GTK on time (in most cases) is solved by using an initialization flag which is checked in module **Gnome::GObject::Object** which almost all modules inherit from. This way, the user never has to initialize GTK.
* To see the original exception and messages leading up to the crash a debug flag in the class **Gnome::N** can be set to show these messages which might help solving your problems. To use it write;
  ```
  use Gnome::N::X;
  ...
  Gnome::N::debug(:on);
  ... lines leading up to crash ...
  Gnome::N::debug(:!on);
  ```
  or you can use `Gnome::N::debug(:off);` to turn it off.
