use v6;
use Semi-xml;

package TMap:ver<0.2.0> {

  role Role {

    # Association parent
    #
    has $.a-parent;
    has $.type;
    has $.topic-ref;

    #---------------------------------------------------------------------------
    # Initialize variant object
    #
    method initialize ( $association where $association.name eq 'association' ) {

      my $topic = $association.get('parent');
      $!a-parent = $association;
      self.check-item-identifiers;
      self.set-reifier($topic);

      for self.nodes -> $r-node {
        if $r-node ~~ XML::Element {
          given $r-node.name {

            # Get the type of this role
            #
            when 'type' {

              for $r-node.nodes -> $t-node {
                if $t-node ~~ XML::Element
                   and $t-node.name eq 'topicRef'
                   and $t-node.attribs<href> {

                  my $tref = self.modify-topic-reference(
                    self.get('filename'),
                    $t-node.attribs<href>
                  );

                  $!type = $topic.get-topic-from-id($tref);
say "Role type of {$association.get('type').attribs<id>}: ", $!type.attribs<id> if ?$!type;

                  # Only one type/role
                  #
                  last;
                }
              }
            }

            when 'topicRef' {

              my $ref = $r-node.attribs<href>;
              if ?$ref {
                my $tref = self.modify-topic-reference(
                  self.get('filename'),
                  $ref
                );

                $!topic-ref = $topic.get-topic-from-id($tref);
say "Role topic ref of {self.name}: ", $!topic-ref.attribs<id> if ?$!topic-ref;
                last;
              }
            }
          }
        }
      }
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'parent' ) { return $!a-parent; }
    multi method get ( 'type' ) { return $!type; }
    multi method get ( 'topicref' ) { return $!topic-ref; }
  }
}
