# OWL - Web ontology language

## Description

Package to manipulate OWL information. It is a library with calls according to
the functional description in the OWL documents.

## Introduction

OWL is described by a number of documents. See ...

This program implements OWL 2 DL - the subset of OWL 2 with favorable
computational properties. This is described in detail in OWL 2 Web Ontology
Language Structural Specification and Functional-Style Syntax (Second Edition).

An OWL 2 ontology is a formal description of a domain of interest. OWL 2
ontologies consist of the following three different syntactic categories:

* Entities, such as classes, properties, and individuals, are identified by
  IRIs. They form the primitive terms of an ontology and constitute the basic
  elements of an ontology. For example, a class a:Person can be used to
  represent the set of all people. Similarly, the object property a:parentOf can
  be used to represent the parent-child relationship. Finally, the individual
  a:Peter can be used to represent a particular person called "Peter".

* Expressions represent complex notions in the domain being described. For
  example, a class expression describes a set of individuals in terms of the
  restrictions on the individuals' characteristics.

* Axioms are statements that are asserted to be true in the domain being
  described. For example, using a subclass axiom, one can state that the class
  a:Student is a subclass of the class a:Person.

## Divertions

* The IRIs supposed to be absolute only. There are, at least for the file://
  protocol, ways to specify a relative path to other ontologies. Here I will
  support that until proven wrong.

* The calls to methods can handle more declarations, assertions etc in one go.
  A hash cannot be used because of the fact that hashes will not keep the same
  order as it is typed. Therefore an array of pairs is used to enter most data.

* The names of methods in OWL are written in camelback notation. Here its all
  lowercase and dashes between words. This is also done for some types of
  arguments. Examples are
  
  OWL                   Program
  ----------            ----------
  Declaration()         declaration()
  ClassAssertion()      class-assertion()
  NamedIndividual       named-individual
  owl:topObjectProperty owl:top-object-property

* The notation of a prefix in these applications and library is different than
  of the OWL standard. In OWL an IRI is like  <prefix> ':' <local>. When there
  is a default prefix there must at least be a ':' present. Here I also remove
  the colon when not needed. This is like OWL/XML.

  Examples;
  
  OWL                   Program
  ----------            ----------
  :Person               Person
  :Mary                 Mary
  owl:Thing             owl:thing

* In OWL order of declarations before other statements is not relevant. Also
  circular imports is acceptable. This program will not support that.
  Declarations must come before other statements so checks can be done
  immediatly. Circular loading will not be possible because of this.

## Ideas and Todo

* [ ] Read an ontology

*     Generate output for
  [ ] OWL functional descriptions
  [ ] XML
  [ ] Records in MongoDB

* [ ] Build a reasoner

* OWL::Ontology
  [x] OWL::IRI iri
  [x] OWL::IRI version
  [ ] import

  [x] Hash $.axioms:
        key                     iri string
        value                   OWL::Axiom

  [x] declaration()             OWL::Declaration is OWL::Axiom
  [x]   class:                  OWL::Class
                                        is OWL::Entity
                                        is OWL::ClassExpression
  [x]   object-property:        OWL::ObjectProperty
                                        is OWL::ObjectPropertyExpression
                                        is OWL::Entity
  [x]   data-property           OWL::DataProperty is OWL::Entity
  [x]   annotation-property     OWL::AnnotationProperty is OWL::Entity
  [x]   data-type               OWL::DataType is OWL::Entity
  [x]   named-individual        OWL::NamedIndividual is OWL::Entity

  [x] sub-class-of()            OWL;:SubClassOf is OWL::ClassAxiom
                                OWL::ClassAxiom is OWL::Axiom
  [ ] equivalent-classes()
  [ ] disjoint-classes()
  [ ] disjoint-union()

  [ ] class-assertion()

* OWL::Entity
* OWL::Axiom
* OWL::IRI
* OWL::Annotation


## Bugs



## Changes

* 0.1.0 Start thinking. Always do that before coding.

## Aurhor

Marcel.Timmerman

## License

Released under [Artistic License 2.0](http://www.perlfoundation.org/artistic_license_2_0).


