# $Id$

package WWW::Vox::Auth;
use strict;
use warnings;

sub new {
    my $class = shift;
    return bless {}, $class;
}

sub prepare_request_obj {}

sub prepare_http_request {}


1;

__END__

=head1 NAME

WWW::Vox::Auth - superclass for Vox authenticators

=head1 SYNOPSIS

    use WWW::Vox;
    use WWW::Vox::Auth::Foo;

    my $auth = WWW::Vox::Auth::Foo->new( foo => 'bar' );
    my $vox = WWW::Vox->new( auth => $auth );

    my $result = $vox->request(...);

=head1 DESCRIPTION

WWW::Vox::Auth is the parent class for WWW::Vox authenticator classes.
Implementors can override its methods to provide a way to authenticate to the
Vox service.

The only provided method of authentication is with Vox login cookies. See
L<WWW::Vox::Auth::Cookies>.

=head1 INTERFACE

=head2 WWW::Vox::Auth->new(%params)

Override this method to accept and store the parameters your authenticator
requires to authenticate Vox requests.

=head2 $auth->prepare_request_obj($object)

Override this method to alter a JSON request as necessary for your
authentication method. C<$object> will be a Perl hashref representing the full
JSON request, ready to send to Vox.

=head2 $auth->prepare_http_request($request)

Override this method to alter an HTTP request instance as necessary for your
authentication method. C<$request> will be an HTTP::Request object.

=head1 DIAGNOSTICS

No errors are generated by WWW::Vox::Auth itself.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to C<bug-www-vox@rt.cpan.org>, or
through the web interface at L<http://rt.cpan.org>.

=head1 AUTHOR

Mark Paschal  C<< <mark@sixapart.com> >>

=head1 LICENCE AND COPYRIGHT

Copyright 2006 Six Apart, Ltd. C<< <cpan@sixapart.com> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
