# NAME

Test::Skeleton::Generator - Create a skeleton for a test file based on an existing module

# SYNOPSIS

simply

    generate_perl_test_skeleton -p ./lib/Module.pm -t t/test.t

or

    perl -MTest::Skeleton::Generator -e 'Test::Skeleton::Generator->new' ./lib/Module.pm ./t/test.t

Or maybe:

    use Test::Skeleton::Generator;
    my $generator = Test::Skeleton::Generator->new( {
        package_file => './lib/Some/Module.pm',
        skip_private_methods => 1,
    } );
    my $test_file_content = $generator->get_test;

# DESCRIPTION

Test::Skeleton::Generator is supposed to be used from within your editor to quickly
generate skeletons/stubs for a test file that is will test the module you are
currently working on.

So suppose you are working on the file `./lib/Foo/Bar.pm` which hasn't got any tests
yet. Now you simply press a keyboard shortcut or click an icon (if you really have to)
and your editor will simply call perl like in the SYNOPSIS above to generate a .t file
in your ./t/ directory. You don't have to write the boiler-plate code yourself.

Basically, there are two ways to use this module:

The simplest way to use this module is from the command line. Simply use the distributed
script `generate_perl_test_skeleton`. See its documentation for more details.

But if you find it useful, you can also use it from another script or module which
will give you more option and lets you handle the content of the future test file yourself.

## Generated Code

The code generated by this module, basically looks like this:

    use Test::Most;

    BEGIN {
        use_ok( 'Your::Module' );
    }

    test_sub1();
    test_sub2();

    done_testing;

    sub get_object {
        return Your::Module->new( @_ );
    }

    sub test_sub1 {
        can_ok 'Your::Module', 'sub1';
    }

    sub test_sub2 {
        can_ok 'Your::Module', 'sub2';
    }

So for each subroutine in your original module, you get a subroutine in the generated
test code that is supposed to test the original sub's code. You also get a function
that I find very handy, that you can call to get an object instance of your package.
I should probably add an option to Test::Skeletion::Generator to suppress the generation
of that sub. But you can also simply delete it, of course.

# SEE ALSO

[Test::StubGenerator](https://metacpan.org/pod/Test::StubGenerator) is a module that is very similar to this one. It uses [PPI](https://metacpan.org/pod/PPI)
to analyze a given module and it will then generate a test stub. It even has an
option to run [Perl::Tidy](https://metacpan.org/pod/Perl::Tidy) on the generated test code. The only thing I don't
like about it is that it won't generate a test subroutine for each subroutine in
the module.

# LICENSE

Copyright (C) Manni Heumann.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

# AUTHOR

Manni Heumann <github@lxxi.org>
