/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.LinkedList;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;

public class SingleEntryAsyncQueue {
    private LinkedList q = new LinkedList();
    private boolean waitingThreadsShouldThrow = false;
    private static int defaultTimeout = 1800;
    private int timeout = defaultTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.waitingThreadsShouldThrow = true;
        if (this.q.isEmpty()) {
            this.q.add("dummy_to_wake_up_getting_thread____(if_there_is_one)");
        } else {
            this.q.clear();
        }
        SingleEntryAsyncQueue singleEntryAsyncQueue = this;
        synchronized (singleEntryAsyncQueue) {
            this.notifyAll();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized Object get() {
        int retries = 0;
        while (this.q.isEmpty()) {
            if (this.q.isEmpty() & retries >= this.timeout) {
                throw new SeleniumCommandTimedOutException();
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                continue;
            }
            ++retries;
        }
        this.verifyThisQueueWasNotHungAndThenCleared("get");
        Object thing = ((OwnerAndDataPair)this.q.removeFirst()).getData();
        this.notifyAll();
        return thing;
    }

    private void verifyThisQueueWasNotHungAndThenCleared(String methodCalled) {
        if (this.waitingThreadsShouldThrow) {
            throw new RuntimeException("called queue." + methodCalled + "() when queue.clear() called");
        }
    }

    public int size() {
        return this.q.size();
    }

    public String toString() {
        return this.q.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(Object thing) {
        this.verifyThisQueueWasNotHungAndThenCleared("put");
        this.q.addLast(new OwnerAndDataPair("owner stub", thing));
        this.notifyAll();
        SingleEntryAsyncQueue singleEntryAsyncQueue = this;
        synchronized (singleEntryAsyncQueue) {
            while (((OwnerAndDataPair)this.q.getFirst()).getData() != thing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.verifyThisQueueWasNotHungAndThenCleared("put");
            }
        }
    }

    public static void setDefaultTimeout(int defaultTimeout) {
        SingleEntryAsyncQueue.defaultTimeout = defaultTimeout;
    }

    class OwnerAndDataPair {
        private Object owner;
        private Object data;

        public OwnerAndDataPair(Object ownerParm, Object dataParm) {
            this.owner = ownerParm;
            this.data = dataParm;
        }

        public Object getData() {
            return this.data;
        }

        public Object getOwner() {
            return this.owner;
        }

        public String toString() {
            return "" + this.data + " (from " + this.owner + ")";
        }
    }
}

