package Business::LetterWriter;

use strict;
use warnings;
use JSON;
use OpenAPI::Client::OpenAI;

our $VERSION = '0.02';

sub get_one_answer_from_new_llm {
    my ($request, $body_builder) = @_;
    
    $body_builder //= sub {
        return {
            model    => 'gpt-4o-mini',
            messages => [ { role => 'user', content => $request } ],
            temperature => 0,
            max_tokens  => 1000,
        };
    };

    my $client = OpenAPI::Client::OpenAI->new();
    my $body = $body_builder->($request);
    my $tx = $client->createChatCompletion({ body => $body });

    my $response_data = $tx->res->json;
    return $response_data->{choices}[0]{message}{content};
}

sub get_hashref_from_template_file{
	my $template_fname = shift;
	open my $template_fh, "<:encoding(UTF-8)", $template_fname;
	my $template = do{local $/; <$template_fh>};
	my @arr = split /\n{2}/, $template;
	my $counter = 1;
	my %return_hash = ();
	foreach my $para (@arr){
		my $key = "paragraph_" . $counter++;
		$return_hash{$key} = $para;
	}
	return \%return_hash;
}

sub out_parts{
	my $text_hashref = shift;
	my $parms = shift;
	my $fn = $parms->{outfn};
	my $preserved_parts = $parms->{preserved_parts};
	open my $outfh, ">:encoding(UTF-8)", $fn;
	foreach my $key (qw(paragraph_1 paragraph_2 paragraph_3 paragraph_4 paragraph_5 paragraph_6)){
		print $outfh $text_hashref->{$key}, "\n\n";
		print $text_hashref->{$key}, "\n\n";
	}
	close $outfh;
}

sub signature{
    return "John Doe";
}

=pod
USAGE:
    use strict;
    use JSON;
    use lib '../Business-LetterWriter/lib/';
    use Business::LetterWriter;

    my $template_href = Business::LetterWriter::get_hashref_from_template_file("./CL_TEMPLATE_DE.txt");

    my $json = JSON->new->utf8(0)->pretty(1);
    my $letter_template_json = $json->encode($template_href);

    my $request 
        = "Here is a template letter in the JSON format: " . $letter_template_json .
        " Tailor each part to make the whole letter friendier less formal and very short. Return the tailored version of the letter strictly in JSON format. Do not explain anything." ;
    my $llm_answer_raw = Business::LetterWriter::get_one_answer_from_new_llm($request);
    my $template_href = $json->decode($llm_answer_raw);
    my %parms = (outfn => "outtest.txt");
    Business::LetterWriter::out_parts($template_href, \%parms);
=cut

1;
