#! perl -w
# Copyright: 2001-2003 The Perl Foundation.  All Rights Reserved.
# $Id: config_h.pl,v 1.10 2004/02/28 12:56:53 leo Exp $

=head1 NAME

config/gen/config_h.pl - Configuration Header

=head1 DESCRIPTION

Generates F<include/parrot/config.h> with platform-specific
configuration values.

=cut

package Configure::Step;

use strict;
use vars qw($description @args);
use Parrot::Configure::Step ':gen';

$description="Generating config.h...";

@args=('define');

sub runstep {
  my $define = shift;
  genfile('config/gen/config_h/config_h.in', 'include/parrot/config.h',
  commentType => '/*',
  ignorePattern => 'PARROT_CONFIG_DATE');

  my $hh = "include/parrot/has_header.h";
  open(HH, ">$hh.tmp")
    or die "Can't open has_header.h: $!";

  print HH qq(
    /*
    ** !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
    **
    ** This file is generated automatically by Configure.pl
    */
  );

  for(sort(Configure::Data->keys())) {
    next unless /i_(\w+)/;
    if(Configure::Data->get($_)) {
      print HH "#define PARROT_HAS_HEADER_\U$1 1\n"
    }
    else {
      print HH "#undef  PARROT_HAS_HEADER_\U$1\n";
    }
  }

  print HH "#define BUILD_OS_NAME \"$^O\"\n";

  if ($define) {
    my @vals = split /,/, $define;
    print HH <<EOF;

/* defines from commandline */

EOF
    for (@vals) {
      print HH "#define PARROT_DEF_" .uc($_) , " 1\n";
    }

  }

  close HH;

  move_if_diff("$hh.tmp", $hh);
}

1;
