
BEGIN
{
  unless ( $ENV{ AUTHOR_TESTING } )
  {
    print qq{1..0 # SKIP these tests are for testing by the author\n};
    exit;
  }
}

# Template for writing a new tests

use 5.006;
use strict;
use warnings;
use feature 'say';

use Data::Dumper;
use Data::Printer;
$Data::Dumper::Maxdepth = 3;

use DateTime;
use DateTime::Format::RFC3339;
my $formatter = DateTime::Format::RFC3339->new();

use WebService::Google::Client;

use Test::More;

=head2 USAGE

To run in the local directory assuming gapi.json present 
  C<prove -I../../../lib events.t -w -o -v>

=cut

my $default_file = $ENV{ 'GOOGLE_TOKENSFILE' } || '../../../gapi.json';
my $user         = $ENV{ 'GMAIL_FOR_TESTING' } || '';                     ## TODO - populate from gapi.json if needed

plan( skip_all => 'No user configuration - set $ENV{GOOGLE_TOKENSFILE}' ) unless -e $default_file;


# my $user = $ENV{'GMAIL_FOR_TESTING'} || 'fablab61ru@gmail.com';

if ( -e $default_file )
{
  my $gapi = WebService::Google::Client->new( debug => 0 );

  $gapi->auth_storage->setup( { type => 'jsonfile', path => $default_file } );
  $gapi->auth_storage->setup( { type => 'jsonfile', path => $default_file } ) || croak( $! );
  my $aref_token_emails = $gapi->auth_storage->storage->get_token_emails_from_storage;
  $user = $aref_token_emails->[0] unless $user;    ## default to the first user if none defined yet
  $gapi->user( $user );
  note( "default_file = $default_file" );
  note( "user = $user" );
  my $calendarId = 'primary';                      # same as $user
  my @event_ids;
  my $maxResults = 2;
  ;                                                # how much events will be added to test right filtration by  maxResults in Events->list

  subtest 'Events->insert' => sub {
    ## add some 2-hours events
    my $t;

    for ( my $i = 1; $i <= $maxResults; $i++ )
    {

      print $i;

      $t = $gapi->Calendar->Events->insert( {
        calendarId => $calendarId,
        options    => {
          start => { dateTime => $formatter->format_datetime( DateTime->now() ) },
          end   => { dateTime => $formatter->format_datetime( DateTime->now()->add_duration( DateTime::Duration->new( hours => 2 ) ) ) },
          summary => "WebService::Google::Client test event number" . $i
        }
      } )->json;

      push @event_ids, $t->{ id };
    }

    note( "Inserted event ids: " . Dumper \@event_ids );

    # test last response structure
    ok( ref( $t ) eq 'HASH',                 "returned a HASHREF" );
    ok( $t->{ kind } eq 'calendar#event',    "kind seems like OK - calendar#event" );
    ok( $t->{ organizer }{ email } eq $user, "organizer user email is OK" );
    ok( $t->{ creator }{ email } eq $user,   "creator email is OK" );
  };
  note( "Sleeping for 10 sec - open https://calendar.google.com/calendar/ to watch the action" );
  sleep( 10 );

=pod
    subtest 'Events->get' => sub {
        my $t = $gapi->Calendar->Events->get(
            { calendarId => $calendarId, eventId => $event_ids[0] } )->json;
        note(Dumper $t );
        ok( ref($t) eq 'HASH', "returned an ARRAY" );
        ok(
            $t->{kind} eq 'calendar#event',
            "kind seems like OK - calendar#event"
        );
    };
=cut

  subtest 'Events->list' => sub {
    my $t;

    for ( my $i = 2; $i <= $maxResults; $i++ )
    {    # working for not every email - possible bug
      $t = $gapi->Calendar->Events->list( { calendarId => $calendarId, options => { maxResults => $i } } )->json;
      note( Dumper $t );
      ok( scalar @{ $t->{ items } } == $i, "maxResults =" . $i );
    }

    # test last response structure
    # warn Dumper $t;
    ok( ref( $t ) eq 'HASH',                          "returned a single item" );
    ok( $t->{ kind } eq 'calendar#events',            "kind seems like OK - calendar#events" );
    ok( $t->{ items }[0]{ kind } eq 'calendar#event', "kind seems like OK - calendar#events" );
  };

  note( "Inserted event ids: " . Dumper \@event_ids );
  note( "Sleeping for 10 sec - open https://calendar.google.com/calendar/ to watch the action" );
  sleep( 10 );
  subtest 'Events->delete' => sub {
    foreach my $id ( @event_ids )
    {
      my $r2 = $gapi->Calendar->Events->delete( { calendarId => $calendarId, eventId => $id } );
      note( Dumper $r2 );
    }
    ok( 1 == 1, 'Just a mark testing 1==1' );
  };


  # delete one event from @event_ids

=pod
    subtest 'Events->delete' => sub {
        my $r1 =
          $gapi->Calendar->Events->list( { calendarId => $calendarId } )->json;
        my $n1        = scalar @{ $r1->{items} };
        my $id_to_del = $event_ids[0];                     # may do rand
        my $r2        = $gapi->Calendar->Events->delete(
            { calendarId => $calendarId, eventId => $id_to_del } );
        my $r3 =
          $gapi->Calendar->Events->list( { calendarId => $calendarId } )->json;
        my $n2 = scalar @{ $r3->{items} };
        ok( $r2->code == 204, 'response code is 204' );
        ok( $n2 eq $n1 - 1,   'items minus 1' );
    };
=cut

}


done_testing();
