#!/usr/bin/perl -w

use strict;
use Data::Dumper;
use Carp;
use blib;
use Test::More tests => 3;
#use SOAP::Lite ( +trace => 'all', readable => 1, outputxml => 1, );

BEGIN { use_ok( 'SOAP::Lite::Simple::DotNet' ); }

# Create out object with basic SOAP::Lite config stuff
my $obj = SOAP::Lite::Simple::DotNet->new({
	uri => 'http://www.webserviceX.NET',
	proxy => 'http://www.webservicex.net/convertMetricWeight.asmx',
	xmlns => 'http://www.webserviceX.NET/',
	timeout => '2',
});

my $xml = "
<MetricWeightValue _value_type='double'>10.1</MetricWeightValue>
<fromMetricWeightUnit>kilogram</fromMetricWeightUnit>
<toMetricWeightUnit>microgram</toMetricWeightUnit>";

# Call the SOAP
if( $obj->fetch({
	'method' => 'ChangeMetricWeightUnit',
	'xml' => $xml,
}) ) {
	ok(1,"fetch() - no errors");

	my $xml_res = $obj->results_xml();
	my $nodes = $xml_res->findnodes("//ChangeMetricWeightUnitResult");

	if(my $node = $nodes->get_node(1)) {
		my $value = $node->findvalue('.',$node);
		is('10100000000',$value,'got conversion expected');
	} else {
		ok(0,'could not get result from .Net data returned');
	}
} else {
	ok(0,'Could not fetch data');
	ok(0,'Error:' . $obj->error());
}

