package NmapParser::Host::OS; 
use base NmapParser::Host;

my @ISA = "Host";
  
use vars qw($AUTOLOAD);

sub new {
    my $pkg = shift;
    my $self = bless {}, $pkg;
    $self->initialize(@_);
    return $self;
}

sub initialize {
    my $self = shift;
    $self->SUPER::initialize(shift, shift);
    $self->{OS} = shift;
}

sub all_names{ 
	
	my ($self) = @_;
	my @names;
	foreach ( @{$self->{stem}{osmatch}} ) { push(@names,$_->{name});}	
	return @names;		
}

sub name { 
	my ($self,$index) = @_ ;
	my @returnVal;
	if ( defined($index)) { 
		push(@returnVal,$self->{stem}{osmatch}[$index]{name}); 
	} elsif ( ref($self->{stem}{osmatch}) eq "HASH") {
	} elsif ( ref($self->{stem}{osmatch}) eq "ARRAY") {	
		foreach ( @{$self->{stem}{osmatch}} ) { 
			push(@returnVal,$_);
		}	
	} else {
		die "unknow error name()\n";
	}
	return @returnVal;
}

sub names{ 
	my ($self,$index) = @_ ;
	my $returnVal;
	if ( defined($index)) { 
		$returnVal = $self->{stem}{osmatch}[$index]{name};
	} else {$returnVal = $self->{stem}{osmatch}{name};}
	
	return $returnVal; 	
}

sub name_count{ 
	my ($self,$index) = @_ ;
	
	return $#{$self->{stem}};
}

sub name_accuracy{ 
	my ($self,$index) = @_ ;
	my $returnVal;	
	if ( defined($index)) { 
		$returnVal = $self->{stem}{osmatch}[$index]{accuracy};
	} else {
		$returnVal = $self->{stem}{osmatch}[0]{accuracy};
	}
	
	return $returnVal;
}

sub os_fingerprint{
	my ($self,$index) = @_ ;
	if (! defined($index) ) { $index = 0; }
	
	return ($self->{stem}{osfingerprint}{fingerprint});	
}


sub portused_closed{ 
	my ($self) = @_ ;
	my @ports = getPortData($self,'closed'); 
	return @ports; 
	
}

sub portused_open{ 
	my ($self) = @_ ;
	my @ports = getPortData($self,'open'); 
	return @ports; 
}

sub getPortData { 
	my ($self,$state) = @_ ;
	my @ports; 
	
	foreach ( @{$self->{stem}{portsused}}) {
		if ( $_->{state} eq $state ) { push(@ports,$_->{portid}); } 
	}
	return @ports; 
}

sub type{ 
	my ($self,$index) = @_ ;
	my $returnVal;
	if (defined($index)) { $returnVal = $self->{stem}{osmatch}[$index]{osclass}[0]{type}; }
	else { $returnVal = $self->{stem}{osmatch}[0]{osclass}[0]{type}; }
	return $returnVal;
	
}
sub vendor{ 
	my ($self,$index) = @_ ;
	my $returnVal;
	if (defined($index)) { $returnVal = $self->{stem}{osmatch}[$index]{osclass}[0]{vendor}; }
	else { $returnVal = $self->{stem}{osmatch}[0]{osclass}[0]{vendor}; }
	return $returnVal;

}

sub class_accuracy{ 
	my ($self,$index) = @_ ;
	my $returnVal;
	if (defined($index)) { $returnVal = $self->{stem}{osmatch}[$index]{osclass}[0]{accuracy}; }
	else { $returnVal = $self->{stem}{osmatch}[0]{osclass}[0]{accuracy}; }
	return $returnVal;
 
}


sub osfamily{ 
	my ($self,$index) = @_ ;
	my $returnVal;
	if (defined($index)) { $returnVal = $self->{stem}{osmatch}[$index]{osclass}[0]{osfamily}; }
	else { $returnVal = $self->{stem}{osmatch}[0]{osclass}[0]{osfamily}; }
	return $returnVal; 	
}

sub osgen{ 
	my ($self,$index) = @_ ;
	my $returnVal;
	if (defined($index)) { $returnVal = $self->{stem}{osmatch}[$index]{osclass}[0]{osgen}; }
	else { $returnVal = $self->{stem}{osmatch}[0]{osclass}[0]{osgen}; }
	return $returnVal; 	
 	
}


sub class_count{ 
	
	my ($self,$index) = @_ ;
	my $returnVal = 0 ;
	if ( defined($index)) { 
		$returnVal = $#{$self->{stem}{osmatch}[$index]{osclass}};
	} else { 
		foreach ( @{$self->{stem}{osmatch}}) {
			$returnVal += ($#{$_->{osclass}} + 1);
		}
	}
	
	return $returnVal; 	

}

# new calls START  
sub cpe { 
	my ($self,$index) = @_;
	my @CPE;
	
	if (defined($index)) { 
		foreach ( @{$self->{stem}{osmatch}[$index]{osclass}{cpe}}) { 
			push(@CPE,$_);
		}
	} else { 
		for my $os ( @{$self->{stem}{osmatch}}) {
			foreach ( @{$os->{osclass}}) { 
				for my $cpe (@{$_->{cpe}} ) { 
					push(@CPE,$cpe);
				} 
			}
		}
	} 
	
	return @CPE;	
}

1; 