#!perl

use strict;
use utf8;

use Test::More  tests => 10;
use Geo::Names::Russian ':all';

use Encode::Locale;
use Encode;

my @tests = (
    [ 'ул. Иванова'             => 'УЛИЦА Иванова' ],
    [ 'Новая Кузнецовская пл'   => 'ПЛОЩАДЬ Кузнецовская Нов' ],
    [ '2-й б-р Сидорова'        => 'БУЛЬВАР 2 Сидорова' ],
    [ 'Лесная Нижн.'            => 'УЛИЦА Лесная Ниж' ],
    [ '7 Петровский'            => 'ПЕРЕУЛОК 7 Петровский' ],
    [ '8 Марта 5-й километр'    => 'УЛИЦА 5км 8 Марта' ],
    [ '4-ая улица 8 Марта'      => 'УЛИЦА 4 8 Марта' ],
    [ '9-й стрелковой дивизии'  => 'УЛИЦА 9 дивизии стрелковой' ],
    [ 'Проезд № 777'            => 'Проезд 777' ],
    [ 'Адмирала Ш. М.Макарова'  => 'Улица Адмирала Макарова_Ш.М.' ],
);


for my $test ( @tests ) {
    my $res = streetname_keystring( $test->[0] );
    is( $res, uc($test->[1]), encode( 'console_out', "hash $test->[0]" ) );
}

