package Kephra::Config::Default::ContextMenus;
our $VERSION = '0.03';

use strict;
use warnings;

sub get {
	return {
		'editpanel_contextmenu' => [
			'item edit-changes-undo',
			'item edit-changes-redo',
			undef,
			'item edit-paste',
			'item select-document',
			undef,
			'item goto-last-edit',
			'item view-dialog-find',
			undef,
			'item file-save-current',
			'item file-open',
			undef,
			'item file-close-current',
		],
		'textselection_contextmenu' => [
			'item edit-copy',
			'item edit-paste',
			'item edit-replace',
			'item edit-cut',
			'item edit-delete',
			undef,
			'item find-selection',
			'item replace-selection',
			'item tool-note-selection',
			undef,
			'item edit-selection-convert-uppercase',
			'item edit-selection-convert-lowercase',
		],
		'markermargin_contextmenu' => [
			{'menu marker' => [
				'item marker-toggle-here',
				'item marker-goto-prev-doc',
				'item marker-goto-next-doc',
				'item marker-goto-prev-all',
				'item marker-goto-next-all',
				'item marker-delete-doc',
				'item marker-delete-all',
			],},
			undef,
			{'menu bookmark_toggle' => [
				'item bookmark-toggle-1',
				'item bookmark-toggle-2',
				'item bookmark-toggle-3',
				'item bookmark-toggle-4',
				'item bookmark-toggle-5',
				'item bookmark-toggle-6',
				'item bookmark-toggle-7',
				'item bookmark-toggle-8',
				'item bookmark-toggle-9',
				'item bookmark-toggle-0',
			],},
			{'menu bookmark_goto' => [
				'item bookmark-goto-1',
				'item bookmark-goto-2',
				'item bookmark-goto-3',
				'item bookmark-goto-4',
				'item bookmark-goto-5',
				'item bookmark-goto-6',
				'item bookmark-goto-7',
				'item bookmark-goto-8',
				'item bookmark-goto-9',
				'item bookmark-goto-0',
			],},
			'item bookmark-delete-doc',
			'item bookmark-delete-all',
			undef,
			'item goto-line',
			undef,
			{'menu view_text_fold' => [
				'item view-editpanel-fold-toggle-here',
				'item view-editpanel-fold-toggle-recursively',
				'item view-editpanel-fold-toggle-siblings',
				'item view-editpanel-fold-toggle-all',
			],},
			undef,
			'checkitem view-editpanel-margin-marker',
			'checkitem view-editpanel-margin-line-number',
			'checkitem view-editpanel-margin-text-fold',
			{'menu view_textmargin' => [
				'radioitem view-editpanel-margin-text-0',
				'radioitem view-editpanel-margin-text-1',
				'radioitem view-editpanel-margin-text-2',
				'radioitem view-editpanel-margin-text-3',
				'radioitem view-editpanel-margin-text-4',
				'radioitem view-editpanel-margin-text-6',
				'radioitem view-editpanel-margin-text-8',
				'radioitem view-editpanel-margin-text-10',
				'radioitem view-editpanel-margin-text-12',
			],},
		],
		'searchbar_contextmenu' => [
			'checkitem search-attribute-incremental-switch',
			'checkitem search-attribute-autowrap-switch',
			undef,
			'checkitem search-attribute-regex-switch',
			'checkitem search-attribute-match-whole-word-switch',
			'checkitem search-attribute-match-word-begin-switch',
			'checkitem search-attribute-match-case-switch',
			undef,
			'radioitem search-range-selection',
			'radioitem search-range-document',
			'radioitem search-range-open-docs',
		],
		'status_syntaxstyle_contextmenu' => [
			'radioitem document-syntaxmode-c',
			'radioitem document-syntaxmode-conf',
			'radioitem document-syntaxmode-css',
			'radioitem document-syntaxmode-html',
			'radioitem document-syntaxmode-js',
			'radioitem document-syntaxmode-perl',
			'radioitem document-syntaxmode-xml',
			'radioitem document-syntaxmode-yaml',
			undef,
			'item document-syntaxmode-auto',
			'checkitem document-syntaxmode-none',
		],
		'status_whitespace_contextmenu' => [
			'checkitem document-auto-indention',
			'checkitem document-brace-indention',
			undef,
			'checkitem view-editpanel-whitespace',
			{'menu document_tab_width' => [
				'checkitem document-tabs-width-1',
				'checkitem document-tabs-width-2',
				'checkitem document-tabs-width-3',
				'checkitem document-tabs-width-4',
				'checkitem document-tabs-width-5',
				'checkitem document-tabs-width-6',
				'checkitem document-tabs-width-8',
			],},
			{'menu document_convert' => [
				'item edit-document-convert-tabs2spaces',
				'item edit-document-convert-spaces2tabs',
				'',
				'item edit-document-convert-indent2spaces',
				'item edit-document-convert-indent2tabs',
				'',
				'item edit-document-format-del-trailing-whitespace',
			],},
			undef,
			'radioitem document-tabs-soft',
			'radioitem document-tabs-hard',
		],
		'status_lineendchar_contextmenu' => [
			'checkitem view-editpanel-EOL',
			undef,
			'item document-EOL-auto',
			undef,
			'radioitem document-EOL-lf',
			'radioitem document-EOL-cr',
			'radioitem document-EOL-cr+lf',
		],
		'status_info_contexmenu' => [
			'radioitem view-statusbar-info-none',
			'radioitem view-statusbar-info-length',
			'radioitem view-statusbar-info-date',
		]
	}
}

1;
