########################################################################
# housekeeping
########################################################################

use v6.d;

unit module FileSystem::Parent:ver<0.3.0>:auth<CPAN:lembark>;

use FindBin;

################################################################
# exported (API)
################################################################

multi scan-up
(
    Stringy :$filter = 'all',
    *%argz
    --> Seq
)
{
    my %filterz =
    (
        all     => True ,
        dir     => :d   ,
        file    => :f   ,
        exist   => :e   ,
    );

    my $value   = %filterz{ $filter }
    or
    fail "Unknown: '$filter'. not " ~ %filterz.keys.join(' ');

    samewith filter => $value, |%argz
}

multi scan-up
(
    Any     :$filter,

    Str     :$append    = '',
    Bool    :$resolve   = False,
    Bool    :$verbose   = False,
    Bool    :$skip-root = False,
    IO()    :$from      = Bin( :$resolve, :$verbose )
    --> Seq
)
is export( :DEFAULT )
{
    # resolve is only applied once, here.

    my $path    
    = $resolve
    ?? $from.absolute.resolve.IO
    !! $from.absolute.IO
    ;

    # note that $path may have nothing to do with $from
    # at this point if $resolve is used w/ a symlink. 

    $path   ~~ :d
    or 
    $path   = $path.parent;

    if $verbose
    {
        note '# Start:  ' ~ $from.gist;
        note "# Path:   '$path'";
        note "# Append: '$append'";
    }

    return gather loop
    {
        # $parent & $path may contain a volume or 
        # path trim, compare all of it.

        my $next    = $path.parent;
        my $at-root = $path ~~ $next;

        # make the check before append and take in 

        if $at-root && $skip-root
        {
            note "# Skip root '$path'"
            if $verbose;
        }
        else
        {
            # $take might be a file,
            # depending on what's in $append.
            #
            # resolve is *not* applied
            # at each iteration.

            my $take
            = $append
            ?? $path.add( $append )
            !! $path
            ;

            if $take ~~ $filter
            {
                note "# Want: $take"
                if $verbose;

                take $take;
            }
            else
            {
                note "# Skip: $take"
                if $verbose;
            }
        };

        $at-root
        and last;

        $path   = $next;
    }
}

=finish
