use v6.d;
use Test;

use FileSystem::Parent;

my $verbose 
= %*ENV< VERBOSE > 
?? True 
!! False
;

sub pick_all
(
    IO $path --> Bool
)
{
    $path ~~ :e
}

my $append  = 'lib';

my $pass0  = scan-up :$verbose, :$append, filter => &pick_all;
ok $pass0,  'scan-up with want dir';

my $pass1  = scan-up :$verbose  :$append, filter => &pick_all, :start( $*PROGRAM-NAME );
ok $pass1,  'scan-up with want dir and start';

my @want0   = $pass0.eager;
my @want1   = $pass1.eager;

put "# Pass0:\t", @want0;
put "# Pass1:\t", @want1;

ok $pass0 ~~ $pass1, 'Bin and $*Program-Name return same list.';

done-testing;
