########################################################################
# housekeeping
########################################################################

use v6.d;

unit module FileSystem::Parent:ver<0.1.0>:auth<CPAN:lembark>;

use FindBin;

################################################################
# package variables
################################################################

my %filterz =
(
    all     => True ,
    dir     => :d   ,
    file    => :f   ,
    exist   => :e   ,
);

################################################################
# exported (API)
################################################################

multi scan-up
(
    Stringy :$filter = 'all', *%argz 
    --> Seq
)
{
    my $value   = %filterz{ $filter }
    or
    fail "Unknown: '$filter'. not " ~ %filterz.keys.join(' ');

    samewith filter => $value, |%argz
}

multi scan-up
(
    Any     :$filter,

    Str     :$append    = '',
    Bool    :$resolve   = False,
    Bool    :$verbose   = False,
    IO()    :$start     = Bin( :$resolve, :$verbose )
    --> Seq
)
is export( :DEFAULT )
{
    my $path    
    = $resolve
    ?? $start.absolute.resolve.IO
    !! $start.absolute.IO
    ;

    # note that $path may have nothing to do with $start
    # at this point if $resolve is used w/ a symlink. 

    $path   ~~ :d
    or 
    $path   = $path.parent;

    if $verbose
    {
        note '# Start:  ' ~ $start.gist;
        note "# Path:   '$path'";
        note "# Append: '$append'";
    }

    return gather loop
    {
        # note that what's take might be a file,
        # depending on what's in $append.

        my $take
        = $append
        ?? $path.add( $append )
        !! $path
        ;

        if $take ~~ $filter
        {
            note "# Want: $take"
            if $verbose;

            take $take;
        }
        else
        {
            note "# Skip: $take"
            if $verbose;
        }

        # $parent & $path may contain a volume or 
        # path trim, compare all of it.

        my $next    = $path.parent;

        $path ~~ $next
        and last;

        $path   = $next;
    }
}

=finish
