# use "*_t" for basename of this file.
# symlink to *-<perl version string to test>.t.
# e.g.,
#   "20-foo-v5.5.3.t"
#   "20-bar-5.005_003"
#   "20-bar-v5.005003"
# will test varieties of the same perl version string.
########################################################################
# housekeeping
########################################################################
use 5.008;
use strict;
use version;

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use lib( "$Bin/../../lib", "$Bin/../lib" );
use Test::KwikHaks;

########################################################################
# package variables 
########################################################################

my $madness = 'Module::FromPerlVer';

my $wv      = Test::KwikHaks->can( 'write_version_file' );

*output     = Test::KwikHaks->can( 'output' );

########################################################################
# test reading version from "use" or "no".
########################################################################

output();

delete $ENV{ PERL_VERSION };

my ( $base, $perl_v )  
= eval
{
    Test::KwikHaks::perl_v_from_basename()
}
or BAIL_OUT "Missing Perl Version: $@";

my $v_file  = $wv->( $perl_v )
or BAIL_OUT "Failed writing version file.", 1;

eval
{
    my @argz    = ( use_dir => 1,  version_from => $v_file );

    use_ok $madness => @argz
}
or BAIL_OUT "Use failed; $@", 1;

for my $prefix ( $madness->source_prefix )
{
    my $expect  = 'version';

    is $prefix, $expect, "Source prefix: '$prefix' ($expect)";
}

for my $found ( scalar $madness->source_files )
{
    @$found
    ? pass 'Acquired source files in version directory.'
    : fail 'No source files for cleanup.'
    ;

    note "Source files:\n", explain $found;

    ok -e , "Found: '$_'"
    for @$found;
}

eval
{
    $madness->cleanup;
    unlink $v_file;

    pass "Survived cleanup.";
}
or 
fail "Failed cleanup: $@";

done_testing;
__END__
