/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2002 from the
 * contents of SDL_perl.xs. Do not edit this file, edit SDL_perl.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "lib/SDL_perl.xs"
//
// SDL.xs
//
// Copyright (C) 2005 David J. Goehrig <dgoehrig@cpan.org>
//
// ------------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//
// ------------------------------------------------------------------------------
//
// Please feel free to send questions, suggestions or improvements to:
//
//	David J. Goehrig
//	dgoehrig@cpan.org
//

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#ifndef aTHX_
#define aTHX_
#endif

#include <SDL.h>

#ifdef HAVE_GL
#include <gl.h>
#endif

#ifdef HAVE_GLU
#include <glu.h>
#endif

#ifdef HAVE_SDL_IMAGE
#include <SDL_image.h>
#endif 

#ifdef HAVE_SDL_MIXER
#include <SDL_mixer.h>
void (*mix_music_finished_cv)();
#endif

#ifdef HAVE_SDL_SOUND
#include <SDL_sound.h>
#endif

#ifdef HAVE_SDL_NET
#include <SDL_net.h>
#endif

#ifdef HAVE_SDL_TTF
#include <SDL_ttf.h>
#define TEXT_SOLID	1
#define TEXT_SHADED	2
#define TEXT_BLENDED	4
#define UTF8_SOLID	8
#define UTF8_SHADED	16	
#define UTF8_BLENDED	32
#define UNICODE_SOLID	64
#define UNICODE_SHADED	128
#define UNICODE_BLENDED	256
#endif

#ifdef HAVE_SMPEG
#include <smpeg/smpeg.h>
#ifdef HAVE_SDL_MIXER
static int sdl_perl_use_smpeg_audio = 0;
#endif
#endif

#ifdef HAVE_SDL_GFX
#include <SDL_rotozoom.h>
#include <SDL_gfxPrimitives.h>
#include <SDL_framerate.h>
#include <SDL_imageFilter.h>
#endif

#ifdef HAVE_SDL_SVG
#include <SDL_svg.h>
#endif

#ifdef USE_THREADS
#define HAVE_TLS_CONTEXT
#endif

/* For windows  */
#ifndef SDL_PERL_DEFINES_H
#define SDL_PERL_DEFINES_H

#ifdef HAVE_TLS_CONTEXT
PerlInterpreter *parent_perl = NULL;
extern PerlInterpreter *parent_perl;
#define GET_TLS_CONTEXT parent_perl =  PERL_GET_CONTEXT;
#define ENTER_TLS_CONTEXT \
        PerlInterpreter *current_perl = PERL_GET_CONTEXT; \
	        PERL_SET_CONTEXT(parent_perl); { \
			                PerlInterpreter *my_perl = parent_perl;
#define LEAVE_TLS_CONTEXT \
					        } PERL_SET_CONTEXT(current_perl);
#else
#define GET_TLS_CONTEXT         /* TLS context not enabled */
#define ENTER_TLS_CONTEXT       /* TLS context not enabled */
#define LEAVE_TLS_CONTEXT       /* TLS context not enabled */
#endif

#endif

Uint32 
sdl_perl_timer_callback ( Uint32 interval, void* param )
{
	Uint32 retval;
	int back;
	SV* cmd;
	ENTER_TLS_CONTEXT
	dSP;

	cmd = (SV*)param;

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(interval)));
	PUTBACK;

	if (0 != (back = call_sv(cmd,G_SCALAR))) {
		SPAGAIN;
		if (back != 1 ) Perl_croak (aTHX_ "Timer Callback failed!");
		retval = POPi;	
	} else {
		Perl_croak(aTHX_ "Timer Callback failed!");
	}

	FREETMPS;
	LEAVE;

	LEAVE_TLS_CONTEXT
	
	return retval;
}

void
sdl_perl_audio_callback ( void* data, Uint8 *stream, int len )
{
	SV *cmd;
	ENTER_TLS_CONTEXT
	dSP;

	cmd = (SV*)data;

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(PTR2IV(stream))));
	XPUSHs(sv_2mortal(newSViv(len)));
	PUTBACK;

	call_sv(cmd,G_VOID|G_DISCARD);
	
	PUTBACK;
	FREETMPS;
	LEAVE;

	LEAVE_TLS_CONTEXT	
}

#ifdef HAVE_SDL_MIXER

void
sdl_perl_music_callback ( void ) 
{
	SV *cmd;
	ENTER_TLS_CONTEXT
	dSP;

	cmd = (SV*)Mix_GetMusicHookData();

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	PUTBACK;
	
	call_sv(cmd,G_VOID|G_DISCARD);

	PUTBACK;
	FREETMPS;
	LEAVE;

	LEAVE_TLS_CONTEXT
}

void
sdl_perl_music_finished_callback ( void )
{
	SV *cmd;
	ENTER_TLS_CONTEXT
	dSP;

	cmd = (SV*)mix_music_finished_cv;
	if ( cmd == NULL ) return;

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	PUTBACK;
	
	call_sv(cmd,G_VOID|G_DISCARD);
	
	PUTBACK;
	FREETMPS;
	LEAVE;

	LEAVE_TLS_CONTEXT
}

#endif

#define INIT_NS_APPLICATION
#define QUIT_NS_APPLICATION


void
sdl_perl_atexit (void)
{
	QUIT_NS_APPLICATION	
	SDL_Quit();
}

void boot_SDL();
void boot_SDL__OpenGL();

XS(boot_SDL_perl)
{
	GET_TLS_CONTEXT
	boot_SDL();
}

#line 261 "lib/SDL_perl.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

#line 304 "lib/SDL_perl.c"

XS(XS_SDL_GetError); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetError)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 257 "lib/SDL_perl.xs"
		RETVAL = SDL_GetError();
#line 321 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_Init); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Init)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "flags");
    {
	Uint32	flags = (Uint32)SvUV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 265 "lib/SDL_perl.xs"
		INIT_NS_APPLICATION
		RETVAL = SDL_Init(flags);
#ifdef HAVE_TLS_CONTEXT
		Perl_call_atexit(PERL_GET_CONTEXT, (void*)sdl_perl_atexit,0);
#else
		atexit(sdl_perl_atexit);
#endif
#line 350 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_InitSubSystem); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_InitSubSystem)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "flags");
    {
	Uint32	flags = (Uint32)SvUV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 279 "lib/SDL_perl.xs"
		RETVAL = SDL_InitSubSystem(flags);
#line 373 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_QuitSubSystem); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_QuitSubSystem)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "flags");
    {
	Uint32	flags = (Uint32)SvUV(ST(0));
#line 287 "lib/SDL_perl.xs"
		SDL_QuitSubSystem(flags);
#line 394 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_Quit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Quit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 292 "lib/SDL_perl.xs"
		QUIT_NS_APPLICATION
		SDL_Quit();
#line 414 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_WasInit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WasInit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "flags");
    {
	Uint32	flags = (Uint32)SvUV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 299 "lib/SDL_perl.xs"
		RETVAL = SDL_WasInit(flags);
#line 436 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Delay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Delay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ms");
    {
	int	ms = (int)SvIV(ST(0));
#line 307 "lib/SDL_perl.xs"
		SDL_Delay(ms);
#line 457 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetTicks); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetTicks)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Uint32	RETVAL;
	dXSTARG;
#line 312 "lib/SDL_perl.xs"
		RETVAL = SDL_GetTicks();
#line 478 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetTimer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetTimer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "interval, callback");
    {
	Uint32	interval = (Uint32)SvUV(ST(0));
	SDL_TimerCallback	callback = INT2PTR(SDL_TimerCallback,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 321 "lib/SDL_perl.xs"
		RETVAL = SDL_SetTimer(interval,callback);
#line 502 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_AddTimer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_AddTimer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "interval, callback, param");
    {
	Uint32	interval = (Uint32)SvUV(ST(0));
	SDL_NewTimerCallback	callback = INT2PTR(SDL_NewTimerCallback,SvIV(ST(1)));
	void *	param = INT2PTR(void *,SvIV(ST(2)));
	SDL_TimerID	RETVAL;
	dXSTARG;
#line 331 "lib/SDL_perl.xs"
		RETVAL = SDL_AddTimer(interval,callback,param);
#line 527 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_PerlTimerCallback); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PerlTimerCallback)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SDL_NewTimerCallback	RETVAL;
	dXSTARG;
#line 338 "lib/SDL_perl.xs"
		RETVAL = sdl_perl_timer_callback;
#line 549 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NewTimer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewTimer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "interval, cmd");
    {
	Uint32	interval = (Uint32)SvUV(ST(0));
	void *	cmd = INT2PTR(void *,SvIV(ST(1)));
	SDL_TimerID	RETVAL;
	dXSTARG;
#line 347 "lib/SDL_perl.xs"
		RETVAL = SDL_AddTimer(interval,sdl_perl_timer_callback,cmd);
#line 573 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_RemoveTimer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RemoveTimer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	SDL_TimerID	id = INT2PTR(SDL_TimerID,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 355 "lib/SDL_perl.xs"
		RETVAL = SDL_RemoveTimer(id);
#line 596 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RWFromFile); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWFromFile)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "file, mode");
    {
	char*	file = (char *)SvPV_nolen(ST(0));
	char *	mode = (char *)SvPV_nolen(ST(1));
	SDL_RWops *	RETVAL;
	dXSTARG;
#line 364 "lib/SDL_perl.xs"
		RETVAL = SDL_RWFromFile(file,mode);
#line 620 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_RWFromFP); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWFromFP)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fp, autoclose");
    {
	FILE*	fp = PerlIO_findFILE(IoIFP(sv_2io(ST(0))));
	int	autoclose = (int)SvIV(ST(1));
	SDL_RWops *	RETVAL;
	dXSTARG;
#line 373 "lib/SDL_perl.xs"
		RETVAL = SDL_RWFromFP(fp,autoclose);
#line 644 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_RWFromMem); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWFromMem)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mem, size");
    {
	char*	mem = (char *)SvPV_nolen(ST(0));
	int	size = (int)SvIV(ST(1));
	SDL_RWops *	RETVAL;
	dXSTARG;
#line 382 "lib/SDL_perl.xs"
		RETVAL = SDL_RWFromMem((void*)mem,size);
#line 668 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_RWFromConstMem); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWFromConstMem)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mem, size");
    {
	const char*	mem = (const char *)SvPV_nolen(ST(0));
	int	size = (int)SvIV(ST(1));
	SDL_RWops *	RETVAL;
	dXSTARG;
#line 391 "lib/SDL_perl.xs"
		RETVAL = SDL_RWFromConstMem((const void*)mem,size);
#line 692 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_AllocRW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_AllocRW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SDL_RWops *	RETVAL;
	dXSTARG;
#line 398 "lib/SDL_perl.xs"
		RETVAL = SDL_AllocRW();
#line 714 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeRW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeRW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "rw");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
#line 406 "lib/SDL_perl.xs"
		SDL_FreeRW(rw);
#line 735 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_RWseek); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWseek)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "rw, off, whence");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
	int	off = (int)SvIV(ST(1));
	int	whence = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 414 "lib/SDL_perl.xs"
		RETVAL = SDL_RWseek(rw,off,whence);
#line 759 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RWtell); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWtell)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "rw");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 422 "lib/SDL_perl.xs"
		RETVAL = SDL_RWtell(rw);
#line 782 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RWread); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWread)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "rw, mem, size, n");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
	char*	mem = (char *)SvPV_nolen(ST(1));
	int	size = (int)SvIV(ST(2));
	int	n = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 433 "lib/SDL_perl.xs"
		RETVAL = SDL_RWread(rw,mem,size,n);
#line 808 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RWwrite); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWwrite)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "rw, mem, size, n");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
	char*	mem = (char *)SvPV_nolen(ST(1));
	int	size = (int)SvIV(ST(2));
	int	n = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 444 "lib/SDL_perl.xs"
		RETVAL = SDL_RWwrite(rw,mem,size,n);
#line 834 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RWclose); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RWclose)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "rw");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 452 "lib/SDL_perl.xs"
		RETVAL = SDL_RWclose(rw);
#line 857 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDNumDrives); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDNumDrives)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 459 "lib/SDL_perl.xs"
		RETVAL = SDL_CDNumDrives();
#line 879 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "drive");
    {
	int	drive = (int)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;
#line 467 "lib/SDL_perl.xs"
		RETVAL = strdup(SDL_CDName(drive));
#line 902 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_CDOpen); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDOpen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "drive");
    {
	int	drive = (int)SvIV(ST(0));
	SDL_CD *	RETVAL;
	dXSTARG;
#line 475 "lib/SDL_perl.xs"
		RETVAL = SDL_CDOpen(drive);
#line 925 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_CDTrackId); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDTrackId)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "track");
    {
	SDL_CDtrack *	track = INT2PTR(SDL_CDtrack *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 483 "lib/SDL_perl.xs"
		RETVAL = track->id;
#line 948 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDTrackType); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDTrackType)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "track");
    {
	SDL_CDtrack *	track = INT2PTR(SDL_CDtrack *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 491 "lib/SDL_perl.xs"
		RETVAL = track->type;
#line 971 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDTrackLength); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDTrackLength)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "track");
    {
	SDL_CDtrack *	track = INT2PTR(SDL_CDtrack *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 499 "lib/SDL_perl.xs"
		RETVAL = track->length;
#line 994 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDTrackOffset); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDTrackOffset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "track");
    {
	SDL_CDtrack *	track = INT2PTR(SDL_CDtrack *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 507 "lib/SDL_perl.xs"
		RETVAL = track->offset;
#line 1017 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDStatus); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDStatus)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 515 "lib/SDL_perl.xs"
		RETVAL = SDL_CDStatus(cd);
#line 1040 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDPlayTracks); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDPlayTracks)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "cd, start_track, ntracks, start_frame, nframes");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	start_track = (int)SvIV(ST(1));
	int	ntracks = (int)SvIV(ST(2));
	int	start_frame = (int)SvIV(ST(3));
	int	nframes = (int)SvIV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 527 "lib/SDL_perl.xs"
		RETVAL = SDL_CDPlayTracks(cd,start_track,start_frame,ntracks,nframes);
#line 1067 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDPlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDPlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "cd, start, length");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	start = (int)SvIV(ST(1));
	int	length = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 537 "lib/SDL_perl.xs"
		RETVAL = SDL_CDPlay(cd,start,length);
#line 1092 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDPause); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDPause)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 545 "lib/SDL_perl.xs"
		RETVAL = SDL_CDPause(cd);
#line 1115 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDResume); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDResume)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 553 "lib/SDL_perl.xs"
		RETVAL = SDL_CDResume(cd);
#line 1138 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDStop); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDStop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 561 "lib/SDL_perl.xs"
		RETVAL = SDL_CDStop(cd);
#line 1161 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDEject); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDEject)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 569 "lib/SDL_perl.xs"
		RETVAL = SDL_CDEject(cd);
#line 1184 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDClose); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDClose)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
#line 577 "lib/SDL_perl.xs"
		SDL_CDClose(cd);
#line 1205 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_CDId); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDId)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 583 "lib/SDL_perl.xs"
		RETVAL = cd->id;
#line 1227 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDNumTracks); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDNumTracks)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 591 "lib/SDL_perl.xs"
		RETVAL = cd->numtracks;
#line 1250 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDCurTrack); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDCurTrack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 599 "lib/SDL_perl.xs"
		RETVAL = cd->cur_track;
#line 1273 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDCurFrame); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDCurFrame)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cd");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 607 "lib/SDL_perl.xs"
		RETVAL = cd->cur_frame;
#line 1296 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_CDTrack); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CDTrack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "cd, number");
    {
	SDL_CD *	cd = INT2PTR(SDL_CD *,SvIV(ST(0)));
	int	number = (int)SvIV(ST(1));
	SDL_CDtrack *	RETVAL;
	dXSTARG;
#line 616 "lib/SDL_perl.xs"
		RETVAL = (SDL_CDtrack *)(cd->track + number);
#line 1320 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_PumpEvents); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PumpEvents)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 623 "lib/SDL_perl.xs"
		SDL_PumpEvents();
#line 1340 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_PushEvent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PushEvent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 629 "lib/SDL_perl.xs"
		RETVAL = SDL_PushEvent( e );
#line 1362 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NewEvent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewEvent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SDL_Event *	RETVAL;
	dXSTARG;
#line 636 "lib/SDL_perl.xs"
		RETVAL = (SDL_Event *) safemalloc (sizeof(SDL_Event));
#line 1384 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeEvent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeEvent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
#line 644 "lib/SDL_perl.xs"
		safefree(e);
#line 1405 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_PollEvent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PollEvent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 650 "lib/SDL_perl.xs"
		RETVAL = SDL_PollEvent(e);
#line 1427 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_WaitEvent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WaitEvent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 658 "lib/SDL_perl.xs"
		RETVAL = SDL_WaitEvent(e);
#line 1450 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_EventState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_EventState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "type, state");
    {
	Uint8	type = (unsigned char)SvUV(ST(0));
	int	state = (int)SvIV(ST(1));
	Uint8	RETVAL;
	dXSTARG;
#line 667 "lib/SDL_perl.xs"
		RETVAL = SDL_EventState(type,state);
#line 1474 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_EventType); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_EventType)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 675 "lib/SDL_perl.xs"
		RETVAL = e->type;
#line 1497 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetEventType); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetEventType)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "e, type");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	type = (unsigned char)SvUV(ST(1));
	Uint8	RETVAL;
	dXSTARG;
#line 684 "lib/SDL_perl.xs"
		RETVAL = e->type;
		e->type = type;
#line 1522 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ActiveEventGain); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ActiveEventGain)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 693 "lib/SDL_perl.xs"
		RETVAL = e->active.gain;
#line 1545 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ActiveEventState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ActiveEventState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 701 "lib/SDL_perl.xs"
		RETVAL = e->active.state;
#line 1568 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_KeyEventState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_KeyEventState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 709 "lib/SDL_perl.xs"
		RETVAL = e->key.state;
#line 1591 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_KeyEventSym); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_KeyEventSym)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 717 "lib/SDL_perl.xs"
		RETVAL = e->key.keysym.sym;
#line 1614 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_KeyEventMod); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_KeyEventMod)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 725 "lib/SDL_perl.xs"
		RETVAL = e->key.keysym.mod;
#line 1637 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_KeyEventUnicode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_KeyEventUnicode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 733 "lib/SDL_perl.xs"
		RETVAL = e->key.keysym.unicode;
#line 1660 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_KeyEventScanCode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_KeyEventScanCode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 741 "lib/SDL_perl.xs"
		RETVAL = e->key.keysym.scancode;
#line 1683 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseMotionState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseMotionState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 749 "lib/SDL_perl.xs"
		RETVAL = e->motion.state;
#line 1706 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseMotionX); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseMotionX)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 757 "lib/SDL_perl.xs"
		RETVAL = e->motion.x;
#line 1729 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseMotionY); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseMotionY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 765 "lib/SDL_perl.xs"
		RETVAL = e->motion.y;
#line 1752 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseMotionXrel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseMotionXrel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 773 "lib/SDL_perl.xs"
		RETVAL = e->motion.xrel;
#line 1775 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseMotionYrel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseMotionYrel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 781 "lib/SDL_perl.xs"
		RETVAL = e->motion.yrel;
#line 1798 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseButtonState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseButtonState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 789 "lib/SDL_perl.xs"
		RETVAL = e->button.state;
#line 1821 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseButton); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseButton)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 797 "lib/SDL_perl.xs"
		RETVAL = e->button.button;
#line 1844 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseButtonX); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseButtonX)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 805 "lib/SDL_perl.xs"
		RETVAL = e->button.x;
#line 1867 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MouseButtonY); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MouseButtonY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 813 "lib/SDL_perl.xs"
		RETVAL = e->button.y;
#line 1890 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SysWMEventMsg); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SysWMEventMsg)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	SDL_SysWMmsg *	RETVAL;
	dXSTARG;
#line 821 "lib/SDL_perl.xs"
		RETVAL = e->syswm.msg;
#line 1913 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_EnableUnicode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_EnableUnicode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "enable");
    {
	int	enable = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 829 "lib/SDL_perl.xs"
		RETVAL = SDL_EnableUNICODE(enable);
#line 1936 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_EnableKeyRepeat); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_EnableKeyRepeat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "delay, interval");
    {
	int	delay = (int)SvIV(ST(0));
	int	interval = (int)SvIV(ST(1));
#line 838 "lib/SDL_perl.xs"
		SDL_EnableKeyRepeat(delay,interval);
#line 1958 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetModState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetModState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Uint32	RETVAL;
	dXSTARG;
#line 843 "lib/SDL_perl.xs"
		RETVAL = SDL_GetModState();
#line 1979 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetModState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetModState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "state");
    {
	Uint32	state = (Uint32)SvUV(ST(0));
#line 851 "lib/SDL_perl.xs"
		SDL_SetModState(state);
#line 2000 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetKeyName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetKeyName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sym");
    {
	int	sym = (int)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;
#line 857 "lib/SDL_perl.xs"
		RETVAL = SDL_GetKeyName(sym);
#line 2022 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_CreateRGBSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CreateRGBSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "flags, width, height, depth, Rmask, Gmask, Bmask, Amask");
    {
	Uint32	flags = (Uint32)SvUV(ST(0));
	int	width = (int)SvIV(ST(1));
	int	height = (int)SvIV(ST(2));
	int	depth = (int)SvIV(ST(3));
	Uint32	Rmask = (Uint32)SvUV(ST(4));
	Uint32	Gmask = (Uint32)SvUV(ST(5));
	Uint32	Bmask = (Uint32)SvUV(ST(6));
	Uint32	Amask = (Uint32)SvUV(ST(7));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 872 "lib/SDL_perl.xs"
		RETVAL = SDL_CreateRGBSurface ( flags, width, height,
				depth, Rmask, Gmask, Bmask, Amask );
#line 2053 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_CreateRGBSurfaceFrom); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CreateRGBSurfaceFrom)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "pixels, width, height, depth, pitch, Rmask, Gmask, Bmask, Amask");
    {
	char *	pixels = (char *)SvPV_nolen(ST(0));
	int	width = (int)SvIV(ST(1));
	int	height = (int)SvIV(ST(2));
	int	depth = (int)SvIV(ST(3));
	int	pitch = (int)SvIV(ST(4));
	Uint32	Rmask = (Uint32)SvUV(ST(5));
	Uint32	Gmask = (Uint32)SvUV(ST(6));
	Uint32	Bmask = (Uint32)SvUV(ST(7));
	Uint32	Amask = (Uint32)SvUV(ST(8));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 890 "lib/SDL_perl.xs"
		Uint8* pixeldata;
		Uint32 len = pitch * height;
		New(0,pixeldata,len,Uint8);
		Copy(pixels,pixeldata,len,Uint8);
		RETVAL = SDL_CreateRGBSurfaceFrom ( pixeldata, width, height,
				depth, pitch, Rmask, Gmask, Bmask, Amask );
#line 2089 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#ifdef HAVE_SDL_IMAGE
#define XSubPPtmpAAAA 1


XS(XS_SDL_IMGLoad); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_IMGLoad)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "fname");
    {
	char *	fname = (char *)SvPV_nolen(ST(0));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 905 "lib/SDL_perl.xs"
		RETVAL = IMG_Load(fname);
#line 2115 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS(XS_SDL_SurfaceCopy); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceCopy)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 915 "lib/SDL_perl.xs"
		Uint8* pixels;
		Uint32 size = surface->pitch * surface->h;
		New(0,pixels,size,Uint8);
		Copy(surface->pixels,pixels,size,Uint8);
		RETVAL = SDL_CreateRGBSurfaceFrom(pixels,surface->w,surface->h,
			surface->format->BitsPerPixel, surface->pitch,
			surface->format->Rmask, surface->format->Gmask,
			surface->format->Bmask, surface->format->Amask);
#line 2146 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
#line 930 "lib/SDL_perl.xs"
		if (surface) {
			Uint8* pixels = surface->pixels;
			Uint32 flags = surface->flags;
			SDL_FreeSurface(surface);
			if (flags & SDL_PREALLOC)
				Safefree(pixels);
		}
#line 2173 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SurfaceFlags); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceFlags)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 942 "lib/SDL_perl.xs"
		RETVAL = surface->flags;
#line 2195 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfacePalette); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfacePalette)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Palette *	RETVAL;
	dXSTARG;
#line 950 "lib/SDL_perl.xs"
		RETVAL = surface->format->palette;
#line 2218 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceBitsPerPixel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceBitsPerPixel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 958 "lib/SDL_perl.xs"
		RETVAL = surface->format->BitsPerPixel;
#line 2241 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceBytesPerPixel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceBytesPerPixel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 966 "lib/SDL_perl.xs"
		RETVAL = surface->format->BytesPerPixel;
#line 2264 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceRshift); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceRshift)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 974 "lib/SDL_perl.xs"
		RETVAL = surface->format->Rshift;
#line 2287 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceGshift); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceGshift)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 982 "lib/SDL_perl.xs"
		RETVAL = surface->format->Gshift;
#line 2310 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceBshift); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceBshift)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 990 "lib/SDL_perl.xs"
		RETVAL = surface->format->Bshift;
#line 2333 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceAshift); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceAshift)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 998 "lib/SDL_perl.xs"
		RETVAL = surface->format->Ashift;
#line 2356 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceRmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceRmask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 1006 "lib/SDL_perl.xs"
		RETVAL = surface->format->Rmask;
#line 2379 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceGmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceGmask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 1014 "lib/SDL_perl.xs"
		RETVAL = surface->format->Gmask;
#line 2402 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceBmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceBmask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 1022 "lib/SDL_perl.xs"
		RETVAL = surface->format->Bmask;
#line 2425 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceAmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceAmask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 1030 "lib/SDL_perl.xs"
		RETVAL = surface->format->Amask;
#line 2448 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceColorKey); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceColorKey)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 1038 "lib/SDL_perl.xs"
		RETVAL = surface->format->colorkey;
#line 2471 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceAlpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceAlpha)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 1046 "lib/SDL_perl.xs"
		RETVAL = surface->format->alpha;
#line 2494 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 1054 "lib/SDL_perl.xs"
		RETVAL = surface->w;
#line 2517 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceH); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceH)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 1062 "lib/SDL_perl.xs"
		RETVAL = surface->h;
#line 2540 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfacePitch); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfacePitch)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 1070 "lib/SDL_perl.xs"
		RETVAL = surface->pitch;
#line 2563 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfacePixels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfacePixels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SV *	RETVAL;
#line 1078 "lib/SDL_perl.xs"
		RETVAL = newSVpvn(surface->pixels,surface->pitch*surface->h);
#line 2585 "lib/SDL_perl.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfacePixel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfacePixel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3)
       croak_xs_usage(cv,  "surface, x, y, ...");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint32	x = (Sint32)SvIV(ST(1));
	Sint32	y = (Sint32)SvIV(ST(2));
	SDL_Color *	RETVAL;
	dXSTARG;
#line 1088 "lib/SDL_perl.xs"
		SDL_Color* color;
		int pix,index;
		Uint8 r,g,b,a;
		int bpp = surface->format->BytesPerPixel;
		Uint8* p = (Uint8*)surface->pixels + bpp*x + surface->pitch*y;
		if ( items < 3 || items > 4 ) 
			Perl_croak(aTHX_ "usage: SDL::SurfacePixel(surface,x,y,[color])");
		if ( items == 4) {
			color = (SDL_Color*)SvIV(ST(3));
			pix = SDL_MapRGB(surface->format,color->r,color->g,color->b);
			switch(bpp) {
				case 1:
					*(Uint8*)p = pix;
					break;
				case 2:
					*(Uint16*)p = pix;
					break;
				case 3:
					if (SDL_BYTEORDER == SDL_BIG_ENDIAN) {
						p[0] = (pix >> 16) & 0xff;
						p[1] = (pix >> 8) & 0xff;
						p[2] = pix & 0xff;
					} else {
						p[0] = pix & 0xff;
						p[1] = (pix >> 8) & 0xff;
						p[2] = (pix >> 16) & 0xff;
					}
					break;
				case 4:
					*(Uint32*)p = pix;
					break;
			}
		}
		RETVAL = (SDL_Color *) safemalloc(sizeof(SDL_Color));
		switch(bpp) {
			case 1:
				index = *(Uint8*)p;
				memcpy(RETVAL,&surface->format->palette[index],sizeof(SDL_Color));
				break;
			case 2:
				pix = *(Uint16*)p;
				SDL_GetRGB(pix,surface->format,&r,&g,&b);
				RETVAL->r = r;
				RETVAL->g = g;
				RETVAL->b = b;
				break;
			case 3:
			case 4:
				pix = *(Uint32*)p;
				SDL_GetRGB(pix,surface->format,&r,&g,&b);
				RETVAL->r = r;
				RETVAL->g = g;
				RETVAL->b = b;
				break;
		}
#line 2665 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_MUSTLOCK); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MUSTLOCK)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 1150 "lib/SDL_perl.xs"
		RETVAL = SDL_MUSTLOCK(surface);
#line 2688 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceLock); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceLock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 1158 "lib/SDL_perl.xs"
		RETVAL = SDL_LockSurface(surface);
#line 2711 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SurfaceUnlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SurfaceUnlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
#line 1166 "lib/SDL_perl.xs"
		SDL_UnlockSurface(surface);
#line 2732 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetVideoSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetVideoSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 1171 "lib/SDL_perl.xs"
		RETVAL = SDL_GetVideoSurface();
#line 2753 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_VideoInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_VideoInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 1179 "lib/SDL_perl.xs"
		HV *hv;
		SDL_VideoInfo *info;
		info = (SDL_VideoInfo *) safemalloc ( sizeof(SDL_VideoInfo));
		memcpy(info,SDL_GetVideoInfo(),sizeof(SDL_VideoInfo));
		hv = newHV();
		hv_store(hv,"hw_available",strlen("hw_available"),
			newSViv(info->hw_available),0);
		hv_store(hv,"wm_available",strlen("wm_available"),
			newSViv(info->wm_available),0);
		hv_store(hv,"blit_hw",strlen("blit_hw"),
			newSViv(info->blit_hw),0);
		hv_store(hv,"blit_hw_CC",strlen("blit_hw_CC"),
			newSViv(info->blit_hw_CC),0);
		hv_store(hv,"blit_hw_A",strlen("blit_hw_A"),
			newSViv(info->blit_hw_A),0);
		hv_store(hv,"blit_sw",strlen("blit_sw"),
			newSViv(info->blit_sw),0);
		hv_store(hv,"blit_sw_CC",strlen("blit_sw_CC"),
			newSViv(info->blit_sw_CC),0);
		hv_store(hv,"blit_sw_A",strlen("blit_sw_A"),
			newSViv(info->blit_sw_A),0);
		hv_store(hv,"blit_fill",strlen("blit_fill"),
			newSViv(info->blit_fill),0);
		hv_store(hv,"video_mem",strlen("video_mem"),
			newSViv(info->video_mem),0);
		RETVAL = hv;
#line 2799 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_NewRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "x, y, w, h");
    {
	Sint16	x = (Sint16)SvIV(ST(0));
	Sint16	y = (Sint16)SvIV(ST(1));
	Uint16	w = (Uint16)SvUV(ST(2));
	Uint16	h = (Uint16)SvUV(ST(3));
	SDL_Rect *	RETVAL;
	dXSTARG;
#line 1215 "lib/SDL_perl.xs"
		RETVAL = (SDL_Rect *) safemalloc (sizeof(SDL_Rect));
		RETVAL->x = x;
		RETVAL->y = y;
		RETVAL->w = w;
		RETVAL->h = h;
#line 2830 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "rect");
    {
	SDL_Rect *	rect = INT2PTR(SDL_Rect *,SvIV(ST(0)));
#line 1227 "lib/SDL_perl.xs"
		safefree(rect);
#line 2851 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_RectX); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RectX)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "rect, ...");
    {
	SDL_Rect *	rect = INT2PTR(SDL_Rect *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 1233 "lib/SDL_perl.xs"
		if (items > 1 ) rect->x = SvIV(ST(1)); 
		RETVAL = rect->x;
#line 2874 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RectY); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RectY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "rect, ...");
    {
	SDL_Rect *	rect = INT2PTR(SDL_Rect *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 1242 "lib/SDL_perl.xs"
		if (items > 1 ) rect->y = SvIV(ST(1)); 
		RETVAL = rect->y;
#line 2898 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RectW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RectW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "rect, ...");
    {
	SDL_Rect *	rect = INT2PTR(SDL_Rect *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 1251 "lib/SDL_perl.xs"
		if (items > 1 ) rect->w = SvIV(ST(1)); 
		RETVAL = rect->w;
#line 2922 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_RectH); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_RectH)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "rect, ...");
    {
	SDL_Rect *	rect = INT2PTR(SDL_Rect *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 1260 "lib/SDL_perl.xs"
		if (items > 1 ) rect->h = SvIV(ST(1)); 
		RETVAL = rect->h;
#line 2946 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ListModes); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ListModes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "format, flags");
    {
	Uint32	flags = (Uint32)SvUV(ST(1));
	SDL_PixelFormat *	format = INT2PTR(SDL_PixelFormat *,SvIV(ST(0)));
	AV *	RETVAL;
#line 1270 "lib/SDL_perl.xs"
		SDL_Rect **mode;
		RETVAL = newAV();
		mode = SDL_ListModes(format,flags);
		if (mode == (SDL_Rect**)-1 ) {
			av_push(RETVAL,newSVpv("all",0));
		} else if (! mode ) {
			av_push(RETVAL,newSVpv("none",0));
		} else {
			for (;*mode;mode++) {
				av_push(RETVAL,newSViv(PTR2IV(*mode)));
			}
		}
#line 2980 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_NewColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "r, g, b");
    {
	Uint8	r = (unsigned char)SvUV(ST(0));
	Uint8	g = (unsigned char)SvUV(ST(1));
	Uint8	b = (unsigned char)SvUV(ST(2));
	SDL_Color *	RETVAL;
	dXSTARG;
#line 1292 "lib/SDL_perl.xs"
		RETVAL = (SDL_Color *) safemalloc(sizeof(SDL_Color));
		RETVAL->r = r;
		RETVAL->g = g;
		RETVAL->b = b;
#line 3009 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_ColorR); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ColorR)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "color, ...");
    {
	SDL_Color *	color = INT2PTR(SDL_Color *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 1303 "lib/SDL_perl.xs"
		if (items > 1 ) color->r = SvIV(ST(1)); 
		RETVAL = color->r;
#line 3033 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ColorG); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ColorG)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "color, ...");
    {
	SDL_Color *	color = INT2PTR(SDL_Color *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 1312 "lib/SDL_perl.xs"
		if (items > 1 ) color->g = SvIV(ST(1)); 
		RETVAL = color->g;
#line 3057 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ColorB); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ColorB)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "color, ...");
    {
	SDL_Color *	color = INT2PTR(SDL_Color *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 1321 "lib/SDL_perl.xs"
		if (items > 1 ) color->b = SvIV(ST(1)); 
		RETVAL = color->b;
#line 3081 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ColorRGB); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ColorRGB)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "color, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SDL_Color *	color = INT2PTR(SDL_Color *,SvIV(ST(0)));
#line 1331 "lib/SDL_perl.xs"
 if (items > 1 ) {
 color->r = SvIV(ST(1));
 color->g = SvIV(ST(2));
 color->b = SvIV(ST(3));
 }
 mXPUSHi( color->r );
 mXPUSHi( color->g );
 mXPUSHi( color->b );
 XSRETURN(3);
#line 3112 "lib/SDL_perl.c"
	PUTBACK;
	return;
    }
}


XS(XS_SDL_FreeColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "color");
    {
	SDL_Color *	color = INT2PTR(SDL_Color *,SvIV(ST(0)));
#line 1345 "lib/SDL_perl.xs"
		return; safefree(color);
#line 3133 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NewPalette); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewPalette)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "number");
    {
	int	number = (int)SvIV(ST(0));
	SDL_Palette *	RETVAL;
	dXSTARG;
#line 1351 "lib/SDL_perl.xs"
		RETVAL = (SDL_Palette *)safemalloc(sizeof(SDL_Palette));
		RETVAL->colors = (SDL_Color *)safemalloc(number * 
						sizeof(SDL_Color));
		RETVAL->ncolors = number;
#line 3158 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_PaletteNColors); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PaletteNColors)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "palette, ...");
    {
	SDL_Palette *	palette = INT2PTR(SDL_Palette *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 1362 "lib/SDL_perl.xs"
		if ( items > 1 ) palette->ncolors = SvIV(ST(1));
		RETVAL = palette->ncolors;
#line 3182 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_PaletteColors); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PaletteColors)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "palette, index, ...");
    {
	SDL_Palette *	palette = INT2PTR(SDL_Palette *,SvIV(ST(0)));
	int	index = (int)SvIV(ST(1));
	SDL_Color *	RETVAL;
	dXSTARG;
#line 1372 "lib/SDL_perl.xs"
		if ( items > 2 ) {
			palette->colors[index].r = SvUV(ST(2)); 
			palette->colors[index].g = SvUV(ST(3)); 
			palette->colors[index].b = SvUV(ST(4)); 
		}
		RETVAL = (SDL_Color *)(palette->colors + index);
#line 3211 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_VideoModeOK); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_VideoModeOK)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "width, height, bpp, flags");
    {
	int	width = (int)SvIV(ST(0));
	int	height = (int)SvIV(ST(1));
	int	bpp = (int)SvIV(ST(2));
	Uint32	flags = (Uint32)SvUV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 1388 "lib/SDL_perl.xs"
		RETVAL = SDL_VideoModeOK(width,height,bpp,flags);
#line 3237 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetVideoMode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetVideoMode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "width, height, bpp, flags");
    {
	int	width = (int)SvIV(ST(0));
	int	height = (int)SvIV(ST(1));
	int	bpp = (int)SvIV(ST(2));
	Uint32	flags = (Uint32)SvUV(ST(3));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 1399 "lib/SDL_perl.xs"
		RETVAL = SDL_SetVideoMode(width,height,bpp,flags);
#line 3263 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_UpdateRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_UpdateRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "surface, x, y, w, h");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	x = (int)SvIV(ST(1));
	int	y = (int)SvIV(ST(2));
	int	w = (int)SvIV(ST(3));
	int	h = (int)SvIV(ST(4));
#line 1411 "lib/SDL_perl.xs"
		SDL_UpdateRect(surface,x,y,w,h);
#line 3288 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_UpdateRects); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_UpdateRects)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "surface, ...");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
#line 1417 "lib/SDL_perl.xs"
		SDL_Rect *rects, *oldrects, *temp;
		int num_rects,i;
		if ( items < 2 ) return;
		num_rects = items - 1;
		oldrects = rects;	
		rects = (SDL_Rect *)safemalloc(sizeof(SDL_Rect)*items);
		for(i=0;i<num_rects;i++) {
			temp = (SDL_Rect *)SvIV(ST(i+1));
			rects[i].x = temp->x;
			rects[i].y = temp->y;
			rects[i].w = temp->w;
			rects[i].h = temp->h;
		} 
		SDL_UpdateRects(surface,num_rects,rects);
		safefree(rects);
		safefree(oldrects);
#line 3323 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_Flip); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Flip)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 1438 "lib/SDL_perl.xs"
		RETVAL = SDL_Flip(surface);
#line 3345 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetColors); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetColors)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "surface, start, ...");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	start = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 1447 "lib/SDL_perl.xs"
		SDL_Color *colors,*temp;
		int i, length;
		if ( items < 3 ) { RETVAL = 0;	goto all_done; }
		length = items - 2;
		colors = (SDL_Color *)safemalloc(sizeof(SDL_Color)*(length+1));
		for ( i = 0; i < length ; i++ ) {
			temp = (SDL_Color *)SvIV(ST(i+2));
			colors[i].r = temp->r;
			colors[i].g = temp->g;
			colors[i].b = temp->b;
		}
		RETVAL = SDL_SetColors(surface, colors, start, length );
		safefree(colors);
all_done:
#line 3382 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MapRGB); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MapRGB)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "surface, r, g, b");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	r = (unsigned char)SvUV(ST(1));
	Uint8	g = (unsigned char)SvUV(ST(2));
	Uint8	b = (unsigned char)SvUV(ST(3));
	Uint32	RETVAL;
	dXSTARG;
#line 1471 "lib/SDL_perl.xs"
		RETVAL = SDL_MapRGB(surface->format,r,g,b);
#line 3408 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MapRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MapRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "surface, r, g, b, a");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint8	r = (unsigned char)SvUV(ST(1));
	Uint8	g = (unsigned char)SvUV(ST(2));
	Uint8	b = (unsigned char)SvUV(ST(3));
	Uint8	a = (unsigned char)SvUV(ST(4));
	Uint32	RETVAL;
	dXSTARG;
#line 1483 "lib/SDL_perl.xs"
		RETVAL = SDL_MapRGBA(surface->format,r,g,b,a);
#line 3435 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GetRGB); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetRGB)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "surface, pixel");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	pixel = (Uint32)SvUV(ST(1));
	AV *	RETVAL;
#line 1492 "lib/SDL_perl.xs"
		Uint8 r,g,b;
		SDL_GetRGB(pixel,surface->format,&r,&g,&b);
		RETVAL = newAV();
		av_push(RETVAL,newSViv(r));
		av_push(RETVAL,newSViv(g));
		av_push(RETVAL,newSViv(b));
#line 3463 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_GetRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "surface, pixel");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	pixel = (Uint32)SvUV(ST(1));
	AV *	RETVAL;
#line 1506 "lib/SDL_perl.xs"
		Uint8 r,g,b,a;
		SDL_GetRGBA(pixel,surface->format,&r,&g,&b,&a);
		RETVAL = newAV();
		av_push(RETVAL,newSViv(r));
		av_push(RETVAL,newSViv(g));
		av_push(RETVAL,newSViv(b));
		av_push(RETVAL,newSViv(a));
#line 3493 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_SaveBMP); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SaveBMP)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "surface, filename");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	char *	filename = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;
#line 1521 "lib/SDL_perl.xs"
		RETVAL = SDL_SaveBMP(surface,filename);
#line 3518 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetColorKey); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetColorKey)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "surface, flag, key");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	flag = (Uint32)SvUV(ST(1));
	SDL_Color *	key = INT2PTR(SDL_Color *,SvIV(ST(2)));
	int	RETVAL;
	dXSTARG;
#line 1531 "lib/SDL_perl.xs"
		Uint32 pixel = SDL_MapRGB(surface->format,key->r,key->g,key->b);
		RETVAL = SDL_SetColorKey(surface,flag,pixel);
#line 3544 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetAlpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetAlpha)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "surface, flag, alpha");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Uint32	flag = (Uint32)SvUV(ST(1));
	Uint8	alpha = (unsigned char)SvUV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 1542 "lib/SDL_perl.xs"
		RETVAL = SDL_SetAlpha(surface,flag,alpha);
#line 3569 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_DisplayFormat); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_DisplayFormat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 1550 "lib/SDL_perl.xs"
		RETVAL = SDL_DisplayFormat(surface);
#line 3592 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_DisplayFormatAlpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_DisplayFormatAlpha)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 1558 "lib/SDL_perl.xs"
		RETVAL = SDL_DisplayFormatAlpha(surface);
#line 3615 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_ConvertRGB); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ConvertRGB)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 1566 "lib/SDL_perl.xs"
		SDL_PixelFormat fmt;
		fmt.palette = NULL;
		fmt.BitsPerPixel = 24;
		fmt.BytesPerPixel = 3;
		fmt.Rmask = 0x000000ff;
		fmt.Gmask = 0x0000ff00;
		fmt.Bmask = 0x00ff0000;
		fmt.Amask = 0x00000000;
		fmt.Rloss = 0;
		fmt.Gloss = 0;
		fmt.Bloss = 0;
		fmt.Aloss = 0;
		fmt.Rshift = 0;
		fmt.Gshift = 8;
		fmt.Bshift = 16;
		fmt.Ashift = 24;
		fmt.colorkey = 0;
		fmt.alpha = 0;
		RETVAL = SDL_ConvertSurface(surface,&fmt,surface->flags);
#line 3656 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_ConvertRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ConvertRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 1592 "lib/SDL_perl.xs"
		SDL_PixelFormat fmt;
		fmt.palette = NULL;
		fmt.BitsPerPixel = 32;
		fmt.BytesPerPixel = 4;
		fmt.Rmask = 0x000000ff;
		fmt.Gmask = 0x0000ff00;
		fmt.Bmask = 0x00ff0000;
		fmt.Amask = 0xff000000;
		fmt.Rloss = 0;
		fmt.Gloss = 0;
		fmt.Bloss = 0;
		fmt.Aloss = 0;
		fmt.Rshift = 0;
		fmt.Gshift = 8;
		fmt.Bshift = 16;
		fmt.Ashift = 24;
		fmt.colorkey = 0;
		fmt.alpha = 0;
		RETVAL = SDL_ConvertSurface(surface,&fmt,surface->flags);
#line 3697 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_BlitSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_BlitSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "src, src_rect, dest, dest_rect");
    {
	SDL_Surface *	src = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Rect *	src_rect = INT2PTR(SDL_Rect *,SvIV(ST(1)));
	SDL_Surface *	dest = INT2PTR(SDL_Surface *,SvIV(ST(2)));
	SDL_Rect *	dest_rect = INT2PTR(SDL_Rect *,SvIV(ST(3)));
	int	RETVAL;
	dXSTARG;
#line 1621 "lib/SDL_perl.xs"
		RETVAL = SDL_BlitSurface(src,src_rect,dest,dest_rect);
#line 3723 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_FillRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FillRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "dest, dest_rect, color");
    {
	SDL_Surface *	dest = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Rect *	dest_rect = INT2PTR(SDL_Rect *,SvIV(ST(1)));
	SDL_Color *	color = INT2PTR(SDL_Color *,SvIV(ST(2)));
	int	RETVAL;
	dXSTARG;
#line 1631 "lib/SDL_perl.xs"
		Uint32 pixel = SDL_MapRGB(dest->format,color->r,color->g,color->b);
		RETVAL = SDL_FillRect(dest,dest_rect,pixel);
#line 3749 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GetAppState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetAppState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Uint8	RETVAL;
	dXSTARG;
#line 1639 "lib/SDL_perl.xs"
		RETVAL = SDL_GetAppState();
#line 3771 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_WMSetCaption); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WMSetCaption)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "title, icon");
    {
	char *	title = (char *)SvPV_nolen(ST(0));
	char *	icon = (char *)SvPV_nolen(ST(1));
#line 1649 "lib/SDL_perl.xs"
		SDL_WM_SetCaption(title,icon);
#line 3793 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_WMGetCaption); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WMGetCaption)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 1654 "lib/SDL_perl.xs"
		char *title,*icon;
		SDL_WM_GetCaption(&title,&icon);
		RETVAL = newAV();
		av_push(RETVAL,newSVpv(title,0));
		av_push(RETVAL,newSVpv(icon,0));
#line 3817 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_WMSetIcon); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WMSetIcon)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "icon");
    {
	SDL_Surface *	icon = INT2PTR(SDL_Surface *,SvIV(ST(0)));
#line 1666 "lib/SDL_perl.xs"
		SDL_WM_SetIcon(icon,NULL);
#line 3839 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_WarpMouse); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WarpMouse)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	Uint16	x = (Uint16)SvUV(ST(0));
	Uint16	y = (Uint16)SvUV(ST(1));
#line 1673 "lib/SDL_perl.xs"
		SDL_WarpMouse(x,y);
#line 3860 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetMouseState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetMouseState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 1678 "lib/SDL_perl.xs"
		Uint8 mask;
		int x;
		int y;
		mask = SDL_GetMouseState(&x,&y);
		RETVAL = newAV();
		av_push(RETVAL,newSViv(mask));
		av_push(RETVAL,newSViv(x));
		av_push(RETVAL,newSViv(y));
#line 3887 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_GetRelativeMouseState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetRelativeMouseState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 1692 "lib/SDL_perl.xs"
		Uint8 mask;
		int x;
		int y;
		mask = SDL_GetRelativeMouseState(&x,&y);
		RETVAL = newAV();
		av_push(RETVAL,newSViv(mask));
		av_push(RETVAL,newSViv(x));
		av_push(RETVAL,newSViv(y));
#line 3916 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_NewCursor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewCursor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "data, mask, x, y");
    {
	SDL_Surface *	data = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Surface *	mask = INT2PTR(SDL_Surface *,SvIV(ST(1)));
	int	x = (int)SvIV(ST(2));
	int	y = (int)SvIV(ST(3));
	SDL_Cursor *	RETVAL;
	dXSTARG;
#line 1710 "lib/SDL_perl.xs"
		RETVAL = SDL_CreateCursor((Uint8*)data->pixels,
				(Uint8*)mask->pixels,data->w,data->h,x,y);
#line 3944 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeCursor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeCursor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cursor");
    {
	SDL_Cursor *	cursor = INT2PTR(SDL_Cursor *,SvIV(ST(0)));
#line 1719 "lib/SDL_perl.xs"
		SDL_FreeCursor(cursor);
#line 3965 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SetCursor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetCursor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cursor");
    {
	SDL_Cursor *	cursor = INT2PTR(SDL_Cursor *,SvIV(ST(0)));
#line 1725 "lib/SDL_perl.xs"
		SDL_SetCursor(cursor);
#line 3985 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetCursor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetCursor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SDL_Cursor *	RETVAL;
	dXSTARG;
#line 1730 "lib/SDL_perl.xs"
		RETVAL = SDL_GetCursor();
#line 4006 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_ShowCursor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ShowCursor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "toggle");
    {
	int	toggle = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 1738 "lib/SDL_perl.xs"
		RETVAL = SDL_ShowCursor(toggle);
#line 4029 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NewAudioSpec); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewAudioSpec)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "freq, format, channels, samples");
    {
	int	freq = (int)SvIV(ST(0));
	Uint16	format = (Uint16)SvUV(ST(1));
	Uint8	channels = (unsigned char)SvUV(ST(2));
	Uint16	samples = (Uint16)SvUV(ST(3));
	SDL_AudioSpec *	RETVAL;
	dXSTARG;
#line 1749 "lib/SDL_perl.xs"
		RETVAL = (SDL_AudioSpec *)safemalloc(sizeof(SDL_AudioSpec));
		RETVAL->freq = freq;
		RETVAL->format = format;
		RETVAL->channels = channels;
		RETVAL->samples = samples;
#line 4059 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeAudioSpec); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeAudioSpec)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "spec");
    {
	SDL_AudioSpec *	spec = INT2PTR(SDL_AudioSpec *,SvIV(ST(0)));
#line 1761 "lib/SDL_perl.xs"
		safefree(spec);
#line 4080 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NewAudioCVT); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewAudioCVT)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "src_format, src_channels, src_rate, dst_format, dst_channels, dst_rate");
    {
	Uint16	src_format = (Uint16)SvUV(ST(0));
	Uint8	src_channels = (unsigned char)SvUV(ST(1));
	int	src_rate = (int)SvIV(ST(2));
	Uint16	dst_format = (Uint16)SvUV(ST(3));
	Uint8	dst_channels = (unsigned char)SvUV(ST(4));
	int	dst_rate = (int)SvIV(ST(5));
	SDL_AudioCVT *	RETVAL;
	dXSTARG;
#line 1772 "lib/SDL_perl.xs"
		RETVAL = (SDL_AudioCVT *)safemalloc(sizeof(SDL_AudioCVT));
		if (SDL_BuildAudioCVT(RETVAL,src_format, src_channels, src_rate,
			dst_format, dst_channels, dst_rate)) { 
			safefree(RETVAL); RETVAL = NULL; }
#line 4110 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeAudioCVT); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeAudioCVT)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cvt");
    {
	SDL_AudioCVT *	cvt = INT2PTR(SDL_AudioCVT *,SvIV(ST(0)));
#line 1783 "lib/SDL_perl.xs"
		safefree(cvt);
#line 4131 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_ConvertAudioData); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ConvertAudioData)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "cvt, data, len");
    {
	SDL_AudioCVT *	cvt = INT2PTR(SDL_AudioCVT *,SvIV(ST(0)));
	Uint8 *	data = INT2PTR(Uint8 *,SvIV(ST(1)));
	int	len = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 1791 "lib/SDL_perl.xs"
		cvt->len = len;
		cvt->buf = (Uint8*) safemalloc(cvt->len*cvt->len_mult);
		memcpy(cvt->buf,data,cvt->len);
		RETVAL = SDL_ConvertAudio(cvt);
#line 4158 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_OpenAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OpenAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "spec, callback");
    {
	SDL_AudioSpec *	spec = INT2PTR(SDL_AudioSpec *,SvIV(ST(0)));
	SV*	callback = ST(1);
	int	RETVAL;
	dXSTARG;
#line 1803 "lib/SDL_perl.xs"
		spec->userdata = (void*)callback;
		spec->callback = sdl_perl_audio_callback;
		RETVAL = SDL_OpenAudio(spec,NULL);
#line 4184 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GetAudioStatus); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetAudioStatus)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Uint32	RETVAL;
	dXSTARG;
#line 1812 "lib/SDL_perl.xs"
		RETVAL = SDL_GetAudioStatus ();
#line 4206 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_PauseAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PauseAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "p_on");
    {
	int	p_on = (int)SvIV(ST(0));
#line 1820 "lib/SDL_perl.xs"
		SDL_PauseAudio(p_on);
#line 4227 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_LockAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_LockAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1825 "lib/SDL_perl.xs"
		SDL_LockAudio();
#line 4246 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_UnlockAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_UnlockAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1830 "lib/SDL_perl.xs"
		SDL_UnlockAudio();
#line 4265 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_CloseAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CloseAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1835 "lib/SDL_perl.xs"
		SDL_CloseAudio();
#line 4284 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_FreeWAV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeWAV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "buf");
    {
	Uint8 *	buf = INT2PTR(Uint8 *,SvIV(ST(0)));
#line 1841 "lib/SDL_perl.xs"
		SDL_FreeWAV(buf);
#line 4304 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_LoadWAV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_LoadWAV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "filename, spec");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	SDL_AudioSpec *	spec = INT2PTR(SDL_AudioSpec *,SvIV(ST(1)));
	AV *	RETVAL;
#line 1848 "lib/SDL_perl.xs"
		SDL_AudioSpec *temp;
		Uint8 *buf;
		Uint32 len;

		RETVAL = newAV();
		temp = SDL_LoadWAV(filename,spec,&buf,&len);
		if ( ! temp ) goto error;
		av_push(RETVAL,newSViv(PTR2IV(temp)));
		av_push(RETVAL,newSViv(PTR2IV(buf)));
		av_push(RETVAL,newSViv(len));
error:
#line 4336 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef HAVE_SDL_MIXER
#define XSubPPtmpAAAB 1


XS(XS_SDL_MixAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "dst, src, len, volume");
    {
	Uint8 *	dst = INT2PTR(Uint8 *,SvIV(ST(0)));
	Uint8 *	src = INT2PTR(Uint8 *,SvIV(ST(1)));
	Uint32	len = (Uint32)SvUV(ST(2));
	int	volume = (int)SvIV(ST(3));
#line 1871 "lib/SDL_perl.xs"
		SDL_MixAudio(dst,src,len,volume);
#line 4364 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixOpenAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixOpenAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "frequency, format, channels, chunksize");
    {
	int	frequency = (int)SvIV(ST(0));
	Uint16	format = (Uint16)SvUV(ST(1));
	int	channels = (int)SvIV(ST(2));
	int	chunksize = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 1880 "lib/SDL_perl.xs"
		RETVAL = Mix_OpenAudio(frequency, format, channels, chunksize);
#line 4389 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixAllocateChannels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixAllocateChannels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "number");
    {
	int	number = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 1888 "lib/SDL_perl.xs"
		RETVAL = Mix_AllocateChannels(number);
#line 4412 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixQuerySpec); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixQuerySpec)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 1895 "lib/SDL_perl.xs"
		int freq, channels, status;
		Uint16 format;
		status = Mix_QuerySpec(&freq,&format,&channels);
		RETVAL = newAV();
		av_push(RETVAL,newSViv(status));
		av_push(RETVAL,newSViv(freq));
		av_push(RETVAL,newSViv(format));
		av_push(RETVAL,newSViv(channels));
#line 4440 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_MixLoadWAV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixLoadWAV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "filename");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	Mix_Chunk *	RETVAL;
	dXSTARG;
#line 1910 "lib/SDL_perl.xs"
		RETVAL = Mix_LoadWAV(filename);
#line 4464 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_MixLoadMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixLoadMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "filename");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	Mix_Music *	RETVAL;
	dXSTARG;
#line 1918 "lib/SDL_perl.xs"
		RETVAL = Mix_LoadMUS(filename);
#line 4487 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_MixQuickLoadWAV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixQuickLoadWAV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "buf");
    {
	Uint8 *	buf = INT2PTR(Uint8 *,SvIV(ST(0)));
	Mix_Chunk *	RETVAL;
	dXSTARG;
#line 1926 "lib/SDL_perl.xs"
		RETVAL = Mix_QuickLoad_WAV(buf);
#line 4510 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFreeChunk); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFreeChunk)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "chunk");
    {
	Mix_Chunk *	chunk = INT2PTR(Mix_Chunk *,SvIV(ST(0)));
#line 1934 "lib/SDL_perl.xs"
		Mix_FreeChunk(chunk);
#line 4531 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixFreeMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFreeMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "music");
    {
	Mix_Music *	music = INT2PTR(Mix_Music *,SvIV(ST(0)));
#line 1940 "lib/SDL_perl.xs"
		Mix_FreeMusic(music);
#line 4551 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixSetPostMixCallback); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixSetPostMixCallback)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "func, arg");
    {
	void *	func = INT2PTR(void *,SvIV(ST(0)));
	void *	arg = INT2PTR(void *,SvIV(ST(1)));
#line 1947 "lib/SDL_perl.xs"
		Mix_SetPostMix(func,arg);
#line 4572 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_PerlMixMusicHook); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_PerlMixMusicHook)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	void *	RETVAL;
	dXSTARG;
#line 1952 "lib/SDL_perl.xs"
		RETVAL = sdl_perl_music_callback;
#line 4593 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_MixSetMusicHook); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixSetMusicHook)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "func, arg");
    {
	void *	func = INT2PTR(void *,SvIV(ST(0)));
	void *	arg = INT2PTR(void *,SvIV(ST(1)));
#line 1961 "lib/SDL_perl.xs"
		Mix_HookMusic(func,arg);
#line 4615 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixSetMusicFinishedHook); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixSetMusicFinishedHook)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "func");
    {
	void *	func = INT2PTR(void *,SvIV(ST(0)));
#line 1967 "lib/SDL_perl.xs"
		mix_music_finished_cv = func;
		Mix_HookMusicFinished(sdl_perl_music_finished_callback);
#line 4636 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixGetMusicHookData); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGetMusicHookData)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	void *	RETVAL;
	dXSTARG;
#line 1973 "lib/SDL_perl.xs"
		RETVAL = Mix_GetMusicHookData();
#line 4657 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_MixReverseChannels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixReverseChannels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "number");
    {
	int	number = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 1981 "lib/SDL_perl.xs"
		RETVAL = Mix_ReserveChannels ( number );
#line 4680 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixGroupChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGroupChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "which, tag");
    {
	int	which = (int)SvIV(ST(0));
	int	tag = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 1990 "lib/SDL_perl.xs"
		RETVAL = Mix_GroupChannel(which,tag);
#line 4704 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixGroupChannels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGroupChannels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "from, to, tag");
    {
	int	from = (int)SvIV(ST(0));
	int	to = (int)SvIV(ST(1));
	int	tag = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2000 "lib/SDL_perl.xs"
		RETVAL = Mix_GroupChannels(from,to,tag);
#line 4729 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixGroupAvailable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGroupAvailable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2008 "lib/SDL_perl.xs"
		RETVAL = Mix_GroupAvailable(tag);
#line 4752 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixGroupCount); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGroupCount)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2016 "lib/SDL_perl.xs"
		RETVAL = Mix_GroupCount(tag);
#line 4775 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixGroupOldest); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGroupOldest)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2024 "lib/SDL_perl.xs"
		RETVAL = Mix_GroupOldest(tag);
#line 4798 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixGroupNewer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixGroupNewer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2032 "lib/SDL_perl.xs"
		RETVAL = Mix_GroupNewer(tag);
#line 4821 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPlayChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPlayChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "channel, chunk, loops");
    {
	int	channel = (int)SvIV(ST(0));
	Mix_Chunk *	chunk = INT2PTR(Mix_Chunk *,SvIV(ST(1)));
	int	loops = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2042 "lib/SDL_perl.xs"
		RETVAL = Mix_PlayChannel(channel,chunk,loops);
#line 4846 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPlayChannelTimed); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPlayChannelTimed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "channel, chunk, loops, ticks");
    {
	int	channel = (int)SvIV(ST(0));
	Mix_Chunk *	chunk = INT2PTR(Mix_Chunk *,SvIV(ST(1)));
	int	loops = (int)SvIV(ST(2));
	int	ticks = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 2053 "lib/SDL_perl.xs"
		RETVAL = Mix_PlayChannelTimed(channel,chunk,loops,ticks);
#line 4872 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPlayMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPlayMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "music, loops");
    {
	Mix_Music *	music = INT2PTR(Mix_Music *,SvIV(ST(0)));
	int	loops = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2062 "lib/SDL_perl.xs"
		RETVAL = Mix_PlayMusic(music,loops);
#line 4896 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadeInChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadeInChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "channel, chunk, loops, ms");
    {
	int	channel = (int)SvIV(ST(0));
	Mix_Chunk *	chunk = INT2PTR(Mix_Chunk *,SvIV(ST(1)));
	int	loops = (int)SvIV(ST(2));
	int	ms = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 2073 "lib/SDL_perl.xs"
		RETVAL = Mix_FadeInChannel(channel,chunk,loops,ms);
#line 4922 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadeInChannelTimed); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadeInChannelTimed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "channel, chunk, loops, ms, ticks");
    {
	int	channel = (int)SvIV(ST(0));
	Mix_Chunk *	chunk = INT2PTR(Mix_Chunk *,SvIV(ST(1)));
	int	loops = (int)SvIV(ST(2));
	int	ticks = (int)SvIV(ST(4));
	int	ms = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 2085 "lib/SDL_perl.xs"
		RETVAL = Mix_FadeInChannelTimed(channel,chunk,loops,ms,ticks);
#line 4949 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadeInMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadeInMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "music, loops, ms");
    {
	Mix_Music *	music = INT2PTR(Mix_Music *,SvIV(ST(0)));
	int	loops = (int)SvIV(ST(1));
	int	ms = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2095 "lib/SDL_perl.xs"
		RETVAL = Mix_FadeInMusic(music,loops,ms);
#line 4974 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixVolume); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixVolume)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "channel, volume");
    {
	int	channel = (int)SvIV(ST(0));
	int	volume = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2104 "lib/SDL_perl.xs"
		RETVAL = Mix_Volume(channel,volume);
#line 4998 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixVolumeChunk); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixVolumeChunk)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "chunk, volume");
    {
	Mix_Chunk *	chunk = INT2PTR(Mix_Chunk *,SvIV(ST(0)));
	int	volume = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2113 "lib/SDL_perl.xs"
		RETVAL = Mix_VolumeChunk(chunk,volume);
#line 5022 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixVolumeMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixVolumeMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "volume");
    {
	int	volume = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2121 "lib/SDL_perl.xs"
		RETVAL = Mix_VolumeMusic(volume);
#line 5045 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixHaltChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixHaltChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "channel");
    {
	int	channel = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2129 "lib/SDL_perl.xs"
		RETVAL = Mix_HaltChannel(channel);
#line 5068 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixHaltGroup); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixHaltGroup)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2137 "lib/SDL_perl.xs"
		RETVAL = Mix_HaltGroup(tag);
#line 5091 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixHaltMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixHaltMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2144 "lib/SDL_perl.xs"
		RETVAL = Mix_HaltMusic();
#line 5113 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixExpireChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixExpireChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "channel, ticks");
    {
	int	channel = (int)SvIV(ST(0));
	int	ticks = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2153 "lib/SDL_perl.xs"
		RETVAL = Mix_ExpireChannel ( channel,ticks);
#line 5137 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadeOutChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadeOutChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "which, ms");
    {
	int	which = (int)SvIV(ST(0));
	int	ms = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2162 "lib/SDL_perl.xs"
		RETVAL = Mix_FadeOutChannel(which,ms);
#line 5161 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadeOutGroup); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadeOutGroup)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "which, ms");
    {
	int	which = (int)SvIV(ST(0));
	int	ms = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2171 "lib/SDL_perl.xs"
		RETVAL = Mix_FadeOutGroup(which,ms);
#line 5185 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadeOutMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadeOutMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ms");
    {
	int	ms = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2179 "lib/SDL_perl.xs"
		RETVAL = Mix_FadeOutMusic(ms);
#line 5208 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadingMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadingMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Mix_Fading	RETVAL;
	dXSTARG;
#line 2186 "lib/SDL_perl.xs"
		RETVAL = Mix_FadingMusic();
#line 5230 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixFadingChannel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixFadingChannel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "which");
    {
	int	which = (int)SvIV(ST(0));
	Mix_Fading	RETVAL;
	dXSTARG;
#line 2194 "lib/SDL_perl.xs"
		RETVAL = Mix_FadingChannel(which);
#line 5253 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPause); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPause)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "channel");
    {
	int	channel = (int)SvIV(ST(0));
#line 2202 "lib/SDL_perl.xs"
		Mix_Pause(channel);
#line 5274 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixResume); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixResume)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "channel");
    {
	int	channel = (int)SvIV(ST(0));
#line 2208 "lib/SDL_perl.xs"
		Mix_Resume(channel);
#line 5294 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixPaused); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPaused)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "channel");
    {
	int	channel = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2214 "lib/SDL_perl.xs"
		RETVAL = Mix_Paused(channel);
#line 5316 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPauseMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPauseMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2221 "lib/SDL_perl.xs"
		Mix_PauseMusic();
#line 5336 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixResumeMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixResumeMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2226 "lib/SDL_perl.xs"
		Mix_ResumeMusic();
#line 5355 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixRewindMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixRewindMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2231 "lib/SDL_perl.xs"
		Mix_RewindMusic();
#line 5374 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_MixPausedMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPausedMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2236 "lib/SDL_perl.xs"
		RETVAL = Mix_PausedMusic();
#line 5395 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPlaying); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPlaying)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "channel");
    {
	int	channel = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2244 "lib/SDL_perl.xs"
		RETVAL = Mix_Playing(channel);
#line 5418 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixPlayingMusic); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixPlayingMusic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2251 "lib/SDL_perl.xs"
		RETVAL = Mix_PlayingMusic();
#line 5440 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_MixCloseAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_MixCloseAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2259 "lib/SDL_perl.xs"
		Mix_CloseAudio();
#line 5460 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS(XS_SDL_GLLoadLibrary); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GLLoadLibrary)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "path");
    {
	char *	path = (char *)SvPV_nolen(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2267 "lib/SDL_perl.xs"
		RETVAL = SDL_GL_LoadLibrary(path);
#line 5483 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GLGetProcAddress); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GLGetProcAddress)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "proc");
    {
	char *	proc = (char *)SvPV_nolen(ST(0));
	void *	RETVAL;
	dXSTARG;
#line 2275 "lib/SDL_perl.xs"
		RETVAL = SDL_GL_GetProcAddress(proc);
#line 5506 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_GLSetAttribute); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GLSetAttribute)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "attr, value");
    {
	int	attr = (int)SvIV(ST(0));
	int	value = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2284 "lib/SDL_perl.xs"
		RETVAL = SDL_GL_SetAttribute(attr, value);
#line 5530 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GLGetAttribute); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GLGetAttribute)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "attr");
    {
	int	attr = (int)SvIV(ST(0));
	AV *	RETVAL;
#line 2292 "lib/SDL_perl.xs"
		int value;
		RETVAL = newAV();
		av_push(RETVAL,newSViv(SDL_GL_GetAttribute(attr, &value)));
		av_push(RETVAL,newSViv(value));
#line 5555 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_GLSwapBuffers); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GLSwapBuffers)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2302 "lib/SDL_perl.xs"
		SDL_GL_SwapBuffers ();
#line 5576 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_BigEndian); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_BigEndian)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2308 "lib/SDL_perl.xs"
		RETVAL = (SDL_BYTEORDER == SDL_BIG_ENDIAN);
#line 5597 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NumJoysticks); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NumJoysticks)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2315 "lib/SDL_perl.xs"
		RETVAL = SDL_NumJoysticks();
#line 5619 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "index");
    {
	int	index = (int)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;
#line 2323 "lib/SDL_perl.xs"
		RETVAL = (char*)SDL_JoystickName(index);
#line 5642 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickOpen); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickOpen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "index");
    {
	int	index = (int)SvIV(ST(0));
	SDL_Joystick *	RETVAL;
	dXSTARG;
#line 2331 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickOpen(index);
#line 5665 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickOpened); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickOpened)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "index");
    {
	int	index = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2339 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickOpened(index);
#line 5688 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickIndex); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickIndex)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "joystick");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2347 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickIndex(joystick);
#line 5711 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickNumAxes); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickNumAxes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "joystick");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2355 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickNumAxes(joystick);
#line 5734 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickNumBalls); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickNumBalls)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "joystick");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2363 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickNumBalls(joystick);
#line 5757 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickNumHats); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickNumHats)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "joystick");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2371 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickNumHats(joystick);
#line 5780 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickNumButtons); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickNumButtons)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "joystick");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2379 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickNumButtons(joystick);
#line 5803 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickUpdate); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickUpdate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2386 "lib/SDL_perl.xs"
		SDL_JoystickUpdate();
#line 5823 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_JoystickGetAxis); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickGetAxis)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "joystick, axis");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	axis = (int)SvIV(ST(1));
	Sint16	RETVAL;
	dXSTARG;
#line 2393 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickGetAxis(joystick,axis);
#line 5846 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickGetHat); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickGetHat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "joystick, hat");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	hat = (int)SvIV(ST(1));
	Uint8	RETVAL;
	dXSTARG;
#line 2402 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickGetHat(joystick,hat);
#line 5870 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickGetButton); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickGetButton)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "joystick, button");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	button = (int)SvIV(ST(1));
	Uint8	RETVAL;
	dXSTARG;
#line 2411 "lib/SDL_perl.xs"
		RETVAL = SDL_JoystickGetButton(joystick,button);
#line 5894 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickGetBall); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickGetBall)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "joystick, ball");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
	int	ball = (int)SvIV(ST(1));
	AV *	RETVAL;
#line 2420 "lib/SDL_perl.xs"
		int success,dx,dy;
		success = SDL_JoystickGetBall(joystick,ball,&dx,&dy);
		RETVAL = newAV();
		av_push(RETVAL,newSViv(success));
		av_push(RETVAL,newSViv(dx));
		av_push(RETVAL,newSViv(dy));
#line 5922 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_JoystickClose); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoystickClose)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "joystick");
    {
	SDL_Joystick *	joystick = INT2PTR(SDL_Joystick *,SvIV(ST(0)));
#line 2433 "lib/SDL_perl.xs"
		SDL_JoystickClose(joystick);
#line 5944 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_JoyAxisEventWhich); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyAxisEventWhich)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 2439 "lib/SDL_perl.xs"
		RETVAL = e->jaxis.which;
#line 5966 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyAxisEventAxis); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyAxisEventAxis)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2447 "lib/SDL_perl.xs"
                RETVAL = e->jaxis.axis;
#line 5989 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyAxisEventValue); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyAxisEventValue)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 2455 "lib/SDL_perl.xs"
                RETVAL = e->jaxis.value;
#line 6012 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyButtonEventWhich); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyButtonEventWhich)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2463 "lib/SDL_perl.xs"
                RETVAL = e->jbutton.which;
#line 6035 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyButtonEventButton); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyButtonEventButton)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2471 "lib/SDL_perl.xs"
                RETVAL = e->jbutton.button;
#line 6058 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyButtonEventState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyButtonEventState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2479 "lib/SDL_perl.xs"
                RETVAL = e->jbutton.state;
#line 6081 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyHatEventWhich); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyHatEventWhich)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2487 "lib/SDL_perl.xs"
                RETVAL = e->jhat.which;
#line 6104 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyHatEventHat); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyHatEventHat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2495 "lib/SDL_perl.xs"
                RETVAL = e->jhat.hat;
#line 6127 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyHatEventValue); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyHatEventValue)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2503 "lib/SDL_perl.xs"
                RETVAL = e->jhat.value;
#line 6150 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyBallEventWhich); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyBallEventWhich)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2511 "lib/SDL_perl.xs"
                RETVAL = e->jball.which;
#line 6173 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyBallEventBall); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyBallEventBall)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 2519 "lib/SDL_perl.xs"
                RETVAL = e->jball.ball;
#line 6196 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyBallEventXrel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyBallEventXrel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 2527 "lib/SDL_perl.xs"
                RETVAL = e->jball.xrel;
#line 6219 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_JoyBallEventYrel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_JoyBallEventYrel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	Sint16	RETVAL;
	dXSTARG;
#line 2535 "lib/SDL_perl.xs"
                RETVAL = e->jball.yrel;
#line 6242 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SetClipRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SetClipRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "surface, rect");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Rect *	rect = INT2PTR(SDL_Rect *,SvIV(ST(1)));
#line 2544 "lib/SDL_perl.xs"
		SDL_SetClipRect(surface,rect);
#line 6264 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_GetClipRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetClipRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	SDL_Rect *	RETVAL;
	dXSTARG;
#line 2550 "lib/SDL_perl.xs"
		RETVAL = (SDL_Rect*) safemalloc(sizeof(SDL_Rect));
		SDL_GetClipRect(surface,RETVAL);
#line 6287 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#ifdef HAVE_SDL_NET
#define XSubPPtmpAAAC 1


XS(XS_SDL_NetInit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetInit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2561 "lib/SDL_perl.xs"
		RETVAL = SDLNet_Init();
#line 6312 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetQuit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetQuit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2568 "lib/SDL_perl.xs"
		SDLNet_Quit();
#line 6332 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetNewIPaddress); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetNewIPaddress)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "host, port");
    {
	Uint32	host = (Uint32)SvUV(ST(0));
	Uint16	port = (Uint16)SvUV(ST(1));
	IPaddress *	RETVAL;
	dXSTARG;
#line 2575 "lib/SDL_perl.xs"
		RETVAL = (IPaddress*) safemalloc(sizeof(IPaddress));
		RETVAL->host = host;
		RETVAL->port = port;
#line 6357 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetIPaddressHost); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetIPaddressHost)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ip");
    {
	IPaddress *	ip = INT2PTR(IPaddress *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 2585 "lib/SDL_perl.xs"
		RETVAL = ip->host;
#line 6380 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetIPaddressPort); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetIPaddressPort)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ip");
    {
	IPaddress *	ip = INT2PTR(IPaddress *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 2593 "lib/SDL_perl.xs"
		RETVAL = ip->port;
#line 6403 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetFreeIPaddress); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetFreeIPaddress)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ip");
    {
	IPaddress *	ip = INT2PTR(IPaddress *,SvIV(ST(0)));
#line 2601 "lib/SDL_perl.xs"
		safefree(ip);
#line 6424 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetResolveIP); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetResolveIP)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "address");
    {
	IPaddress *	address = INT2PTR(IPaddress *,SvIV(ST(0)));
	const char *	RETVAL;
	dXSTARG;
#line 2607 "lib/SDL_perl.xs"
		RETVAL = SDLNet_ResolveIP(address);
#line 6446 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_NetResolveHost); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetResolveHost)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "address, host, port");
    {
	IPaddress *	address = INT2PTR(IPaddress *,SvIV(ST(0)));
	const char *	host = (const char *)SvPV_nolen(ST(1));
	Uint16	port = (Uint16)SvUV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2617 "lib/SDL_perl.xs"
		RETVAL = SDLNet_ResolveHost(address,host,port);
#line 6471 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCPOpen); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCPOpen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ip");
    {
	IPaddress *	ip = INT2PTR(IPaddress *,SvIV(ST(0)));
	TCPsocket	RETVAL;
	dXSTARG;
#line 2625 "lib/SDL_perl.xs"
		RETVAL = SDLNet_TCP_Open(ip);
#line 6494 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCPAccept); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCPAccept)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "server");
    {
	TCPsocket	server = INT2PTR(TCPsocket,SvIV(ST(0)));
	TCPsocket	RETVAL;
	dXSTARG;
#line 2633 "lib/SDL_perl.xs"
		RETVAL = SDLNet_TCP_Accept(server);
#line 6517 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCPGetPeerAddress); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCPGetPeerAddress)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sock");
    {
	TCPsocket	sock = INT2PTR(TCPsocket,SvIV(ST(0)));
	IPaddress *	RETVAL;
	dXSTARG;
#line 2641 "lib/SDL_perl.xs"
		RETVAL = SDLNet_TCP_GetPeerAddress(sock);
#line 6540 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCPSend); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCPSend)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "sock, data, len");
    {
	TCPsocket	sock = INT2PTR(TCPsocket,SvIV(ST(0)));
	void *	data = INT2PTR(void *,SvIV(ST(1)));
	int	len = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2651 "lib/SDL_perl.xs"
		RETVAL = SDLNet_TCP_Send(sock,data,len);
#line 6565 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCPRecv); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCPRecv)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sock, maxlen");
    {
	TCPsocket	sock = INT2PTR(TCPsocket,SvIV(ST(0)));
	int	maxlen = (int)SvIV(ST(1));
	AV *	RETVAL;
#line 2660 "lib/SDL_perl.xs"
		int status;
		void *buffer;
		buffer = safemalloc(maxlen);
		RETVAL = newAV();
		status = SDLNet_TCP_Recv(sock,buffer,maxlen);
		av_push(RETVAL,newSViv(status));
		av_push(RETVAL,newSVpvn((char*)buffer,maxlen));
#line 6594 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCPClose); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCPClose)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sock");
    {
	TCPsocket	sock = INT2PTR(TCPsocket,SvIV(ST(0)));
#line 2674 "lib/SDL_perl.xs"
		SDLNet_TCP_Close(sock);
#line 6616 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetAllocPacket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetAllocPacket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	int	size = (int)SvIV(ST(0));
	UDPpacket *	RETVAL;
	dXSTARG;
#line 2680 "lib/SDL_perl.xs"
		RETVAL = SDLNet_AllocPacket(size);
#line 6638 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetAllocPacketV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetAllocPacketV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "howmany, size");
    {
	int	howmany = (int)SvIV(ST(0));
	int	size = (int)SvIV(ST(1));
	UDPpacket **	RETVAL;
	dXSTARG;
#line 2689 "lib/SDL_perl.xs"
		RETVAL = SDLNet_AllocPacketV(howmany,size);
#line 6662 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetResizePacket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetResizePacket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "packet, newsize");
    {
	UDPpacket *	packet = INT2PTR(UDPpacket *,SvIV(ST(0)));
	int	newsize = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2698 "lib/SDL_perl.xs"
		RETVAL = SDLNet_ResizePacket(packet,newsize);
#line 6686 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetFreePacket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetFreePacket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "packet");
    {
	UDPpacket *	packet = INT2PTR(UDPpacket *,SvIV(ST(0)));
#line 2706 "lib/SDL_perl.xs"
		SDLNet_FreePacket(packet);
#line 6707 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetFreePacketV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetFreePacketV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "packet");
    {
	UDPpacket **	packet = INT2PTR(UDPpacket **,SvIV(ST(0)));
#line 2712 "lib/SDL_perl.xs"
		SDLNet_FreePacketV(packet);
#line 6727 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetUDPOpen); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPOpen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "port");
    {
	Uint16	port = (Uint16)SvUV(ST(0));
	UDPsocket	RETVAL;
	dXSTARG;
#line 2718 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_Open(port);
#line 6749 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPBind); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPBind)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "sock, channel, address");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	int	channel = (int)SvIV(ST(1));
	IPaddress *	address = INT2PTR(IPaddress *,SvIV(ST(2)));
	int	RETVAL;
	dXSTARG;
#line 2728 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_Bind(sock,channel,address);
#line 6774 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPUnbind); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPUnbind)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sock, channel");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	int	channel = (int)SvIV(ST(1));
#line 2737 "lib/SDL_perl.xs"
		SDLNet_UDP_Unbind(sock,channel);
#line 6796 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetUDPGetPeerAddress); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPGetPeerAddress)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sock, channel");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	int	channel = (int)SvIV(ST(1));
	IPaddress *	RETVAL;
	dXSTARG;
#line 2744 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_GetPeerAddress(sock,channel);
#line 6819 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPSendV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPSendV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "sock, packets, npackets");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	UDPpacket **	packets = INT2PTR(UDPpacket **,SvIV(ST(1)));
	int	npackets = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2754 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_SendV(sock,packets,npackets);
#line 6844 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPSend); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPSend)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "sock, channel, packet");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	int	channel = (int)SvIV(ST(1));
	UDPpacket *	packet = INT2PTR(UDPpacket *,SvIV(ST(2)));
	int	RETVAL;
	dXSTARG;
#line 2764 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_Send(sock,channel,packet);
#line 6869 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPRecvV); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPRecvV)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sock, packets");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	UDPpacket **	packets = INT2PTR(UDPpacket **,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 2773 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_RecvV(sock,packets);
#line 6893 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPRecv); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPRecv)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sock, packet");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
	UDPpacket *	packet = INT2PTR(UDPpacket *,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 2782 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_Recv(sock,packet);
#line 6917 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDPClose); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDPClose)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sock");
    {
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(0)));
#line 2790 "lib/SDL_perl.xs"
		SDLNet_UDP_Close(sock);
#line 6938 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetAllocSocketSet); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetAllocSocketSet)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "maxsockets");
    {
	int	maxsockets = (int)SvIV(ST(0));
	SDLNet_SocketSet	RETVAL;
	dXSTARG;
#line 2796 "lib/SDL_perl.xs"
		RETVAL = SDLNet_AllocSocketSet(maxsockets);
#line 6960 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCP_AddSocket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCP_AddSocket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "set, sock");
    {
	SDLNet_SocketSet	set = INT2PTR(SDLNet_SocketSet,SvIV(ST(0)));
	TCPsocket	sock = INT2PTR(TCPsocket,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 2805 "lib/SDL_perl.xs"
		RETVAL = SDLNet_TCP_AddSocket(set,sock);
#line 6984 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDP_AddSocket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDP_AddSocket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "set, sock");
    {
	SDLNet_SocketSet	set = INT2PTR(SDLNet_SocketSet,SvIV(ST(0)));
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 2814 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_AddSocket(set,sock);
#line 7008 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetTCP_DelSocket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetTCP_DelSocket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "set, sock");
    {
	SDLNet_SocketSet	set = INT2PTR(SDLNet_SocketSet,SvIV(ST(0)));
	TCPsocket	sock = INT2PTR(TCPsocket,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 2823 "lib/SDL_perl.xs"
		RETVAL = SDLNet_TCP_DelSocket(set,sock);
#line 7032 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetUDP_DelSocket); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetUDP_DelSocket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "set, sock");
    {
	SDLNet_SocketSet	set = INT2PTR(SDLNet_SocketSet,SvIV(ST(0)));
	UDPsocket	sock = INT2PTR(UDPsocket,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 2832 "lib/SDL_perl.xs"
		RETVAL = SDLNet_UDP_DelSocket(set,sock);
#line 7056 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetCheckSockets); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetCheckSockets)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "set, timeout");
    {
	SDLNet_SocketSet	set = INT2PTR(SDLNet_SocketSet,SvIV(ST(0)));
	Uint32	timeout = (Uint32)SvUV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2841 "lib/SDL_perl.xs"
		RETVAL = SDLNet_CheckSockets(set,timeout);
#line 7080 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetSocketReady); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetSocketReady)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sock");
    {
	SDLNet_GenericSocket	sock = INT2PTR(SDLNet_GenericSocket,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2849 "lib/SDL_perl.xs"
		RETVAL = SDLNet_SocketReady(sock);
#line 7103 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetFreeSocketSet); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetFreeSocketSet)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "set");
    {
	SDLNet_SocketSet	set = INT2PTR(SDLNet_SocketSet,SvIV(ST(0)));
#line 2857 "lib/SDL_perl.xs"
		SDLNet_FreeSocketSet(set);
#line 7124 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetWrite16); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetWrite16)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "value, area");
    {
	Uint16	value = (Uint16)SvUV(ST(0));
	void *	area = INT2PTR(void *,SvIV(ST(1)));
#line 2864 "lib/SDL_perl.xs"
		SDLNet_Write16(value,area);
#line 7145 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetWrite32); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetWrite32)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "value, area");
    {
	Uint32	value = (Uint32)SvUV(ST(0));
	void *	area = INT2PTR(void *,SvIV(ST(1)));
#line 2871 "lib/SDL_perl.xs"
		SDLNet_Write32(value,area);
#line 7166 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_NetRead16); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetRead16)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "area");
    {
	void *	area = INT2PTR(void *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 2877 "lib/SDL_perl.xs"
		RETVAL = SDLNet_Read16(area);
#line 7188 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_NetRead32); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NetRead32)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "area");
    {
	void *	area = INT2PTR(void *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 2885 "lib/SDL_perl.xs"
		RETVAL = SDLNet_Read32(area);
#line 7211 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif 
#ifdef HAVE_SDL_TTF
#define XSubPPtmpAAAD 1


XS(XS_SDL_TTFInit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFInit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2896 "lib/SDL_perl.xs"
		RETVAL = TTF_Init();
#line 7237 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFQuit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFQuit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2903 "lib/SDL_perl.xs"
		TTF_Quit();
#line 7257 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_TTFOpenFont); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFOpenFont)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "file, ptsize");
    {
	char *	file = (char *)SvPV_nolen(ST(0));
	int	ptsize = (int)SvIV(ST(1));
	TTF_Font *	RETVAL;
	dXSTARG;
#line 2910 "lib/SDL_perl.xs"
		RETVAL = TTF_OpenFont(file,ptsize);
#line 7280 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFGetFontStyle); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFGetFontStyle)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2918 "lib/SDL_perl.xs"
		RETVAL = TTF_GetFontStyle(font);
#line 7303 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFSetFontStyle); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFSetFontStyle)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "font, style");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	style = (int)SvIV(ST(1));
#line 2927 "lib/SDL_perl.xs"
		TTF_SetFontStyle(font,style);
#line 7325 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_TTFFontHeight); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFFontHeight)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2933 "lib/SDL_perl.xs"
		RETVAL = TTF_FontHeight(font);
#line 7347 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFFontAscent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFFontAscent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2941 "lib/SDL_perl.xs"
		RETVAL = TTF_FontAscent(font);
#line 7370 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFFontDescent); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFFontDescent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2949 "lib/SDL_perl.xs"
		RETVAL = TTF_FontDescent(font);
#line 7393 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFFontLineSkip); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFFontLineSkip)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 2957 "lib/SDL_perl.xs"
		RETVAL = TTF_FontLineSkip(font);
#line 7416 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFGlyphMetrics); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFGlyphMetrics)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "font, ch");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	Uint16	ch = (Uint16)SvUV(ST(1));
	AV *	RETVAL;
#line 2966 "lib/SDL_perl.xs"
		int minx, miny, maxx, maxy, advance;
		RETVAL = newAV();
		TTF_GlyphMetrics(font, ch, &minx, &miny, &maxx, &maxy, &advance);
		av_push(RETVAL,newSViv(minx));
		av_push(RETVAL,newSViv(miny));
		av_push(RETVAL,newSViv(maxx));
		av_push(RETVAL,newSViv(maxy));
		av_push(RETVAL,newSViv(advance));
#line 7446 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFSizeText); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFSizeText)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "font, text");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	AV *	RETVAL;
#line 2982 "lib/SDL_perl.xs"
		int w,h;
		RETVAL = newAV();
		if(TTF_SizeText(font,text,&w,&h))
		{
			av_push(RETVAL,newSViv(w));
			av_push(RETVAL,newSViv(h));
			sv_2mortal((SV*)RETVAL);
		}
		else
		{
			 printf("TTF error at TTFSizeText: %s \n", TTF_GetError()); 
			 Perl_croak (aTHX_ "TTF error \n");	

		}


#line 7485 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFSizeUTF8); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFSizeUTF8)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "font, text");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	AV *	RETVAL;
#line 3006 "lib/SDL_perl.xs"
		int w,h;
		RETVAL = newAV();
		if(TTF_SizeUTF8(font,text,&w,&h))
		{
			av_push(RETVAL,newSViv(w));
			av_push(RETVAL,newSViv(h));
			sv_2mortal((SV*)RETVAL);

		}
		else
		{
			printf("TTF error at TTFSizeUTF8 with : %s \n", TTF_GetError());
			Perl_croak (aTHX_ "TTF error \n");
		}

#line 7523 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFSizeUNICODE); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFSizeUNICODE)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "font, text");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	const Uint16 *	text = INT2PTR(const Uint16 *,SvIV(ST(1)));
	AV *	RETVAL;
#line 3029 "lib/SDL_perl.xs"
		int w,h;
		RETVAL = newAV();
		if(TTF_SizeUNICODE(font,text,&w,&h))
		{
			av_push(RETVAL,newSViv(w));
			av_push(RETVAL,newSViv(h));
			sv_2mortal((SV*)RETVAL);

		}
		else
		{
			printf("TTF error at TTFSizeUNICODE : %s \n", TTF_GetError()); 
			Perl_croak (aTHX_ "TTF error \n");
		}

#line 7561 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderTextSolid); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderTextSolid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, text, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3053 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderText_Solid(font,text,*fg);
#line 7587 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderUTF8Solid); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderUTF8Solid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, text, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3063 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderUTF8_Solid(font,text,*fg);
#line 7612 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderUNICODESolid); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderUNICODESolid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, text, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	const Uint16 *	text = INT2PTR(const Uint16 *,SvIV(ST(1)));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3073 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderUNICODE_Solid(font,text,*fg);
#line 7637 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderGlyphSolid); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderGlyphSolid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, ch, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	Uint16	ch = (Uint16)SvUV(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3083 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderGlyph_Solid(font,ch,*fg);
#line 7662 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderTextShaded); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderTextShaded)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "font, text, fg, bg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Color *	bg = INT2PTR(SDL_Color *,SvIV(ST(3)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3094 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderText_Shaded(font,text,*fg,*bg);
#line 7688 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderUTF8Shaded); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderUTF8Shaded)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "font, text, fg, bg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Color *	bg = INT2PTR(SDL_Color *,SvIV(ST(3)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3105 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderUTF8_Shaded(font,text,*fg,*bg);
#line 7714 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderUNICODEShaded); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderUNICODEShaded)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "font, text, fg, bg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	const Uint16 *	text = INT2PTR(const Uint16 *,SvIV(ST(1)));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Color *	bg = INT2PTR(SDL_Color *,SvIV(ST(3)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3116 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderUNICODE_Shaded(font,text,*fg,*bg);
#line 7740 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderGlyphShaded); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderGlyphShaded)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "font, ch, fg, bg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	Uint16	ch = (Uint16)SvUV(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Color *	bg = INT2PTR(SDL_Color *,SvIV(ST(3)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3127 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderGlyph_Shaded(font,ch,*fg,*bg);
#line 7766 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderTextBlended); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderTextBlended)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, text, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3137 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderText_Blended(font,text,*fg);
#line 7791 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderUTF8Blended); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderUTF8Blended)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, text, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	char *	text = (char *)SvPV_nolen(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3147 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderUTF8_Blended(font,text,*fg);
#line 7816 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderUNICODEBlended); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderUNICODEBlended)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, text, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	const Uint16 *	text = INT2PTR(const Uint16 *,SvIV(ST(1)));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3157 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderUNICODE_Blended(font,text,*fg);
#line 7841 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFRenderGlyphBlended); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFRenderGlyphBlended)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "font, ch, fg");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	Uint16	ch = (Uint16)SvUV(ST(1));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(2)));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3167 "lib/SDL_perl.xs"
		RETVAL = TTF_RenderGlyph_Blended(font,ch,*fg);
#line 7866 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_TTFCloseFont); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFCloseFont)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
#line 3175 "lib/SDL_perl.xs"
		TTF_CloseFont(font);
		font=NULL; //to be safe http://sdl.beuc.net/sdl.wiki/SDL_ttf_copy_Functions_Management_TTF_CloseFont
#line 7888 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_TTFPutString); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_TTFPutString)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "font, mode, surface, x, y, fg, bg, text");
    {
	TTF_Font *	font = INT2PTR(TTF_Font *,SvIV(ST(0)));
	int	mode = (int)SvIV(ST(1));
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(2)));
	int	x = (int)SvIV(ST(3));
	int	y = (int)SvIV(ST(4));
	SDL_Color *	fg = INT2PTR(SDL_Color *,SvIV(ST(5)));
	SDL_Color *	bg = INT2PTR(SDL_Color *,SvIV(ST(6)));
	char *	text = (char *)SvPV_nolen(ST(7));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3189 "lib/SDL_perl.xs"
		SDL_Surface *img;
		SDL_Rect dest;
		int w,h;
		dest.x = x;
		dest.y = y;
		RETVAL = NULL;
		switch (mode) {
			case TEXT_SOLID:
				img = TTF_RenderText_Solid(font,text,*fg);
				TTF_SizeText(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case TEXT_SHADED:
				img = TTF_RenderText_Shaded(font,text,*fg,*bg);
				TTF_SizeText(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case TEXT_BLENDED:
				img = TTF_RenderText_Blended(font,text,*fg);
				TTF_SizeText(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case UTF8_SOLID:
				img = TTF_RenderUTF8_Solid(font,text,*fg);
				TTF_SizeUTF8(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case UTF8_SHADED:
				img = TTF_RenderUTF8_Shaded(font,text,*fg,*bg);
				TTF_SizeUTF8(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case UTF8_BLENDED:
				img = TTF_RenderUTF8_Blended(font,text,*fg);
				TTF_SizeUTF8(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case UNICODE_SOLID:
				img = TTF_RenderUNICODE_Solid(font,(Uint16*)text,*fg);
				TTF_SizeUNICODE(font,(Uint16*)text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case UNICODE_SHADED:
				img = TTF_RenderUNICODE_Shaded(font,(Uint16*)text,*fg,*bg);
				TTF_SizeUNICODE(font,(Uint16*)text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			case UNICODE_BLENDED:
				img = TTF_RenderUNICODE_Blended(font,(Uint16*)text,*fg);
				TTF_SizeUNICODE(font,(Uint16*)text,&w,&h);
				dest.w = w;
				dest.h = h;
				break;
			default:
				img = TTF_RenderText_Shaded(font,text,*fg,*bg);
				TTF_SizeText(font,text,&w,&h);
				dest.w = w;
				dest.h = h;
		}
		if ( img && img->format && img->format->palette ) {
			SDL_Color *c = &img->format->palette->colors[0];
			Uint32 key = SDL_MapRGB( img->format, c->r, c->g, c->b );
			SDL_SetColorKey(img,SDL_SRCCOLORKEY,key );
			if (0 > SDL_BlitSurface(img,NULL,surface,&dest)) {
				SDL_FreeSurface(img);
				RETVAL = NULL;	
			} else {
				RETVAL = img;
			}
		}
#line 7994 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif

XS(XS_SDL_CreateYUVOverlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_CreateYUVOverlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "width, height, format, display");
    {
	int	width = (int)SvIV(ST(0));
	int	height = (int)SvIV(ST(1));
	Uint32	format = (Uint32)SvUV(ST(2));
	SDL_Surface *	display = INT2PTR(SDL_Surface *,SvIV(ST(3)));
	SDL_Overlay *	RETVAL;
	dXSTARG;
#line 3279 "lib/SDL_perl.xs"
		RETVAL = SDL_CreateYUVOverlay ( width, height, format, display );
#line 8021 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_LockYUVOverlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_LockYUVOverlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "overlay");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3287 "lib/SDL_perl.xs"
		RETVAL = SDL_LockYUVOverlay(overlay);
#line 8044 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_UnlockYUVOverlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_UnlockYUVOverlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "overlay");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
#line 3295 "lib/SDL_perl.xs"
                SDL_UnlockYUVOverlay(overlay);
#line 8065 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_DisplayYUVOverlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_DisplayYUVOverlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "overlay, dstrect");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	SDL_Rect *	dstrect = INT2PTR(SDL_Rect *,SvIV(ST(1)));
	int	RETVAL;
	dXSTARG;
#line 3302 "lib/SDL_perl.xs"
		RETVAL = SDL_DisplayYUVOverlay ( overlay, dstrect );
#line 8088 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeYUVOverlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeYUVOverlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "overlay");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
#line 3310 "lib/SDL_perl.xs"
                SDL_FreeYUVOverlay ( overlay );
#line 8109 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_OverlayFormat); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayFormat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "overlay, ...");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 3316 "lib/SDL_perl.xs"
		if ( items > 1 ) 
			overlay->format = SvIV(ST(1));
		RETVAL = overlay->format;
#line 8133 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_OverlayW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "overlay, ...");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3326 "lib/SDL_perl.xs"
		if ( items > 1 ) 
			overlay->w = SvIV(ST(1));
		RETVAL = overlay->w;
#line 8158 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_OverlayH); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayH)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "overlay, ...");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3336 "lib/SDL_perl.xs"
		if ( items > 1 )
			overlay->h = SvIV(ST(1));
		RETVAL = overlay->h;
#line 8183 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_OverlayPlanes); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayPlanes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "overlay, ...");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3346 "lib/SDL_perl.xs"
                if ( items > 1 )
                        overlay->planes = SvIV(ST(1));
                RETVAL = overlay->planes;
#line 8208 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_OverlayHW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayHW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "overlay");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 3356 "lib/SDL_perl.xs"
		RETVAL = overlay->hw_overlay;
#line 8231 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_OverlayPitches); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayPitches)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "overlay");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	Uint16 *	RETVAL;
	dXSTARG;
#line 3364 "lib/SDL_perl.xs"
		RETVAL = overlay->pitches;
#line 8254 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_OverlayPixels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_OverlayPixels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "overlay");
    {
	SDL_Overlay *	overlay = INT2PTR(SDL_Overlay *,SvIV(ST(0)));
	Uint8 **	RETVAL;
	dXSTARG;
#line 3372 "lib/SDL_perl.xs"
		RETVAL = overlay->pixels;
#line 8277 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_WMToggleFullScreen); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WMToggleFullScreen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	SDL_Surface *	surface = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3380 "lib/SDL_perl.xs"
		RETVAL = SDL_WM_ToggleFullScreen(surface);
#line 8300 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_WMGrabInput); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WMGrabInput)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	Uint32	mode = (Uint32)SvUV(ST(0));
	Uint32	RETVAL;
	dXSTARG;
#line 3388 "lib/SDL_perl.xs"
		RETVAL = SDL_WM_GrabInput(mode);
#line 8323 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_WMIconifyWindow); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_WMIconifyWindow)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 3395 "lib/SDL_perl.xs"
		RETVAL = SDL_WM_IconifyWindow();
#line 8345 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ResizeEventW); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ResizeEventW)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3403 "lib/SDL_perl.xs"
		RETVAL = e->resize.w;
#line 8368 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_ResizeEventH); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_ResizeEventH)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "e");
    {
	SDL_Event *	e = INT2PTR(SDL_Event *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3411 "lib/SDL_perl.xs"
		RETVAL = e->resize.h;
#line 8391 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_AudioDriverName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_AudioDriverName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 3418 "lib/SDL_perl.xs"
		char name[32];
		RETVAL = SDL_AudioDriverName(name,32);
#line 8414 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_GetKeyState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GetKeyState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "k");
    {
	SDLKey	k = (SDLKey)SvUV(ST(0));
	Uint32	RETVAL;
	dXSTARG;
#line 3427 "lib/SDL_perl.xs"
		if (k >= SDLK_LAST) Perl_croak (aTHX_ "Key out of range");	
		RETVAL = SDL_GetKeyState(NULL)[k];
#line 8438 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef HAVE_SMPEG
#define XSubPPtmpAAAE 1


XS(XS_SDL_NewSMPEGInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewSMPEGInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SMPEG_Info *	RETVAL;
	dXSTARG;
#line 3437 "lib/SDL_perl.xs"
		RETVAL = (SMPEG_Info *) safemalloc (sizeof(SMPEG_Info));
#line 8463 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeSMPEGInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeSMPEGInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info *	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
#line 3445 "lib/SDL_perl.xs"
		safefree(info);
#line 8484 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGInfoHasAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoHasAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3451 "lib/SDL_perl.xs"
		RETVAL = info->has_audio;
#line 8506 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoHasVideo); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoHasVideo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3459 "lib/SDL_perl.xs"
		RETVAL = info->has_video;
#line 8529 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoWidth); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoWidth)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3467 "lib/SDL_perl.xs"
		RETVAL = info->width;
#line 8552 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoHeight); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoHeight)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3475 "lib/SDL_perl.xs"
		RETVAL = info->height;
#line 8575 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoCurrentFrame); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoCurrentFrame)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3483 "lib/SDL_perl.xs"
		RETVAL = info->current_frame;
#line 8598 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoCurrentFPS); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoCurrentFPS)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	double	RETVAL;
	dXSTARG;
#line 3491 "lib/SDL_perl.xs"
		RETVAL = info->current_fps;
#line 8621 "lib/SDL_perl.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoCurrentAudioFrame); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoCurrentAudioFrame)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3499 "lib/SDL_perl.xs"
		RETVAL = info->audio_current_frame;
#line 8644 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoCurrentOffset); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoCurrentOffset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3507 "lib/SDL_perl.xs"
		RETVAL = info->current_offset;
#line 8667 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoTotalSize); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoTotalSize)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 3515 "lib/SDL_perl.xs"
		RETVAL = info->total_size;
#line 8690 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoCurrentTime); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoCurrentTime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	double	RETVAL;
	dXSTARG;
#line 3523 "lib/SDL_perl.xs"
		RETVAL = info->current_time;
#line 8713 "lib/SDL_perl.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGInfoTotalTime); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGInfoTotalTime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(0)));
	double	RETVAL;
	dXSTARG;
#line 3531 "lib/SDL_perl.xs"
		RETVAL = info->total_time;
#line 8736 "lib/SDL_perl.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGError); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGError)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	char *	RETVAL;
	dXSTARG;
#line 3539 "lib/SDL_perl.xs"
		RETVAL = SMPEG_error(mpeg);
#line 8759 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_NewSMPEG); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_NewSMPEG)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "filename, info, use_audio");
    {
	char*	filename = (char *)SvPV_nolen(ST(0));
	SMPEG_Info*	info = INT2PTR(SMPEG_Info *,SvIV(ST(1)));
	int	use_audio = (int)SvIV(ST(2));
	SMPEG *	RETVAL;
	dXSTARG;
#line 3549 "lib/SDL_perl.xs"
#ifdef HAVE_SDL_MIXER
		RETVAL = SMPEG_new(filename,info,0);
#else
		RETVAL = SMPEG_new(filename,info,use_audio);
#endif
#line 8788 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_FreeSMPEG); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_FreeSMPEG)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
#line 3561 "lib/SDL_perl.xs"
		SMPEG_delete(mpeg);
#line 8809 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGEnableAudio); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGEnableAudio)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, flag");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	flag = (int)SvIV(ST(1));
#line 3568 "lib/SDL_perl.xs"
		SMPEG_enableaudio(mpeg,flag);
#ifdef HAVE_SDL_MIXER
		sdl_perl_use_smpeg_audio = flag;
#endif
#line 8833 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGEnableVideo); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGEnableVideo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, flag");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	flag = (int)SvIV(ST(1));
#line 3578 "lib/SDL_perl.xs"
		SMPEG_enablevideo(mpeg,flag);
#line 8854 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGSetVolume); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGSetVolume)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, volume");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	volume = (int)SvIV(ST(1));
#line 3585 "lib/SDL_perl.xs"
		SMPEG_setvolume(mpeg,volume);
#line 8875 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGSetDisplay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGSetDisplay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "mpeg, dest, surfLock");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	SDL_Surface*	dest = INT2PTR(SDL_Surface *,SvIV(ST(1)));
	SDL_mutex*	surfLock = INT2PTR(SDL_mutex *,SvIV(ST(2)));
#line 3593 "lib/SDL_perl.xs"
		SMPEG_setdisplay(mpeg,dest,surfLock,NULL);
#line 8897 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGScaleXY); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGScaleXY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "mpeg, w, h");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	w = (int)SvIV(ST(1));
	int	h = (int)SvIV(ST(2));
#line 3601 "lib/SDL_perl.xs"
		SMPEG_scaleXY(mpeg,w,h);
#line 8919 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGScale); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGScale)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, scale");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	scale = (int)SvIV(ST(1));
#line 3608 "lib/SDL_perl.xs"
		SMPEG_scale(mpeg,scale);
#line 8940 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGPlay); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGPlay)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
#line 3614 "lib/SDL_perl.xs"
                SDL_AudioSpec audiofmt;
                Uint16 format;
                int freq, channels;
#ifdef HAVE_SDL_MIXER
		if  (sdl_perl_use_smpeg_audio ) {
       			SMPEG_enableaudio(mpeg, 0);
			Mix_QuerySpec(&freq, &format, &channels);
			audiofmt.format = format;
			audiofmt.freq = freq;
			audiofmt.channels = channels;
			SMPEG_actualSpec(mpeg, &audiofmt);
			Mix_HookMusic(SMPEG_playAudioSDL, mpeg);
			SMPEG_enableaudio(mpeg, 1);
		}
#endif
	        SMPEG_play(mpeg);
#line 8975 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGStatus); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGStatus)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	SMPEGstatus	RETVAL;
	dXSTARG;
#line 3635 "lib/SDL_perl.xs"
		RETVAL = SMPEG_status(mpeg);
#line 8997 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SMPEGPause); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGPause)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
#line 3643 "lib/SDL_perl.xs"
		SMPEG_pause(mpeg);
#line 9018 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGLoop); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGLoop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, repeat");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	repeat = (int)SvIV(ST(1));
#line 3650 "lib/SDL_perl.xs"
		SMPEG_loop(mpeg,repeat);
#line 9039 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGStop); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGStop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
#line 3656 "lib/SDL_perl.xs"
		SMPEG_stop(mpeg);
#ifdef HAVE_SDL_MIXER
        	Mix_HookMusic(NULL, NULL);
#endif
#line 9062 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGRewind); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGRewind)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
#line 3665 "lib/SDL_perl.xs"
		SMPEG_rewind(mpeg);
#line 9082 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGSeek); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGSeek)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, bytes");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	bytes = (int)SvIV(ST(1));
#line 3672 "lib/SDL_perl.xs"
		SMPEG_seek(mpeg,bytes);
#line 9103 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGSkip); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGSkip)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, seconds");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	float	seconds = (float)SvNV(ST(1));
#line 3679 "lib/SDL_perl.xs"
		SMPEG_skip(mpeg,seconds);
#line 9124 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGSetDisplayRegion); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGSetDisplayRegion)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, rect");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	SDL_Rect*	rect = INT2PTR(SDL_Rect *,SvIV(ST(1)));
#line 3686 "lib/SDL_perl.xs"
		SMPEG_setdisplayregion(mpeg,rect->x,rect->y,rect->w,rect->h);
#line 9145 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGRenderFrame); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGRenderFrame)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "mpeg, frame");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	int	frame = (int)SvIV(ST(1));
#line 3693 "lib/SDL_perl.xs"
		SMPEG_renderFrame(mpeg,frame);
#line 9166 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SMPEGGetInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SMPEGGetInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mpeg");
    {
	SMPEG*	mpeg = INT2PTR(SMPEG *,SvIV(ST(0)));
	SMPEG_Info *	RETVAL;
	dXSTARG;
#line 3699 "lib/SDL_perl.xs"
		RETVAL = (SMPEG_Info *) safemalloc (sizeof(SMPEG_Info));
		SMPEG_getinfo(mpeg,RETVAL);
#line 9189 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}

#endif
#ifdef HAVE_SDL_GFX
#define XSubPPtmpAAAF 1


XS(XS_SDL_GFXRotoZoom); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXRotoZoom)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "src, angle, zoom, smooth");
    {
	SDL_Surface *	src = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	double	angle = (double)SvNV(ST(1));
	double	zoom = (double)SvNV(ST(2));
	int	smooth = (int)SvIV(ST(3));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3716 "lib/SDL_perl.xs"
		RETVAL = rotozoomSurface( src, angle, zoom, smooth);
#line 9219 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXZoom); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXZoom)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "src, zoomx, zoomy, smooth");
    {
	SDL_Surface *	src = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	double	zoomx = (double)SvNV(ST(1));
	double	zoomy = (double)SvNV(ST(2));
	int	smooth = (int)SvIV(ST(3));
	SDL_Surface *	RETVAL;
	dXSTARG;
#line 3727 "lib/SDL_perl.xs"
		RETVAL = zoomSurface( src, zoomx, zoomy, smooth);
#line 9245 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXPixelColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXPixelColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "dst, x, y, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Uint32	color = (Uint32)SvUV(ST(3));
	int	RETVAL;
	dXSTARG;
#line 3738 "lib/SDL_perl.xs"
		RETVAL = pixelColor( dst, x, y, color);
#line 9271 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXPixelRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXPixelRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "dst, x, y, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Uint8	r = (unsigned char)SvUV(ST(3));
	Uint8	g = (unsigned char)SvUV(ST(4));
	Uint8	b = (unsigned char)SvUV(ST(5));
	Uint8	a = (unsigned char)SvUV(ST(6));
	int	RETVAL;
	dXSTARG;
#line 3752 "lib/SDL_perl.xs"
		RETVAL = pixelRGBA( dst, x, y, r, g, b, a );
#line 9300 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXHlineColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXHlineColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x1, x2, y, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	x2 = (Sint16)SvIV(ST(2));
	Sint16	y = (Sint16)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 3764 "lib/SDL_perl.xs"
		RETVAL = hlineColor( dst, x1, x2, y, color );
#line 9327 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXHlineRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXHlineRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x1, x2, y, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	x2 = (Sint16)SvIV(ST(2));
	Sint16	y = (Sint16)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 3779 "lib/SDL_perl.xs"
		RETVAL = hlineRGBA( dst, x1, x2, y, r, g, b, a );
#line 9357 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXVlineColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXVlineColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x, y1, y2, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	y2 = (Sint16)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 3791 "lib/SDL_perl.xs"
		RETVAL = vlineColor( dst, x, y1, y2, color );
#line 9384 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXVlineRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXVlineRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x, y1, y2, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	y2 = (Sint16)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 3806 "lib/SDL_perl.xs"
		RETVAL = vlineRGBA( dst, x, y1, y2, r, g, b, a );
#line 9414 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXRectangleColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXRectangleColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 3819 "lib/SDL_perl.xs"
		RETVAL = rectangleColor( dst, x1, y1, x2, y2, color );
#line 9442 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXRectangleRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXRectangleRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 3835 "lib/SDL_perl.xs"
		RETVAL = rectangleRGBA( dst, x1, y1, x2, y2, r, g, b, a );
#line 9473 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXBoxColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXBoxColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 3848 "lib/SDL_perl.xs"
		RETVAL = boxColor( dst, x1, y1, x2, y2, color );
#line 9501 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXBoxRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXBoxRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 3864 "lib/SDL_perl.xs"
		RETVAL = boxRGBA( dst, x1, y1, x2, y2, r, g, b, a );
#line 9532 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXLineColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXLineColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 3877 "lib/SDL_perl.xs"
		RETVAL = lineColor( dst, x1, y1, x2, y2, color );
#line 9560 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXLineRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXLineRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 3893 "lib/SDL_perl.xs"
		RETVAL = lineRGBA( dst, x1, y1, x2, y2, r, g, b, a );
#line 9591 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAalineColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAalineColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 3906 "lib/SDL_perl.xs"
		RETVAL = aalineColor( dst, x1, y1, x2, y2, color );
#line 9619 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAalineRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAalineRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x1, y1, x2, y2, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x1 = (Sint16)SvIV(ST(1));
	Sint16	y1 = (Sint16)SvIV(ST(2));
	Sint16	x2 = (Sint16)SvIV(ST(3));
	Sint16	y2 = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 3922 "lib/SDL_perl.xs"
		RETVAL = aalineRGBA( dst, x1, y1, x2, y2, r, g, b, a );
#line 9650 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXCircleColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXCircleColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x, y, r, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	r = (Sint16)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 3934 "lib/SDL_perl.xs"
		RETVAL = circleColor( dst, x, y, r, color );
#line 9677 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXCircleRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXCircleRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x, y, rad, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rad = (Sint16)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 3949 "lib/SDL_perl.xs"
		RETVAL = circleRGBA( dst, x, y, rad, r, g, b, a );
#line 9707 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAacircleColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAacircleColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x, y, r, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	r = (Sint16)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 3961 "lib/SDL_perl.xs"
		RETVAL = aacircleColor( dst, x, y, r, color );
#line 9734 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAacircleRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAacircleRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x, y, rad, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rad = (Sint16)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 3976 "lib/SDL_perl.xs"
		RETVAL = aacircleRGBA( dst, x, y, rad, r, g, b, a );
#line 9764 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledCircleColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledCircleColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x, y, r, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	r = (Sint16)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 3988 "lib/SDL_perl.xs"
		RETVAL = filledCircleColor( dst, x, y, r, color );
#line 9791 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledCircleRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledCircleRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x, y, rad, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rad = (Sint16)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 4003 "lib/SDL_perl.xs"
		RETVAL = filledCircleRGBA( dst, x, y, rad, r, g, b, a );
#line 9821 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXEllipseColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXEllipseColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, x, y, rx, ry, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rx = (Sint16)SvIV(ST(3));
	Sint16	ry = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 4016 "lib/SDL_perl.xs"
		RETVAL = ellipseColor( dst, x, y, rx, ry, color );
#line 9849 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXEllipseRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXEllipseRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x, y, rx, ry, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rx = (Sint16)SvIV(ST(3));
	Sint16	ry = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 4032 "lib/SDL_perl.xs"
		RETVAL = ellipseRGBA( dst, x, y, rx, ry, r, g, b, a );
#line 9880 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAaellipseColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAaellipseColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, xc, yc, rx, ry, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	xc = (Sint16)SvIV(ST(1));
	Sint16	yc = (Sint16)SvIV(ST(2));
	Sint16	rx = (Sint16)SvIV(ST(3));
	Sint16	ry = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 4045 "lib/SDL_perl.xs"
		RETVAL = aaellipseColor( dst, xc, yc, rx, ry, color );
#line 9908 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAaellipseRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAaellipseRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x, y, rx, ry, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rx = (Sint16)SvIV(ST(3));
	Sint16	ry = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 4061 "lib/SDL_perl.xs"
		RETVAL = aaellipseRGBA( dst, x, y, rx, ry, r, g, b, a );
#line 9939 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledEllipseColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledEllipseColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "dst, x, y, rx, ry, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rx = (Sint16)SvIV(ST(3));
	Sint16	ry = (Sint16)SvIV(ST(4));
	Uint32	color = (Uint32)SvUV(ST(5));
	int	RETVAL;
	dXSTARG;
#line 4074 "lib/SDL_perl.xs"
		RETVAL = filledEllipseColor( dst, x, y, rx, ry, color );
#line 9967 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledEllipseRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledEllipseRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "dst, x, y, rx, ry, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rx = (Sint16)SvIV(ST(3));
	Sint16	ry = (Sint16)SvIV(ST(4));
	Uint8	r = (unsigned char)SvUV(ST(5));
	Uint8	g = (unsigned char)SvUV(ST(6));
	Uint8	b = (unsigned char)SvUV(ST(7));
	Uint8	a = (unsigned char)SvUV(ST(8));
	int	RETVAL;
	dXSTARG;
#line 4090 "lib/SDL_perl.xs"
		RETVAL = filledEllipseRGBA( dst, x, y, rx, ry, r, g, b, a );
#line 9998 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledPieColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledPieColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "dst, x, y, rad, start, end, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rad = (Sint16)SvIV(ST(3));
	Sint16	start = (Sint16)SvIV(ST(4));
	Sint16	end = (Sint16)SvIV(ST(5));
	Uint32	color = (Uint32)SvUV(ST(6));
	int	RETVAL;
	dXSTARG;
#line 4104 "lib/SDL_perl.xs"
		RETVAL = filledPieColor( dst, x, y, rad, start, end, color );
#line 10027 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledPieRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledPieRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 10)
       croak_xs_usage(cv,  "dst, x, y, rad, start, end, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	Sint16	rad = (Sint16)SvIV(ST(3));
	Sint16	start = (Sint16)SvIV(ST(4));
	Sint16	end = (Sint16)SvIV(ST(5));
	Uint8	r = (unsigned char)SvUV(ST(6));
	Uint8	g = (unsigned char)SvUV(ST(7));
	Uint8	b = (unsigned char)SvUV(ST(8));
	Uint8	a = (unsigned char)SvUV(ST(9));
	int	RETVAL;
	dXSTARG;
#line 4121 "lib/SDL_perl.xs"
		RETVAL = filledPieRGBA( dst, x, y, rad, start, end, r, g, b, a );
#line 10059 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXPolygonColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXPolygonColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, vx, vy, n, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16*	vx = INT2PTR(Sint16 *,SvIV(ST(1)));
	Sint16*	vy = INT2PTR(Sint16 *,SvIV(ST(2)));
	int	n = (int)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 4133 "lib/SDL_perl.xs"
		RETVAL = polygonColor( dst, vx, vy, n, color );
#line 10086 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXPolygonRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXPolygonRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, vx, vy, n, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16*	vx = INT2PTR(Sint16 *,SvIV(ST(1)));
	Sint16*	vy = INT2PTR(Sint16 *,SvIV(ST(2)));
	int	n = (int)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 4148 "lib/SDL_perl.xs"
		RETVAL = polygonRGBA( dst, vx, vy, n, r, g, b, a );
#line 10116 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAapolygonColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAapolygonColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, vx, vy, n, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16*	vx = INT2PTR(Sint16 *,SvIV(ST(1)));
	Sint16*	vy = INT2PTR(Sint16 *,SvIV(ST(2)));
	int	n = (int)SvIV(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 4160 "lib/SDL_perl.xs"
		RETVAL = aapolygonColor( dst, vx, vy, n, color );
#line 10143 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXAapolygonRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXAapolygonRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, vx, vy, n, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16*	vx = INT2PTR(Sint16 *,SvIV(ST(1)));
	Sint16*	vy = INT2PTR(Sint16 *,SvIV(ST(2)));
	int	n = (int)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 4175 "lib/SDL_perl.xs"
		RETVAL = aapolygonRGBA( dst, vx, vy, n, r, g, b, a );
#line 10173 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledPolygonColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledPolygonColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, vx, vy, n, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16*	vx = INT2PTR(Sint16 *,SvIV(ST(1)));
	Sint16*	vy = INT2PTR(Sint16 *,SvIV(ST(2)));
	int	n = (int)SvIV(ST(3));
	int	color = (int)SvIV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 4187 "lib/SDL_perl.xs"
		RETVAL = filledPolygonColor( dst, vx, vy, n, color );
#line 10200 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXFilledPolygonRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXFilledPolygonRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, vx, vy, n, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16*	vx = INT2PTR(Sint16 *,SvIV(ST(1)));
	Sint16*	vy = INT2PTR(Sint16 *,SvIV(ST(2)));
	int	n = (int)SvIV(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 4202 "lib/SDL_perl.xs"
		RETVAL = filledPolygonRGBA( dst, vx, vy, n, r, g, b, a );
#line 10230 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXCharacterColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXCharacterColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x, y, c, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	char	c = (char)*SvPV_nolen(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 4214 "lib/SDL_perl.xs"
		RETVAL = characterColor( dst, x, y, c, color );
#line 10257 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXCharacterRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXCharacterRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x, y, c, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	char	c = (char)*SvPV_nolen(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 4229 "lib/SDL_perl.xs"
		RETVAL = characterRGBA( dst, x, y, c, r, g, b, a );
#line 10287 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXStringColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXStringColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "dst, x, y, c, color");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	char*	c = (char *)SvPV_nolen(ST(3));
	Uint32	color = (Uint32)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;
#line 4241 "lib/SDL_perl.xs"
		RETVAL = stringColor( dst, x, y, c, color );
#line 10314 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_GFXStringRGBA); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_GFXStringRGBA)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "dst, x, y, c, r, g, b, a");
    {
	SDL_Surface*	dst = INT2PTR(SDL_Surface *,SvIV(ST(0)));
	Sint16	x = (Sint16)SvIV(ST(1));
	Sint16	y = (Sint16)SvIV(ST(2));
	char*	c = (char *)SvPV_nolen(ST(3));
	Uint8	r = (unsigned char)SvUV(ST(4));
	Uint8	g = (unsigned char)SvUV(ST(5));
	Uint8	b = (unsigned char)SvUV(ST(6));
	Uint8	a = (unsigned char)SvUV(ST(7));
	int	RETVAL;
	dXSTARG;
#line 4256 "lib/SDL_perl.xs"
		RETVAL = stringRGBA( dst, x, y, c, r, g, b, a );
#line 10344 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifdef HAVE_SDL_SVG
#define XSubPPtmpAAAG 1


XS(XS_SDL_SVG_Load); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_Load)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "filename");
    {
	char*	filename = (char *)SvPV_nolen(ST(0));
	SDL_svg_context *	RETVAL;
	dXSTARG;
#line 4269 "lib/SDL_perl.xs"
		RETVAL = SVG_Load(filename);
#line 10371 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_LoadBuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_LoadBuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "data, len");
    {
	char*	data = (char *)SvPV_nolen(ST(0));
	int	len = (int)SvIV(ST(1));
	SDL_svg_context *	RETVAL;
	dXSTARG;
#line 4278 "lib/SDL_perl.xs"
		RETVAL = SVG_LoadBuffer(data,len);
#line 10395 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_SetOffset); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_SetOffset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "source, xoff, yoff");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	double	xoff = (double)SvNV(ST(1));
	double	yoff = (double)SvNV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 4288 "lib/SDL_perl.xs"
		RETVAL = SVG_SetOffset(source,xoff,yoff);
#line 10420 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_SetScale); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_SetScale)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "source, xscale, yscale");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	double	xscale = (double)SvNV(ST(1));
	double	yscale = (double)SvNV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 4298 "lib/SDL_perl.xs"
		RETVAL = SVG_SetScale(source,xscale,yscale);
#line 10445 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_RenderToSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_RenderToSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "source, x, y, dest");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	int	x = (int)SvIV(ST(1));
	int	y = (int)SvIV(ST(2));
	SDL_Surface*	dest = INT2PTR(SDL_Surface *,SvIV(ST(3)));
	int	RETVAL;
	dXSTARG;
#line 4309 "lib/SDL_perl.xs"
		RETVAL = SVG_RenderToSurface(source,x,y,dest);
#line 10471 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_Free); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_Free)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "source");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
#line 4317 "lib/SDL_perl.xs"
		SVG_Free(source);	
#line 10492 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SVG_Set_Flags); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_Set_Flags)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "source, flags");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	Uint32	flags = (Uint32)SvUV(ST(1));
#line 4324 "lib/SDL_perl.xs"
		SVG_Set_Flags(source,flags);
#line 10513 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SVG_Width); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_Width)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "source");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	float	RETVAL;
	dXSTARG;
#line 4330 "lib/SDL_perl.xs"
		RETVAL = SVG_Width(source);
#line 10535 "lib/SDL_perl.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_HEIGHT); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_HEIGHT)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "source");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	float	RETVAL;
	dXSTARG;
#line 4338 "lib/SDL_perl.xs"
		RETVAL = SVG_Height(source);
#line 10558 "lib/SDL_perl.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SVG_SetClipping); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_SetClipping)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "source, minx, miny, maxx, maxy");
    {
	SDL_svg_context*	source = INT2PTR(SDL_svg_context *,SvIV(ST(0)));
	int	minx = (int)SvIV(ST(1));
	int	miny = (int)SvIV(ST(2));
	int	maxx = (int)SvIV(ST(3));
	int	maxy = (int)SvIV(ST(4));
#line 4350 "lib/SDL_perl.xs"
		SVG_SetClipping(source,minx,miny,maxx,maxy);
#line 10583 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_SVG_Version); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SVG_Version)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 4355 "lib/SDL_perl.xs"
		RETVAL = SVG_Version();
#line 10604 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifdef HAVE_SDL_SOUND
#define XSubPPtmpAAAH 1


XS(XS_SDL_SoundAudioInfoFormat); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundAudioInfoFormat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "audioinfo");
    {
	Sound_AudioInfo*	audioinfo = INT2PTR(Sound_AudioInfo *,SvIV(ST(0)));
	Uint16	RETVAL;
	dXSTARG;
#line 4368 "lib/SDL_perl.xs"
		RETVAL = audioinfo->format;
#line 10631 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundAudioInfoChannels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundAudioInfoChannels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "audioinfo");
    {
	Sound_AudioInfo*	audioinfo = INT2PTR(Sound_AudioInfo *,SvIV(ST(0)));
	Uint8	RETVAL;
	dXSTARG;
#line 4376 "lib/SDL_perl.xs"
		RETVAL = audioinfo->channels;
#line 10654 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundAudioInforate); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundAudioInforate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "audioinfo");
    {
	Sound_AudioInfo*	audioinfo = INT2PTR(Sound_AudioInfo *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 4384 "lib/SDL_perl.xs"
		RETVAL = audioinfo->rate;
#line 10677 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundDecoderInfoExtensions); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundDecoderInfoExtensions)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "decoderinfo");
    {
	Sound_DecoderInfo*	decoderinfo = INT2PTR(Sound_DecoderInfo *,SvIV(ST(0)));
	AV *	RETVAL;
#line 4392 "lib/SDL_perl.xs"
		const char **ext;
		for ( ext = decoderinfo->extensions; *ext != NULL; ext++ ){
			av_push(RETVAL,newSVpv(*ext,0));
		}
#line 10702 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundDecoderInfoDescription); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundDecoderInfoDescription)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "decoderinfo");
    {
	Sound_DecoderInfo*	decoderinfo = INT2PTR(Sound_DecoderInfo *,SvIV(ST(0)));
	const char *	RETVAL;
	dXSTARG;
#line 4403 "lib/SDL_perl.xs"
		RETVAL = decoderinfo->description;
#line 10726 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundDecoderInfoAuthor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundDecoderInfoAuthor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "decoderinfo");
    {
	Sound_DecoderInfo*	decoderinfo = INT2PTR(Sound_DecoderInfo *,SvIV(ST(0)));
	const char *	RETVAL;
	dXSTARG;
#line 4411 "lib/SDL_perl.xs"
		RETVAL = decoderinfo->author;
#line 10749 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundDecoderInfoUrl); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundDecoderInfoUrl)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "decoderinfo");
    {
	Sound_DecoderInfo*	decoderinfo = INT2PTR(Sound_DecoderInfo *,SvIV(ST(0)));
	const char *	RETVAL;
	dXSTARG;
#line 4419 "lib/SDL_perl.xs"
		RETVAL = decoderinfo->url;
#line 10772 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundSampleDecoder); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundSampleDecoder)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	const Sound_DecoderInfo *	RETVAL;
	dXSTARG;
#line 4427 "lib/SDL_perl.xs"
		RETVAL = sample->decoder;
#line 10795 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundSampleDesired); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundSampleDesired)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Sound_AudioInfo *	RETVAL;
	dXSTARG;
#line 4435 "lib/SDL_perl.xs"
		RETVAL = &sample->desired;
#line 10818 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundSampleAcutal); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundSampleAcutal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Sound_AudioInfo *	RETVAL;
	dXSTARG;
#line 4443 "lib/SDL_perl.xs"
		RETVAL = &sample->actual;
#line 10841 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundSampleBuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundSampleBuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	char *	RETVAL;
	dXSTARG;
#line 4451 "lib/SDL_perl.xs"
		RETVAL = sample->buffer;
#line 10864 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundSampleBufferSize); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundSampleBufferSize)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 4459 "lib/SDL_perl.xs"
		RETVAL = sample->buffer_size;
#line 10887 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_SoundSampleFlags); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_SoundSampleFlags)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 4467 "lib/SDL_perl.xs"
		RETVAL = (Uint32)sample->flags;
#line 10910 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_Init); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_Init)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 4474 "lib/SDL_perl.xs"
		RETVAL = Sound_Init();
#line 10932 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_Quit); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_Quit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 4481 "lib/SDL_perl.xs"
		RETVAL = Sound_Quit();
#line 10954 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_AvailableDecoders); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_AvailableDecoders)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 4488 "lib/SDL_perl.xs"
		RETVAL = newAV();
		const Sound_DecoderInfo** sdi;
		sdi = Sound_AvailableDecoders();
		if (sdi != NULL)  {
			for (;*sdi != NULL; ++sdi) {
				av_push(RETVAL,sv_2mortal(newSViv(PTR2IV(*sdi))));
			}
		}
#line 10982 "lib/SDL_perl.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_GetError); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_GetError)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;
#line 4502 "lib/SDL_perl.xs"
		RETVAL = Sound_GetError();
#line 11005 "lib/SDL_perl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_ClearError); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_ClearError)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4509 "lib/SDL_perl.xs"
		Sound_ClearError();
#line 11025 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_Sound_NewSample); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_NewSample)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "rw, ext, desired, buffsize");
    {
	SDL_RWops*	rw = INT2PTR(SDL_RWops *,SvIV(ST(0)));
	const char*	ext = (const char *)SvPV_nolen(ST(1));
	Sound_AudioInfo*	desired = INT2PTR(Sound_AudioInfo *,SvIV(ST(2)));
	Uint32	buffsize = (Uint32)SvUV(ST(3));
	Sound_Sample *	RETVAL;
	dXSTARG;
#line 4518 "lib/SDL_perl.xs"
		RETVAL = Sound_NewSample(rw,ext,desired,buffsize);
#line 11050 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_NewSampleFromMem); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_NewSampleFromMem)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "data, size, ext, desired, buffsize");
    {
	const Uint8 *	data = INT2PTR(const Uint8 *,SvIV(ST(0)));
	Uint32	size = (Uint32)SvUV(ST(1));
	const char*	ext = (const char *)SvPV_nolen(ST(2));
	Sound_AudioInfo*	desired = INT2PTR(Sound_AudioInfo *,SvIV(ST(3)));
	Uint32	buffsize = (Uint32)SvUV(ST(4));
	Sound_Sample *	RETVAL;
	dXSTARG;
#line 4530 "lib/SDL_perl.xs"
		RETVAL = Sound_NewSampleFromMem(data,size,ext,desired,buffsize);
#line 11077 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_NewSampleFromFile); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_NewSampleFromFile)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "fname, desired, buffsize");
    {
	const char*	fname = (const char *)SvPV_nolen(ST(0));
	Sound_AudioInfo*	desired = INT2PTR(Sound_AudioInfo *,SvIV(ST(1)));
	Uint32	buffsize = (Uint32)SvUV(ST(2));
	Sound_Sample *	RETVAL;
	dXSTARG;
#line 4540 "lib/SDL_perl.xs"
		RETVAL = Sound_NewSampleFromFile(fname,desired,buffsize);
#line 11102 "lib/SDL_perl.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_FreeSample); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_FreeSample)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
#line 4548 "lib/SDL_perl.xs"
		Sound_FreeSample(sample);
#line 11123 "lib/SDL_perl.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL_Sound_GetDuration); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_GetDuration)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Sint32	RETVAL;
	dXSTARG;
#line 4554 "lib/SDL_perl.xs"
		RETVAL = Sound_GetDuration(sample);
#line 11145 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_SetBufferSize); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_SetBufferSize)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sample, size");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Uint32	size = (Uint32)SvUV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 4563 "lib/SDL_perl.xs"
		RETVAL = Sound_SetBufferSize(sample,size);
#line 11169 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_Decode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_Decode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 4571 "lib/SDL_perl.xs"
		RETVAL = Sound_Decode(sample);
#line 11192 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_DecodeAll); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_DecodeAll)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Uint32	RETVAL;
	dXSTARG;
#line 4579 "lib/SDL_perl.xs"
		RETVAL = Sound_DecodeAll(sample);
#line 11215 "lib/SDL_perl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_Rewind); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_Rewind)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sample");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 4587 "lib/SDL_perl.xs"
		RETVAL = Sound_Rewind(sample);
#line 11238 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL_Sound_Seek); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL_Sound_Seek)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sample, ms");
    {
	Sound_Sample*	sample = INT2PTR(Sound_Sample *,SvIV(ST(0)));
	Uint32	ms = (Uint32)SvUV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 4596 "lib/SDL_perl.xs"
		RETVAL = Sound_Seek(sample,ms);
#line 11262 "lib/SDL_perl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS(boot_SDL); /* prototype to pass -Wmissing-prototypes */
XS(boot_SDL)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    const char* file = __FILE__;

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

        newXS("SDL::GetError", XS_SDL_GetError, file);
        newXS("SDL::Init", XS_SDL_Init, file);
        newXS("SDL::InitSubSystem", XS_SDL_InitSubSystem, file);
        newXS("SDL::QuitSubSystem", XS_SDL_QuitSubSystem, file);
        newXS("SDL::Quit", XS_SDL_Quit, file);
        newXS("SDL::WasInit", XS_SDL_WasInit, file);
        newXS("SDL::Delay", XS_SDL_Delay, file);
        newXS("SDL::GetTicks", XS_SDL_GetTicks, file);
        newXS("SDL::SetTimer", XS_SDL_SetTimer, file);
        newXS("SDL::AddTimer", XS_SDL_AddTimer, file);
        newXS("SDL::PerlTimerCallback", XS_SDL_PerlTimerCallback, file);
        newXS("SDL::NewTimer", XS_SDL_NewTimer, file);
        newXS("SDL::RemoveTimer", XS_SDL_RemoveTimer, file);
        newXS("SDL::RWFromFile", XS_SDL_RWFromFile, file);
        newXS("SDL::RWFromFP", XS_SDL_RWFromFP, file);
        newXS("SDL::RWFromMem", XS_SDL_RWFromMem, file);
        newXS("SDL::RWFromConstMem", XS_SDL_RWFromConstMem, file);
        newXS("SDL::AllocRW", XS_SDL_AllocRW, file);
        newXS("SDL::FreeRW", XS_SDL_FreeRW, file);
        newXS("SDL::RWseek", XS_SDL_RWseek, file);
        newXS("SDL::RWtell", XS_SDL_RWtell, file);
        newXS("SDL::RWread", XS_SDL_RWread, file);
        newXS("SDL::RWwrite", XS_SDL_RWwrite, file);
        newXS("SDL::RWclose", XS_SDL_RWclose, file);
        newXS("SDL::CDNumDrives", XS_SDL_CDNumDrives, file);
        newXS("SDL::CDName", XS_SDL_CDName, file);
        newXS("SDL::CDOpen", XS_SDL_CDOpen, file);
        newXS("SDL::CDTrackId", XS_SDL_CDTrackId, file);
        newXS("SDL::CDTrackType", XS_SDL_CDTrackType, file);
        newXS("SDL::CDTrackLength", XS_SDL_CDTrackLength, file);
        newXS("SDL::CDTrackOffset", XS_SDL_CDTrackOffset, file);
        newXS("SDL::CDStatus", XS_SDL_CDStatus, file);
        newXS("SDL::CDPlayTracks", XS_SDL_CDPlayTracks, file);
        newXS("SDL::CDPlay", XS_SDL_CDPlay, file);
        newXS("SDL::CDPause", XS_SDL_CDPause, file);
        newXS("SDL::CDResume", XS_SDL_CDResume, file);
        newXS("SDL::CDStop", XS_SDL_CDStop, file);
        newXS("SDL::CDEject", XS_SDL_CDEject, file);
        newXS("SDL::CDClose", XS_SDL_CDClose, file);
        newXS("SDL::CDId", XS_SDL_CDId, file);
        newXS("SDL::CDNumTracks", XS_SDL_CDNumTracks, file);
        newXS("SDL::CDCurTrack", XS_SDL_CDCurTrack, file);
        newXS("SDL::CDCurFrame", XS_SDL_CDCurFrame, file);
        newXS("SDL::CDTrack", XS_SDL_CDTrack, file);
        newXS("SDL::PumpEvents", XS_SDL_PumpEvents, file);
        newXS("SDL::PushEvent", XS_SDL_PushEvent, file);
        newXS("SDL::NewEvent", XS_SDL_NewEvent, file);
        newXS("SDL::FreeEvent", XS_SDL_FreeEvent, file);
        newXS("SDL::PollEvent", XS_SDL_PollEvent, file);
        newXS("SDL::WaitEvent", XS_SDL_WaitEvent, file);
        newXS("SDL::EventState", XS_SDL_EventState, file);
        newXS("SDL::EventType", XS_SDL_EventType, file);
        newXS("SDL::SetEventType", XS_SDL_SetEventType, file);
        newXS("SDL::ActiveEventGain", XS_SDL_ActiveEventGain, file);
        newXS("SDL::ActiveEventState", XS_SDL_ActiveEventState, file);
        newXS("SDL::KeyEventState", XS_SDL_KeyEventState, file);
        newXS("SDL::KeyEventSym", XS_SDL_KeyEventSym, file);
        newXS("SDL::KeyEventMod", XS_SDL_KeyEventMod, file);
        newXS("SDL::KeyEventUnicode", XS_SDL_KeyEventUnicode, file);
        newXS("SDL::KeyEventScanCode", XS_SDL_KeyEventScanCode, file);
        newXS("SDL::MouseMotionState", XS_SDL_MouseMotionState, file);
        newXS("SDL::MouseMotionX", XS_SDL_MouseMotionX, file);
        newXS("SDL::MouseMotionY", XS_SDL_MouseMotionY, file);
        newXS("SDL::MouseMotionXrel", XS_SDL_MouseMotionXrel, file);
        newXS("SDL::MouseMotionYrel", XS_SDL_MouseMotionYrel, file);
        newXS("SDL::MouseButtonState", XS_SDL_MouseButtonState, file);
        newXS("SDL::MouseButton", XS_SDL_MouseButton, file);
        newXS("SDL::MouseButtonX", XS_SDL_MouseButtonX, file);
        newXS("SDL::MouseButtonY", XS_SDL_MouseButtonY, file);
        newXS("SDL::SysWMEventMsg", XS_SDL_SysWMEventMsg, file);
        newXS("SDL::EnableUnicode", XS_SDL_EnableUnicode, file);
        newXS("SDL::EnableKeyRepeat", XS_SDL_EnableKeyRepeat, file);
        newXS("SDL::GetModState", XS_SDL_GetModState, file);
        newXS("SDL::SetModState", XS_SDL_SetModState, file);
        newXS("SDL::GetKeyName", XS_SDL_GetKeyName, file);
        newXS("SDL::CreateRGBSurface", XS_SDL_CreateRGBSurface, file);
        newXS("SDL::CreateRGBSurfaceFrom", XS_SDL_CreateRGBSurfaceFrom, file);
#if XSubPPtmpAAAA
        newXS("SDL::IMGLoad", XS_SDL_IMGLoad, file);
#endif
        newXS("SDL::SurfaceCopy", XS_SDL_SurfaceCopy, file);
        newXS("SDL::FreeSurface", XS_SDL_FreeSurface, file);
        newXS("SDL::SurfaceFlags", XS_SDL_SurfaceFlags, file);
        newXS("SDL::SurfacePalette", XS_SDL_SurfacePalette, file);
        newXS("SDL::SurfaceBitsPerPixel", XS_SDL_SurfaceBitsPerPixel, file);
        newXS("SDL::SurfaceBytesPerPixel", XS_SDL_SurfaceBytesPerPixel, file);
        newXS("SDL::SurfaceRshift", XS_SDL_SurfaceRshift, file);
        newXS("SDL::SurfaceGshift", XS_SDL_SurfaceGshift, file);
        newXS("SDL::SurfaceBshift", XS_SDL_SurfaceBshift, file);
        newXS("SDL::SurfaceAshift", XS_SDL_SurfaceAshift, file);
        newXS("SDL::SurfaceRmask", XS_SDL_SurfaceRmask, file);
        newXS("SDL::SurfaceGmask", XS_SDL_SurfaceGmask, file);
        newXS("SDL::SurfaceBmask", XS_SDL_SurfaceBmask, file);
        newXS("SDL::SurfaceAmask", XS_SDL_SurfaceAmask, file);
        newXS("SDL::SurfaceColorKey", XS_SDL_SurfaceColorKey, file);
        newXS("SDL::SurfaceAlpha", XS_SDL_SurfaceAlpha, file);
        newXS("SDL::SurfaceW", XS_SDL_SurfaceW, file);
        newXS("SDL::SurfaceH", XS_SDL_SurfaceH, file);
        newXS("SDL::SurfacePitch", XS_SDL_SurfacePitch, file);
        newXS("SDL::SurfacePixels", XS_SDL_SurfacePixels, file);
        newXS("SDL::SurfacePixel", XS_SDL_SurfacePixel, file);
        newXS("SDL::MUSTLOCK", XS_SDL_MUSTLOCK, file);
        newXS("SDL::SurfaceLock", XS_SDL_SurfaceLock, file);
        newXS("SDL::SurfaceUnlock", XS_SDL_SurfaceUnlock, file);
        newXS("SDL::GetVideoSurface", XS_SDL_GetVideoSurface, file);
        newXS("SDL::VideoInfo", XS_SDL_VideoInfo, file);
        newXS("SDL::NewRect", XS_SDL_NewRect, file);
        newXS("SDL::FreeRect", XS_SDL_FreeRect, file);
        newXS("SDL::RectX", XS_SDL_RectX, file);
        newXS("SDL::RectY", XS_SDL_RectY, file);
        newXS("SDL::RectW", XS_SDL_RectW, file);
        newXS("SDL::RectH", XS_SDL_RectH, file);
        newXS("SDL::ListModes", XS_SDL_ListModes, file);
        newXS("SDL::NewColor", XS_SDL_NewColor, file);
        newXS("SDL::ColorR", XS_SDL_ColorR, file);
        newXS("SDL::ColorG", XS_SDL_ColorG, file);
        newXS("SDL::ColorB", XS_SDL_ColorB, file);
        newXS("SDL::ColorRGB", XS_SDL_ColorRGB, file);
        newXS("SDL::FreeColor", XS_SDL_FreeColor, file);
        newXS("SDL::NewPalette", XS_SDL_NewPalette, file);
        newXS("SDL::PaletteNColors", XS_SDL_PaletteNColors, file);
        newXS("SDL::PaletteColors", XS_SDL_PaletteColors, file);
        newXS("SDL::VideoModeOK", XS_SDL_VideoModeOK, file);
        newXS("SDL::SetVideoMode", XS_SDL_SetVideoMode, file);
        newXS("SDL::UpdateRect", XS_SDL_UpdateRect, file);
        newXS("SDL::UpdateRects", XS_SDL_UpdateRects, file);
        newXS("SDL::Flip", XS_SDL_Flip, file);
        newXS("SDL::SetColors", XS_SDL_SetColors, file);
        newXS("SDL::MapRGB", XS_SDL_MapRGB, file);
        newXS("SDL::MapRGBA", XS_SDL_MapRGBA, file);
        newXS("SDL::GetRGB", XS_SDL_GetRGB, file);
        newXS("SDL::GetRGBA", XS_SDL_GetRGBA, file);
        newXS("SDL::SaveBMP", XS_SDL_SaveBMP, file);
        newXS("SDL::SetColorKey", XS_SDL_SetColorKey, file);
        newXS("SDL::SetAlpha", XS_SDL_SetAlpha, file);
        newXS("SDL::DisplayFormat", XS_SDL_DisplayFormat, file);
        newXS("SDL::DisplayFormatAlpha", XS_SDL_DisplayFormatAlpha, file);
        newXS("SDL::ConvertRGB", XS_SDL_ConvertRGB, file);
        newXS("SDL::ConvertRGBA", XS_SDL_ConvertRGBA, file);
        newXS("SDL::BlitSurface", XS_SDL_BlitSurface, file);
        newXS("SDL::FillRect", XS_SDL_FillRect, file);
        newXS("SDL::GetAppState", XS_SDL_GetAppState, file);
        newXS("SDL::WMSetCaption", XS_SDL_WMSetCaption, file);
        newXS("SDL::WMGetCaption", XS_SDL_WMGetCaption, file);
        newXS("SDL::WMSetIcon", XS_SDL_WMSetIcon, file);
        newXS("SDL::WarpMouse", XS_SDL_WarpMouse, file);
        newXS("SDL::GetMouseState", XS_SDL_GetMouseState, file);
        newXS("SDL::GetRelativeMouseState", XS_SDL_GetRelativeMouseState, file);
        newXS("SDL::NewCursor", XS_SDL_NewCursor, file);
        newXS("SDL::FreeCursor", XS_SDL_FreeCursor, file);
        newXS("SDL::SetCursor", XS_SDL_SetCursor, file);
        newXS("SDL::GetCursor", XS_SDL_GetCursor, file);
        newXS("SDL::ShowCursor", XS_SDL_ShowCursor, file);
        newXS("SDL::NewAudioSpec", XS_SDL_NewAudioSpec, file);
        newXS("SDL::FreeAudioSpec", XS_SDL_FreeAudioSpec, file);
        newXS("SDL::NewAudioCVT", XS_SDL_NewAudioCVT, file);
        newXS("SDL::FreeAudioCVT", XS_SDL_FreeAudioCVT, file);
        newXS("SDL::ConvertAudioData", XS_SDL_ConvertAudioData, file);
        newXS("SDL::OpenAudio", XS_SDL_OpenAudio, file);
        newXS("SDL::GetAudioStatus", XS_SDL_GetAudioStatus, file);
        newXS("SDL::PauseAudio", XS_SDL_PauseAudio, file);
        newXS("SDL::LockAudio", XS_SDL_LockAudio, file);
        newXS("SDL::UnlockAudio", XS_SDL_UnlockAudio, file);
        newXS("SDL::CloseAudio", XS_SDL_CloseAudio, file);
        newXS("SDL::FreeWAV", XS_SDL_FreeWAV, file);
        newXS("SDL::LoadWAV", XS_SDL_LoadWAV, file);
#if XSubPPtmpAAAB
        newXS("SDL::MixAudio", XS_SDL_MixAudio, file);
        newXS("SDL::MixOpenAudio", XS_SDL_MixOpenAudio, file);
        newXS("SDL::MixAllocateChannels", XS_SDL_MixAllocateChannels, file);
        newXS("SDL::MixQuerySpec", XS_SDL_MixQuerySpec, file);
        newXS("SDL::MixLoadWAV", XS_SDL_MixLoadWAV, file);
        newXS("SDL::MixLoadMusic", XS_SDL_MixLoadMusic, file);
        newXS("SDL::MixQuickLoadWAV", XS_SDL_MixQuickLoadWAV, file);
        newXS("SDL::MixFreeChunk", XS_SDL_MixFreeChunk, file);
        newXS("SDL::MixFreeMusic", XS_SDL_MixFreeMusic, file);
        newXS("SDL::MixSetPostMixCallback", XS_SDL_MixSetPostMixCallback, file);
        newXS("SDL::PerlMixMusicHook", XS_SDL_PerlMixMusicHook, file);
        newXS("SDL::MixSetMusicHook", XS_SDL_MixSetMusicHook, file);
        newXS("SDL::MixSetMusicFinishedHook", XS_SDL_MixSetMusicFinishedHook, file);
        newXS("SDL::MixGetMusicHookData", XS_SDL_MixGetMusicHookData, file);
        newXS("SDL::MixReverseChannels", XS_SDL_MixReverseChannels, file);
        newXS("SDL::MixGroupChannel", XS_SDL_MixGroupChannel, file);
        newXS("SDL::MixGroupChannels", XS_SDL_MixGroupChannels, file);
        newXS("SDL::MixGroupAvailable", XS_SDL_MixGroupAvailable, file);
        newXS("SDL::MixGroupCount", XS_SDL_MixGroupCount, file);
        newXS("SDL::MixGroupOldest", XS_SDL_MixGroupOldest, file);
        newXS("SDL::MixGroupNewer", XS_SDL_MixGroupNewer, file);
        newXS("SDL::MixPlayChannel", XS_SDL_MixPlayChannel, file);
        newXS("SDL::MixPlayChannelTimed", XS_SDL_MixPlayChannelTimed, file);
        newXS("SDL::MixPlayMusic", XS_SDL_MixPlayMusic, file);
        newXS("SDL::MixFadeInChannel", XS_SDL_MixFadeInChannel, file);
        newXS("SDL::MixFadeInChannelTimed", XS_SDL_MixFadeInChannelTimed, file);
        newXS("SDL::MixFadeInMusic", XS_SDL_MixFadeInMusic, file);
        newXS("SDL::MixVolume", XS_SDL_MixVolume, file);
        newXS("SDL::MixVolumeChunk", XS_SDL_MixVolumeChunk, file);
        newXS("SDL::MixVolumeMusic", XS_SDL_MixVolumeMusic, file);
        newXS("SDL::MixHaltChannel", XS_SDL_MixHaltChannel, file);
        newXS("SDL::MixHaltGroup", XS_SDL_MixHaltGroup, file);
        newXS("SDL::MixHaltMusic", XS_SDL_MixHaltMusic, file);
        newXS("SDL::MixExpireChannel", XS_SDL_MixExpireChannel, file);
        newXS("SDL::MixFadeOutChannel", XS_SDL_MixFadeOutChannel, file);
        newXS("SDL::MixFadeOutGroup", XS_SDL_MixFadeOutGroup, file);
        newXS("SDL::MixFadeOutMusic", XS_SDL_MixFadeOutMusic, file);
        newXS("SDL::MixFadingMusic", XS_SDL_MixFadingMusic, file);
        newXS("SDL::MixFadingChannel", XS_SDL_MixFadingChannel, file);
        newXS("SDL::MixPause", XS_SDL_MixPause, file);
        newXS("SDL::MixResume", XS_SDL_MixResume, file);
        newXS("SDL::MixPaused", XS_SDL_MixPaused, file);
        newXS("SDL::MixPauseMusic", XS_SDL_MixPauseMusic, file);
        newXS("SDL::MixResumeMusic", XS_SDL_MixResumeMusic, file);
        newXS("SDL::MixRewindMusic", XS_SDL_MixRewindMusic, file);
        newXS("SDL::MixPausedMusic", XS_SDL_MixPausedMusic, file);
        newXS("SDL::MixPlaying", XS_SDL_MixPlaying, file);
        newXS("SDL::MixPlayingMusic", XS_SDL_MixPlayingMusic, file);
        newXS("SDL::MixCloseAudio", XS_SDL_MixCloseAudio, file);
#endif
        newXS("SDL::GLLoadLibrary", XS_SDL_GLLoadLibrary, file);
        newXS("SDL::GLGetProcAddress", XS_SDL_GLGetProcAddress, file);
        newXS("SDL::GLSetAttribute", XS_SDL_GLSetAttribute, file);
        newXS("SDL::GLGetAttribute", XS_SDL_GLGetAttribute, file);
        newXS("SDL::GLSwapBuffers", XS_SDL_GLSwapBuffers, file);
        newXS("SDL::BigEndian", XS_SDL_BigEndian, file);
        newXS("SDL::NumJoysticks", XS_SDL_NumJoysticks, file);
        newXS("SDL::JoystickName", XS_SDL_JoystickName, file);
        newXS("SDL::JoystickOpen", XS_SDL_JoystickOpen, file);
        newXS("SDL::JoystickOpened", XS_SDL_JoystickOpened, file);
        newXS("SDL::JoystickIndex", XS_SDL_JoystickIndex, file);
        newXS("SDL::JoystickNumAxes", XS_SDL_JoystickNumAxes, file);
        newXS("SDL::JoystickNumBalls", XS_SDL_JoystickNumBalls, file);
        newXS("SDL::JoystickNumHats", XS_SDL_JoystickNumHats, file);
        newXS("SDL::JoystickNumButtons", XS_SDL_JoystickNumButtons, file);
        newXS("SDL::JoystickUpdate", XS_SDL_JoystickUpdate, file);
        newXS("SDL::JoystickGetAxis", XS_SDL_JoystickGetAxis, file);
        newXS("SDL::JoystickGetHat", XS_SDL_JoystickGetHat, file);
        newXS("SDL::JoystickGetButton", XS_SDL_JoystickGetButton, file);
        newXS("SDL::JoystickGetBall", XS_SDL_JoystickGetBall, file);
        newXS("SDL::JoystickClose", XS_SDL_JoystickClose, file);
        newXS("SDL::JoyAxisEventWhich", XS_SDL_JoyAxisEventWhich, file);
        newXS("SDL::JoyAxisEventAxis", XS_SDL_JoyAxisEventAxis, file);
        newXS("SDL::JoyAxisEventValue", XS_SDL_JoyAxisEventValue, file);
        newXS("SDL::JoyButtonEventWhich", XS_SDL_JoyButtonEventWhich, file);
        newXS("SDL::JoyButtonEventButton", XS_SDL_JoyButtonEventButton, file);
        newXS("SDL::JoyButtonEventState", XS_SDL_JoyButtonEventState, file);
        newXS("SDL::JoyHatEventWhich", XS_SDL_JoyHatEventWhich, file);
        newXS("SDL::JoyHatEventHat", XS_SDL_JoyHatEventHat, file);
        newXS("SDL::JoyHatEventValue", XS_SDL_JoyHatEventValue, file);
        newXS("SDL::JoyBallEventWhich", XS_SDL_JoyBallEventWhich, file);
        newXS("SDL::JoyBallEventBall", XS_SDL_JoyBallEventBall, file);
        newXS("SDL::JoyBallEventXrel", XS_SDL_JoyBallEventXrel, file);
        newXS("SDL::JoyBallEventYrel", XS_SDL_JoyBallEventYrel, file);
        newXS("SDL::SetClipRect", XS_SDL_SetClipRect, file);
        newXS("SDL::GetClipRect", XS_SDL_GetClipRect, file);
#if XSubPPtmpAAAC
        newXS("SDL::NetInit", XS_SDL_NetInit, file);
        newXS("SDL::NetQuit", XS_SDL_NetQuit, file);
        newXS("SDL::NetNewIPaddress", XS_SDL_NetNewIPaddress, file);
        newXS("SDL::NetIPaddressHost", XS_SDL_NetIPaddressHost, file);
        newXS("SDL::NetIPaddressPort", XS_SDL_NetIPaddressPort, file);
        newXS("SDL::NetFreeIPaddress", XS_SDL_NetFreeIPaddress, file);
        newXS("SDL::NetResolveIP", XS_SDL_NetResolveIP, file);
        newXS("SDL::NetResolveHost", XS_SDL_NetResolveHost, file);
        newXS("SDL::NetTCPOpen", XS_SDL_NetTCPOpen, file);
        newXS("SDL::NetTCPAccept", XS_SDL_NetTCPAccept, file);
        newXS("SDL::NetTCPGetPeerAddress", XS_SDL_NetTCPGetPeerAddress, file);
        newXS("SDL::NetTCPSend", XS_SDL_NetTCPSend, file);
        newXS("SDL::NetTCPRecv", XS_SDL_NetTCPRecv, file);
        newXS("SDL::NetTCPClose", XS_SDL_NetTCPClose, file);
        newXS("SDL::NetAllocPacket", XS_SDL_NetAllocPacket, file);
        newXS("SDL::NetAllocPacketV", XS_SDL_NetAllocPacketV, file);
        newXS("SDL::NetResizePacket", XS_SDL_NetResizePacket, file);
        newXS("SDL::NetFreePacket", XS_SDL_NetFreePacket, file);
        newXS("SDL::NetFreePacketV", XS_SDL_NetFreePacketV, file);
        newXS("SDL::NetUDPOpen", XS_SDL_NetUDPOpen, file);
        newXS("SDL::NetUDPBind", XS_SDL_NetUDPBind, file);
        newXS("SDL::NetUDPUnbind", XS_SDL_NetUDPUnbind, file);
        newXS("SDL::NetUDPGetPeerAddress", XS_SDL_NetUDPGetPeerAddress, file);
        newXS("SDL::NetUDPSendV", XS_SDL_NetUDPSendV, file);
        newXS("SDL::NetUDPSend", XS_SDL_NetUDPSend, file);
        newXS("SDL::NetUDPRecvV", XS_SDL_NetUDPRecvV, file);
        newXS("SDL::NetUDPRecv", XS_SDL_NetUDPRecv, file);
        newXS("SDL::NetUDPClose", XS_SDL_NetUDPClose, file);
        newXS("SDL::NetAllocSocketSet", XS_SDL_NetAllocSocketSet, file);
        newXS("SDL::NetTCP_AddSocket", XS_SDL_NetTCP_AddSocket, file);
        newXS("SDL::NetUDP_AddSocket", XS_SDL_NetUDP_AddSocket, file);
        newXS("SDL::NetTCP_DelSocket", XS_SDL_NetTCP_DelSocket, file);
        newXS("SDL::NetUDP_DelSocket", XS_SDL_NetUDP_DelSocket, file);
        newXS("SDL::NetCheckSockets", XS_SDL_NetCheckSockets, file);
        newXS("SDL::NetSocketReady", XS_SDL_NetSocketReady, file);
        newXS("SDL::NetFreeSocketSet", XS_SDL_NetFreeSocketSet, file);
        newXS("SDL::NetWrite16", XS_SDL_NetWrite16, file);
        newXS("SDL::NetWrite32", XS_SDL_NetWrite32, file);
        newXS("SDL::NetRead16", XS_SDL_NetRead16, file);
        newXS("SDL::NetRead32", XS_SDL_NetRead32, file);
#endif
#if XSubPPtmpAAAD
        newXS("SDL::TTFInit", XS_SDL_TTFInit, file);
        newXS("SDL::TTFQuit", XS_SDL_TTFQuit, file);
        newXS("SDL::TTFOpenFont", XS_SDL_TTFOpenFont, file);
        newXS("SDL::TTFGetFontStyle", XS_SDL_TTFGetFontStyle, file);
        newXS("SDL::TTFSetFontStyle", XS_SDL_TTFSetFontStyle, file);
        newXS("SDL::TTFFontHeight", XS_SDL_TTFFontHeight, file);
        newXS("SDL::TTFFontAscent", XS_SDL_TTFFontAscent, file);
        newXS("SDL::TTFFontDescent", XS_SDL_TTFFontDescent, file);
        newXS("SDL::TTFFontLineSkip", XS_SDL_TTFFontLineSkip, file);
        newXS("SDL::TTFGlyphMetrics", XS_SDL_TTFGlyphMetrics, file);
        newXS("SDL::TTFSizeText", XS_SDL_TTFSizeText, file);
        newXS("SDL::TTFSizeUTF8", XS_SDL_TTFSizeUTF8, file);
        newXS("SDL::TTFSizeUNICODE", XS_SDL_TTFSizeUNICODE, file);
        newXS("SDL::TTFRenderTextSolid", XS_SDL_TTFRenderTextSolid, file);
        newXS("SDL::TTFRenderUTF8Solid", XS_SDL_TTFRenderUTF8Solid, file);
        newXS("SDL::TTFRenderUNICODESolid", XS_SDL_TTFRenderUNICODESolid, file);
        newXS("SDL::TTFRenderGlyphSolid", XS_SDL_TTFRenderGlyphSolid, file);
        newXS("SDL::TTFRenderTextShaded", XS_SDL_TTFRenderTextShaded, file);
        newXS("SDL::TTFRenderUTF8Shaded", XS_SDL_TTFRenderUTF8Shaded, file);
        newXS("SDL::TTFRenderUNICODEShaded", XS_SDL_TTFRenderUNICODEShaded, file);
        newXS("SDL::TTFRenderGlyphShaded", XS_SDL_TTFRenderGlyphShaded, file);
        newXS("SDL::TTFRenderTextBlended", XS_SDL_TTFRenderTextBlended, file);
        newXS("SDL::TTFRenderUTF8Blended", XS_SDL_TTFRenderUTF8Blended, file);
        newXS("SDL::TTFRenderUNICODEBlended", XS_SDL_TTFRenderUNICODEBlended, file);
        newXS("SDL::TTFRenderGlyphBlended", XS_SDL_TTFRenderGlyphBlended, file);
        newXS("SDL::TTFCloseFont", XS_SDL_TTFCloseFont, file);
        newXS("SDL::TTFPutString", XS_SDL_TTFPutString, file);
#endif
        newXS("SDL::CreateYUVOverlay", XS_SDL_CreateYUVOverlay, file);
        newXS("SDL::LockYUVOverlay", XS_SDL_LockYUVOverlay, file);
        newXS("SDL::UnlockYUVOverlay", XS_SDL_UnlockYUVOverlay, file);
        newXS("SDL::DisplayYUVOverlay", XS_SDL_DisplayYUVOverlay, file);
        newXS("SDL::FreeYUVOverlay", XS_SDL_FreeYUVOverlay, file);
        newXS("SDL::OverlayFormat", XS_SDL_OverlayFormat, file);
        newXS("SDL::OverlayW", XS_SDL_OverlayW, file);
        newXS("SDL::OverlayH", XS_SDL_OverlayH, file);
        newXS("SDL::OverlayPlanes", XS_SDL_OverlayPlanes, file);
        newXS("SDL::OverlayHW", XS_SDL_OverlayHW, file);
        newXS("SDL::OverlayPitches", XS_SDL_OverlayPitches, file);
        newXS("SDL::OverlayPixels", XS_SDL_OverlayPixels, file);
        newXS("SDL::WMToggleFullScreen", XS_SDL_WMToggleFullScreen, file);
        newXS("SDL::WMGrabInput", XS_SDL_WMGrabInput, file);
        newXS("SDL::WMIconifyWindow", XS_SDL_WMIconifyWindow, file);
        newXS("SDL::ResizeEventW", XS_SDL_ResizeEventW, file);
        newXS("SDL::ResizeEventH", XS_SDL_ResizeEventH, file);
        newXS("SDL::AudioDriverName", XS_SDL_AudioDriverName, file);
        newXS("SDL::GetKeyState", XS_SDL_GetKeyState, file);
#if XSubPPtmpAAAE
        newXS("SDL::NewSMPEGInfo", XS_SDL_NewSMPEGInfo, file);
        newXS("SDL::FreeSMPEGInfo", XS_SDL_FreeSMPEGInfo, file);
        newXS("SDL::SMPEGInfoHasAudio", XS_SDL_SMPEGInfoHasAudio, file);
        newXS("SDL::SMPEGInfoHasVideo", XS_SDL_SMPEGInfoHasVideo, file);
        newXS("SDL::SMPEGInfoWidth", XS_SDL_SMPEGInfoWidth, file);
        newXS("SDL::SMPEGInfoHeight", XS_SDL_SMPEGInfoHeight, file);
        newXS("SDL::SMPEGInfoCurrentFrame", XS_SDL_SMPEGInfoCurrentFrame, file);
        newXS("SDL::SMPEGInfoCurrentFPS", XS_SDL_SMPEGInfoCurrentFPS, file);
        newXS("SDL::SMPEGInfoCurrentAudioFrame", XS_SDL_SMPEGInfoCurrentAudioFrame, file);
        newXS("SDL::SMPEGInfoCurrentOffset", XS_SDL_SMPEGInfoCurrentOffset, file);
        newXS("SDL::SMPEGInfoTotalSize", XS_SDL_SMPEGInfoTotalSize, file);
        newXS("SDL::SMPEGInfoCurrentTime", XS_SDL_SMPEGInfoCurrentTime, file);
        newXS("SDL::SMPEGInfoTotalTime", XS_SDL_SMPEGInfoTotalTime, file);
        newXS("SDL::SMPEGError", XS_SDL_SMPEGError, file);
        newXS("SDL::NewSMPEG", XS_SDL_NewSMPEG, file);
        newXS("SDL::FreeSMPEG", XS_SDL_FreeSMPEG, file);
        newXS("SDL::SMPEGEnableAudio", XS_SDL_SMPEGEnableAudio, file);
        newXS("SDL::SMPEGEnableVideo", XS_SDL_SMPEGEnableVideo, file);
        newXS("SDL::SMPEGSetVolume", XS_SDL_SMPEGSetVolume, file);
        newXS("SDL::SMPEGSetDisplay", XS_SDL_SMPEGSetDisplay, file);
        newXS("SDL::SMPEGScaleXY", XS_SDL_SMPEGScaleXY, file);
        newXS("SDL::SMPEGScale", XS_SDL_SMPEGScale, file);
        newXS("SDL::SMPEGPlay", XS_SDL_SMPEGPlay, file);
        newXS("SDL::SMPEGStatus", XS_SDL_SMPEGStatus, file);
        newXS("SDL::SMPEGPause", XS_SDL_SMPEGPause, file);
        newXS("SDL::SMPEGLoop", XS_SDL_SMPEGLoop, file);
        newXS("SDL::SMPEGStop", XS_SDL_SMPEGStop, file);
        newXS("SDL::SMPEGRewind", XS_SDL_SMPEGRewind, file);
        newXS("SDL::SMPEGSeek", XS_SDL_SMPEGSeek, file);
        newXS("SDL::SMPEGSkip", XS_SDL_SMPEGSkip, file);
        newXS("SDL::SMPEGSetDisplayRegion", XS_SDL_SMPEGSetDisplayRegion, file);
        newXS("SDL::SMPEGRenderFrame", XS_SDL_SMPEGRenderFrame, file);
        newXS("SDL::SMPEGGetInfo", XS_SDL_SMPEGGetInfo, file);
#endif
#if XSubPPtmpAAAF
        newXS("SDL::GFXRotoZoom", XS_SDL_GFXRotoZoom, file);
        newXS("SDL::GFXZoom", XS_SDL_GFXZoom, file);
        newXS("SDL::GFXPixelColor", XS_SDL_GFXPixelColor, file);
        newXS("SDL::GFXPixelRGBA", XS_SDL_GFXPixelRGBA, file);
        newXS("SDL::GFXHlineColor", XS_SDL_GFXHlineColor, file);
        newXS("SDL::GFXHlineRGBA", XS_SDL_GFXHlineRGBA, file);
        newXS("SDL::GFXVlineColor", XS_SDL_GFXVlineColor, file);
        newXS("SDL::GFXVlineRGBA", XS_SDL_GFXVlineRGBA, file);
        newXS("SDL::GFXRectangleColor", XS_SDL_GFXRectangleColor, file);
        newXS("SDL::GFXRectangleRGBA", XS_SDL_GFXRectangleRGBA, file);
        newXS("SDL::GFXBoxColor", XS_SDL_GFXBoxColor, file);
        newXS("SDL::GFXBoxRGBA", XS_SDL_GFXBoxRGBA, file);
        newXS("SDL::GFXLineColor", XS_SDL_GFXLineColor, file);
        newXS("SDL::GFXLineRGBA", XS_SDL_GFXLineRGBA, file);
        newXS("SDL::GFXAalineColor", XS_SDL_GFXAalineColor, file);
        newXS("SDL::GFXAalineRGBA", XS_SDL_GFXAalineRGBA, file);
        newXS("SDL::GFXCircleColor", XS_SDL_GFXCircleColor, file);
        newXS("SDL::GFXCircleRGBA", XS_SDL_GFXCircleRGBA, file);
        newXS("SDL::GFXAacircleColor", XS_SDL_GFXAacircleColor, file);
        newXS("SDL::GFXAacircleRGBA", XS_SDL_GFXAacircleRGBA, file);
        newXS("SDL::GFXFilledCircleColor", XS_SDL_GFXFilledCircleColor, file);
        newXS("SDL::GFXFilledCircleRGBA", XS_SDL_GFXFilledCircleRGBA, file);
        newXS("SDL::GFXEllipseColor", XS_SDL_GFXEllipseColor, file);
        newXS("SDL::GFXEllipseRGBA", XS_SDL_GFXEllipseRGBA, file);
        newXS("SDL::GFXAaellipseColor", XS_SDL_GFXAaellipseColor, file);
        newXS("SDL::GFXAaellipseRGBA", XS_SDL_GFXAaellipseRGBA, file);
        newXS("SDL::GFXFilledEllipseColor", XS_SDL_GFXFilledEllipseColor, file);
        newXS("SDL::GFXFilledEllipseRGBA", XS_SDL_GFXFilledEllipseRGBA, file);
        newXS("SDL::GFXFilledPieColor", XS_SDL_GFXFilledPieColor, file);
        newXS("SDL::GFXFilledPieRGBA", XS_SDL_GFXFilledPieRGBA, file);
        newXS("SDL::GFXPolygonColor", XS_SDL_GFXPolygonColor, file);
        newXS("SDL::GFXPolygonRGBA", XS_SDL_GFXPolygonRGBA, file);
        newXS("SDL::GFXAapolygonColor", XS_SDL_GFXAapolygonColor, file);
        newXS("SDL::GFXAapolygonRGBA", XS_SDL_GFXAapolygonRGBA, file);
        newXS("SDL::GFXFilledPolygonColor", XS_SDL_GFXFilledPolygonColor, file);
        newXS("SDL::GFXFilledPolygonRGBA", XS_SDL_GFXFilledPolygonRGBA, file);
        newXS("SDL::GFXCharacterColor", XS_SDL_GFXCharacterColor, file);
        newXS("SDL::GFXCharacterRGBA", XS_SDL_GFXCharacterRGBA, file);
        newXS("SDL::GFXStringColor", XS_SDL_GFXStringColor, file);
        newXS("SDL::GFXStringRGBA", XS_SDL_GFXStringRGBA, file);
#endif
#if XSubPPtmpAAAG
        newXS("SDL::SVG_Load", XS_SDL_SVG_Load, file);
        newXS("SDL::SVG_LoadBuffer", XS_SDL_SVG_LoadBuffer, file);
        newXS("SDL::SVG_SetOffset", XS_SDL_SVG_SetOffset, file);
        newXS("SDL::SVG_SetScale", XS_SDL_SVG_SetScale, file);
        newXS("SDL::SVG_RenderToSurface", XS_SDL_SVG_RenderToSurface, file);
        newXS("SDL::SVG_Free", XS_SDL_SVG_Free, file);
        newXS("SDL::SVG_Set_Flags", XS_SDL_SVG_Set_Flags, file);
        newXS("SDL::SVG_Width", XS_SDL_SVG_Width, file);
        newXS("SDL::SVG_HEIGHT", XS_SDL_SVG_HEIGHT, file);
        newXS("SDL::SVG_SetClipping", XS_SDL_SVG_SetClipping, file);
        newXS("SDL::SVG_Version", XS_SDL_SVG_Version, file);
#endif
#if XSubPPtmpAAAH
        newXS("SDL::SoundAudioInfoFormat", XS_SDL_SoundAudioInfoFormat, file);
        newXS("SDL::SoundAudioInfoChannels", XS_SDL_SoundAudioInfoChannels, file);
        newXS("SDL::SoundAudioInforate", XS_SDL_SoundAudioInforate, file);
        newXS("SDL::SoundDecoderInfoExtensions", XS_SDL_SoundDecoderInfoExtensions, file);
        newXS("SDL::SoundDecoderInfoDescription", XS_SDL_SoundDecoderInfoDescription, file);
        newXS("SDL::SoundDecoderInfoAuthor", XS_SDL_SoundDecoderInfoAuthor, file);
        newXS("SDL::SoundDecoderInfoUrl", XS_SDL_SoundDecoderInfoUrl, file);
        newXS("SDL::SoundSampleDecoder", XS_SDL_SoundSampleDecoder, file);
        newXS("SDL::SoundSampleDesired", XS_SDL_SoundSampleDesired, file);
        newXS("SDL::SoundSampleAcutal", XS_SDL_SoundSampleAcutal, file);
        newXS("SDL::SoundSampleBuffer", XS_SDL_SoundSampleBuffer, file);
        newXS("SDL::SoundSampleBufferSize", XS_SDL_SoundSampleBufferSize, file);
        newXS("SDL::SoundSampleFlags", XS_SDL_SoundSampleFlags, file);
        newXS("SDL::Sound_Init", XS_SDL_Sound_Init, file);
        newXS("SDL::Sound_Quit", XS_SDL_Sound_Quit, file);
        newXS("SDL::Sound_AvailableDecoders", XS_SDL_Sound_AvailableDecoders, file);
        newXS("SDL::Sound_GetError", XS_SDL_Sound_GetError, file);
        newXS("SDL::Sound_ClearError", XS_SDL_Sound_ClearError, file);
        newXS("SDL::Sound_NewSample", XS_SDL_Sound_NewSample, file);
        newXS("SDL::Sound_NewSampleFromMem", XS_SDL_Sound_NewSampleFromMem, file);
        newXS("SDL::Sound_NewSampleFromFile", XS_SDL_Sound_NewSampleFromFile, file);
        newXS("SDL::Sound_FreeSample", XS_SDL_Sound_FreeSample, file);
        newXS("SDL::Sound_GetDuration", XS_SDL_Sound_GetDuration, file);
        newXS("SDL::Sound_SetBufferSize", XS_SDL_Sound_SetBufferSize, file);
        newXS("SDL::Sound_Decode", XS_SDL_Sound_Decode, file);
        newXS("SDL::Sound_DecodeAll", XS_SDL_Sound_DecodeAll, file);
        newXS("SDL::Sound_Rewind", XS_SDL_Sound_Rewind, file);
        newXS("SDL::Sound_Seek", XS_SDL_Sound_Seek, file);
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#line 11768 "lib/SDL_perl.c"

    /* End of Initialisation Section */

    if (PL_unitcheckav)
         call_list(PL_scopestack_ix, PL_unitcheckav);
    XSRETURN_YES;
}

