use v6.c;
use Test;
use lib 'lib';

use LZW::Revolunet;

my $frlen  = 4096;
my $dspath = './t/datasets';
my $phrase = (
    'Тексты - это не энциклопедические и не лингвистические ' ~
    ' системы. Тексты сужают бесконечные или неопределенные ' ~
    'возможности систем и создают закрытый универсум. Системы ' ~
    'редельны, но бесконечны. Тексты - предельны и конечны, хотя ' ~
    'интерпретаций может быть очень много. Источник - Умберто Эко ' ~
    'От интернета к Гуттенбергу: текст и гипертекст - URL: ' ~
    'http://kiev.philosophy.ru/library/eco/internet.html Точность ' ~
    'цитирования - почти дословно'
) x 255;

plan 1;

subtest {
    plan 6;
    my $obj = LZW::Revolunet.new;
    my $dsz = 97000;
    $obj.set_dictsize( $dsz );
    is( $obj.get_dictsize, $dsz, 'set/get_dictsize' );
    is(
        $obj.decode_utf8($obj.encode_utf8($phrase)),
        $phrase,
        'escape/unescape'
    );
    ok( $obj.compress($phrase), 'compress');
    ok( $obj.decompress($obj.compress($phrase)), 'decompress');
    my $cmp = $obj.compress( $obj.encode_utf8($phrase) );
    is(
        $obj.decode_utf8( $obj.decompress( $cmp ) ),
        $phrase,
        'compress and decompress, ' ~
            $cmp.chars ~ '/' ~ $phrase.chars ~ ' bytes'
    );
    ok( process_datasets( $obj, False ), 'process datasets');
}, 'subtest 1';

done-testing;

sub process_datasets( Any $obj, Bool $print ) returns Bool {
    my @ds   = get_datasets;
    for @ds -> $ds {
        my @frms  = dataset_to_frames($ds);
        my $dstat = 0;
        for @frms -> $f {
            my $cmp  = $obj.compress( $obj.encode_utf8($f) );
            my $dcmp = $obj.decode_utf8( $obj.decompress( $cmp ) );
            $dstat += $cmp.chars
        }
        my $cntlen = @frms.join(q{}).chars;
        if $print {
            ($ds ~ ': compress ratio ' ~ floor($dstat/$cntlen*100) ~ '%').say;
        }
    }
    True;
}

sub dataset_to_frames( Str $fname ) returns List {
    my @frames;
    if ( $fname.IO.e ) {
        my $cnt = $fname.IO.slurp;
        my $ff  = ($cnt.chars / $frlen).floor;
        my $hf  = $cnt.chars % $frlen;
        # ( $ff~','~$hf~','~($hf+$ff*$frlen)~'='~$cnt.chars).say;
        for (0..$ff) {
            if ( $_ < $ff ) {
                @frames.push( $cnt.substr( $_*$frlen, $frlen) );
            } else {
                @frames.push( $cnt.substr( $_*$frlen, $_*$frlen+$hf) );
            }
        }
    }
    @frames;
}

sub get_datasets returns List {
    my @files;
    my $dir  = $dspath;
    my @todo = $dir.IO;
    while @todo {
        for @todo.pop.dir -> $path {
            @files.push($path.Str) if $path.f;
            @todo.push: $path if $path.d;
        }
    }
    @files
}
