=head1 Name

SPVM::Document::EnvironmentVariables - Environment Variables

=head1 Description

This document explains environment variables.

=head1 Environment Variables

If an environment variable is an empty string, it is treated as an undefined value.

=head2 SPVM_BUILD_DIR

A directory for files generated by the compiler and linker.

C source codes for precompilation, dynamic link libraries and object files are stored into this directory.

These files are output when attempting to build a module containing methods with the C<native> attribute or the C<precompile> attribute.

If these files are output and the directory given by C<SPVM_BUILD_DIR> environment variable does not exist, an exception is thrown.
Examples:

  # bash
  export SPVM_BUILD_DIR=~/.spvm_build
  
  # csh
  setenv SPVM_BUILD_DIR ~/.spvm_build

=head2 SPVM_CC_DEBUG

If C<SPVM_CC_DEBUG> environement variable is a true value of Perl, debug messages and messages from L<SPVM native class|SPVM::Document::NativeClass> compiler and linker are printed to stderr.

=head2 SPVM_CC_QUIET

If C<SPVM_CC_QUIET> environement variable is a true value of Perl, messages L<SPVM native class|SPVM::Document::NativeClass> compiler and linker are not printed to stderr.

If it is defined and a false value of Perl, the messages are printed.

This setting has a higher priority than L<SPVM::Builder::Config#quiet|SPVM::Builder::Config/"quiet"> field.

=head2 SPVM_CC_FORCE

If C<SPVM_CC_FORCE> environement variable is a true value of Perl, the compilation and link by L<SPVM native class|SPVM::Document::NativeClass> compiler and linker are forced.

This setting has a higher priority than L<SPVM::Builder::Config#force|SPVM::Builder::Config/"force"> field.

=head1 See Also

=over 2

=item * L<SPVM::Document>

=back

=head1 Copyright & License

Copyright (c) 2023 Yuki Kimoto

MIT License
