#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__Character__character(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__Character__escape(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__Character__escape_ascii(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Literal__Character__character(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::Character";
    const char* sub_name = "character";
    const char* file = "TestCase/Literal/Character.spvm";
    int32_t line = 4;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::Character";
    const char* sub_name = "character";
    const char* file = "TestCase/Literal/Character.spvm";
    int32_t line = 5;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 97;
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__Character__escape(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[10];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x00';
L2: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x07';
L3: // MOVE_CONSTANT_BYTE
  byte_vars[2] = '\x08';
L4: // MOVE_CONSTANT_BYTE
  byte_vars[3] = '\x09';
L5: // MOVE_CONSTANT_BYTE
  byte_vars[4] = '\x0A';
L6: // MOVE_CONSTANT_BYTE
  byte_vars[5] = '\x0C';
L7: // MOVE_CONSTANT_BYTE
  byte_vars[6] = '\x0D';
L8: // MOVE_CONSTANT_BYTE
  byte_vars[7] = '\x22';
L9: // MOVE_CONSTANT_BYTE
  byte_vars[8] = '\x27';
L10: // MOVE_CONSTANT_BYTE
  byte_vars[9] = '\x5C';
L11: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L18: // GOTO
  goto L19;
L19: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L21: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_NE_ZERO
  if (int_vars[0]) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L26: // GOTO
  goto L27;
L27: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[2];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L29: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L34: // GOTO
  goto L35;
L35: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[3];
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L37: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L42: // GOTO
  goto L43;
L43: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[4];
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 10;
L45: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L50: // GOTO
  goto L51;
L51: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[5];
L52: // MOVE_CONSTANT_INT
  int_vars[5] = 12;
L53: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L58: // GOTO
  goto L59;
L59: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[6];
L60: // MOVE_CONSTANT_INT
  int_vars[5] = 13;
L61: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L66: // GOTO
  goto L67;
L67: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[7];
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 34;
L69: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L74: // GOTO
  goto L75;
L75: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[8];
L76: // MOVE_CONSTANT_INT
  int_vars[5] = 39;
L77: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_NE_ZERO
  if (int_vars[0]) { goto L83; }
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L82: // GOTO
  goto L83;
L83: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[9];
L84: // MOVE_CONSTANT_INT
  int_vars[5] = 92;
L85: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_NE_ZERO
  if (int_vars[0]) { goto L91; }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L90: // GOTO
  goto L91;
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L95;
L93: // INIT_INT
  int_vars[6] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L95;
L95: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__Character__escape_ascii(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[22];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x00';
L2: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x11';
L3: // MOVE_CONSTANT_BYTE
  byte_vars[2] = '\x22';
L4: // MOVE_CONSTANT_BYTE
  byte_vars[3] = '\x33';
L5: // MOVE_CONSTANT_BYTE
  byte_vars[4] = '\x44';
L6: // MOVE_CONSTANT_BYTE
  byte_vars[5] = '\x55';
L7: // MOVE_CONSTANT_BYTE
  byte_vars[6] = '\x66';
L8: // MOVE_CONSTANT_BYTE
  byte_vars[7] = '\x77';
L9: // MOVE_CONSTANT_BYTE
  byte_vars[8] = '\x78';
L10: // MOVE_CONSTANT_BYTE
  byte_vars[9] = '\x79';
L11: // MOVE_CONSTANT_BYTE
  byte_vars[10] = '\x7A';
L12: // MOVE_CONSTANT_BYTE
  byte_vars[11] = '\x7B';
L13: // MOVE_CONSTANT_BYTE
  byte_vars[12] = '\x7C';
L14: // MOVE_CONSTANT_BYTE
  byte_vars[13] = '\x7D';
L15: // MOVE_CONSTANT_BYTE
  byte_vars[14] = '\x7E';
L16: // MOVE_CONSTANT_BYTE
  byte_vars[15] = '\x7F';
L17: // MOVE_CONSTANT_BYTE
  byte_vars[16] = '\x7A';
L18: // MOVE_CONSTANT_BYTE
  byte_vars[17] = '\x7B';
L19: // MOVE_CONSTANT_BYTE
  byte_vars[18] = '\x7C';
L20: // MOVE_CONSTANT_BYTE
  byte_vars[19] = '\x7D';
L21: // MOVE_CONSTANT_BYTE
  byte_vars[20] = '\x7E';
L22: // MOVE_CONSTANT_BYTE
  byte_vars[21] = '\x7F';
L23: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L30: // GOTO
  goto L31;
L31: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 17;
L33: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L38: // GOTO
  goto L39;
L39: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[2];
L40: // MOVE_CONSTANT_INT
  int_vars[5] = 34;
L41: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L46: // GOTO
  goto L47;
L47: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[3];
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 51;
L49: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L54: // GOTO
  goto L55;
L55: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[4];
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 68;
L57: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L62: // GOTO
  goto L63;
L63: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[5];
L64: // MOVE_CONSTANT_INT
  int_vars[5] = 85;
L65: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L70: // GOTO
  goto L71;
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[6];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 102;
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L78: // GOTO
  goto L79;
L79: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[7];
L80: // MOVE_CONSTANT_INT
  int_vars[5] = 119;
L81: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_NE_ZERO
  if (int_vars[0]) { goto L87; }
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L86: // GOTO
  goto L87;
L87: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[8];
L88: // MOVE_CONSTANT_INT
  int_vars[5] = 120;
L89: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L94: // GOTO
  goto L95;
L95: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[9];
L96: // MOVE_CONSTANT_INT
  int_vars[5] = 121;
L97: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_NE_ZERO
  if (int_vars[0]) { goto L103; }
L100: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L102: // GOTO
  goto L103;
L103: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[10];
L104: // MOVE_CONSTANT_INT
  int_vars[5] = 122;
L105: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_NE_ZERO
  if (int_vars[0]) { goto L111; }
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L110: // GOTO
  goto L111;
L111: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[11];
L112: // MOVE_CONSTANT_INT
  int_vars[5] = 123;
L113: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L114: // BOOL_INT
  int_vars[0] = int_vars[0];
L115: // IF_NE_ZERO
  if (int_vars[0]) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L118: // GOTO
  goto L119;
L119: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[12];
L120: // MOVE_CONSTANT_INT
  int_vars[5] = 124;
L121: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L127; }
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L126: // GOTO
  goto L127;
L127: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[13];
L128: // MOVE_CONSTANT_INT
  int_vars[5] = 125;
L129: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L130: // BOOL_INT
  int_vars[0] = int_vars[0];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L135; }
L132: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L134: // GOTO
  goto L135;
L135: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[14];
L136: // MOVE_CONSTANT_INT
  int_vars[5] = 126;
L137: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L138: // BOOL_INT
  int_vars[0] = int_vars[0];
L139: // IF_NE_ZERO
  if (int_vars[0]) { goto L143; }
L140: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L141: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L142: // GOTO
  goto L143;
L143: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[15];
L144: // MOVE_CONSTANT_INT
  int_vars[5] = 127;
L145: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L146: // BOOL_INT
  int_vars[0] = int_vars[0];
L147: // IF_NE_ZERO
  if (int_vars[0]) { goto L151; }
L148: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L149: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L150: // GOTO
  goto L151;
L151: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[16];
L152: // MOVE_CONSTANT_INT
  int_vars[5] = 122;
L153: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L154: // BOOL_INT
  int_vars[0] = int_vars[0];
L155: // IF_NE_ZERO
  if (int_vars[0]) { goto L159; }
L156: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L157: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L158: // GOTO
  goto L159;
L159: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[17];
L160: // MOVE_CONSTANT_INT
  int_vars[5] = 123;
L161: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_NE_ZERO
  if (int_vars[0]) { goto L167; }
L164: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L165: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L166: // GOTO
  goto L167;
L167: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[18];
L168: // MOVE_CONSTANT_INT
  int_vars[5] = 124;
L169: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L170: // BOOL_INT
  int_vars[0] = int_vars[0];
L171: // IF_NE_ZERO
  if (int_vars[0]) { goto L175; }
L172: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L173: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L174: // GOTO
  goto L175;
L175: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[19];
L176: // MOVE_CONSTANT_INT
  int_vars[5] = 125;
L177: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L178: // BOOL_INT
  int_vars[0] = int_vars[0];
L179: // IF_NE_ZERO
  if (int_vars[0]) { goto L183; }
L180: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L181: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L182: // GOTO
  goto L183;
L183: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[20];
L184: // MOVE_CONSTANT_INT
  int_vars[5] = 126;
L185: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L186: // BOOL_INT
  int_vars[0] = int_vars[0];
L187: // IF_NE_ZERO
  if (int_vars[0]) { goto L191; }
L188: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L189: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L190: // GOTO
  goto L191;
L191: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[21];
L192: // MOVE_CONSTANT_INT
  int_vars[5] = 127;
L193: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L194: // BOOL_INT
  int_vars[0] = int_vars[0];
L195: // IF_NE_ZERO
  if (int_vars[0]) { goto L199; }
L196: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L197: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L203;
L198: // GOTO
  goto L199;
L199: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L200: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L203;
L201: // INIT_INT
  int_vars[6] = 0;
L202: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L203;
L203: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


