#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_SPVM__Comparator = -1;
static int32_t BASIC_TYPE_ID_TestCase__Simple = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_any_object_type(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_match_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_match_callback(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_match_class(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_multi_numeric_type(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_callback(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_callback_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_class(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_class_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Isa__isa_numeric_type(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Isa__isa_any_object_type(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // MOVE_INT
  int_vars[0] = int_vars[0];
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_match_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Isa";
    const char* sub_name = "isa_match_array";
    const char* file = "TestCase/Isa.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Isa";
    const char* sub_name = "isa_match_array";
    const char* file = "TestCase/Isa.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L12: // IS_TYPE
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_int;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_match_callback(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // HAS_CALLBACK
  {
    if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
      BASIC_TYPE_ID_SPVM__Comparator = env->get_basic_type_id(env, "SPVM::Comparator");
      if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Comparator");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t callback_basic_type_id = BASIC_TYPE_ID_SPVM__Comparator;
    int32_t callback_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
int_vars[0]      = env->has_callback(env, object, callback_basic_type_id);
    }
    else {
int_vars[0]      = 0;
    }
  }
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L8: // HAS_CALLBACK
  {
    if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
      BASIC_TYPE_ID_SPVM__Comparator = env->get_basic_type_id(env, "SPVM::Comparator");
      if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Comparator");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t callback_basic_type_id = BASIC_TYPE_ID_SPVM__Comparator;
    int32_t callback_type_dimension = 0;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
int_vars[0]      = env->has_callback(env, object, callback_basic_type_id);
    }
    else {
int_vars[0]      = 0;
    }
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L13: // GOTO
  goto L14;
L14: // GOTO
  goto L16;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_match_class(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Isa";
    const char* sub_name = "isa_match_class";
    const char* file = "TestCase/Isa.spvm";
    int32_t line = 47;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L14: // GOTO
  goto L15;
L15: // GOTO
  goto L17;
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_multi_numeric_type(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // BOOL_INT
  int_vars[0] = int_vars[2];
L4: // MOVE_INT
  int_vars[0] = int_vars[0];
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[4];
L12: // MOVE_INT
  int_vars[0] = int_vars[0];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_callback(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Isa";
    const char* sub_name = "isa_not_match_callback";
    const char* file = "TestCase/Isa.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L4: // HAS_CALLBACK
  {
    if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
      BASIC_TYPE_ID_SPVM__Comparator = env->get_basic_type_id(env, "SPVM::Comparator");
      if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Comparator");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t callback_basic_type_id = BASIC_TYPE_ID_SPVM__Comparator;
    int32_t callback_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
int_vars[0]      = env->has_callback(env, object, callback_basic_type_id);
    }
    else {
int_vars[0]      = 0;
    }
  }
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_callback_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // HAS_CALLBACK
  {
    if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
      BASIC_TYPE_ID_SPVM__Comparator = env->get_basic_type_id(env, "SPVM::Comparator");
      if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Comparator");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t callback_basic_type_id = BASIC_TYPE_ID_SPVM__Comparator;
    int32_t callback_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
int_vars[0]      = env->has_callback(env, object, callback_basic_type_id);
    }
    else {
int_vars[0]      = 0;
    }
  }
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // BOOL_INT
  int_vars[0] = int_vars[2];
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // BOOL_INT
  int_vars[0] = int_vars[3];
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_class(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Isa";
    const char* sub_name = "isa_not_match_class";
    const char* file = "TestCase/Isa.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L4: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Simple < 0) {
      BASIC_TYPE_ID_TestCase__Simple = env->get_basic_type_id(env, "TestCase::Simple");
      if (BASIC_TYPE_ID_TestCase__Simple < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Simple");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Simple;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_not_match_class_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // BOOL_INT
  int_vars[0] = int_vars[2];
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // BOOL_INT
  int_vars[0] = int_vars[3];
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Isa__isa_numeric_type(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // BOOL_INT
  int_vars[0] = int_vars[3];
L4: // MOVE_INT
  int_vars[0] = int_vars[0];
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L22;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[5];
L12: // MOVE_INT
  int_vars[0] = int_vars[0];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L22;
L20: // INIT_INT
  int_vars[7] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


