package SWISH::Prog::Xapian::Results;
use strict;
use warnings;
use base qw( SWISH::Prog::Results );
use SWISH::Prog::Xapian::Result;

__PACKAGE__->mk_ro_accessors(qw( mset ));

our $VERSION = '0.01';

=head1 NAME

SWISH::Prog::Xapian::Results - search results for Swish3 Xapian backend

=head1 SYNOPSIS

 # see SWISH::Prog::Results
 
=cut

=head1 METHODS

=cut

=head2 mset

Get the internal Search::Xapian::MSet object. This is a read-only
accessor method.

=head2 next

Returns the next SWISH::Prog::Xapian::Result from the Results iterator.

=cut

sub next {
    my $self = shift;
    my $i    = $self->{_i}++;
    return if $i >= $self->hits;
    my $mit = $self->{mset}->get_msetiterator($i);
    return SWISH::Prog::Xapian::Result->new(
        doc   => $mit->get_document(),
        score => $mit->get_percent() * 10,    # scale to 1000
    );
}

1;

__END__

=head1 AUTHOR

Peter Karman, C<< <karman at cpan dot org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-swish-prog-xapian at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=SWISH-Prog-Xapian>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc SWISH::Prog::Xapian

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/SWISH-Prog-Xapian>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/SWISH-Prog-Xapian>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=SWISH-Prog-Xapian>

=item * Search CPAN

L<http://search.cpan.org/dist/SWISH-Prog-Xapian>

=back

=head1 COPYRIGHT & LICENSE

Copyright 2009 Peter Karman, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
