package BoardStreams::ListenerObservable;

use Mojo::Base -strict, -signatures;

use BoardStreams::Registry;

use Mojo::JSON 'to_json', 'decode_json';
use RxPerl::Mojo ':all';

use Exporter 'import';
our @EXPORT_OK = qw/ get_listener_observable /;

our $VERSION = "v0.0.7";

my %listener_observables;

sub get_listener_observable ($c, $channel_name, $prefix) {
    return $listener_observables{$channel_name} //= rx_observable->new(sub ($subscriber) {
        my $accumulated;
        my $cb = $c->$prefix->pubsub->listen($channel_name => sub ($pubsub, $payload) {
            $payload =~ s/^\:([^:]+)\: //;
            if (defined(my $prefix = $1)) {
                if ($prefix eq '0') {
                    $accumulated = $payload;
                } elsif ($prefix =~ /^\d+\z/) {
                    $accumulated .= $payload;
                } elsif ($prefix eq 'end') {
                    $accumulated .= $payload;
                    # next accepts character hashrefs
                    $subscriber->next(decode_json $accumulated);
                    undef $accumulated;
                }
            } else {
                # next accepts character hashrefs
                $subscriber->next(decode_json $payload);
                undef $accumulated;
            }
        });

        return sub {
            $c->$prefix->pubsub->unlisten($channel_name => $cb);
            delete $listener_observables{$channel_name};
        };
    })->pipe(
        op_tap(sub ($payload) {
            my $channel_users = BoardStreams::Registry->query($channel_name);
            my $json_msg = to_json {
                type    => 'event_patch',
                channel => $channel_name,
                # payload is: {id, data:{event,patch}}
                %$payload,
            };
            $_->send({text => $json_msg}) foreach @$channel_users;
        }),
        op_share(),
    );
}

1;