package Logger;

$|=1;

use Exporter;use POSIX;use IO::Socket;

sub new
{
    my ($class,$level) = @_;
    $level = uc($level);
 
    $level = "DEBUG" if ( $level eq '' );

    $level = "DEBUG" if ( $level ne 'SQL' && $level ne 'FATAL' && $level ne 'ERROR' && $level ne 'WARN' && $level ne 'INFO' && $level ne 'DEBUG' );
   my $Log =$level eq 'DEBUG' ?  { _fatal => 1, _error => 1, _warng => 1, _info  => 1, _debug => 1, _writefile => 0, _console => 1, _sql => 1 }
   : $level eq 'INFO' ?  { _fatal => 1, _error => 1, _warng => 1, _info  => 1, _debug => 0, _writefile => 0, _console => 1, _sql => 1 }
   : $level eq 'WARN' ?  { _fatal => 1, _error => 1, _warng => 1, _info  => 0, _debug => 0, _writefile => 0, _console => 1, _sql => 0 }
   : $level eq 'ERROR' ?  { _fatal => 1, _error => 1, _warng => 0, _info  => 0, _debug => 0, _writefile => 0, _console => 1, _sql => 0 }
   : $level eq 'FATAL' ?  { _fatal => 1, _error => 0, _warng => 0, _info  => 0, _debug => 0, _writefile => 0, _console => 1, _sql => 0 }
   : { _fatal => 1, _error => 1, _warng => 1, _info  => 1, _debug => 0, _writefile => 0, _console => 1, _sql => 1 };
    	
    $Log->{ _remoteflag }   = 0;
    $Log->{ _remotehost }   = '127.0.0.1';
    $Log->{ _remoteport }   = 1514;
    $Log->{ _logstr }       = 'scripts: ';
    $Log->{ _filehandle }   = '';

    return bless($Log,$class); 

}
sub writeremotelog
{
    my ($obj,$msg,$mode) = @_;$msg = $obj->{_logstr}." |[$mode] => $msg \n";$obj->{_remotehandle}->send("$msg");
}

sub writelog
{
    my ($obj,$msg,$mode) = @_;my $fh = $obj->{_filehandle};print $fh strftime("%m-%d-%Y %H:%M:%S",localtime()), " [$mode] => $msg \n";
}

sub closelog
{
    my ($obj) = @_;my $fh = $obj->{_filehandle};close $fh;
}

sub enable_console
{
    my ($obj) = @_;$obj->{_console} = 1;
}

sub disable_console
{
    my ($obj) = @_;$obj->{_console} = 0;
}

sub fatal
{
    my ($obj,$msg) = @_;

	if ( $obj->{_fatal} == 1 )
	{
    	print strftime("%m-%d-%Y %H:%M:%S",localtime()), " [FATAL] => $msg \n" if ( $obj->{_console} == 1 );
        if($obj->{_remoteflag} == 1)
        {
            $obj->writeremotelog($msg,"FATAL");
        }
        else
        {
            $obj->writelog($msg,"FATAL") if ( $obj->{_writefile} == 1 );
        }
	}
}

sub error
{
    	my ($obj,$msg) = @_;

	if ( $obj->{_error} == 1 )
	{
	    print strftime("%m-%d-%Y %H:%M:%S",localtime()), " [ERROR] => $msg \n" if ( $obj->{_console} == 1 );
        if($obj->{_remoteflag} == 1)
        {
            $obj->writeremotelog($msg,"ERROR");
        }
        else
        {
            $obj->writelog($msg,"ERROR") if ( $obj->{_writefile} == 1 );
        }
    }
}

sub warng
{
    my ($obj,$msg) = @_;

	if ( $obj->{_warng} == 1 )
	{
	    print strftime("%m-%d-%Y %H:%M:%S",localtime()), " [WARN ] => $msg \n" if ( $obj->{_console} == 1 );
        if($obj->{_remoteflag} == 1)
        {
            $obj->writeremotelog($msg,"WARN ");
        }
        else
        {
            $obj->writelog($msg,"WARN ") if ( $obj->{_writefile} == 1 );
        }
    }
}

sub info
{
    my ($obj,$msg) = @_;
	if ( $obj->{_info} == 1 )
	{
	    print strftime("%m-%d-%Y %H:%M:%S",localtime()), " [INFO ] => $msg \n" if ( $obj->{_console} == 1 );
        if($obj->{_remoteflag} == 1)
        {
            $obj->writeremotelog($msg,"INFO ");
        }
        else
        {
		    $obj->writelog($msg,"INFO ") if ( $obj->{_writefile} == 1 );
        }
	}
}

sub debug
{
    my ($obj,$msg) = @_;

	if ( $obj->{_debug} == 1 )
	{
	    print strftime("%m-%d-%Y %H:%M:%S",localtime()), " [DEBUG] => $msg \n" if ( $obj->{_console} == 1 );
        if($obj->{_remoteflag} == 1)
        {
            $obj->writeremotelog($msg,"DEBUG");
        }
        else
        {
            $obj->writelog($msg,"DEBUG") if ( $obj->{_writefile} == 1 );
        }
    }
}

sub sql
{
    my ($obj,$msg) = @_;

    if ( $obj->{_sql} == 1 )
    {
        print strftime("%m-%d-%Y %H:%M:%S",localtime()), " [SQL  ] => $msg \n" if ( $obj->{_console} == 1 );
        if($obj->{_remoteflag} == 1)
        {
            $obj->writeremotelog($msg,"SQL  ");
        }
        else
        {
            $obj->writelog($msg,"SQL  ") if ( $obj->{_writefile} == 1 );
        }
    }
}


sub setlogfile
{
    my ($obj,$file,$mode,$RemoteFlag) = @_;
    
    if($RemoteFlag == 1)
    {
        my $logstr = $1 if($file =~ m/.*\/(.*?).log$/);
        my $sock = IO::Socket::INET->new(
                                PeerAddr => $obj->{_remotehost},
                                PeerPort => $obj->{_remoteport},
                                Proto    => 'udp',
                            ) || die "Couldn't connect to $host:$port: $!";
        $obj->{_remoteflag} = $RemoteFlag;
        $obj->{_remotehandle} = $sock;
        $obj->{_logstr} .= $logstr;
    }
    else
    {
	    if ( $mode eq 'a' ){
		    $mode = ">>";
    	}else{
	    	$mode = ">";
	    }

    	my $fh;
	open($fh,"$mode$file") || die "Error: $! \n";
    	$obj->{_writefile} = 1;
	$obj->{_filehandle} = $fh;
    }
}

1;
=head1 NAME

LOG::Logger - Catching the Errors from the Various Perl Script and returns the error status.

=head1 SYNOPSIS

  use LOG::Logger
  $dynlog=Logger->new($Errorlevel);

=head1 DESCRIPTION

To Trap the Errors from the Various Perl Script.

=head2 EXPORT

use LOG::Logger
 
sub new()
{
	shift;
 	return bless($Log,$class); 
} 
$dynlog=Logger->new($Errorlevel);


=head1 SEE ALSO

=head1 AUTHOR

Name :K.Kaavannan <br>
E-Mail: kaavannaniisc@gmail.com

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014 by Kaavannan K

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.12.3 or,
at your option, any later version of Perl 5 you may have available.


=cut
