#!/usr/local/bin/perl -sw
#
# $Id: Makefile.PL,v 1.2 1998/07/14 10:55:08 joe Exp $
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.
#
BEGIN { require 5.004 }	# 5.004 is required for Win32
use Config;
use ExtUtils::MakeMaker 5.16, qw(&WriteMakefile $Verbose);
use DBI 0.93;		# must be installed first
use DBI::DBD;
use Getopt::Long;
use strict;

if (!exists($ENV{'DBROOT'})) {
    print "You must set the 'DBROOT' variable before running me.\n";
    exit 1;
}

my %opts = 
(
    'NAME'	=> 'DBD::Adabas',
    'VERSION_FROM' => 'Adabas.pm',
    clean	=> { FILES=> 'Adabas.xsi' },
    dist	=> {
		#DIST_DEFAULT=> 'clean distcheck disttest ci tardist',
		DIST_DEFAULT=> 'clean distcheck ci tardist',
		PREOP    => '$(MAKE) -f Makefile.old distdir',
		COMPRESS => 'gzip', SUFFIX => 'gz'
	    },
    OBJECT	=> '$(O_FILES)',
);

$::opt_g = 0;
GetOptions(qw(g!)) or die "Invalid arguments";

$opts{OPTIMIZE} = '-g -O0' if $::opt_g;


print "\nConfiguring DBD::Adabas ...\n
>>>\tRemember to actually *READ* the README file!
   \tAnd re-read it if you have any problems.\n
";

open(SQLH, ">mysql.h") || die "Can't open mysql.h: $!\n";
print SQLH "/* Do not edit this file. It is automatically written by Makefile.PL.\n";
print SQLH "   Any changes made here will be lost. \n*/\n\n";
print SQLH "#undef WORD /* from perly.y */\n";

if ($^O eq 'MSWin32') {
	my $extrainc = "";
	$extrainc = ";$Config{incpath}\\mfc" if $Config{cc} eq 'bcc32';
    $opts{SKIP} = ['processPL'];
    $opts{DEFINE}  = "";
    $opts{INC}  = "-I\$(INSTALLSITEARCH)/auto/DBI" . $extrainc;
    $opts{LIBS} = ["-lODBC32.LIB"];
    $opts{macro}->{EXTRALIB} = 'ODBC32.LIB';
    print SQLH "#include <windows.h>\n";
    print SQLH "#include <sql.h> \n#include <sqlext.h>\n";
}
else {
    # Use ODBCHOME env var to point to driver manager directory
    # Then try to work out which driver manager is being used. (not done yet)

    my($odbc, $myodbc);
    if ($ENV{DBROOT}  &&  -f ($ENV{DBROOT} . "/lib/odbclib.a")  &&
	-f ($ENV{DBROOT} . "/incl/sql.h")) {
	# Looks like Adabas ...
	print "Configuring for Adabas ...\n";
	$odbc = $ENV{DBROOT};
	$myodbc = "adabas";
	if ($^O =~ /solaris/) {
	    $opts{LIBS} = ["-lcurses"]; # Brain damaged, I know ...
	}
    } else {
	$odbc= $ENV{ODBCHOME} || die "ODBCHOME env var not set\n";

	my $myodbc = 'iodbc';	# edit and hack to suit!
	
	$myodbc = 'empress'
	    if <$odbc/lib/libempodbc.*>;
	$myodbc = 'intersolve'
	    if -f "$odbc/include/qeodbc.h" && -f "$odbc/include/sql.h";
	$myodbc = 'adabas'
	    if $ENV{DBROOT} && $odbc eq $ENV{DBROOT} && -f "$odbc/lib/odbclib.a";
	
	warn "Umm, this looks like a $myodbc driver manager\n";

	warn "Using ODBC in $odbc\n";
	$ENV{LD_LIBRARY_PATH} =~ /\Q$odbc/
	    || warn "Warning: LD_LIBRARY_PATH doesn't include $odbc\n";
    }

    my $lib_d1 = "$odbc/lib";
    my $lib_d2 = "$odbc/dlls";
    my $libs   = "odbc";
    $opts{LIBS} = " -L$lib_d1 -R$lib_d1 -L$lib_d2 -R$lib_d2 -l$libs";

    $opts{INC}  = "-I. -I\$(INSTALLSITEARCH)/auto/DBI";

    # Feel free to come up with neat (or un-neat) hacks to get your's to build!

    if ($myodbc eq 'iodbc') {
	# This is a hack using Intersolve's free Solaris ODBC manager
	# Since it doesn't come with the sql header files (!) we get them from iODBC!
	# Note: we use DEFINE not INC for iODBC so we don't get its config.h
	$opts{DEFINE}  = "-I/home/timbo/perl/mod/DBD/iODBC/i212";    # XXX hack for now
	print SQLH "#define FAR \n#define EXPORT \n#define CALLBACK \n";
	print SQLH "#include <isql.h>\n";
        print SQLH "#include <isqlext.h>\n";
	print SQLH "#include \"fixup_t.h\"\n";
    } elsif ($myodbc eq 'intersolve') {
	$opts{INC} .= " -I$ENV{ODBCHOME}/include";
	$opts{DEFINE}  = "";
	print SQLH "#include <qeodbc.h>\n";
	print SQLH "#include <sql.h> \n#include <sqlext.h>\n";
    } elsif ($myodbc eq 'empress') {
 	$opts{INC} .= " -I".$odbc."/include";
 	$opts{DEFINE}  = "";
 	print SQLH "#include <odbcsys.h>\n#include <sql.h> \n#include <sqlext.h>\n";
	$opts{LIBS} = "-L$odbc/lib -R$odbc/lib -lempodbc";
    } elsif ($myodbc eq 'adabas') {
 	print SQLH "#define FAR \n#define EXPORT \n#define CALLBACK \n";
 	print SQLH "#define ADABAS_ODBC \n";
 	print SQLH "#include <WINDOWS.H>\n";
 	print SQLH "#include <sql.h>\n";
 	print SQLH "#include <sqlext.h>\n";
	print SQLH "#include \"fixup_t.h\"\n";
 	$opts{INC} .= " -I$odbc/incl";
 	$opts{LIBS} = "-L$odbc/lib -lsqlrte -lsqlptc";
 	$opts{LDFROM} = "\$(OBJECT) $odbc/lib/odbclib.a";
    } else {
 	print "\n*** WARNING ***\a\n";
 	print "Unknown driver manager. Using default build process.\n";
	print "This will almost certainly fail at some point.\n";
 	print "In which case you will need to edit/hack the Makefile.PL\n";
 	print "to suit your needs. (Specifically to locate your odbc\n";
 	print "library and header files.)\n\n";
	$opts{DEFINE}  = "";
	print SQLH "#include <sql.h> \n#include <sqlext.h>\n";
    }
}

print SQLH "\n";
print SQLH "#include \"fixup_c.h\"\n";
print SQLH "\n";
print SQLH "\n";
close(SQLH);

WriteMakefile(%opts);

local($^W)=0;
print qq{
The DBD::Adabas tests will use these values for the database connection:
    DBI_DSN=$ENV{DBI_DSN}		e.g. dbi:Adabas:demo
    DBI_USER=$ENV{DBI_USER}
    DBI_PASS=$ENV{DBI_PASS}
};
print "Warning: not all required environment variables are set.\n"
	unless ($ENV{DBI_DSN} && $ENV{DBI_USER} && $ENV{DBI_PASS});
print "Warning: DBI_DSN ($ENV{DBI_DSN}) doesn't start with 'dbi:Adabas:'\n"
	if ($ENV{DBI_DSN} && $ENV{DBI_DSN} !~ m/^[dD][bB][iI]:Adabas:/);
print "\n";

sub MY::postamble {
    return dbd_postamble(@_);
}

__END__


