<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:wiz="http://ns.gestinanna.org/xsm/xsl/wizard"
  xmlns="http://ns.gestinanna.org/statemachine"
>

<!-- xsl:output indent="yes" / -->

<!-- need to add an alias for _begin => step_1 -->

<xsl:template match="wiz:steps">
  <inherit name="/sys/xsm/wizard"/>
  <alias id="_begin" state="step_1"/>
  <xsl:for-each select="wiz:step">
    <xsl:if test="@alias">
      <alias>
        <xsl:attribute name="id"><xsl:value-of select="@alias"/></xsl:attribute>
        <xsl:attribute name="state"><xsl:value-of select="concat('step_', position())"/></xsl:attribute>
      </alias>
    </xsl:if>
    <state>
      <xsl:attribute name="id">
        <xsl:text>step_</xsl:text>
        <xsl:value-of select="position()"/>
      </xsl:attribute>
      <xsl:if test="@view">
        <xsl:attribute name="view"><xsl:value-of select="@view"/></xsl:attribute>
      </xsl:if>
      <xsl:copy-of xmlns:xsm="http://ns.gestinanna.org/statemachine" select="../xsm:filter"/>
      <xsl:if test="position() > 1">
        <transition>
          <xsl:attribute name="state">
            <xsl:text>step_</xsl:text>
            <xsl:value-of select="position() - 1"/>
          </xsl:attribute>
          <!-- need to copy variables, but make them all optional -->
          <variable id="action.prev"/>
          <xsl:apply-templates select="variable|group|filter" mode="prev"/>
        </transition>
      </xsl:if>
      <transition>
        <xsl:attribute name="state">
          <xsl:choose>
            <xsl:when test="position() = last()">
              <xsl:choose>
                <xsl:when test="@finish"><xsl:value-of select="@finish"/></xsl:when>
                <xsl:otherwise><xsl:text>finish</xsl:text></xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>step_</xsl:text>
              <xsl:value-of select="position() + 1"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <!-- need to copy variables -->
        <!-- need to copy any script -->
        <variable id="action.next"/>
        <xsl:apply-templates select="@*|node()"/>
      </transition>
      <xsl:if test="@finish and position() != last()">
        <transition>
          <xsl:attribute name="state">
            <xsl:value-of select="@finish"/>
          </xsl:attribute>
          <variable id="action.finish"/>
          <xsl:apply-templates select="variable | group | filter"/>
        </transition>
      </xsl:if>
      <transition state="discard">
        <variable id="action.discard"/>
      </transition>

      <!-- need transitions to all previous states -->
      <xsl:variable name="my-position" select="position()"/>
      <xsl:for-each select="../wiz:step">
        <xsl:if test="my-position > position()">
          <transition>
            <xsl:attribute name="state">
              <xsl:text>step_</xsl:text>
              <xsl:value-of select="position()"/>
            </xsl:attribute>
            <variable id="action.jump">
              <constraint>
                <xsl:attribute name="equal" select="position()"/>
              </constraint>
            </variable>
            <!-- need to copy variables and make them optional -->
          </transition>
        </xsl:if>
      </xsl:for-each>
      <xsl:apply-templates select="transition" mode="jump" />
    </state>
  </xsl:for-each>
</xsl:template>

<xsl:template match="@* | node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="@* | node()" mode="prev">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="prev"/>
    </xsl:copy>
</xsl:template>

<xsl:template xmlns:xsm="http://ns.gestinanna.org/statemachine" match="xsm:transition" mode="jump">
    <xsm:transition>
      <xsl:apply-templates select="@*|node()"/>
      <xsl:apply-templates select="../xsm:variable | ../xsl:group" mode="prev"/>
      <xsl:apply-templates select="../xsl:filter"/>
    </xsm:transition>
</xsl:template>

<xsl:template xmlns:xsm="http://ns.gestinanna.org/statemachine" match="xsm:variable" mode="prev">
  <xsl:copy>
    <xsl:attribute name="dependence"><xsl:text>OPTIONAL</xsl:text></xsl:attribute>
    <xsl:apply-templates select="@*|node()" mode="prev"/>
  </xsl:copy>
</xsl:template>

<xsl:template xmlns:xsm="http://ns.gestinanna.org/statemachine" match="xsm:script" mode="prev"/>

<xsl:template match="wiz:step"/>
<xsl:template match="wiz:step" mode="prev"/>

<xsl:template match="wiz:step/@finish"/>
<xsl:template match="wiz:step/@finish" mode="prev"/>

</xsl:stylesheet>
