#!/usr/bin/perl
# Last Update by /gn0/jong/Perl/update_subroutines.pl: Fri Dec  5 00:14:59 GMT 1997
#________________________________________________________________________________
# Title     : write_parf_files.pl
# Usage     : write_parf_files.pl xxxx.msp0 [xxxx.msp5]
#             write_parf_files.pl g=pdb100d.pdbg m=pdb40d_1to5_psi_iss_nr_seg.msp d=pdb100d.mpfa
#
# Function  : Any simple MSP file(msp0) will be processed to produce xxx.parf file
#              xxx.msp5 is the result of parsing of msp3 file.
#             This is to evaluate the results of any SEARCH program by USING
#             xxxx.pdbg file which is derived from xxxx.mpfa like FASTA seq file
#
# Example   : write_parf_files.pl All_FASTA_pdb40d_sorted_935.msp
#             write_parf_files.pl d=pdb100d.mpfa g=pdb100d.pdbg m=pdb40d_1to5_psi_iss_nr_seg.msp
# Keywords  :
# Options   :
#  $pdbd_seq_only=d by d -d
#  $sam_571_seq_only=571 by 571 -571
#  $pdb95d_2092_seq=2092 by 2092 -2092
#  $use_raw_score=r by r -r
#  $use_eval_but_show_raw_score=e by e -e  ## eval order but only raw score is shown.
#  $MSP_file= by m=             # PDBG file is PDB Grouping file
#  $PDBG_file= by g=            # PDBG file is PDB Grouping file
#  $PDBD_file= by d=            # PDBD file is PDB Grouping file
#  $NO_Adjustment_in_homology=A by A ## this disables the special family homology adj.
#  $Fold_level_homology=F by F
#
# Author    : jong@salt2.med.harvard.edu sat@mrc-lmb.cam.ac.uk
# Version   : 1.6
#--------------------------------------------------------------------------------

my @files=@{&parse_arguments(1)};
my (%hash, @keys, $sum_eval, $sorted_name);

$pdbd_seq_only='d'; ## temporary default !!!

@file_out=@{&write_parf_files(@files, "m=$MSP_file", "g=$PDBG_file",
                                      "d=$PDBD_file", $pdbd_seq_only, $pdb95d_2092_seq,
                                      $PDB40D_935_FASTA, $sam_571_seq_only,
                                      $use_eval_but_show_raw_score, $use_raw_score,
                                      $NO_Adjustment_in_homology, $Fold_level_homology)};

print "\n# \@file_out is @file_out\n";


#________________________________________________________________________________
# Title     : write_parf_files
# Usage     : @file_out=@{&write_parf_files(@files, "m=$MSP_file", "g=$PDBG_file",
#                "d=$PDBD_file", $pdbd_seq_only, $pdb95d_2092_seq,
#                 $use_eval_but_show_raw_score, $use_raw_score)};
# Function  : takes xxxx.msp files and writes xxxx.parf file PARF file is
#             for performance assessment with ranking.
# Example   :
# Keywords  : write_parf
# Options   :
#  $pdbd_file_seq_only=d by d -d
#  $sam_571_seq_only=571 by 571 -571
#  $pdb95d_2092_seq =2092 by 2092 -2092
#  $ISS_2nd_Eval_factor= by E= ## "E=$eval"
#  $PDB40D_935_FASTA= 935 by 935
#  $use_raw_score=r
#  $MSP_file= by m=
#  $NO_Adjustment_in_homology=A by A ## this disables the special family homology adj.
#  $Fold_level_homology=F by F
#  $PDBG_file= by g=            # PDBG file is PDB Grouping file
#  $use_eval_but_show_raw_score=e by e -e  ## eval order but only raw score is shown.
#                                            This is to make a special graph
#                                           requested by David Haussler
# Version   : 2.8
#--------------------------------------------------------------------------------
sub write_parf_files{
        #"""""""""""""""""< handle_arguments{ head Ver 4.1 >"""""""""""""""""""
        my(@A)=&handle_arguments(@_);my($num_opt)=${$A[7]};my($char_opt)=${$A[8]};
        my(@hash)=@{$A[0]};my(@file)=@{$A[4]};my(@dir)=@{$A[3]};my(@array)=@{$A[1]};
        my(@string)=@{$A[2]};my(@num_opt)=@{$A[5]};my(@char_opt)=@{$A[6]};
        my(@raw_string)=@{$A[9]};my(%vars)=%{$A[10]};my(@range)=@{$A[11]};
        my($i,$j,$c,$d,$e,$f,$g,$h,$k,$l,$m,$n,$o,$p,$q,$r,$s,$t,$u,$v,$w,$x,$y,$z);
        if($debug==1){print "\n\t\@hash=\"@hash\"
        \@raw_string=\"@raw_string\"\n\t\@array=\"@array\"\n\t\@num_opt=\"@num_opt\"
        \@char_opt=\"@char_opt\"\n\t\@file=\"@file\"\n\t\@string=\"@string\"\n" }
        #""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
        my (%fix_hash, %pdb, $pdbd_seq_only, $sam_571_seq_only, %hash_classification,
                %hash_super,  $pdb95d_2092_seq, @final_parf_files, %hash_super_fam_pairs,
                $PDB40D_935_FASTA, $use_raw_score, %hash_raw_score, @sorted_name,
                $use_eval_but_show_raw_score, $PDBG_file, $MSP_file, $PDBD_file, $ISL_classif,
                $NO_Adjustment_in_homology, $Fold_level_homology);
        my $ISS_2nd_Eval_factor=191; ## for ISS only

        print "\n# write_parf_files: \$char_opt is $char_opt\n\n";
        if($char_opt=~/r/){       $use_raw_score='r';
                print "\n# (W) You put r opt, so I will use RAW score than Evalue for PARF file\n\n";
        }
        if($char_opt=~/e/){       $use_eval_but_show_raw_score='e'; $use_raw_score='';
                print "\n# (W) You put e opt, so I will use Eval but show score for PARF file\n\n";
        }
        if($char_opt=~/A/){       $NO_Adjustment_in_homology='A'; }
        if($char_opt=~/F/){       $Fold_level_homology='F'; }
        if($vars{'m'}=~/(\S+)/){      $MSP_file=$1; @file=($MSP_file);  } ## one big MSP file??
        if($vars{'g'}=~/(\S+)/){      $PDBG_file=$1  }
        if($vars{'d'}=~/(\S+)/){      $PDBD_file=$1  }
        if($vars{'E'}=~/\d+/){        $ISS_2nd_Eval_factor=$vars{'E'}
        }elsif($char_opt=~/d/){       $pdbd_seq_only='d';
        }elsif($char_opt=~/571/){     $sam_571_seq_only=571;
        }elsif($char_opt=~/2092/){    $pdb95d_2092_seq=2092;
        }elsif($char_opt=~/935/){     $PDB40D_935_FASTA=935 }

        #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        # gettting correcting_pairs from  \&get_scop_correcting_pairs, \%fix_hash made!\n";
        #______________________________________________________________________________________________
        %fix_hash=%{&get_scop_correcting_pairs()};

        if(@file < 1){ print "\n\n\n# \@file is empty, something is wrong, Do your input files in PWD?\n\n\n\n"; exit }

        @file=@{&check_input_file_extension('msp', \@file)};

        #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        # getting to attach classification";
        #___________________________________
        if(-s $PDBG_file){
            #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            # openning PDBG file ";
            #___________________________________
            if(-s $PDBG_file){
                 open(PDBG, "$PDBG_file") || die "\n Can not open $PDBG_file\n";
                 while(<PDBG>){
                      if(/\>(\S+)[\_\d+\-\d+]* +(((\d+)\.\d+)\.\d+)/){
                           if($3 == 8 or $3 == 9){
                                print "\n# $0: Warning write_parf_files sub, superfamily $3 is NOT used\n";
                           }
                           $pdb{$1}=$2;
                           $hash_fold{$1}=$3;
                           $hash_classification{$1}=$2;
                           $hash_super{$1}=$2;
                      }
                 }
                 close(PDBG);
                 print "\n# $pdb{$1}\n";
            }
        }elsif(-s $PDBD_file){
            print "\n# write_parf_files is trying to attach SCOP class to hash var by using $PDBD_file\n\n";
            open(PDBD, $PDBD_file);
            while(<PDBD>){
                if(/\>(\S+)[\_\d+\-\d+]* +(((\d+\.\d+)\.\d+)\.\d+\.\d+) */){
                        $pdb{$1}=$3;
                        $hash_fold{$1}=$4;
                        $hash_classification{$1}=$2;
                        $hash_super{$1}=$3;
                }
            }
            close(PDBD);
        }else{  print "\n# $0: Can't find \$PDBD_file $PDBD_file, set the ENV var to point it\n";
                    exit;
        }
        if($Fold_level_homology){
             %pdb=%hash_fold; ## replacing %pdb with Fold level ( '3.1'  rather than '3.1.5')
        }

#&show_hash(\%pdb);

        #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        # processing \"@file\" \n";
        #________________________________________
        for($i=0; $i< @file; $i++){
                my(%hash, $homol, $pair, $File, $base, $PDBG_file, $pdb40d_old,
                     $sorted_name, $factor, $PDBD_file, $evalue, $evalue2,
                     $evalue1, $answer_char, $outfile, %bad_intermediates);
                $File=$file[$i];
                $base=${&get_base_names($File)};

                open(BAD_ISL_SEQ_MSP, ">BAD\_$File") || die "\n# Can not open BAD\_$File\n";
                open(BAD_ISL_SEQ, ">BAD\_$base\.txt") || die "\n# Can not open BAD\_$base\.txt\n";

                #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                # opening the input  MSP file $File \n";
                #____________________________________________
                if($File=~/\S\.gz$/){ system("gunzip -c $File") } ## Just in case it is compressed
                open(MSP_FILE, "$File") || die "\nCan not open $File, Error!!\n";
                while(<MSP_FILE>){
                     my($intermediate_seq, $homol, $raw_score, @sorted_name, $sorted_name, $query, $match, $evalue, $ISL_classif);
                     #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                     # (1) For handling FASTA search output(NORMAL MSP output style, I mean.  LYG_ANSAN_1-182_d153l___4.2.1_1-179    1
                     #__________________________________________________________________________
                     if( /^ *(\S+) +(\S+) +\S* *\d+ +\d+ +(\S+) +\d+ +\d+ +(\S+_\d+\-\d+_(\S+)_((\d+\.\d+)\.\d+))/){ ## to match ISL search  nr_RIP3_SAPOF_1-220_d1mrj___4.102.1_42-198
                          ($raw_score, $evalue, $query, $intermediate_seq, $match, $ISL_classif, $Fold_classif)=($1,$2, $3, $4, $5, $6, $7);
                          if($Fold_level_homology){  $ISL_classif=$Fold_classif; }
                          $ISL_classif{$match}=$ISL_classif;
                     #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                     # (2)
                     #________________________________________________
                     }elsif(/^ *(\S+) +(\S+) +\S* *\d+ +\d+ +(\S+) +\d+ +\d+ +(\S+) *\d*/){ ## This is a direct PDB40D vs PDB40D etc
                          ($raw_score, $evalue, $query, $match)=($1,$2, $3, $4);

                     #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                     # (3) For handling ISS search output";
                     #________________________________________________
                     }elsif(/^ *(\S+)_\d+\-\d+_(\d+\.\d+\.\d+)\S+ +\d+ +(\S+) +(\womolog) +\S+ +\d+ +(\S+) +(\S+)_\d+\-\d+_(\d+\.\d+\.\d+)\S+/){
                          $query=$1; $evalue1=$3; $homol=$4; $evalue2=$5; $match=$6;

                          if($pdbd_seq_only and ($query !~/^[cde][s\d]/ or $match !~/^[cde][s\d]/) ){ next };
                          @sorted_name= sort($query, $match);
                          $sorted_name= join(' ', @sorted_name );
                          if($fix_hash{$sorted_name}){  $homol='Homolog' }; ## correction.
                          $sum_eval=($evalue1+($evalue2*$ISS_2nd_Eval_factor));  ## just the sum
                          $pair=sprintf("%-20s %-7s", $sorted_name, $homol);
                          $hash{$pair}=$sum_eval;
                          if($hash_classification{$sorted_name[0]} and $hash_classification{$sorted_name[1]}){
                                  $hash_super_fam_pairs{$pair}=
                                  sprintf("%-15s %-15s", $hash_classification{$sorted_name[0]},  $hash_classification{$sorted_name[1]});
                          }else{
                                  delete($hash{$pair});
                                  print "\n# write_parf_files: classifctn info for \"$pair\" is missing, SKIPPING this line !!";
                          }

                     }else{ next }

                     if($pdbd_seq_only and ($query !~/^[cde][s\d]/ or $match !~/^[cde][s\d]/) ){ ## to match d1dkga1 or ds055_
                             print "\n(E) NO pdbd \$query :$query,  \$match :$match, I need like: d1dkga1 or ds055_\n";
                             print "(E) This could be due to truncated blastp output. \$pdbd_seq_only was $pdbd_seq_only\n"; next };
                     if($query=~/^(\S+)_\d+\.\d+\.\d+/){    $query=$1;      }
                     if($match=~/^(\S+)_\d+\.\d+\.\d+/){    $match=$1;      }
                     if($query=~/^(\S+)_\d+\-\d+/){    $query=$1;      }
                     if($match=~/^(\S+)_\d+\-\d+/){    $match=$1;      }

                     if($query eq $match){ next }
                     @sorted_name= sort($query, $match);
                     $sorted_name= join(' ', @sorted_name );
                     #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                     # This is critical part for checking identity.
                     # The first condition $pdb{$query} is necessary, as singlets will not ahve any
                     # classification, so it will be NULL. NULL and NULL are equal, resulting in Homolog, which is incorrect
                     #________________________________________________________________________________

                     if( ($pdb{$query} and ($pdb{$query} eq $pdb{$match}) ) or $fix_hash{$sorted_name}=~/\S/ ){
                          $homol='Homolog';

                     }else{
                          #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                          # Checks if Adjustment is wanted or not. If not, anything notmatched to be equal will be Nomolog
                          #________________________________________________________________________________________________
                          if($NO_Adjustment_in_homology){
                              $homol='Nomolog';
                          }else{
                               #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                               # Folling is to fix the prblem in 1.38 SCOP families of 3.1.5, 7, 8, 11, 11/Jan99, 3.4.1, 3.21.1 and 3.22.1
                               #________________________________________________________________________
                               if( ($pdb{$query} =~/^3\.1\.[578]$/ and $pdb{$match} =~/^3\.1\.[578]$/) or
                                    ($pdb{$query} =~/^3\.1\.1[01]$/ and $pdb{$match} =~/^3\.1\.[578]$/)    or
                                    ($pdb{$query} =~/^3\.1\.[578]$/ and $pdb{$match} =~/^3\.1\.1[01]$/)){
                                        $homol='Homolog';
                               }elsif( ($pdb{$query} =~/^3\.2[12]\.1$/ and $pdb{$match} =~/^3\.2[12]\.1$/) or
                                    ($pdb{$query} =~/^3\.4\.1$/ and $pdb{$match} =~/^3\.2[12]\.1$/)  or
                                    ($pdb{$query} =~/3\.2[12]\.1$/ and $pdb{$match} =~/^3\.4\.1$/) ){
                                        $homol='Homolog';
                               }elsif($pdb{$query} =~/^2\.62\./ and $pdb{$match} =~/^2\.62\./){
                                    $homol='Homolog';
                               }elsif($pdb{$query} =~/^1\.81\.[23]$/ and $pdb{$match} =~/^1\.81\.[23]$/){
                                    $homol='Homolog';
                               }elsif($pdb{$query} =~/^2\.5[12]\./ and $pdb{$match} =~/^2\.5[12]\./){
                                    $homol='Nomolog';   $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                               }elsif($pdb{$query} =~/^2\.21\./ and $pdb{$match} =~/^2\.62\./){
                                    $homol='Nomolog';   $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                               }elsif($pdb{$query} =~/^2\.62\./ and $pdb{$match} =~/^2\.21\./){
                                    $homol='Nomolog';   $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                               }elsif($pdb{$query} =~/^2\.62\./ and $pdb{$match} =~/^3\.33\./){
                                    $homol='Nomolog';   $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                               }elsif($pdb{$query} =~/^3\.33\./ and $pdb{$match} =~/^2\.62\./){
                                    $homol='Nomolog';   $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                               #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                               # These are removed from ISL due to error
                               #_____________________________________________
                               }elsif($pdb{$query} =~/^3\.22\.1$/ and $pdb{$match} =~/^3\.66\.1$/){
                                    $homol='Nomolog'; $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                                    next;
                               }elsif($pdb{$query} =~/^3\.66\.1$/ and $pdb{$match} =~/^3\.22\.1$/){
                                    $homol='Nomolog'; $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                                    next;
                               }else{
                                    if($hash_fold{$query} =~/^\d+\.\d+$/ and ($hash_fold{$query} eq $hash_fold{$match} )){
                                            $homol='Fomolog'; ## fold level homologues
                                    }else{
                                            $homol='Nomolog'; $bad_intermediates{"$intermediate_seq"}=$intermediate_seq;
                                    }
                               }
                          }
                     }

                     #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                     # Noting WRONG ISL sequences
                     #_______________________________________________
                     if( ($pdb{$query} and $pdb{$match} and $ISL_classif) and ($pdb{$match} ne $ISL_classif) ){
                          print "(ERROR) bad_isl_seq_list.msp ->$File: PDB classif of $match, $pdb{$query} isN'T same as interm seq classif $ISL_classif, BadISS assignment?\n$_\n";
                          print "\nBAD ISL seq, writing in MSP file";
                          print BAD_ISL_SEQ_MSP $_;
                     }

                     $pair=sprintf("%-20s %-7s", $sorted_name, $homol);
                     #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                     # If we choose RAW score than Evalue, by $use_raw_score (r) opt
                     #___________________________________________________________
                     if($use_raw_score){
                          if(!$hash{$pair} or $hash{$pair} < $raw_score){
                                $hash{$pair}=$raw_score;
                                if($hash_classification{$sorted_name[0]} and $hash_classification{$sorted_name[1]}){
                                        $hash_super_fam_pairs{$pair}=
                                                sprintf("%-15s %-15s", $hash_classification{$sorted_name[0]},  $hash_classification{$sorted_name[1]});
                                }else{
                                        delete($hash{$pair}); ## removing the entry from the hash completely
                                        #print "\n# write_parf_files: classifctn info for \"$pair\" is missing, SKIPPING this line !!";
                                }
                          }
                     }else{
                          if(!$hash{$pair} or $hash{$pair} > $evalue){
                                $hash{$pair}=$evalue;   $hash_raw_score{$pair}=$raw_score; # just storing
                                if($hash_classification{$sorted_name[0]} and $hash_classification{$sorted_name[1]}){
                                        $hash_super_fam_pairs{$pair}=
                                                sprintf("%-15s %-15s", $hash_classification{$sorted_name[0]},  $hash_classification{$sorted_name[1]});
                                }else{
                                        delete($hash{$pair}); ## removing the entry from the hash completely
                                        #print "\n# write_parf_files: classifctn info for \"$pair\" is missing, SKIPPING this line !!";
                                }
                          }
                     }
                }


                @keys=%hash;
                if($use_raw_score){
                        @sorted=  sort { $hash{$b} <=> $hash{$a} }  @keys;
                }else{
                        @sorted=  sort { $hash{$a} <=> $hash{$b} }  @keys;
                }

                if($use_eval_but_show_raw_score){
                        $outfile="e_opt\_$base\_$NO_Adjustment_in_homology\_$Fold_level_homology\.parf";
                }elsif($use_raw_score){
                        $outfile="r_opt\_$base\_$NO_Adjustment_in_homology\_$Fold_level_homology\.parf";
                }else{
                        $outfile="$base\_$NO_Adjustment_in_homology\_$Fold_level_homology\.parf";
                }
                if(@keys > 1 ){
                         open(RANKED, ">$outfile");
                }else{
                         print "\n\n\n# (E) write_parf_files: The seq pair entry number is too small( <2), I think something went wrong\n\n\n";
                         next;
                }

                #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                # sorted by Eval but the result score is raw score
                #__________________________________________________
                if($use_eval_but_show_raw_score){
                        for($j=0; $j< @sorted; $j++){
                                 if($sorted[$j]=~/\S+ +\S+ +\S+/){
                                             printf RANKED ("%-28s %-22s %-30s\n", $sorted[$j], $hash_raw_score{$sorted[$j]},
                                                                                                                 $hash_super_fam_pairs{$sorted[$j]} );
                                 }
                        }
                }else{
                        for($j=0; $j< @sorted; $j++){
                                 if($sorted[$j]=~/\S+ +\S+ +\S+/){
                                             printf RANKED ("%-28s %-22s %-30s\n", $sorted[$j], $hash{$sorted[$j]},
                                                                                                                 $hash_super_fam_pairs{$sorted[$j]} );
                                 }
                        }
                }
                %hash_raw_score=%hash=();
                close (RANKED);
                close ( MSP_FILE );
                if(-s $outfile){
                         push(@final_parf_files, $outfile);
                         if(-d $ENV{'haussler'} ){
                                    $target_direc=$ENV{'haussler'};
                                    print "\n# $target_direc is found !!, You must be JONG Park, or Are you Sarah??\n";
                                    print "\n# write_rdif_files : As you have haussler dir, I copy $outfile to it\n\n";
                                    system("cp $outfile $target_direc");
                         }
                }else{
                         print "\n\n\n\n# write_parf_files: \$outfile is not big, ERROR???\n\n\n\n";
                }

                #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                # writing bad ISL seq alone NOT in MSP file
                #_____________________________________________
                @bad_isl_seqs=keys %bad_intermediates;
                for($b=0; $b< @bad_isl_seqs; $b++){
                        print BAD_ISL_SEQ "$bad_isl_seqs[$b]\n";
                }
                close BAD_ISL_SEQ;
        }
        close(BAD_ISL_SEQ_MSP);
        return(\@final_parf_files);
}




#________________________________________________________________________
# Title     : assign_options_to_variables
# Usage     : &assign_options_to_variables(\$input_line);
# Function  : Assigns the values set in head box to the variables used in
#             the programs according to the values given at prompt.
#             This produces global values.
#             When numbers are given at prompt, they go to @num_opt
#              global variable. %vars global option will be made
#
# Example   : When you want to set 'a' char to a variable called '$dummy' in
#             the program, you put a head box commented line
#             '#  $dummy    becomes  a  by  -a '
#             Then, the parse_arguments and this sub routine will read the head
#             box and assigns 'a' to $dummy IF you put an argument of '-a' in
#             the prompt.
# Warning   : This is a global vars generator!!!
# Keywords  :
# Options   : '#' at prompt will make a var  $debug set to 1. This is to
#              print out all the print lines to make debugging easier.
# Returns   : Some globaly used variables according to prompt options.
#             @num_opt,
#
# Argument  : None.
# Version   : 2.6
#--------------------------------------------------------------------
sub assign_options_to_variables{
	my($i, %vars, $j, $op, $z, $n, $symb, $value, $var, %val, @val, $ARG_REG,
	 $option_table_example, @input_options, $first_border_and_title, $sym, @arg);

	#""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#      Defining small variables for option table reading
	#""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	my($g)='gets';                my($if)='if';
	my($is)='is';                 my(@input_files);
	my($o)='or';   my(@arguments) = sort @ARGV;

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#  Assigning global arguments(@num_opt, %vars) variables
	#_______________________________________________________________
	for($i=0; $i< @arguments; $i++){
	 if(($arguments[$i]=~/^(\-?\d+[\.\d+]?)$/)&&   ### it mustn't be a file
		( !(-f $arguments[$i]) ) ){                ### getting NUM opt
		push(@num_opt, $1);
	 }elsif( $arguments[$i]=~/^(\S+)=(\S+)$/){
		$vars{$1}=$2;
	 }
	}

	#""""""""""""""""""""""""""""""""""""""""""""""""""
	#   Some DEFAULT $debug variables for debugging purposes
	#""""""""""""""""""""""""""""""""""""""""""""""""""
	&set_debug_option;

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#   The main processing of self
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	open(SELF, "$0");    ## opens the program you ran to get the options table.
	while(<SELF>){

	  if( $first_border_and_title > 6 ){  ## This is to make it read only the first headbox.
		  last;                            #  $first_border_and_title is an incremental counter.
	  }elsif( /^ *#[_\*\-]{15,}$/ and /^ *# *[Tt][itle]*[ :]*/ ){
		  $first_border_and_title++;
		  print __LINE__, "# assign_options_to_variables : Title line found\n" if $debug eq 1;
	  }elsif(/^ {0,5}# {1,50}[\$\%\@].+$/){
		  $op = $&;  ## $op is for the whole input option line which has $xxxx, @xxx, %xxxx format
		  $op =~ s/^( *\# *)(\W\w+.+)$/$2/;  ## This is removing '#  ' in the line.
		  $op =~ s/^(\W\w+.+)(\s+\#.*)$/$1/;  ## This is removing any comments in the line.
			 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
			 ## matching the following line input format.
			 ## $av_sc_segment     becomes    a  by  a  # To smooth the SC rates. Gets the averages of
			 ## $ARG_REG is for arguments regular expression variable.
			 ##  This reg. exp. matches = 'a or A or E or e' part
			 ##  which represents alternative prompt arguments possibilities. \=$b$g$is$e$set
			 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
			 $ARG_REG ='(\S*) *[or=\,]* *(\S*) *[=or\,]* *(\S*) *[=or\,]* *(\S*) *[=or\,]* *(\S*)';
			 if($op=~/^([\$\@\%])([\w\-]+) {0,20}[=|$g|$is] *[\$\@\%]*([\- \w\.\d]+) *[bB]y +$ARG_REG/){
							 ## $sym     $var        becomes          a [$a...]       by       a -a -A
				  my $sym = $1;  #### The symbols like ($, @, %), '$' in the above.
				  my $var = $2;  #### Actual variable name 'var' from $var, 'av_sc_segment' in the above.
				  my $val = $3;  #### The becoming value  first 'a' in the above.
				  my @arg = ($4, $5, $6, $7, $8);  ## The alternative prompt arguments, second 'a' in the above..
			      print "\n $sym $var $val \n" if $debug==1;
			      print "\n \@arg are @arg \n" if $debug==1;

				  #""""""""""""""""""""""""""""""""""""""""""""""""""""
				  #  Going through the PROMPT args.
				  #""""""""""""""""""""""""""""""""""""""""""""""""""""
				  for($z=0; $z < @arguments; $z++){     ## $arguments[$z]  is from @ARGV
					  if($arguments[$z]=~/^\-\w+$/){
						  $arguments[$z] =~ s/\-//;
					  }
					  for ($i=0; $i < @arg; $i ++ ){
						 if( ("$arg[$i]" eq "$arguments[$z]" )&& ($arg[$i] !~ /\=/)
							 && ($sym eq '$') ){
							 ${"$var"}="$val";
							 if($debug == 1){
								 print __LINE__," \$${var} is set to \"$1\"\n";
							 }

						 }#'''''''''''''''' $arg = by s=  syntax ~~~~~~~~~~~~~~~~~~~~~~~~~~~
						 elsif( ( $arg[$i] =~ /^(\w+) *\=/ ) &&
							( $arguments[$z] =~ /^${1}= *([\w\.*\-*]+)$/) &&
							( $sym eq '$') ){
							  ${"$var"}="$1";
							  if($debug eq 1){ print __LINE__,"\$${var} is set to \"$1\"\n";  }
						 }
					  }
				  }
			  }
		}
	}
}
#________________________________________________________________________
# Title     : parse_arguments
# Usage     : &parse_arguments; or  (file1, file2)=@{&parse_arguments};
# Function  : Parse and assign any types of arguments on prompt in UNIX to
#             the various variables inside of the running program.
#             This is more visual than getopt and easier.
#             just change the option table_example below for your own variable
#             setttings. This program reads itself and parse the arguments
#             according to the setting you made in this subroutine or
#             option table in anywhere in the program.
#             It also imports the ENV variables to your program.
#
# Example   : &parse_arguments(1);
#             @files=@{&parse_arguments(1)};
# Warning   : HASH and ARRAY mustn't be like = (1, 2,3) or (1,2 ,3)
# Keywords  :
# Options   : '0'  to specify that there is no argument to sub, use
#              &parse_arguments(0);
#             parse_arguments itself does not have any specific option.
#             '#' at prompt will make a var  $debug set to 1. This is to
#              print out all the print lines to make debugging easier.
#
#             'e=xxxx' for filtering input files by extension xxxx
#
# Returns   : Filenames in a reference of array
#             and input files in an array (file1, file2)=@{&parse_arguments};
# Argument  : uses @ARGV
# Version   : 2.0
#--------------------------------------------------------------------
sub parse_arguments{
	my( $c, $d, $f, $arg_num, $option_table_seen, $n, $option_filtered,
		$option_table_example, $input_line, @input_files,
		$extension);

	&import_ENV_vars; # this enables  $PDB40D automatically assigns the shell var value of $ENV{'PDB40D'}

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#   Checks if there were arguments
	#_______________________________________________________
	if( @ARGV < 1 ){ #<-- If Argument is not given at prompt
	  for(@_){
		 if($_ eq '0'){ ## this means, parsearguments do not need any argus. So no need to parse anything
			 last;
		 }else{
			 print "\n \"$0\" requires at least one Argument, suiciding.\n\n";
			 print chr(7); #<-- This is beeping
			 print "  To get help type \"$0  h\"\n\n\n ";
			 exit;
		 }
	  }
	}
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	#   Some DEFAULT $debug variables for debugging purposes
	#__________________________________________________________
	&set_debug_option;

	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	#  If there is only one prompt arg. and is [-]*[hH][elp]*, it calls
	#   &default_help and exits
	#___________________________________________________________________
	if( ( @ARGV == 1 ) && ($ARGV[0] =~ /^[\-]*[hH\?][elp ]*$/) ){
		&default_help;
		exit;
	}

	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	#  Checking some input options like 'e=txt' for extension filtering
	#_____________________________________________________________________
	for($i=0; $i< @_; $i++){
			if($_[$i]=~/e=(\S+)/){
		  push(@extension, $1);
	  }elsif($_[$i]=~/^[\-]?r$/){ ## reversing file order in return stage
					$reverse_out_file_name_order='r';
			}
	}


	for($f=0; $f < @ARGV; $f++){
	 if( $ARGV[$f] =~ /\w+[\-\.\w]+$/ and -f $ARGV[$f] ){
		 #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		 # When extension is defined, filter files by it
		 #____________________________________________
		 if(@extension > 0){
		     for($e=0; $e < @extension; $e++){
				 $extension=$extension[$e];
				 if($ARGV[$f]=~/\S\.$extension/){
					 push(@input_files, $ARGV[$f] );
				 }else{ next }
			 }
		 }else{
			 push(@input_files, $ARGV[$f] );
			 next;
		 }
	 }
	}

	#""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#     Reading the running program script
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""
	&assign_options_to_variables;
	if($HELP == 1){ &default_help }
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# reverse order if 'r' opt is set
	#_____________________________________________
	if($reverse_out_file_name_order){
			@input_files=reverse(@input_files);
	}
	return(\@input_files);
}
#________________________________________________________________________
# Title     : set_debug_option
# Usage     : &set_debug_option;
# Function  : If you put '#' or  '##' at the prompt of any program which uses
#             this sub you will get verbose printouts for the program if the program
#             has a lot of comments.
# Example   : set_debug_option #    <-- at prompt.
# Warning   :
# Keywords  :
# Options   : #   for 1st level of verbose printouts
#             ##  for even more verbose printouts
# $debug  becomes 1 by '#'  or '_'
# $debug2 becomes 1 by '##'  or '__'
#
# Returns   :  $debug
# Argument  :
# Version   : 1.8
#--------------------------------------------------------------------
sub set_debug_option{
	my($j, $i, $level);
	unless( defined($debug) ){
	 for($j=0; $j < @ARGV; $j ++){
		 if( $ARGV[$j] =~/^(_+)$|^(#+)$/){ # in bash, '#' is a special var, so use '_'
			 print __LINE__," >>>>>>> Debug option is set by $1 <<<<<<<<<\n";
			 $debug=1;
				  print chr(7);
			 print __LINE__," \$debug  is set to ", $debug, "\n";
			 splice(@ARGV,$j,1); $j-- ;
			 $level = length($1)+1;
			 for($i=0; $i < $level; $i++){
				 ${"debug$i"}=1;
				 print __LINE__," \$debug${i} is set to ", ${"debug$i"}, "\n";
			 }
		 }
	 }
	}
}
#________________________________________________________________________
# Title     : get_base_names
# Usage     : $base =${&get_base_names(\$file_name)};
#             :   or @bases = &get_base_names(\@files);  # <-- uses `pwd` for abs directory
# Function  : produces the file base name(eg, "evalign"  out of "evalign.pl" ).
#              when xxxx.xx.gz form file is given, it removes gz as well
#
# Example   : $base => 'test'  with 'test.txt' or '/home/dir/of/mine/text.txt'
# Warning   :
# Keywords  : get_base_name{, base_name, file_base_name ,  get_file_base_name
#             get_basename, basename, get_root_name, base , root, get_file_root
# Options   :
# Returns   :
# Argument  : handles both ref and non-ref.
# Version   : 1.5
#--------------------------------------------------------------------
sub get_base_names{
	my($x, $pos, $pos1, @out_file, $file_only, $file, @file, $base, @base);
	@file=@{$_[0]} if (ref($_[0]) eq 'ARRAY');
	@file=@_ if !(ref($_[0]) eq 'ARRAY');
	for($x=0; $x < @file; $x ++){
		if( ref($file[$x]) ){
			$file = ${$file[$x]};
			$pos1=rindex($file, "/");
	        $file_only=substr($file, ($pos1+1));
						if($file_only=~/(\S+\.\S+)\.gz$/){
							 $pos = rindex($1, ".");
			   $base= substr($1, 0, $pos);
			}elsif($file_only=~/^[^\.]+$/){ ## when file does not have '.' in its name
							 $base= $file_only;
						}else{
							 $pos = rindex($file_only, ".");
							 $base= substr($file_only, 0, $pos);
						}
		}else{
			$file = $file[$x];
			$pos1=rindex($file, "/");
	        $file_only=substr($file, ($pos1+1));
			if($file_only=~/(\S+\.\S+)\.gz$/){
							 $pos = rindex($1, ".");
			   $base= substr($1, 0, $pos);
						}elsif($file_only=~/^[^\.]+$/){ ## when file does not have '.' in its name
							 $base= $file_only;
			}else{
							 $pos = rindex($file_only, ".");
							 $base= substr($file_only, 0, $pos);
						}
		}
		push(@base, $base);
	}
	if(@base == 1 ){ \$base[0] }else{ \@base }
}

#________________________________________________________________________________
# Title     : get_scop_correcting_pairs
# Usage     : %correct=%{&get_scop_correcting_pairs()};
# Function  :
# Example   :
# Keywords  : get_pdb_correcting_pairs , correct_pairs_in_scop, correct_homology_pairs
# Options   :
# Category  :
# Version   : 1.4
#--------------------------------------------------------------------------------
sub get_scop_correcting_pairs{
		my (%correcting_pairs, @correcting_pairs);

		#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# %correcting_pairs is a correcting table for old pdb40d file classi
		#_____________________________________________________________________
		@correcting_pairs=(  # should be pairs
				'd2kauc1 d2kauc2', 'd1pkya1 d1pkya2',
				'd1pvda2 d1trka1', 'd1pbe_1 d1pbe_2',
				'd1poxa3 d1pvda2', 'd1efga1 d1efga2',
				'd1dsba1 d1dsba2', 'd2gsta1 d2gsta2',
				'd1bct__ d1brd__', 'd1qora1 d1qora2',
				'd2ohxa1 d2ohxa2', 'd1efga2 d1eft_1',
				'd1tada1 d1tada2', 'd1gsea1 d1gsea2',
				'd1gesa2 d2tmda3', 'd1lvl_2 d2tmda3',
				'd2tmda3 d2tpra2', 'd1tde_1 d2tmda3',
				'd1nhp_2 d2tmda3', 'd1gesa1 d2tmda3',
				'd1lvl_1 d2tmda3', 'd2tmda3 d2tpra1',
				'd1fcda1 d2tmda3', 'd1nhp_1 d2tmda3',
				'd1tde_2 d2tmda3', 'd1pbe_1 d2tmda3',
				'd1ebha1 d1ebha2', 'd1gesa2 d2dlda2', ## 3.4.1  with
				'd1gesa2 d1psda2', 'd1nhp_2 d2dlda2',
				'd1ldm_1 d1tde_2', 'd1coy_1 d1ldb_1',
				'd1lvl_2 d1psda2', 'd1psda2 d1tde_2',
				'd1hyha1 d1tde_2', 'd1fcda1 d1ldm_1',
				'd1hdca_ d1nhp_2', 'd1fcda1 d1hlpa1',
				'd1llda1 d1lvl_2', 'd2dlda2 d2tpra2',
				'd1ldm_1 d1nhp_2', 'd1llda1 d1pbe_1',
				'd1gdha2 d2tpra1', 'd1ldb_1 d1nhp_2',
				'd1gesa2 d1scua2', 'd1fcda1 d1hyha1',
				'd1gesa1 d1hlpa1', 'd1gdha2 d1gesa2',
				'd1lvl_2 d2dlda2', 'd1gesa1 d2dlda2',
				'd1nhp_2 d2ohxa2', 'd1tde_2 d2dlda2', # 3.4.1. with 3.18.1, 3.17.1.
				'd1nhp_1 d2cmd_1', 'd1fcda1 d1ldb_1',
				'd1lvl_1 d2ohxa2', 'd1nhp_2 d2naca2',
				'd1pbe_1 d2ohxa2', 'd1gdha2 d1nhp_2',
				'd2cmd_1 d2tpra1', 'd1tde_1 d2cmd_1',
				'd1llda1 d1nhp_2', 'd1hlpa1 d1nhp_2',
				'd1nhp_1 d2dlda2', 'd1hyha1 d1nhp_2',
				'd1nhp_2 d1psda2', 'd1fcda1 d2cmd_1',
				'd1fcda1 d1llda1', 'd1lvl_2 d1udpa_',
				'd1psda2 d2tpra2', 'd1hdca_ d1lvl_2',
				'd1gesa2 d1llda1', 'd1nhp_2 d1qora2',
				'd1ldm_1 d2tpra1', 'd1coy_1 d2dlda2',
				'd2dlda2 d2tpra1', 'd1hdca_ d1pbe_1',
				'd1coy_1 d1gdha2', 'd1nhp_2 d2cmd_1',
				'd1llda1 d1tde_1', 'd1llda1 d1lvl_1',
				'd1bdma1 d2tpra1', 'd1gd1o1 d2tpra2',
				'd1ldb_1 d1lvl_1', 'd1hlpa1 d1tde_2',
				'd1coy_1 d1psda2', 'd1nhp_2 d1udpa_',
				'd1llda1 d1tde_2', 'd1tde_2 d2cmd_1',
				'd1llda1 d2tpra2', 'd1ldb_1 d1tde_1',
				'd1coy_1 d1hlpa1', 'd1coy_1 d2cmd_1',
				'd1bdma1 d1gesa2', 'd1hyha1 d2tpra2',
				'd1gesa2 d1hyha1', 'd1gesa2 d2ohxa2',
				'd1ldb_1 d1tde_2', 'd1hlpa1 d1pbe_1',
				'd1ldm_1 d2tpra2', 'd2ohxa2 d2tpra1',
				'd1ldb_1 d2tpra2', 'd1gesa2 d1ldm_1',
				'd1lvl_2 d1qora2', 'd1gesa1 d2naca2',
				'd1coy_1 d1llda1', 'd1coy_1 d1hyha1',
				'd1coy_1 d1ldm_1', 'd1ldm_1 d1lvl_2',
				'd1eny__ d1nhp_2', 'd1pbe_1 d2pgd_2',
				'd1ldb_1 d1pbe_1', 'd1ldb_1 d1lvl_2',
				'd1gesa2 d1hlpa1', 'd1dhr__ d1nhp_2',
				'd1hdca_ d1tde_1', 'd1gesa1 d1psda2',
				'd1pbe_1 d2cmd_1', 'd1tde_2 d1udpa_',
				'd1pbe_1 d2dlda2', 'd1hdca_ d1tde_2',
				'd1gesa2 d1ldb_1', 'd1psda2 d2tpra1',
				'd1gdha2 d1lvl_2', 'd1tde_1 d2dlda2',
				'd1ldm_1 d1pbe_1', 'd1pbe_1 d1scua2',
				'd1gesa1 d2ohxa2', 'd1lvl_2 d2naca2',
				'd1gd1o1 d1lvl_1', 'd1fvl__ d1kst__',
				'd1kst__ d2ech__', 'd1hsaa2 d1std__', ## d1hsaa.. is NOT homol, but to fix a problem in E_100_e_0.0005_j30_segged_2092
				'd1afp__ d1hfi__'
				);


		 for($i=0; $i< @correcting_pairs; $i++){
										 $correcting_pairs{$correcting_pairs[$i]}=$correcting_pairs[$i];
		 }
		 return(\%correcting_pairs);
}


#________________________________________________________________________
# Title     : default_help
# Usage     : &default_help2;  usually with 'parse_arguments' sub.
# Function  : Prints usage information and others when invoked. You need to have
#             sections like this explanation box in your perl code. When invoked,
#             default_help routine reads the running perl code (SELF READING) and
#             displays what you have typed in this box.
#             After one entry names like # Function :, the following lines without
#             entry name (like this very line) are attached to the previous entry.
#             In this example, to # Function : entry.
# Example   : &default_help2; &default_help2(\$arg_num_limit);   &default_help2( '3' );
#             1 scalar digit for the minimum number of arg (optional),
#             or its ref. If this defined, it will produce exit the program
#             telling the minimum arguments.
# Warning   : this uses format and references
# Keywords  :
# Options   :
# Returns   : formated information
# Argument  :
# Version   : 3.4
#--------------------------------------------------------------------
sub default_help{
	my($i, $perl_dir, $arg_num_limit, $head ,$arg_num_limit, $key_press, $e,
	  @entries, @entries_I_want_write, $option_tb_found, $extension, $logname, $tmp );
	$logname=getlogin();
	my($pwd)=`pwd`;
	my($date)=`date`;
	chomp($date,$pwd);
	my($not_provided)="--- not provided ---\n";
	my($file_to_read) = $0;

	for($i=0; $i < @_; $i ++){
	  if((ref($_[$i]) eq 'SCALAR')&&(${$_[$i]} =~ /^\d$/)){
		  $arg_num_limit = ${$_[$i]};  }
	  elsif( (!(ref($_[$i]))) && ($_[$i] =~ /^\d$/)){
		  $arg_num_limit = $_[$i];     }
	}
	my %entries = %{&read_head_box(\$file_to_read )};
	if($option_tb_found ==1){
	 @option_tb=@{&read_option_table(\$file_to_read)};
	}

	@entries = keys %entries;
	foreach $help_item (@entries){
	  ${$help_item}= $not_provided if( ${$help_item}=~/^[\W]*$/  and  !defined(${$help_item}) );
	}
	#""""""""""""""""""""""""""""""""""""""""
	#########  Writing the format <<<<<<<<<<<
	#""""""""""""""""""""""""""""""""""""""""
	$~ =HEADER_HELP;
	write;   ## <<--  $~ is the selection operator
	$~ =DEFAULT_HELP_FORM;

	@entries_I_want_write=sort keys %entries;

	for( @entries_I_want_write ){  write  }

	print chr(7);  print "_"x72,"\n\n";

	if(@ARGV < $arg_num_limit){ print "\* $0 fataly needs $arg_num_limit arguments\n\n" }

	if(  $option_tb_found == 1){
	 #########  Printing the OPTION table contents <<<<<<<<<<<<
	 print "  Press \"Return\" key to see what options $logname\'s \n\n    \"$0\" take... \n";
				 $key_press=getc();
	 print @option_tb, "\n"x2 if(@option_tb > 0);
	}
format HEADER_HELP  =
_____________________________________________________________________
		  __  __      ______     __          _____
		 /\ \/\ \    /\  ___\   /\ \        /\  _ `\
		 \ \ \_\ \   \ \ \__/   \ \ \       \ \ \L\ \
		  \ \  _  \   \ \  _\    \ \ \       \ \ ,__/
		   \ \ \ \ \   \ \ \/___  \ \ \_____  \ \ \/
		    \ \_\ \_\   \ \_____\  \ \______\  \ \_\
		     \/_/\/_/    \/_____/   \/______/   \/_/ V 3.1`
_____________________________________________________________________
.
format DEFAULT_HELP_FORM =
 @<<<<<<<<<: @*
 $_,        $entries{$_}
.
}
#________________________________________________________________________
# Title     : handle_arguments
# Usage     : Just put the whole box delimited by the two '###..' lines below
#             to inside of your subroutines. It will call 'handle_arguments'
#             subroutine and parse all the given input arguments.
#             To use, claim the arguments, just use the variable in the box.
#             For example, if you had passed 2 file names for files existing
#             in your PWD(or if the string looks like this: xxxx.ext),
#             you can claim them by $file[0], $file[1] in
#             your subroutine.
# Function  : Sorts input arguments going into subroutines and returns default
#             arrays of references for various types (file, dir, hash, array,,,,)
#             If you give (\@out, @file), it will put @out into @array as a ref
#             and also the contents of @out will be dereferenced and put to
#             raw_string regardless what is in it).
#
# Example   : 'handle_arguments(\@array, $string, \%hash, 8, 'any_string')
# Warning   :
# Keywords  : handling arguments, parsing arguments,
# Options   :
# Returns   : Following GLOBAL variables
#
#             $num_opt,    @num_opt     @file          @dir
#             $char_opt,   @char_opt    %vars          @array,
#             @hash        @string,     @raw_string    @range,
#
#             $num_opt has 10,20
#             @num_opt has (10, 20)
#             @file has  xxxx.ext
#             @dir has  dir  or /my/dir
#             $char_opt has 'A,B'
#             @char_opt has (A, B)
#             @array has  (\@ar1, \@ar2)
#             @hash has (\%hash1, \%hash2)
#             @string  ('sdfasf', 'dfsf')
#             @raw_string (file.ext, dir_name, 'strings',,)
#             @range has values like  10-20
#             %vars deals with x=2, y=3 stuff.
#
# Argument  : any type, any amount
# Version   : 4.8
#--------------------------------------------------------------------
sub handle_arguments{
	my($c, $d, $e, $f, $i, $j, $k, $l, $s, $t, $x, $y, $z, $char_opt, $dir, @hash,
		$file, $in_dir, $num_opt, @char_opt, @dir, @file, @string, @file_dir, @k,
		@num_opt, @raw_string,@string, @array, %vars, @range, @temp, $temp,
		@char_options);

	&set_debug_option;
	if(@_<1){ print chr(7),"\n This is handle_arguments. No args Passed, Error?\n"}
	elsif( (@_ ==1)&& (ref($_[0]) eq 'ARRAY') ){ # when there is only 1 argument
	  push(@array, $_[0]);
	  push(@k, $_[0]);
	}elsif( (@_==1)&&( !ref($_[0]) ) ){
	  if(-f $_[0]){ push(@file, $_[0]);   push(@string, $_[0]) }
	  elsif(-d $_[0]){ push(@dir, $_[0]); push(@string, $_[0]) }
	  elsif($_[0]=~/^\d+$/){ push(@num_opt, $_[0]); $num_opt.=$_[0] }
	  elsif($_[0]=~/^\w+$/){ push(@string, $_[0]); }
	}elsif(@_ >=1){ @k = @_ }

	#####______Start of  general argument handling______######
	for($k=0; $k < @k ;$k++){
	  if( !ref($k[$k]) ){
		  if($k[$k]=~ /^[\-]?([a-zA-Z]\d*) {0,5}$/){  push(@char_opt, $1); $char_opt .= "$1\,";
		  }elsif($k[$k]=~ /^\-([a-zA-Z]+)$/){          ## When multiple option is given,
			  @char_options = split(/\,|/, $1);  push(@char_opt, @char_options);
			  $char_opt .= join("\,", @char_options); ## '-' should be used. eg. '-HEGI'
		  }elsif($k[$k]=~ /^(\w+)\=(\S* *)$/){  $vars{$1}=$2;  $vars .= "$1\,";
		  }elsif($k[$k]=~ /^(\-?\d+)$/){ push(@num_opt, $1);  $num_opt .= "$1\,";
		  }elsif($k[$k]=~ /^\d+\.?\d*\-\d+\.?\d*$/){  push(@range,  $k[$k] );
		  }elsif(-f $k[$k]){                          push(@file,   $k[$k] );
		  }elsif(-d $k[$k]){                          push(@dir,    $k[$k] );
		  }elsif($k[$k]=~ /\/[\w\d\.\-]+[\/].+[\/]$/){push(@dir,    $k[$k] );
		  }elsif($k[$k]=~ /^\/[\w\d\.\-]+[\/]*$/){    push(@dir,    $k[$k] );
		  }elsif($k[$k]=~ /^[\/\w\d\-\.]+\.\w+$/){    push(@file,   $k[$k] );
		  }elsif($k[$k]=~ /\S\/[\/\w\d\-\.]+\.\w+$/){ push(@file,   $k[$k] );
		  }elsif($k[$k]=~/^\w+[\/\\\w\d\.\-]+$/){     push(@string, $k[$k] );
		        # string does not have space, but includes '\', '/', '.'
		  }else{                                      push(@raw_string, $k[$k] );  }

	  }elsif( ref($k[$k]) ){
		  if( ref($k[$k]) eq "SCALAR"){
			 if(${$k[$k]} =~ /^[\-]?([a-zA-Z]\d*) {0,5}$/){ push(@char_opt, $1); $char_opt  .= "$1\,";
				}elsif(${$k[$k]}=~ /^\-([a-zA-Z]+)$/){ push(@char_opt, @char_options);
					$char_opt  .= join("\,", @char_options);  ## as an option string.
				}elsif(${$k[$k]}=~ /^(\w+)\=(\S* *)$/){  $vars{$1}=$2;  $vars .= "$1\,";
				}elsif(${$k[$k]}=~ /^(\-?\d+)$/){ $num_opt .= "$1\,";  push(@num_opt, $1);
			    }elsif(${$k[$k]}=~ /^\d+\.?\d*\-\d+\.?\d*$/){    push(@range,  $k[$k] );
				}elsif(-f ${$k[$k]}){                            push(@file,   ${$k[$k]} );
				}elsif(-d ${$k[$k]}){                            push(@dir,    ${$k[$k]} );
				}elsif(${$k[$k]}=~ /\/[\/\w\d\.\-]+[\/].+[\/]/){ push(@dir,    ${$k[$k]} );
				}elsif(${$k[$k]}=~/^\/[\/\w\d\.\-]+[\/]*$/){     push(@dir,    ${$k[$k]} );
				}elsif(${$k[$k]}=~ /^[\/\w\d\-\.]+\.\w+$/){      push(@file,   ${$k[$k]} );
				}elsif(${$k[$k]}=~/^\w+[\w\d\.\-]+$/){           push(@string, ${$k[$k]} );
				}else{                                           push(@raw_string, ${$k[$k]}); }
		  }elsif(ref($k[$k]) eq "ARRAY"){ my @temp_arr = @{$k[$k]}; push(@array, $k[$k]);
			for ($i=0; $i<@temp_arr; $i++){
			   if(-f $temp_arr[$i]){                            push(@file, $temp_arr[$i]);
			   }elsif($temp_arr[$i]=~/^\d+\.?\d*\-\d+\.?\d*$/){ push(@range,$temp_arr[$i] );
			   }elsif(-d $temp_arr[$i]){                        push(@dir , $temp_arr[$i]);
			   }elsif($temp_arr[$i]=~/\/[\/\w\d\.\-]+[\/].+[\/]/){ push(@dir, $temp_arr[$i] );
			   }elsif($temp_arr[$i]=~/^\/[\/\w\d\.\-]+[\/]*$/){ push(@dir, $temp_arr[$i] );
			   }elsif($temp_arr[$i]=~/^[\/\w\d\-\.]+\.\w+$/){   push(@file,$temp_arr[$i] );
																push(@string,$temp_arr[$i] );
			   }elsif($temp_arr[$i]=~/^\w+[\w\d\.\-]+$/){       push(@string,$temp_arr[$i]);
			   }else{                                           push(@raw_string, $temp_arr[$i]); }
			 }
		  }elsif(ref($k[$k]) eq "HASH"){                             push(@hash,   $k[$k] ); }
	  }
	}
	@raw_string=(@raw_string, @string);
	@file = @{&remove_dup_in_arrayH(\@file)};
	#-----------------------------------------------------
	 sub remove_dup_in_arrayH{  my($i, @nondup, @out_ref, %duplicate, @orig, @out_ref);
		for($i=0; $i<@_; $i++){  undef(%duplicate);
	       if(ref($_[$i]) eq 'ARRAY'){    @orig = @{$_[$i]};    }
		   @nondup = grep { ! $duplicate{$_}++ } @orig; push(@out_ref, \@nondup);  }
		if(@out_ref ==1){ return($out_ref[0]);}
		elsif(@out_ref >1){  return(@out_ref);}
	 }
	#-----------------------------------------------------
	return(\@hash, \@array, \@string, \@dir, \@file, \@num_opt,
			\@char_opt, \$num_opt, \$char_opt, \@raw_string, \%vars, \@range );
}
#________________________________________________________________________________
# Title     : import_ENV_vars
# Usage     :
# Function  : You can use any ENV set variables directly in your
#             program. So, you can say $USER instead of $ENV{'USER'}
# Example   :
# Keywords  : import_Env_vars, import_ENV_variables
# Options   :
# Version   : 1.1
#--------------------------------------------------------------------------------
sub import_ENV_vars{
		my($caller_package, $env_var_name);
		$caller_package=caller;
		foreach  $env_var_name (keys %ENV){
			 ${"${'caller_package'}::${'env_var_name'}"}=$ENV{$env_var_name}; ## ' ' are necessary
		}
		print "\n# import_ENV_vars: ALL the ENV settings are imported to $0 program\n";
}

#________________________________________________________________________
# Title     : read_option_table
# Usage     :
# Function  : Reads the option table made by Jong in any perl script. The
#             option table is a box with separators.
# Example   :
# Warning   :
# Keywords  :
# Options   :
# Returns   :
# Argument  :
# Version   : 1.0
#--------------------------------------------------------------------
sub read_option_table{
	my($table_found, @option_tb, $head, );
	 open(SELF, "${$_[0]}");
	 while(<SELF>){
		if( (/^ *#+/) && ( $table_found== 1) ){
		  push (@option_tb, "$_");
		}elsif( ($table_found != 1)&&(/^ *\#+ *[Oo]ption *[Tt]able */) ){
			$table_found=1; $head="############## Option Table  \"$0\"\n"; ##
			push(@option_tb, $head);
		}
		if( ($table_found==1)&&(/^ *###################+ *$/)){  ### to find the end point of reading
			$table_found =0; last; }
	 }
	 return(\@option_tb);
}
#________________________________________________________________________
# Title     : read_head_box
# Usage     : %entries = %{&read_head_box([\$file_to_read, \@BOXED ] )};
# Function  : Reads the introductory header box(the one you see on top of sub routines of
#             Jong's programs.). Make a hash(associative array) to put entries
#             and descriptions of the items. The hash values have new lines '\n' are
#             attached, so that later write_head_box just sorts Title to the top
#             and prints without much calculation.
#             This is similar to read_head_box, but
#             This has one long straight string as value(no \n inside)
#             There are two types of ending line one is Jong's #---------- ...
#             the other is Astrid's  #*************** ...
# Example   : Output is something like
#             ('Title', 'read_head_box', 'Tips', 'Use to parse doc', ...)
# Warning   :
# Keywords  : open_head_box, open_headbox, read_headbox
# Options   : 'b' for remove blank lines. This will remove all the entries
#             with no descriptions
# Returns   : A hash ref.
# Argument  : One or None. If you give an argu. it should be a ref. of an ARRAY
#              or a filename, or ref. of a filename.
#             If no arg is given, it reads SELF, ie. the program itself.
# Version   : 2.7
#--------------------------------------------------------------------
sub read_head_box{
	my($i, $c, $d, $j, $s, $z, @whole_file, $title_found, %Final_out,
	  $variable_string, $TITLE, $title, @keys, $end_found, $line, $entry,
	  $entry_match, $End_line_num, $remove_blank,  $title_entry_null,
	  $end_found, $Enclosed_entry, $Enclosed_var, $blank_counter,
	  $title_entry_exist, $entry_value, $temp_W, $Warning_part, $tmp,
	  $option_tb_found
	);

	if(ref($_[0]) eq 'ARRAY'){ ## When array is given
	  @whole_file = @{$_[0]};
	}elsif(-e ${$_[0]}){       ## When filename is given in a ref
	  open(FILE, "${$_[0]}");
	  @whole_file=(<FILE>);
	}elsif(-e $_[0]){          ## When filename is given
	  open(FILE, "$_[0]");
	  @whole_file=(<FILE>);
	}elsif( $_[0] eq 'b'){          ## When filename is given
	  $remove_blank = 1;
	}elsif( ${$_[0]} eq 'b'){          ## When filename is given
	  $remove_blank = 1;
	}else{
	  open(SELF, "$0");
	  @whole_file=(<SELF>);
	}
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	for($i=0; $i<@whole_file; $i++){
	 $whole_file[$i] =~ tr/\t/ {7}/;  ## This is quite important to some parsing!!!
	 #########################################
	 ##  The first and second line of box 1 ##
	 #########################################
	 if( ($whole_file[$i]=~/^#[_\*\~\-\=]{20,}$/)&&    ##  '#______' is discarded
		 ($whole_file[$i+1]=~/ *\# {0,3}([TitlNam]+e) {0,8}: {1,10}([\w\.:]*) *(Copyright.*)/i) ){
		 $TITLE = $1;      $title = "$2\n";   $Final_out{'Warning'}.="$3\n";
		 $entry_match=$TITLE; ## The very first $entry_match is set to 'Title' to prevent null entry
		 if($TITLE =~ /^Title|Name$/i){   #
			  if( ($title=~/^\s+$/)||( $title eq "\n") ){
				  $title_entry_null =1;  $title = '';  }    }
		 $Final_out{$TITLE}=$title;
		 $title_found ++ ;   $i++;  ## << this is essential to prevent reading the same line again.
		 last if $title_found > 1;    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ## The first and second line of box 2, #__________ or #**************
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($whole_file[$i]=~/^#[_\*]{20,}$/)&&
		 ($whole_file[$i+1]=~/^# {1,3}(\w{1,6}\s{0,2}\w+) {0,7}: {1,5}(.*) */i) ){
		 $title_found ++ ;        $i++;
		 $entry_match=$1;       $entry_value=$2;
		 $entry_match =~ s#^\S#(($tmp = $&) =~ tr/[a-z]/[A-Z]/,$tmp)#e;  ## Capitalize words
		 $Final_out{$entry_match}.= "$entry_value\n";
		 last if $title_found > 1;  next;   }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ##  'Enclosed' : section. After this, everything is read without discrimination ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($Enclosed_entry == 1)&&($whole_file[$i] =~/^#{1,} {1,}(.*)$/) ){
		 $Final_out{$Enclosed_var}.= "$1\n";    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ##  With proper entry 1 : for  'eg)'
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($title_found==1)&&
		 ($whole_file[$i]=~ /^# {1,12}(eg ?\)) {0,8}(.*)/i)){
		 $entry_match='Example';
		 $Final_out{$entry_match}.= "$2\n";
	 }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ##  With PROPER entry 2 : descriptins like. 'Ussage : ssssssxxjkk  kj'
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($title_found==1)&&
		 ($whole_file[$i]=~ /^# {1,2}(\w{1,4}\s{0,2}\w{1,7}) {0,8}[:\)] {0,6}(.*) */i)){
		 $entry_match=$1;       $entry_value=$2;
		 $entry_match =~ s#^\S#(($tmp = $&) =~ tr/[a-z]/[A-Z]/,$tmp)#e;
		 $Final_out{$entry_match}.= "$entry_value\n";
		 if($entry_match=~/^(Enclosed?)$/i){
			  $Enclosed_entry = 1;  $Enclosed_var=$1;        }    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 #  With proper entry 3 : descriptins like. 'Ussage :', But blank description ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($title_found==1)&&
		 ($whole_file[$i]=~ /^# {1,2}(\w{1,4}\s{0,2}\w{1,7}) {0,8}[:\)]( {0,})$/i)){
		 $entry_match=$1;       $entry_value=$2;
		 $entry_match =~ s#^\S#(($tmp = $&) =~ tr/[a-z]/[A-Z]/,$tmp)#e;
		 $Final_out{$entry_match}.= " $entry_value\n";
		 if($entry_match=~/^(Enclosed?)$/i){
			  $Enclosed_entry = 1;  $Enclosed_var=$1;      }    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 #  $option variable matching                ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1) && ($title_found==1) &&
		 ($whole_file[$i]=~ /^# {1,15}([\$\@]\w+ +[\w=\>]+ +\S+ \w+ \S+ *.*)/ )){
		 $Final_out{$entry_match} .= "$1\n";  }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###  all space line matching                 ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&  ##<----- If blank line is matched. Take the line
		 ($title_found==1)&&($whole_file[$i]=~/^# {0,}$/) ){
		 $blank_counter++;
		 if($blank_counter > 2){ $blank_counter--; }
		 else{ $Final_out{$entry_match}.= " \n";  }     }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###  Anything after 3 space to 12 positions  ##
	 ###  To match 'examples' etc. INC. ':'       ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&
		 ($title_found==1)&&($whole_file[$i]=~/^#( {2,12})(.+)/) ){
		 $Final_out{$entry_match}.= "$1$2\n"; $blank_counter=0; }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###  Anything after 1 space to 11 positions  ##
	 ###  To match 'examples' etc. EXC. ':'       ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&
		 ($title_found==1)&&($whole_file[$i]=~/^# {1,12}([^:.]+)/) ){
		 $Final_out{$entry_match}.= "$1\n"; $blank_counter=0;}

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###-------End of the read_box reading--------##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($title_found==1)&&
		 ($whole_file[$i]=~ /^#[\~\=\*\-]{15,}/)){  ## to match '#-----..' or '#******..'(Astrid's)
		 $End_line_num = $i;       $end_found++;
		 last;      }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 #  <<<<  Check if there is option table >>>>  #
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( (/^#{10,} option table of this program   #{10,}/)&&($end_found >=1) &&($title_found==1)){
				 $option_tb_found++; ### This is a global var.
	 }
	} ## < End of for loop


	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	### If title is not there at all     ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	@keys=keys %Final_out;
	for(@keys){
	  if(/^Title$/i){    ## No Entry of Title at all??
		  $TITLE =$&;
		  $title_entry_exist = 1;
		  if($Final_out{$_}=~/^ *$/){   ## if Title => Null or just space
			  $title_entry_null = 1;    }  }  }

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	### When title entry is not there    ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	if( $title_entry_exist != 1){
		for($s=$End_line_num+1; $s < $End_line_num+20; $s++){
			if( $whole_file[$s] =~ /^sub {1,5}([\w\.]+) {0,6}\{/){
				$Final_out{'Title'} = "$1\n";   last;       }
			elsif( $whole_file[$s] =~/^#________________________+/){
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{'Title'} = "$0";     last;
			}else{
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{'Title'} = "$0";
			}
		}
	}
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	### When title is blank              ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	elsif($title_entry_null ==1){  ## It looks for 'sub xxxxx{ ' line to get title
		### $End_line_num is the last line read.
		for($s = $End_line_num+1; $s < $End_line_num+20; $s++){
			if( $whole_file[$s] =~ /^sub {1,5}(\w+\.*\w*) {0,7}{/){
				$Final_out{$TITLE} = "$1\n";    last;     }
			elsif( $whole_file[$s] =~/^#________________________+/){
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{$TITLE} = "$0";     last;
			}else{
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{$TITLE} = "$0";
			}
		}
	}
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	## Error handling, if no head box is found   ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	if($title_found < 1){ print "\nFatal: No headbox found by read_head_box2 sub.\n";  }
	\%Final_out;
}               ##<<--- ENd of the sub read_head_box


#________________________________________________________________________________
# Title     : check_input_file_extension
# Usage     : @file=@{&check_input_file_extension('msp', \@file)};
#             or @file=@{&check_input_file_extension('msp,nhco', \@file)};
#                for multiple extension allowance
# Function  :
# Example   : @file=@{&check_input_file_extension('msp', \@file)};
# Keywords  :
# Options   :
# Category  :
# Version   : 1.2
#--------------------------------------------------------------------------------
sub check_input_file_extension{
		my(@file, @extentions, $extension_not_matched, $i, $file_ext_wanted);
		$file_ext_wanted=$_[0];
		@extentions=split(/[\, ]+/, $file_ext_wanted);
		@file=@{$_[1]};
		for(@extentions){
				$file_ext_wanted=$_;
				#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				print "\n# (2) checking file extension \n";
				#___________________________________________________
				if($file[0] =~/\.$file_ext_wanted/){
						 $extension_not_matched=1;
				}
		}
		unless($extension_not_matched){
				 print "\n# write_nhco_files : normally accepts xxxx.$file_ext_wanted files. Put y+return to continue";
				 print "\n# write_nhco_files : You can type \'c\' for changing the file extension to parf \n\n>>>";
				 $answer_char=getc;
				 if($answer_char=~/^y/i){
						 $answer_char='';
				 }elsif($answer_char=~/^c/i){
						 $answer_char='';
						 #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
						 print "\n# (3) write_nhco_files: chaning all the file input extension to 'parf'";
						 #_______________________________________________________________________________
						 for($i=0; $i< @file; $i++){
								 $base=${&get_base_names($file[$i])};
								 $file[$i]="$base\.$file_ext_wanted";
						 }
				 }else{
						 $answer_char='';
						 print "\n\n\n# check_input_file_extension: You rudely put rubbish, I am dying. $0\n\n\n";
						 print chr(7);
						 exit;
				 }
		}
		return(\@file);
}

#________________________________________________________________________
# Title     : show_hash
# Usage     : &show_hash(\@input_array);
# Function  : for debugging purpose. Shows any array elem line by line.
#             the line is 60 elements long (uses recursion)
# Example   : Output:      item1
#             Output:      item2
#             Output:      item3
# Warning   : There is a global variable:  $show_hash_option
#             It tries to detect any given sting which is joined by ','
# Keywords  :
# Options   : -s or -S or s or S for spaced output. Eg)
#             seq1       1 1 1 1 1 1 1 1 1 1 1 1
#
#             instead of
#             seq1       111111111111
#
#             -h or -H or h or H for horizontal line of '---------...'
#
# Returns   :
# Argument  :
# Category  :
# Version   : 1.9
#--------------------------------------------------------------------
sub show_hash{
		my($k, $i, $t, @in2, $in, $LEN, %TEM, $out_in_html_form ); ## You should not put $show_hash_option
		my(@in)=@_;                     ## and $horizontal_line  in my !!!
		my($KL)=18; # default keys string length;
		my($VL)=80; # default values string length;
		my($GAP)=2;  # default space between keys and values
		my($horizontal_line, $show_hash_optionXX, $Hash_counter, @line);

		## This is to get the option of 'space' to make spaced output.
		for($t=0; $t < @in; $t++){
				if($in[$t] =~/^[-]+[sS][pace]*$/){
						$show_hash_optionXX = 1;  splice(@in, $t, 1);
				}elsif(${in[$t]} =~/^[-]+[sS][pace]*$/){
						$show_hash_optionXX = 1;  splice(@in, $t, 1);
				}elsif($in[$t] =~/^[-]+[hH][rR]*$/){
						$horizontal_line = 1;     splice(@in, $t, 1);
				}elsif($in[$t] =~/html/i){
						$out_in_html_form="HTML"; splice(@in, $t, 1);
				}elsif(${in[$t]} =~/html/i){
						$out_in_html_form='HTML'; splice(@in, $t, 1);
				}

		}

		######## Main loop #################
		if($horizontal_line ==1){  ## This puts the delimiter '--------------(  )'
				$Hash_counter ++;
				print "\n","-"x78,"(${Hash_counter}th hash)", "\n";
		}

		for($k=0; $k < @in; $k++){
			 if(ref($in[$k]) eq 'ARRAY'){  ### When the hashes were given in array ref.
						&show_hash(@{$in[$k]}, $show_hash_optionXX, $horizontal_line, $out_in_html_form);
						print "\n";
			 }elsif(ref($in[$k]) eq 'HASH'){  ### recursion
						&show_hash(%{$in[$k]}, $out_in_html_form, $show_hash_optionXX, $horizontal_line);
						print "\n";
			 }elsif(ref($in[$k+1]) eq 'HASH'){  ### recursion
						&show_hash(%{$in[$k+1]}, $horizontal_line, $out_in_html_form, $show_hash_optionXX); print "\n";
			 }elsif(ref($in[$k]) eq 'SCALAR'){
						if($out_in_html_form){  print ${$_[$k]}, "<br>\n";
						}else{   print ${$_[$k]}, "\n"; }
			 }elsif( !ref($in[$k]) ){
						if( !ref($in[$k+1]) && defined($in[$k+1])  ){
								 if($show_hash_optionXX){  #### space option checking.
										 %TEM = @in;
										 $LEN = ${&max_elem_string_array_show_hash(keys %TEM)};
											if($LEN > $KL){ $KL = $LEN + $GAP +2};
											if($out_in_html_form){
												 printf ("<br>%-${KL}s ", $in[$k]);  $k++;
												 printf ("%-${VL}s<br>\n","@line");
											}else{
												 printf ("%-${KL}s ", $in[$k]);  $k++;
												 printf ("%-${VL}s\n","@line");
											}
								 }else{                        ### If not option is set, just write
											%TEM = @in;
											$LEN = ${&max_elem_string_array_show_hash( keys %TEM)};
											if($LEN > $KL){ $KL = $LEN + $GAP +2};
											if($out_in_html_form){
												 printf ("<br>%-${KL}s ", $in[$k]);  $k++; # print $in[$k], "\t";  $k++;
												 printf ("%-${VL}s<br>\n",$in[$k]);        # print $in[$k], "\n";
											}else{
												 printf ("%-${KL}s ", $in[$k]);  $k++; # print $in[$k], "\t";  $k++;
												 printf ("%-${VL}s\n",$in[$k]);        # print $in[$k], "\n";
											}
								 }
						}
						#________________________________________________________
						# Title    : max_elem_string_array_show_hash
						# Keywords : largest string length of array
						# Function : gets the largest string length of element of any array of numbers.
						# Usage    : ($out1, $out2)=@{&max_elem_array(\@array1, \@array2)};
						#            ($out1)       =${&max_elem_array(\@array1)          };
						# Argument : numerical arrays
						# Version  : 1.1
						#-------------------------------------------------------
						sub max_elem_string_array_show_hash{
								my(@input, $i, $max_elem); @input = @{$_[0]} || @_;
								for($i=0; $i< @input ; $i++){
										 $max_elem = length($input[0]);
										 if (length($input[$i]) > $max_elem){
														 $max_elem = length($input[$i]);
										 }
								}
								return(\$max_elem);
						}
						#####################################insert_gaps_in_seq_hash
			 }
	 }
}


