package Mojolicious::Plugin::Riotjs;
use Mojo::Base 'Mojolicious::Plugin';
use Cwd ();

our $VERSION = '0.06';

$ENV{NODE_PATH} ||= '';

sub node_paths {
  my ($self, $app) = @_;
  my %PATH;

  grep { $_ and -d and !$PATH{$_}++ } split(/:/, $ENV{NODE_PATH}), eval { Cwd::abs_path('node_modules') },
    $app->home->rel_dir('node_modules');
}

sub register {
  my ($self, $app, $config) = @_;

  $config->{ext} ||= 'tag';
  $ENV{NODE_PATH} = join ':', $self->node_paths($app);
  $app->plugin('AssetPack') unless eval { $app->asset };
  $app->asset->preprocessors->add($config->{ext} => 'Mojolicious::Plugin::Riotjs::Preprocessor' => $config);
}

1;

=encoding utf8

=head1 NAME

Mojolicious::Plugin::Riotjs - DEPRECATED

=head1 VERSION

0.06

=head1 DESCRIPTION

L<Mojolicious::Plugin::Riotjs> will be DEPRECATED.

Use L<Mojolicious::Plugin::AssetPack::Pipe::Riotjs> bundled with
L<Mojolicious::Plugin::AssetPack> instead.

From the L<web page|https://muut.com/riotjs/>:

  A REACT-LIKE, 2.5KB USER INTERFACE LIBRARY
  Custom tags - Virtual DOM - Full stack - IE8

=head2 Dependencies

Riot is required for this module to work. You can install Riot with
L<npm|https://www.npmjs.com/>:

  $ sudo apt-get install npm
  $ npm install riot

=head1 SYNOPSIS

  use Mojolicious::Lite;

  get "/" => "index";
  app->plugin("riotjs");
  app->asset(
    "app.js" => qw(
      http://cdnjs.cloudflare.com/ajax/libs/riot/2.0.13/riot.js
      /js/todo.tag
      /js/main.js
    )
  );
  app->start;

  __DATA__
  @@ /js/todo.tag
  <todo>
    <h3>{ opts.title }</h3>
    <ul>
      <li each={ item, i in items }>{ item.title }</li>
    </ul>
    <form onsubmit={ add }>
      <input>
      <button>Add #{ items.length + 1 }</button>
    </form>

    this.items = []

    add(e) {
      var input = e.target[0]
      if (input.value.length) this.items.push({ title: input.value })
      input.value = ''
    }
  </todo>

  @@ /js/main.js
  riot.mount('todo')

  @@ index.html.ep
  <!DOCTYPE html>
  <html>
    <head>
      <title>Riot.js Demo</title>
      <!--[if lt IE 9]>
      <script src="//cdnjs.cloudflare.com/ajax/libs/es5-shim/4.0.5/es5-shim.min.js"></script>
      <script src="//cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script>html5.addElements('todo')</script>
      <![endif]-->
    </head>
    <body>
      <todo></todo>
      %= asset "app.js"
    </body>
  </html>

=head1 METHODS

=head2 node_paths

DEPRECATED.

=head2 register

DEPRECATED.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014, Jan Henning Thorsen

This program is free software, you can redistribute it and/or modify it under
the terms of the Artistic License version 2.0.

=head1 AUTHOR

Jan Henning Thorsen - C<jhthorsen@cpan.org>

=cut
