package Locale::CLDR::Hy v0.25.1;
# This file auto generated from Data\common\main\hy.xml
#	on Sat 10 May 12:13:26 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.18;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'աբխազերեն',
 				'af' => 'աֆրիկաանս',
 				'am' => 'ամհարերեն',
 				'ar' => 'արաբերեն',
 				'ar_001' => 'ժամանակակից ստանդարտ արաբերեն',
 				'as' => 'ասամերեն',
 				'az' => 'ադրբեջաներեն',
 				'be' => 'բելառուսերեն',
 				'bg' => 'բուլղարերեն',
 				'bn' => 'բենգալերեն',
 				'bo' => 'տիբեթերեն',
 				'br' => 'Բրետոներեն',
 				'bs' => 'բոսնիերեն',
 				'ca' => 'կատալաներեն',
 				'cs' => 'չեխերեն',
 				'cy' => 'ուելսերեն',
 				'da' => 'դանիերեն',
 				'de' => 'գերմաներեն',
 				'de_AT' => 'ավստրիական գերմաներեն',
 				'de_CH' => 'շվեյցարական բարձր գերմաներեն',
 				'el' => 'հունարեն',
 				'en' => 'անգլերեն',
 				'en_AU' => 'ավստրալական անգլերեն',
 				'en_CA' => 'կանադական անգլերեն',
 				'en_GB' => 'բրիտանական անգլերեն',
 				'en_GB@alt=short' => 'անգլերեն (ՄԹ)',
 				'en_US' => 'ամերիկյան անգլերեն',
 				'en_US@alt=short' => 'անգլերեն (ԱՄՆ)',
 				'eo' => 'էսպերանտո',
 				'es' => 'իսպաներեն',
 				'es_419' => 'լատինաամերիկյան իսպաներեն',
 				'es_ES' => 'եվրոպական իսպաներեն',
 				'es_MX' => 'մեքսիկական իսպաներեն',
 				'et' => 'էստոներեն',
 				'eu' => 'բասկերեն',
 				'fa' => 'պարսկերեն',
 				'fi' => 'ֆիններեն',
 				'fil' => 'ֆիլիպիներեն',
 				'fj' => 'ֆիջիերեն',
 				'fo' => 'ֆարյորերեն',
 				'fr' => 'ֆրանսերեն',
 				'fr_CA' => 'կանադական ֆրանսերեն',
 				'fr_CH' => 'շվեյցարական ֆրանսերեն',
 				'fy' => 'արևմտյան ֆրիզերեն',
 				'ga' => 'իռլանդերեն',
 				'gd' => 'Գաելյան Շոտլանդերեն',
 				'gl' => 'գալիսերեն',
 				'gn' => 'գուարանի',
 				'gsw' => 'շվեյցարական գերմաներեն',
 				'gu' => 'գուջարաթի',
 				'ha' => 'հաուսա',
 				'haw' => 'հավայիերեն',
 				'he' => 'եբրայերեն',
 				'hi' => 'հինդի',
 				'hr' => 'խորվաթերեն',
 				'ht' => 'հաիթերեն',
 				'hu' => 'հունգարերեն',
 				'hy' => 'հայերեն',
 				'ia' => 'Ինտերլինգուա',
 				'id' => 'ինդոնեզերեն',
 				'ie' => 'Ինտերլինգ',
 				'ig' => 'իգբո',
 				'is' => 'իսլանդերեն',
 				'it' => 'իտալերեն',
 				'ja' => 'ճապոներեն',
 				'jv' => 'ճավայերեն',
 				'ka' => 'վրացերեն',
 				'kk' => 'ղազախերեն',
 				'km' => 'քմերերեն',
 				'kn' => 'կաննադա',
 				'ko' => 'կորեերեն',
 				'ks' => 'քաշմիրերեն',
 				'ku' => 'քրդերեն',
 				'ky' => 'ղրղզերեն',
 				'la' => 'լատիներեն',
 				'lb' => 'լյուքսեմբուրգերեն',
 				'ln' => 'Լինգալա',
 				'lo' => 'լաոսերեն',
 				'lt' => 'լիտվերեն',
 				'lv' => 'լատվիերեն',
 				'mg' => 'մալագասերեն',
 				'mi' => 'մաորի',
 				'mk' => 'մակեդոներեն',
 				'ml' => 'մալայալամ',
 				'mn' => 'Մոնղոլերեն',
 				'mr' => 'մարաթի',
 				'ms' => 'մալայերեն',
 				'mt' => 'մալթերեն',
 				'my' => 'բիրմայերեն',
 				'nb' => 'նորվեգերեն բուկմոլ',
 				'ne' => 'նեպալերեն',
 				'nl' => 'հոլանդերեն',
 				'nl_BE' => 'ֆլամանդերեն',
 				'nn' => 'նորվեգերեն նյունորսկ',
 				'no' => 'Նորվեգերեն',
 				'oc' => 'Ակվիտաներեն',
 				'or' => 'օրիյա',
 				'pa' => 'փենջաբերեն',
 				'pl' => 'լեհերեն',
 				'ps' => 'փուշթու',
 				'pt' => 'պորտուգալերեն',
 				'pt_BR' => 'բրազիլական պորտուգալերեն',
 				'pt_PT' => 'եվրոպական պորտուգալերեն',
 				'qu' => 'քեչուա',
 				'rm' => 'ռոմանշերեն',
 				'ro' => 'ռումիներեն',
 				'ru' => 'ռուսերեն',
 				'sa' => 'սանսկրիտ',
 				'sd' => 'սինդհի',
 				'sh' => 'Սերբա-Խորվաթերեն',
 				'si' => 'սինհալերեն',
 				'sk' => 'սլովակերեն',
 				'sl' => 'սլովեներեն',
 				'so' => 'սոմալիերեն',
 				'sq' => 'ալբաներեն',
 				'sr' => 'սերբերեն',
 				'st' => 'Սեսոտո',
 				'su' => 'սունդաներեն',
 				'sv' => 'շվեդերեն',
 				'sw' => 'սուահիլի',
 				'ta' => 'թամիլերեն',
 				'te' => 'թելուգու',
 				'tg' => 'տաջիկերեն',
 				'th' => 'թայերեն',
 				'ti' => 'թիգրինիա',
 				'tk' => 'թուրքմեներեն',
 				'tlh' => 'Կլինգոն',
 				'to' => 'տոնգա',
 				'tr' => 'թուրքերեն',
 				'tt' => 'թաթարերեն',
 				'tw' => 'Տուի',
 				'ug' => 'ույղուրերեն',
 				'uk' => 'ուկրաիներեն',
 				'und' => 'անհայտ լեզու',
 				'ur' => 'ուրդու',
 				'uz' => 'ուզբեկերեն',
 				'vi' => 'վիետնամերեն',
 				'wo' => 'վոլոֆ',
 				'xh' => 'քսոզա',
 				'yi' => 'Իդիշ',
 				'yo' => 'յորուբա',
 				'zgh' => 'ստանդարտ մարոկական թամազիղտ',
 				'zh' => 'չինարեն',
 				'zh_Hans' => 'պարզեցված չինարեն',
 				'zh_Hant' => 'ավանդական չինարեն',
 				'zu' => 'զուլուսերեն',
 				'zxx' => 'առանց լեզվային բովանդակության',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'արաբական',
 			'Armn' => 'հայկական',
 			'Beng' => 'բենգալական',
 			'Bopo' => 'բոպոմոֆո',
 			'Brai' => 'բրայլի',
 			'Cyrl' => 'կյուրեղագիր',
 			'Deva' => 'դեվանագարի',
 			'Ethi' => 'եթովպական',
 			'Geor' => 'վրացական',
 			'Grek' => 'հունական',
 			'Gujr' => 'գուջարաթի',
 			'Guru' => 'գուրմուխի',
 			'Hang' => 'հանգուլ',
 			'Hani' => 'չինական',
 			'Hans' => 'պարզեցված չինական',
 			'Hans@alt=stand-alone' => 'պարզեցված չինական',
 			'Hant' => 'ավանդական չինական',
 			'Hant@alt=stand-alone' => 'ավանդական չինական',
 			'Hebr' => 'եբրայական',
 			'Hira' => 'հիրագանա',
 			'Jpan' => 'ճապոնական',
 			'Kana' => 'կատականա',
 			'Khmr' => 'քմերական',
 			'Knda' => 'կաննադա',
 			'Kore' => 'կորեական',
 			'Laoo' => 'լաոսական',
 			'Latn' => 'լատինական',
 			'Mlym' => 'մալայալամ',
 			'Mong' => 'մոնղոլական',
 			'Mymr' => 'մյանմարական',
 			'Orya' => 'օրիյա',
 			'Sinh' => 'սինհալական',
 			'Taml' => 'թամիլական',
 			'Telu' => 'թելուգու',
 			'Thaa' => 'թաանա',
 			'Thai' => 'թայական',
 			'Tibt' => 'տիբեթական',
 			'Zsym' => 'նշաններ',
 			'Zxxx' => 'չգրված',
 			'Zyyy' => 'ընդհանուր',
 			'Zzzz' => 'անհայտ գիր',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Աշխարհ',
 			'002' => 'Աֆրիկա',
 			'003' => 'Հյուսիսային Ամերիկա',
 			'005' => 'Հարավային Ամերիկա',
 			'009' => 'Օվկիանիա',
 			'011' => 'Արևմտյան Աֆրիկա',
 			'013' => 'Կենտրոնական Ամերիկա',
 			'014' => 'Արևելյան Աֆրիկա',
 			'015' => 'Հյուսիսային Աֆրիկա',
 			'017' => 'Կենտրոնական Աֆրիկա',
 			'018' => 'Աֆրիկայի հարավ',
 			'019' => 'Ամերիկա',
 			'021' => 'Հյուսիսային Ամերիկա - Մեքսիկայից հյուսիս',
 			'029' => 'Կարիբյան կղզիներ',
 			'030' => 'Արևելյան Ասիա',
 			'034' => 'Հարավային Ասիա',
 			'035' => 'Հարավ-Արևելյան Ասիա',
 			'039' => 'Հարավային Եվրոպա',
 			'053' => 'Ավստրալասիա',
 			'054' => 'Մալանեզիա',
 			'057' => 'Միկրոնեզիայի տարածաշրջան',
 			'061' => 'Պոլինեզիա',
 			'142' => 'Ասիա',
 			'143' => 'Կենտրոնական Ասիա',
 			'145' => 'Արևմտյան Ասիա',
 			'150' => 'Եվրոպա',
 			'151' => 'Արևելյան Եվրոպա',
 			'154' => 'Հյուսիսային Եվրոպա',
 			'155' => 'Արևմտյան Եվրոպա',
 			'419' => 'Լատինական Ամերիկա',
 			'AC' => 'Համբարձման կղզի',
 			'AD' => 'Անդորա',
 			'AE' => 'Միացյալ Արաբական Էմիրություններ',
 			'AF' => 'Աֆղանստան',
 			'AG' => 'Անտիգուա և Բարբուդա',
 			'AI' => 'Անգիլիա',
 			'AL' => 'Ալբանիա',
 			'AM' => 'Հայաստան',
 			'AO' => 'Անգոլա',
 			'AQ' => 'Անտարկտիդա',
 			'AR' => 'Արգենտինա',
 			'AS' => 'Ամերիկյան Սամոա',
 			'AT' => 'Ավստրիա',
 			'AU' => 'Ավստրալիա',
 			'AW' => 'Արուբա',
 			'AX' => 'Ալանդյան կղզիներ',
 			'AZ' => 'Ադրբեջան',
 			'BA' => 'Բոսնիա և Հերցեգովինա',
 			'BB' => 'Բարբադոս',
 			'BD' => 'Բանգլադեշ',
 			'BE' => 'Բելգիա',
 			'BF' => 'Բուրկինա Ֆասո',
 			'BG' => 'Բուլղարիա',
 			'BH' => 'Բահրեյն',
 			'BI' => 'Բուրունդի',
 			'BJ' => 'Բենին',
 			'BL' => 'Սուրբ Բարթողոմեոսի կղզի',
 			'BM' => 'Բերմուդյան կղզիներ',
 			'BN' => 'Բրունեյ',
 			'BO' => 'Բոլիվիա',
 			'BQ' => 'Կարիբյան Նիդերլանդներ',
 			'BR' => 'Բրազիլիա',
 			'BS' => 'Բահամյան կղզիներ',
 			'BT' => 'Բութան',
 			'BV' => 'Բուվե կղզի',
 			'BW' => 'Բոտսվանա',
 			'BY' => 'Բելառուս',
 			'BZ' => 'Բելիզ',
 			'CA' => 'Կանադա',
 			'CC' => 'Կոկոսյան (Քիլինգ) կղզիներ',
 			'CD' => 'Կոնգո - Կինշասա',
 			'CD@alt=variant' => 'Կոնգո (Կոնգոյի Ժողովրդավարական Հանրապետություն)',
 			'CF' => 'Կենտրոնական Աֆրիկյան Հանրապետություն',
 			'CG' => 'Կոնգո - Բրազավիլ',
 			'CG@alt=variant' => 'Կոնգո (Կոնգոյի Հանրապետություն)',
 			'CH' => 'Շվեյցարիա',
 			'CI' => 'Փղոսկրի Ափ',
 			'CK' => 'Կուկի կղզիներ',
 			'CL' => 'Չիլի',
 			'CM' => 'Կամերուն',
 			'CN' => 'Չինաստան',
 			'CO' => 'Կոլումբիա',
 			'CP' => 'Քլիփերթոն կղզի',
 			'CR' => 'Կոստա-Ռիկա',
 			'CU' => 'Կուբա',
 			'CV' => 'Կաբո Վերդե',
 			'CW' => 'Կյուրասաո',
 			'CX' => 'Ծննդյան կղզի',
 			'CY' => 'Կիպրոս',
 			'CZ' => 'Չեխիա',
 			'DE' => 'Գերմանիա',
 			'DG' => 'Դիեգո Գարսիա',
 			'DJ' => 'Ջիբուտի',
 			'DK' => 'Դանիա',
 			'DM' => 'Դոմինիկա',
 			'DO' => 'Դոմինիկյան Հանրապետություն',
 			'DZ' => 'Ալժիր',
 			'EA' => 'Սեուտա և Մելիլյա',
 			'EC' => 'Էկվադոր',
 			'EE' => 'Էստոնիա',
 			'EG' => 'Եգիպտոս',
 			'EH' => 'Արևմտյան Սահարա',
 			'ER' => 'Էրիտրեա',
 			'ES' => 'Իսպանիա',
 			'ET' => 'Եթովպիա',
 			'EU' => 'Եվրոպական Միություն',
 			'FI' => 'Ֆինլանդիա',
 			'FJ' => 'Ֆիջի',
 			'FK' => 'Ֆոլկլենդյան կղզիներ',
 			'FK@alt=variant' => 'Ֆոլկլենդյան (Մալվինյան) կղզիներ',
 			'FM' => 'Միկրոնեզիա',
 			'FO' => 'Ֆարերյան կղզիներ',
 			'FR' => 'Ֆրանսիա',
 			'GA' => 'Գաբոն',
 			'GB' => 'Միացյալ Թագավորություն',
 			'GB@alt=short' => 'Միացյալ Թագավորություն',
 			'GD' => 'Գրենադա',
 			'GE' => 'Վրաստան',
 			'GF' => 'Ֆրանսիական Գվիանա',
 			'GG' => 'Գերնսի',
 			'GH' => 'Գանա',
 			'GI' => 'Ջիբրալթար',
 			'GL' => 'Գրենլանդիա',
 			'GM' => 'Գամբիա',
 			'GN' => 'Գվինեա',
 			'GP' => 'Գվադելուպա',
 			'GQ' => 'Հասարակածային Գվինեա',
 			'GR' => 'Հունաստան',
 			'GS' => 'Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ',
 			'GT' => 'Գվատեմալա',
 			'GU' => 'Գուամ',
 			'GW' => 'Գվինեա-Բիսաու',
 			'GY' => 'Գայանա',
 			'HK' => 'Հոնկոնգի ՀՎՇ',
 			'HK@alt=short' => 'Հոնկոնգ',
 			'HM' => 'Հերդ կղզի և ՄակԴոնալդի կղզիներ',
 			'HN' => 'Հոնդուրաս',
 			'HR' => 'Խորվաթիա',
 			'HT' => 'Հաիթի',
 			'HU' => 'Հունգարիա',
 			'IC' => 'Կանարյան կղզիներ',
 			'ID' => 'Ինդոնեզիա',
 			'IE' => 'Իռլանդիա',
 			'IL' => 'Իսրայել',
 			'IM' => 'Մեն կղզի',
 			'IN' => 'Հնդկաստան',
 			'IO' => 'Հնդկական Օվկիանոսում Բրիտանական Տարածք',
 			'IQ' => 'Իրաք',
 			'IR' => 'Իրան',
 			'IS' => 'Իսլանդիա',
 			'IT' => 'Իտալիա',
 			'JE' => 'Ջերսի',
 			'JM' => 'Ջամայկա',
 			'JO' => 'Հորդանան',
 			'JP' => 'Ճապոնիա',
 			'KE' => 'Քենիա',
 			'KG' => 'Ղրղզստան',
 			'KH' => 'Կամբոջա',
 			'KI' => 'Կիրիբատի',
 			'KM' => 'Կոմորյան կղզիներ',
 			'KN' => 'Սենթ Քիթս և Նևիս',
 			'KP' => 'Հյուսիսային Կորեա',
 			'KR' => 'Հարավային Կորեա',
 			'KW' => 'Քուվեյթ',
 			'KY' => 'Կայմանյան կղզիներ',
 			'KZ' => 'Ղազախստան',
 			'LA' => 'Լաոս',
 			'LB' => 'Լիբանան',
 			'LC' => 'Սենթ Լյուսիա',
 			'LI' => 'Լիխտենշտեյն',
 			'LK' => 'Շրի Լանկա',
 			'LR' => 'Լիբերիա',
 			'LS' => 'Լեսոտո',
 			'LT' => 'Լիտվա',
 			'LU' => 'Լյուքսեմբուրգ',
 			'LV' => 'Լատվիա',
 			'LY' => 'Լիբիա',
 			'MA' => 'Մարոկո',
 			'MC' => 'Մոնակո',
 			'MD' => 'Մոլդովա',
 			'ME' => 'Չեռնոգորիա',
 			'MF' => 'Սեն Մարտեն',
 			'MG' => 'Մադագասկար',
 			'MH' => 'Մարշալյան կղզիներ',
 			'MK' => 'Մակեդոնիա',
 			'MK@alt=variant' => 'Մակեդոնիա (ՄՆՀՀ)',
 			'ML' => 'Մալի',
 			'MM' => 'Մյանմա (Բիրմա)',
 			'MN' => 'Մոնղոլիա',
 			'MO' => 'Չինաստանի Մակաո ՀՎՇ',
 			'MO@alt=short' => 'Մակաո',
 			'MP' => 'Հյուսիսային Մարիանյան կղզիներ',
 			'MQ' => 'Մարտինիկա',
 			'MR' => 'Մավրիտանիա',
 			'MS' => 'Մոնտսերատ',
 			'MT' => 'Մալթա',
 			'MU' => 'Մավրիկիոս',
 			'MV' => 'Մալդիվներ',
 			'MW' => 'Մալավի',
 			'MX' => 'Մեքսիկա',
 			'MY' => 'Մալայզիա',
 			'MZ' => 'Մոզամբիկ',
 			'NA' => 'Նամիբիա',
 			'NC' => 'Նոր Կալեդոնիա',
 			'NE' => 'Նիգեր',
 			'NF' => 'Նորֆոլկ կղզի',
 			'NG' => 'Նիգերիա',
 			'NI' => 'Նիկարագուա',
 			'NL' => 'Նիդերլանդեր',
 			'NO' => 'Նորվեգիա',
 			'NP' => 'Նեպալ',
 			'NR' => 'Նաուրու',
 			'NU' => 'Նիուե',
 			'NZ' => 'Նոր Զելանդիա',
 			'OM' => 'Օման',
 			'PA' => 'Պանամա',
 			'PE' => 'Պերու',
 			'PF' => 'Ֆրանսիական Պոլինեզիա',
 			'PG' => 'Պապուա Նոր Գվինեա',
 			'PH' => 'Ֆիլիպիններ',
 			'PK' => 'Պակիստան',
 			'PL' => 'Լեհաստան',
 			'PM' => 'Սեն Պիեր և Միկելոն',
 			'PN' => 'Պիտկեռն կղզիներ',
 			'PR' => 'Պուերտո Ռիկո',
 			'PS' => 'Պաղեստինյան տարածքներ',
 			'PS@alt=short' => 'Պաղեստին',
 			'PT' => 'Պորտուգալիա',
 			'PW' => 'Պալաու',
 			'PY' => 'Պարագվայ',
 			'QA' => 'Կատար',
 			'QO' => 'Արտաքին Օվկիանիա',
 			'RE' => 'Ռեյունիոն',
 			'RO' => 'Ռումինիա',
 			'RS' => 'Սերբիա',
 			'RU' => 'Ռուսաստան',
 			'RW' => 'Ռուանդա',
 			'SA' => 'Սաուդյան Արաբիա',
 			'SB' => 'Սողոմոնյան կղզիներ',
 			'SC' => 'Սեյշելյան կղզիներ',
 			'SD' => 'Սուդան',
 			'SE' => 'Շվեդիա',
 			'SG' => 'Սինգապուր',
 			'SH' => 'Սուրբ Հեղինեի կղզի',
 			'SI' => 'Սլովենիա',
 			'SJ' => 'Սվալբարդ և Յան-Մայեն',
 			'SK' => 'Սլովակիա',
 			'SL' => 'Սյերա-Լեոնե',
 			'SM' => 'Սան Մարինո',
 			'SN' => 'Սենեգալ',
 			'SO' => 'Սոմալի',
 			'SR' => 'Սուրինամ',
 			'SS' => 'Հարավային Սուդան',
 			'ST' => 'Սան Տոմե և Պրինսիպի',
 			'SV' => 'Սալվադոր',
 			'SX' => 'Սինտ Մարտեն',
 			'SY' => 'Սիրիա',
 			'SZ' => 'Սվազիլենդ',
 			'TA' => 'Տրիստան դա Կունյա',
 			'TC' => 'Տերկս և Կայկոս կղզիներ',
 			'TD' => 'Չադ',
 			'TF' => 'Ֆրանսիական Հարավային Տարածքներ',
 			'TG' => 'Տոգո',
 			'TH' => 'Թաիլանդ',
 			'TJ' => 'Տաջիկստան',
 			'TK' => 'Տոկելաու',
 			'TL' => 'Թիմոր-Լեստե',
 			'TL@alt=variant' => 'Արևելյան Թիմոր',
 			'TM' => 'Թուրքմենստան',
 			'TN' => 'Թունիս',
 			'TO' => 'Տոնգա',
 			'TR' => 'Թուրքիա',
 			'TT' => 'Տրինիդադ և Տոբագո',
 			'TV' => 'Տուվալու',
 			'TW' => 'Թայվան',
 			'TZ' => 'Տանզանիա',
 			'UA' => 'Ուկրաինա',
 			'UG' => 'Ուգանդա',
 			'UM' => 'Արտաքին կղզիներ (ԱՄՆ)',
 			'US' => 'Ամերիկայի Միացյալ Նահանգներ',
 			'US@alt=short' => 'ԱՄՆ',
 			'UY' => 'Ուրուգվայ',
 			'UZ' => 'Ուզբեկստան',
 			'VA' => 'Վատիկան քաղաք-պետություն',
 			'VC' => 'Սենթ Վիսենտ և Գրենադիններ',
 			'VE' => 'Վենեսուելա',
 			'VG' => 'Բրիտանական Վիրջինյան կղզիներ',
 			'VI' => 'Ամերիկյան Վիրջինյան կղզիներ',
 			'VN' => 'Վիետնամ',
 			'VU' => 'Վանուատու',
 			'WF' => 'Ուոլիս և Ֆուտունա',
 			'WS' => 'Սամոա',
 			'XK' => 'Կոսովո',
 			'YE' => 'Եմեն',
 			'YT' => 'Մայոտ',
 			'ZA' => 'Հարավաֆրիկյան Հանրապետություն',
 			'ZM' => 'Զամբիա',
 			'ZW' => 'Զիմբաբվե',
 			'ZZ' => 'Անհայտ տարածաշրջան',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Տոմար',
 			'collation' => 'Տեսակավորման կարգ',
 			'currency' => 'արժույթ',
 			'numbers' => 'թվեր',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{Գրիգորյան տոմար},
 			},
 			'collation' => {
 				'ducet' => q{Սկզբնադիր տեսակավորման կարգ Unicode-ի համար},
 				'search' => q{Ընդհանուր որոնում},
 				'standard' => q{Տեսակավորման ստանդարտ կարգ},
 			},
 			'numbers' => {
 				'arab' => q{արաբա-հնդկական թվեր},
 				'arabext' => q{արաբա-հնդկական թվերի ընդլայնված համակարգ},
 				'armn' => q{հայկական թվեր},
 				'armnlow' => q{հայկական թվեր (փոքրատառ)},
 				'beng' => q{բենգալական թվեր},
 				'deva' => q{դեվանագարի թվեր},
 				'ethi' => q{եթովպական թվեր},
 				'fullwide' => q{թվերի լայն ձևաչափ},
 				'geor' => q{վրացական թվեր},
 				'grek' => q{հունական թվեր},
 				'greklow' => q{հունական թվեր (փոքրատառ)},
 				'gujr' => q{գուջարաթի թվեր},
 				'guru' => q{գուրմուխի թվեր},
 				'hanidec' => q{չինական տասնորդական թվեր},
 				'hans' => q{չինական պարզեցված թվեր},
 				'hansfin' => q{չինական պարզեցված ֆինանսական թվեր},
 				'hant' => q{չինական ավանդական թվեր},
 				'hantfin' => q{չինական ավանդական ֆինանսական թվեր},
 				'hebr' => q{եբրայերեն թվեր},
 				'jpan' => q{ճապոնական թվեր},
 				'jpanfin' => q{ճապոնական ֆինանսական թվեր},
 				'khmr' => q{քմերական թվեր},
 				'knda' => q{կաննադա թվեր},
 				'laoo' => q{լաոսական թվեր},
 				'latn' => q{արևմտյան թվեր},
 				'mlym' => q{մալայալամ թվեր},
 				'mymr' => q{բիրմական թվեր},
 				'orya' => q{օրիյա թվեր},
 				'roman' => q{հռոմեական թվեր},
 				'romanlow' => q{հռոմեական թվեր (փոքրատառ)},
 				'taml' => q{թամիլական ավանդական թվեր},
 				'tamldec' => q{թամիլական թվեր},
 				'telu' => q{թելուգու թվեր},
 				'thai' => q{թայական թվեր},
 				'tibt' => q{տիբեթական թվեր},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Մետրիկ},
 			'UK' => q{Անգլիական},
 			'US' => q{Ամերիկյան},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Լեզու. {0}',
 			'script' => 'Գիր. {0}',
 			'territory' => 'Շրջան. {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['Ա', 'Բ', 'Գ', 'Դ', 'Ե', 'Զ', 'Է', 'Ը', 'Թ', 'Ժ', 'Ի', 'Լ', 'Խ', 'Ծ', 'Կ', 'Հ', 'Ձ', 'Ղ', 'Ճ', 'Մ', 'Յ', 'Ն', 'Շ', 'Ո', 'Չ', 'Պ', 'Ջ', 'Ռ', 'Ս', 'Վ', 'Տ', 'Ր', 'Ց', 'Ւ', 'Փ', 'Ք', 'Օ', 'Ֆ'],
			main => qr{(?^u:[ա բ գ դ ե զ է ը թ ժ ի լ խ ծ կ հ ձ ղ ճ մ յ ն շ ո չ պ ջ ռ ս վ տ ր ց ւ փ ք և օ ֆ])},
			punctuation => qr{(?^u:[֊ , ՝ \: ՜ ՞ . « » ՚ ՛ ՟])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} ակր),
						'other' => q({0} ակր),
					},
					'arc-minute' => {
						'one' => q({0} րոպե),
						'other' => q({0} րոպե),
					},
					'arc-second' => {
						'one' => q({0} վայրկյան),
						'other' => q({0} վայրկյան),
					},
					'celsius' => {
						'one' => q({0} աստիճան ըստ Ցելսիուսի),
						'other' => q({0} աստիճան ըստ Ցելսիուսի),
					},
					'centimeter' => {
						'one' => q({0} սանտիմետր),
						'other' => q({0} սանտիմետր),
					},
					'cubic-kilometer' => {
						'one' => q({0} խորանարդ կիլոմետր),
						'other' => q({0} խորանարդ կիլոմետր),
					},
					'cubic-mile' => {
						'one' => q({0} խորանարդ մղոն),
						'other' => q({0} խորանարդ մղոն),
					},
					'day' => {
						'one' => q({0} օր),
						'other' => q({0} օր),
					},
					'degree' => {
						'one' => q({0} աստիճան),
						'other' => q({0} աստիճան),
					},
					'fahrenheit' => {
						'one' => q({0} աստիճան ըստ Ֆարենհայթի),
						'other' => q({0} աստիճան ըստ Ֆարենհայթի),
					},
					'foot' => {
						'one' => q({0} ֆուտ),
						'other' => q({0} ֆուտ),
					},
					'g-force' => {
						'one' => q({0} ձգողության ուժի արագացում),
						'other' => q({0} ձգողության ուժի արագացում),
					},
					'gram' => {
						'one' => q({0} գրամ),
						'other' => q({0} գրամ),
					},
					'hectare' => {
						'one' => q({0} հեկտար),
						'other' => q({0} հեկտար),
					},
					'hectopascal' => {
						'one' => q({0} հեկտապասկալ),
						'other' => q({0} հեկտապասկալ),
					},
					'horsepower' => {
						'one' => q({0} ձիաուժ),
						'other' => q({0} ձիաուժ),
					},
					'hour' => {
						'one' => q({0} ժամ),
						'other' => q({0} ժամ),
					},
					'inch' => {
						'one' => q({0} դյույմ),
						'other' => q({0} դյույմ),
					},
					'inch-hg' => {
						'one' => q({0} դյույմ սնդիկի սյուն),
						'other' => q({0} դյույմ սնդիկի սյուն),
					},
					'kilogram' => {
						'one' => q({0} կիլոգրամ),
						'other' => q({0} կիլոգրամ),
					},
					'kilometer' => {
						'one' => q({0} կիլոմետր),
						'other' => q({0} կիլոմետր),
					},
					'kilometer-per-hour' => {
						'one' => q({0} կիլոմետր / ժամ),
						'other' => q({0} կիլոմետր / ժամ),
					},
					'kilowatt' => {
						'one' => q({0} կիլովատ),
						'other' => q({0} կիլովատ),
					},
					'light-year' => {
						'one' => q({0} լուսային տարի),
						'other' => q({0} լուսային տարի),
					},
					'liter' => {
						'one' => q({0} լիտր),
						'other' => q({0} լիտր),
					},
					'meter' => {
						'one' => q({0} մետր),
						'other' => q({0} մետր),
					},
					'meter-per-second' => {
						'one' => q({0} մետր / վայրկյան),
						'other' => q({0} մետր / վայրկյան),
					},
					'mile' => {
						'one' => q({0} մղոն),
						'other' => q({0} մղոն),
					},
					'mile-per-hour' => {
						'one' => q({0} մղոն / ժամ),
						'other' => q({0} մղոն / ժամ),
					},
					'millibar' => {
						'one' => q({0} միլիբար),
						'other' => q({0} միլիբար),
					},
					'millimeter' => {
						'one' => q({0} միլիմետր),
						'other' => q({0} միլիմետր),
					},
					'millisecond' => {
						'one' => q({0} միլիվայրկյան),
						'other' => q({0} միլիվայրկյան),
					},
					'minute' => {
						'one' => q({0} րոպե),
						'other' => q({0} րոպե),
					},
					'month' => {
						'one' => q({0} ամիս),
						'other' => q({0} ամիս),
					},
					'ounce' => {
						'one' => q({0} ունցիա),
						'other' => q({0} ունցիա),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} պիկոմետր),
						'other' => q({0} պիկոմետր),
					},
					'pound' => {
						'one' => q({0} ֆունտ),
						'other' => q({0} ֆունտ),
					},
					'second' => {
						'one' => q({0} վայրկյան),
						'other' => q({0} վայրկյան),
					},
					'square-foot' => {
						'one' => q({0} քառակուսի ֆուտ),
						'other' => q({0} քառակուսի ֆուտ),
					},
					'square-kilometer' => {
						'one' => q({0} քառակուսի կիլոմետր),
						'other' => q({0} քառակուսի կիլոմետր),
					},
					'square-meter' => {
						'one' => q({0} քառակուսի մետր),
						'other' => q({0} քառակուսի մետր),
					},
					'square-mile' => {
						'one' => q({0} քառակուսի մղոն),
						'other' => q({0} քառակուսի մղոն),
					},
					'watt' => {
						'one' => q({0} վատ),
						'other' => q({0} վատ),
					},
					'week' => {
						'one' => q({0} շաբաթ),
						'other' => q({0} շաբաթ),
					},
					'yard' => {
						'one' => q({0} յարդ),
						'other' => q({0} յարդ),
					},
					'year' => {
						'one' => q({0} տարի),
						'other' => q({0} տարի),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0}ակր),
						'other' => q({0}ակր),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} սմ),
						'other' => q({0} սմ),
					},
					'cubic-kilometer' => {
						'one' => q({0}կմ³),
						'other' => q({0}կմ³),
					},
					'cubic-mile' => {
						'one' => q({0}մղ³),
						'other' => q({0}մղ³),
					},
					'day' => {
						'one' => q({0}օ.),
						'other' => q({0}օ.),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}G),
					},
					'gram' => {
						'one' => q({0} գր),
						'other' => q({0} գր),
					},
					'hectare' => {
						'one' => q({0}հա),
						'other' => q({0}հա),
					},
					'hectopascal' => {
						'one' => q({0} հՊա),
						'other' => q({0} հՊա),
					},
					'horsepower' => {
						'one' => q({0}ձ/ու),
						'other' => q({0}ձ/ու),
					},
					'hour' => {
						'one' => q({0} ժ.),
						'other' => q({0} ժ.),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0}" ս. ս.),
						'other' => q({0}" ս. ս),
					},
					'kilogram' => {
						'one' => q({0} կգ),
						'other' => q({0} կգ),
					},
					'kilometer' => {
						'one' => q({0} կմ),
						'other' => q({0} կմ),
					},
					'kilometer-per-hour' => {
						'one' => q({0}կմ/ժ),
						'other' => q({0}կմ/ժ),
					},
					'kilowatt' => {
						'one' => q({0}կՎ),
						'other' => q({0}կՎ),
					},
					'light-year' => {
						'one' => q({0} լ. տ.),
						'other' => q({0} լ. տ.),
					},
					'liter' => {
						'one' => q({0}լ.),
						'other' => q({0}լ.),
					},
					'meter' => {
						'one' => q({0} մ),
						'other' => q({0} մ),
					},
					'meter-per-second' => {
						'one' => q({0}մ/վ),
						'other' => q({0}մ/վ),
					},
					'mile' => {
						'one' => q({0} մղ),
						'other' => q({0} մղ),
					},
					'mile-per-hour' => {
						'one' => q({0}մղ/ժ),
						'other' => q({0}մղ/ժ),
					},
					'millibar' => {
						'one' => q({0} մբ),
						'other' => q({0} մբ),
					},
					'millimeter' => {
						'one' => q({0} մմ),
						'other' => q({0} մմ),
					},
					'millisecond' => {
						'one' => q({0}մվ),
						'other' => q({0}մվ),
					},
					'minute' => {
						'one' => q({0} ր.),
						'other' => q({0} ր.),
					},
					'month' => {
						'one' => q({0} ա.),
						'other' => q({0} ա.),
					},
					'ounce' => {
						'one' => q({0} ունց),
						'other' => q({0} ունց),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} պմ),
						'other' => q({0} պմ),
					},
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					'second' => {
						'one' => q({0} վ.),
						'other' => q({0} վ.),
					},
					'square-foot' => {
						'one' => q({0}ֆտ²),
						'other' => q({0}ֆտ²),
					},
					'square-kilometer' => {
						'one' => q({0} կմ²),
						'other' => q({0} կմ²),
					},
					'square-meter' => {
						'one' => q({0} մ²),
						'other' => q({0} մ²),
					},
					'square-mile' => {
						'one' => q({0}մղ²),
						'other' => q({0}մղ²),
					},
					'watt' => {
						'one' => q({0}Վ),
						'other' => q({0}Վ),
					},
					'week' => {
						'one' => q({0} շ.),
						'other' => q({0} շ.),
					},
					'yard' => {
						'one' => q({0} յդ.),
						'other' => q({0} յդ.),
					},
					'year' => {
						'one' => q({0}տ.),
						'other' => q({0}տ.),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} ակր),
						'other' => q({0} ակր),
					},
					'arc-minute' => {
						'one' => q({0} րոպ),
						'other' => q({0} րոպ),
					},
					'arc-second' => {
						'one' => q({0} վրկ),
						'other' => q({0} վրկ),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} սմ),
						'other' => q({0} սմ),
					},
					'cubic-kilometer' => {
						'one' => q({0} կմ³),
						'other' => q({0} կմ³),
					},
					'cubic-mile' => {
						'one' => q({0} մղ³),
						'other' => q({0} մղ³),
					},
					'day' => {
						'one' => q({0} օր),
						'other' => q({0} օր),
					},
					'degree' => {
						'one' => q({0} աստճ.),
						'other' => q({0} աստճ.),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ֆտ.),
						'other' => q({0} ֆտ.),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} գր),
						'other' => q({0} գր),
					},
					'hectare' => {
						'one' => q({0} հա),
						'other' => q({0} հա),
					},
					'hectopascal' => {
						'one' => q({0} հՊա),
						'other' => q({0} հՊա),
					},
					'horsepower' => {
						'one' => q({0} ձ/ու),
						'other' => q({0} ձ/ու),
					},
					'hour' => {
						'one' => q({0} ժ.),
						'other' => q({0} ժ.),
					},
					'inch' => {
						'one' => q({0} դմ.),
						'other' => q({0} դմ.),
					},
					'inch-hg' => {
						'one' => q({0} դյույմ ս. ս.),
						'other' => q({0} դյույմ ս. ս.),
					},
					'kilogram' => {
						'one' => q({0} կգ),
						'other' => q({0} կգ),
					},
					'kilometer' => {
						'one' => q({0} կմ),
						'other' => q({0} կմ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} կմ/ժ),
						'other' => q({0} կմ/ժ),
					},
					'kilowatt' => {
						'one' => q({0} կՎ),
						'other' => q({0} կՎ),
					},
					'light-year' => {
						'one' => q({0} լ. տ.),
						'other' => q({0} լ. տ.),
					},
					'liter' => {
						'one' => q({0} լ.),
						'other' => q({0} լ.),
					},
					'meter' => {
						'one' => q({0} մ),
						'other' => q({0} մ),
					},
					'meter-per-second' => {
						'one' => q({0} մ/վ),
						'other' => q({0} մ/վ),
					},
					'mile' => {
						'one' => q({0} մղ),
						'other' => q({0} մղ),
					},
					'mile-per-hour' => {
						'one' => q({0} մղ/ժ),
						'other' => q({0} մղ/ժ),
					},
					'millibar' => {
						'one' => q({0} մբ),
						'other' => q({0} մբ),
					},
					'millimeter' => {
						'one' => q({0} մմ),
						'other' => q({0} մմ),
					},
					'millisecond' => {
						'one' => q({0} մվ),
						'other' => q({0}մվ),
					},
					'minute' => {
						'one' => q({0} րպ.),
						'other' => q({0} րպ.),
					},
					'month' => {
						'one' => q({0} ամս),
						'other' => q({0} ամս),
					},
					'ounce' => {
						'one' => q({0} ունց),
						'other' => q({0} ունց),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} պմ),
						'other' => q({0} պմ),
					},
					'pound' => {
						'one' => q({0} ֆն.),
						'other' => q({0} ֆն.),
					},
					'second' => {
						'one' => q({0} վրկ),
						'other' => q({0} վրկ),
					},
					'square-foot' => {
						'one' => q({0} քռ. ֆտ.),
						'other' => q({0} քռ. ֆտ.),
					},
					'square-kilometer' => {
						'one' => q({0} կմ²),
						'other' => q({0} կմ²),
					},
					'square-meter' => {
						'one' => q({0} մ²),
						'other' => q({0} մ²),
					},
					'square-mile' => {
						'one' => q({0} քռ. մղ.),
						'other' => q({0} քռ. մղ.),
					},
					'watt' => {
						'one' => q({0} Վ),
						'other' => q({0} Վ),
					},
					'week' => {
						'one' => q({0} շբթ.),
						'other' => q({0} շբթ.),
					},
					'yard' => {
						'one' => q({0} յդ.),
						'other' => q({0} յդ.),
					},
					'year' => {
						'one' => q({0} տր.),
						'other' => q({0} տր.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:այո|ա|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ոչ|ո|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} և {1}),
				2 => q({0} և {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'armn',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#0.###',
				},
				'1000' => {
					'one' => '0 հզր',
					'other' => '0 հզր',
				},
				'10000' => {
					'one' => '00 հզր',
					'other' => '00 հզր',
				},
				'100000' => {
					'one' => '000 հզր',
					'other' => '000 հզր',
				},
				'1000000' => {
					'one' => '0 մլն',
					'other' => '0 մլն',
				},
				'10000000' => {
					'one' => '00 մլն',
					'other' => '00 մլն',
				},
				'100000000' => {
					'one' => '000 մլն',
					'other' => '000 մլն',
				},
				'1000000000' => {
					'one' => '0 մլրդ',
					'other' => '0 մլրդ',
				},
				'10000000000' => {
					'one' => '00 մլրդ',
					'other' => '00 մլրդ',
				},
				'100000000000' => {
					'one' => '000 մլրդ',
					'other' => '000 մլրդ',
				},
				'1000000000000' => {
					'one' => '0 տրլն',
					'other' => '0 տրլն',
				},
				'10000000000000' => {
					'one' => '00 տրլն',
					'other' => '00 տրլն',
				},
				'100000000000000' => {
					'one' => '000 տրլն',
					'other' => '000 տրլն',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 հազար',
					'other' => '0 հազար',
				},
				'10000' => {
					'one' => '00 հազար',
					'other' => '00 հազար',
				},
				'100000' => {
					'one' => '000 հազար',
					'other' => '000 հազար',
				},
				'1000000' => {
					'one' => '0 միլիոն',
					'other' => '0 միլիոն',
				},
				'10000000' => {
					'one' => '00 միլիոն',
					'other' => '00 միլիոն',
				},
				'100000000' => {
					'one' => '000 միլիոն',
					'other' => '000 միլիոն',
				},
				'1000000000' => {
					'one' => '0 միլիարդ',
					'other' => '0 միլիարդ',
				},
				'10000000000' => {
					'one' => '00 միլիարդ',
					'other' => '00 միլիարդ',
				},
				'100000000000' => {
					'one' => '000 միլիարդ',
					'other' => '000 միլիարդ',
				},
				'1000000000000' => {
					'one' => '0 տրիլիոն',
					'other' => '0 տրիլիոն',
				},
				'10000000000000' => {
					'one' => '00 տրիլիոն',
					'other' => '00 տրիլիոն',
				},
				'100000000000000' => {
					'one' => '000 տրիլիոն',
					'other' => '000 տրիլիոն',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 հզր',
					'other' => '0 հզր',
				},
				'10000' => {
					'one' => '00 հզր',
					'other' => '00 հզր',
				},
				'100000' => {
					'one' => '000 հզր',
					'other' => '000 հզր',
				},
				'1000000' => {
					'one' => '0 մլն',
					'other' => '0 մլն',
				},
				'10000000' => {
					'one' => '00 մլն',
					'other' => '00 մլն',
				},
				'100000000' => {
					'one' => '000 մլն',
					'other' => '000 մլն',
				},
				'1000000000' => {
					'one' => '0 մլրդ',
					'other' => '0 մլրդ',
				},
				'10000000000' => {
					'one' => '00 մլրդ',
					'other' => '00 մլրդ',
				},
				'100000000000' => {
					'one' => '000 մլրդ',
					'other' => '000 մլրդ',
				},
				'1000000000000' => {
					'one' => '0 տրլն',
					'other' => '0 տրլն',
				},
				'10000000000000' => {
					'one' => '00 տրլն',
					'other' => '00 տրլն',
				},
				'100000000000000' => {
					'one' => '000 տրլն',
					'other' => '000 տրլն',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '#0.00 ¤',
						'positive' => '#0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(Արաբական Միացյալ Էմիրությունների դիրհամ),
				'one' => q(Արաբական Միացյալ Էմիրությունների դիրհամ),
				'other' => q(Արաբական Միացյալ Էմիրությունների դիրհամ),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Աֆղանական աֆղանի),
				'one' => q(Աֆղանական աֆղանի),
				'other' => q(Աֆղանական աֆղանի),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Ալբանական լեկ),
				'one' => q(Ալբանական լեկ),
				'other' => q(Ալբանական լեկ),
			},
		},
		'AMD' => {
			symbol => 'դր.',
			display_name => {
				'currency' => q(Հայկական դրամ),
				'one' => q(Հայկական դրամ),
				'other' => q(Հայկական դրամ),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Նիդերլանդական Անտիլների գուլդեն),
				'one' => q(Նիդերլանդական Անտիլների գուլդեն),
				'other' => q(Նիդերլանդական Անտիլների գուլդեն),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Անգոլական կվանզա),
				'one' => q(Անգոլական կվանզա),
				'other' => q(Անգոլական կվանզա),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Արգենտինական պեսո),
				'one' => q(Արգենտինական պեսո),
				'other' => q(Արգենտինական պեսո),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(Ավստրալական դոլար),
				'one' => q(Ավստրալական դոլար),
				'other' => q(Ավստրալական դոլար),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Արուբական ֆլորին),
				'one' => q(Արուբական ֆլորին),
				'other' => q(Արուբական ֆլորին),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Ադրբեջանական մանաթ),
				'one' => q(Ադրբեջանական մանաթ),
				'other' => q(Ադրբեջանական մանաթ),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Բոսնիա և Հերցեգովինայի փոխարկելի մարկա),
				'one' => q(Բոսնիա և Հերցեգովինայի փոխարկելի մարկա),
				'other' => q(Բոսնիա և Հերցեգովինայի փոխարկելի մարկա),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Բարբադոսյան դոլար),
				'one' => q(Բարբադոսյան դոլար),
				'other' => q(Բարբադոսյան դոլար),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Բանգլադեշի տակա),
				'one' => q(Բանգլադեշի տակա),
				'other' => q(Բանգլադեշի տակա),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Բուլղարական լև),
				'one' => q(Բուլղարական լև),
				'other' => q(Բուլղարական լև),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Բահրեյնական դինար),
				'one' => q(Բահրեյնական դինար),
				'other' => q(Բահրեյնական դինար),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Բուրունդիի ֆրանկ),
				'one' => q(Բուրունդիի ֆրանկ),
				'other' => q(Բուրունդիի ֆրանկ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Բերմուդյան դոլար),
				'one' => q(Բերմուդյան դոլար),
				'other' => q(Բերմուդյան դոլար),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Բրունեյական դոլար),
				'one' => q(Բրունեյական դոլար),
				'other' => q(Բրունեյական դոլար),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Բոլիվիական բոլիվիանո),
				'one' => q(Բոլիվիական բոլիվիանո),
				'other' => q(Բոլիվիական բոլիվիանո),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Բրազիլական ռեալ),
				'one' => q(Բրազիլական ռեալ),
				'other' => q(Բրազիլական ռեալ),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Բահամական դոլար),
				'one' => q(Բահամական դոլար),
				'other' => q(Բահամական դոլար),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Բութանական նգուլտրում),
				'one' => q(Բութանական նգուլտրում),
				'other' => q(Բութանական նգուլտրում),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Բոթսվանական պուլա),
				'one' => q(Բոթսվանական պուլա),
				'other' => q(Բոթսվանական պուլա),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Բելառուսական ռուբլի),
				'one' => q(Բելառուսական ռուբլի),
				'other' => q(Բելառուսական ռուբլի),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Բելիզի դոլար),
				'one' => q(Բելիզի դոլար),
				'other' => q(Բելիզի դոլար),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Կանադական դոլար),
				'one' => q(Կանադական դոլար),
				'other' => q(Կանադական դոլար),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Կոնգոյի ֆրանկ),
				'one' => q(Կոնգոյի ֆրանկ),
				'other' => q(Կոնգոյի ֆրանկ),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Շվեյցարական ֆրանկ),
				'one' => q(Շվեյցարական ֆրանկ),
				'other' => q(Շվեյցարական ֆրանկ),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Չիլիական պեսո),
				'one' => q(Չիլիական պեսո),
				'other' => q(Չիլիական պեսո),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Չինական յուան),
				'one' => q(Չինական յուան),
				'other' => q(Չինական յուան),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Կոլումբիական պեսո),
				'one' => q(Կոլումբիական պեսո),
				'other' => q(Կոլումբիական պեսո),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Կոստա Ռիկայի կոլոն),
				'one' => q(Կոստա Ռիկայի կոլոն),
				'other' => q(Կոստա Ռիկայի կոլոն),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Կուբական փոխարկելի պեսո),
				'one' => q(Կուբական փոխարկելի պեսո),
				'other' => q(Կուբական փոխարկելի պեսո),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Կուբական պեսո),
				'one' => q(Կուբական պեսո),
				'other' => q(Կուբական պեսո),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Կաբո Վերդեի էսկուդո),
				'one' => q(Կաբո Վերդեի էսկուդո),
				'other' => q(Կաբո Վերդեի էսկուդո),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Չեխական կրոնա),
				'one' => q(Չեխական կրոնա),
				'other' => q(Չեխական կրոնա),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Ջիբութիի ֆրանկ),
				'one' => q(Ջիբութիի ֆրանկ),
				'other' => q(Ջիբութիի ֆրանկ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Դանիական կրոնա),
				'one' => q(Դանիական կրոնա),
				'other' => q(Դանիական կրոնա),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Դոմինիկական պեսո),
				'one' => q(Դոմինիկական պեսո),
				'other' => q(Դոմինիկական պեսո),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Ալժիրական դինար),
				'one' => q(Ալժիրական դինար),
				'other' => q(Ալժիրական դինար),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Եգիպտական ֆունտ),
				'one' => q(Եգիպտական ֆունտ),
				'other' => q(Եգիպտական ֆունտ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Էրիթրեական նակֆա),
				'one' => q(Էրիթրեական նակֆա),
				'other' => q(Էրիթրեական նակֆա),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Եթովպական բիր),
				'one' => q(Եթովպական բիր),
				'other' => q(Եթովպական բիր),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Եվրո),
				'one' => q(Եվրո),
				'other' => q(Եվրո),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Ֆիջիական դոլար),
				'one' => q(Ֆիջիական դոլար),
				'other' => q(Ֆիջիական դոլար),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Ֆոլկլենդյան կղզիներ ֆունտ),
				'one' => q(Ֆոլկլենդյան կղզիներ ֆունտ),
				'other' => q(Ֆոլկլենդյան կղզիներ ֆունտ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Բրիտանական ֆունտ ստեռլինգ),
				'one' => q(Բրիտանական ֆունտ ստեռլինգ),
				'other' => q(Բրիտանական ֆունտ ստեռլինգ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Վրացական լարի),
				'one' => q(Վրացական լարի),
				'other' => q(Վրացական լարի),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Գանական սեդի),
				'one' => q(Գանական սեդի),
				'other' => q(Գանական սեդի),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Ջիբրալթարի ֆունտ),
				'one' => q(Ջիբրալթարի ֆունտ),
				'other' => q(Ջիբրալթարի ֆունտ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Գամբիական դալասի),
				'one' => q(Գամբիական դալասի),
				'other' => q(Գամբիական դալասի),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Գվինեական ֆրանկ),
				'one' => q(Գվինեական ֆրանկ),
				'other' => q(Գվինեական ֆրանկ),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Գվատեմալական կետսալ),
				'one' => q(Գվատեմալական կետսալ),
				'other' => q(Գվատեմալական կետսալ),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Գայանական դոլար),
				'one' => q(Գայանական դոլար),
				'other' => q(Գայանական դոլար),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Հոնկոնգի դոլար),
				'one' => q(Հոնկոնգի դոլար),
				'other' => q(Հոնկոնգի դոլար),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Հոնդուրասական լեմպրիա),
				'one' => q(Հոնդուրասական լեմպրիա),
				'other' => q(Հոնդուրասական լեմպրիա),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Խորվաթական կունա),
				'one' => q(Խորվաթական կունա),
				'other' => q(Խորվաթական կունա),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Հաիթյան գուրդ),
				'one' => q(Հաիթյան գուրդ),
				'other' => q(Հաիթյան գուրդ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Հունգարական ֆորինտ),
				'one' => q(Հունգարական ֆորինտ),
				'other' => q(Հունգարական ֆորինտ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Ինդոնեզական ռուփի),
				'one' => q(Ինդոնեզական ռուփի),
				'other' => q(Ինդոնեզական ռուփի),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Իսրայելի նոր շեկել),
				'one' => q(Իսրայելի նոր շեկել),
				'other' => q(Իսրայելի նոր շեկել),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Հնդկական ռուփի),
				'one' => q(Հնդկական ռուփի),
				'other' => q(Հնդկական ռուփի),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Իրաքյան դինար),
				'one' => q(Իրաքյան դինար),
				'other' => q(Իրաքյան դինար),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Իրանական ռիալ),
				'one' => q(Իրանական ռիալ),
				'other' => q(Իրանական ռիալ),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Իսլանդական կրոնա),
				'one' => q(Իսլանդական կրոնա),
				'other' => q(Իսլանդական կրոնա),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Ջամայկական դոլար),
				'one' => q(Ջամայկական դոլար),
				'other' => q(Ջամայկական դոլար),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Հորդանանական դինար),
				'one' => q(Հորդանանական դինար),
				'other' => q(Հորդանանական դինար),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(Ճապոնական իեն),
				'one' => q(Ճապոնական իեն),
				'other' => q(Ճապոնական իեն),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Քենիական շիլինգ),
				'one' => q(Քենիական շիլինգ),
				'other' => q(Քենիական շիլինգ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Ղրղզական սոմ),
				'one' => q(Ղրղզական սոմ),
				'other' => q(Ղրղզական սոմ),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Կամբոջական ռիել),
				'one' => q(Կամբոջական ռիել),
				'other' => q(Կամբոջական ռիել),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Կոմորյան կղզիների ֆրանկ),
				'one' => q(Կոմորյան կղզիների ֆրանկ),
				'other' => q(Կոմորյան կղզիների ֆրանկ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ԿԺԴՀ-ի վոնա),
				'one' => q(ԿԺԴՀ-ի վոնա),
				'other' => q(ԿԺԴՀ-ի վոնա),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(Հարավկորեական վոնա),
				'one' => q(Հարավկորեական վոնա),
				'other' => q(Հարավկորեական վոնա),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Քուվեյթական դինար),
				'one' => q(Քուվեյթական դինար),
				'other' => q(Քուվեյթական դինար),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Կայմանյան կղզիների դոլար),
				'one' => q(Կայմանյան կղզիների դոլար),
				'other' => q(Կայմանյան կղզիների դոլար),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Ղազախական տենգե),
				'one' => q(Ղազախական տենգե),
				'other' => q(Ղազախական տենգե),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Լաոսական կիպ),
				'one' => q(Լաոսական կիպ),
				'other' => q(Լաոսական կիպ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Լիբանանական ֆունտ),
				'one' => q(Լիբանանական ֆունտ),
				'other' => q(Լիբանանական ֆունտ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Լանկիական ռուփի),
				'one' => q(Լանկիական ռուփի),
				'other' => q(Լանկիական ռուփի),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Լիբերիական դոլար),
				'one' => q(Լիբերիական դոլար),
				'other' => q(Լիբերիական դոլար),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Լիտվական լիտ),
				'one' => q(Լիտվական լիտ),
				'other' => q(Լիտվական լիտ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Լատվիական լատ),
				'one' => q(Լատվիական լատ),
				'other' => q(Լատվիական լատ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Լիբիական դինար),
				'one' => q(Լիբիական դինար),
				'other' => q(Լիբիական դինար),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Մարոկական դիրհամ),
				'one' => q(Մարոկական դիրհամ),
				'other' => q(Մարոկական դիրհամ),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Մոլդովական լեյ),
				'one' => q(Մոլդովական լեյ),
				'other' => q(Մոլդովական լեյ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Մադագասկարի արիարի),
				'one' => q(Մադագասկարի արիարի),
				'other' => q(Մադագասկարի արիարի),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Մակեդոնական դենար),
				'one' => q(Մակեդոնական դենար),
				'other' => q(Մակեդոնական դենար),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Մյանմական կյատ),
				'one' => q(Մյանմական կյատ),
				'other' => q(Մյանմական կյատ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Մոնղոլական տուգրիկ),
				'one' => q(Մոնղոլական տուգրիկ),
				'other' => q(Մոնղոլական տուգրիկ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Մակաոյի պատակա),
				'one' => q(Մակաոյի պատակա),
				'other' => q(Մակաոյի պատակա),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Մավրիտանական ուգիյա),
				'one' => q(Մավրիտանական ուգիյա),
				'other' => q(Մավրիտանական ուգիյա),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Մավրիկական ռուփի),
				'one' => q(Մավրիկական ռուփի),
				'other' => q(Մավրիկական ռուփի),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Մալդիվյան ռուֆիա),
				'one' => q(Մալդիվյան ռուֆիա),
				'other' => q(Մալդիվյան ռուֆիա),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Մալավիական կվաչա),
				'one' => q(Մալավիական կվաչա),
				'other' => q(Մալավիական կվաչա),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Մեքսիկական պեսո),
				'one' => q(Մեքսիկական պեսո),
				'other' => q(Մեքսիկական պեսո),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Մալայզիական ռինգիտ),
				'one' => q(Մալայզիական ռինգիտ),
				'other' => q(Մալայզիական ռինգիտ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Մոզամբիկյան մետիկալ),
				'one' => q(Մոզամբիկյան մետիկալ),
				'other' => q(Մոզամբիկյան մետիկալ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Նամիբիական դոլար),
				'one' => q(Նամիբիական դոլար),
				'other' => q(Նամիբիական դոլար),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Նիգերիական նայրա),
				'one' => q(Նիգերիական նայրա),
				'other' => q(Նիգերիական նայրա),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Նիկարագուական կորդոբա),
				'one' => q(Նիկարագուական կորդոբա),
				'other' => q(Նիկարագուական կորդոբա),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Նորվեգական կրոնա),
				'one' => q(Նորվեգական կրոնա),
				'other' => q(Նորվեգական կրոնա),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Նեպալական ռուփի),
				'one' => q(Նեպալական ռուփի),
				'other' => q(Նեպալական ռուփի),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(Նորզելանդական դոլար),
				'one' => q(Նորզելանդական դոլար),
				'other' => q(Նորզելանդական դոլար),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Օմանական ռիալ),
				'one' => q(Օմանական ռիալ),
				'other' => q(Օմանական ռիալ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Պանամական բալբոա),
				'one' => q(Պանամական բալբոա),
				'other' => q(Պանամական բալբոա),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Պերուի նոր սոլ),
				'one' => q(Պերուի նոր սոլ),
				'other' => q(Պերուի նոր սոլ),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Պապուա-Նոր Գվինեայի կինա),
				'one' => q(Պապուա-Նոր Գվինեայի կինա),
				'other' => q(Պապուա-Նոր Գվինեայի կինա),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Ֆիլիպինական պեսո),
				'one' => q(Ֆիլիպինական պեսո),
				'other' => q(Ֆիլիպինական պեսո),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Պակիստանական ռուփի),
				'one' => q(Պակիստանական ռուփի),
				'other' => q(Պակիստանական ռուփի),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Լեհական զլոտի),
				'one' => q(Լեհական զլոտի),
				'other' => q(Լեհական զլոտի),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Պարագվայական գուարանի),
				'one' => q(Պարագվայական գուարանի),
				'other' => q(Պարագվայական գուարանի),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Քաթարական ռիալ),
				'one' => q(Քաթարական ռիալ),
				'other' => q(Քաթարական ռիալ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Ռումինական լեյ),
				'one' => q(Ռումինական լեյ),
				'other' => q(Ռումինական լեյ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Սերբական դինար),
				'one' => q(Սերբական դինար),
				'other' => q(Սերբական դինար),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Ռուսական ռուբլի),
				'one' => q(Ռուսական ռուբլի),
				'other' => q(Ռուսական ռուբլի),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Ռուանդական ֆրանկ),
				'one' => q(Ռուանդական ֆրանկ),
				'other' => q(Ռուանդական ֆրանկ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Սաուդյան Արաբիայի ռիալ),
				'one' => q(Սաուդյան Արաբիայի ռիալ),
				'other' => q(Սաուդյան Արաբիայի ռիալ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Սողոմոնյան կղզիների դոլար),
				'one' => q(Սողոմոնյան կղզիների դոլար),
				'other' => q(Սողոմոնյան կղզիների դոլար),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Սեյշելյան կղզիների ռուփի),
				'one' => q(Սեյշելյան կղզիների ռուփի),
				'other' => q(Սեյշելյան կղզիների ռուփի),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Սուդանական ֆունտ),
				'one' => q(Սուդանական ֆունտ),
				'other' => q(Սուդանական ֆունտ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Շվեդական կրոնա),
				'one' => q(Շվեդական կրոնա),
				'other' => q(Շվեդական կրոնա),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Սինգապուրյան դոլար),
				'one' => q(Սինգապուրյան դոլար),
				'other' => q(Սինգապուրյան դոլար),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Սուրբ Հեղինեի կղզու ֆունտ),
				'one' => q(Սուրբ Հեղինեի կղզու ֆունտ),
				'other' => q(Սուրբ Հեղինեի կղզու ֆունտ),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Սիերա-Լեոնեի լեոնե),
				'one' => q(Սիերա-Լեոնեի լեոնե),
				'other' => q(Սիերա-Լեոնեի լեոնե),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Սոմալիական շիլինգ),
				'one' => q(Սոմալիական շիլինգ),
				'other' => q(Սոմալիական շիլինգ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Սուրինամական դոլար),
				'one' => q(Սուրինամական դոլար),
				'other' => q(Սուրինամական դոլար),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Հարավսուդանական ֆունտ),
				'one' => q(Հարավսուդանական ֆունտ),
				'other' => q(Հարավսուդանական ֆունտ),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Սան Տոմե և Պրինսիպիի դոբրա),
				'one' => q(Սան Տոմե և Պրինսիպիի դոբրա),
				'other' => q(Սան Տոմե և Պրինսիպիի դոբրա),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Սիրիական ֆունտ),
				'one' => q(Սիրիական ֆունտ),
				'other' => q(Սիրիական ֆունտ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Սվազիլենդական լիլանգենի),
				'one' => q(Սվազիլենդական լիլանգենի),
				'other' => q(Սվազիլենդական լիլանգենի),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Թաիլանդական բատ),
				'one' => q(Թաիլանդական բատ),
				'other' => q(Թաիլանդական բատ),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Տաջիկական սոմոնի),
				'one' => q(Տաջիկական սոմոնի),
				'other' => q(Տաջիկական սոմոնի),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Թուրքմենական մանաթ),
				'one' => q(Թուրքմենական մանաթ),
				'other' => q(Թուրքմենական մանաթ),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Թունիսական դինար),
				'one' => q(Թունիսական դինար),
				'other' => q(Թունիսական դինար),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Տոնգայի պաանգա),
				'one' => q(Տոնգայի պաանգա),
				'other' => q(Տոնգայի պաանգա),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Թուրքական լիրա),
				'one' => q(Թուրքական լիրա),
				'other' => q(Թուրքական լիրա),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Տրինիդադ և Տոբագոյի դոլար),
				'one' => q(Տրինիդադ և Տոբագոյի դոլար),
				'other' => q(Տրինիդադ և Տոբագոյի դոլար),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Թայվանական նոր դոլար),
				'one' => q(Թայվանական նոր դոլար),
				'other' => q(Թայվանական նոր դոլար),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Տանզանիական շիլինգ),
				'one' => q(Տանզանիական շիլինգ),
				'other' => q(Տանզանիական շիլինգ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Ուկրաինական գրիվնա),
				'one' => q(Ուկրաինական գրիվնա),
				'other' => q(Ուկրաինական գրիվնա),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Ուգանդական շիլինգ),
				'one' => q(Ուգանդական շիլինգ),
				'other' => q(Ուգանդական շիլինգ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(ԱՄՆ դոլար),
				'one' => q(ԱՄՆ դոլար),
				'other' => q(ԱՄՆ դոլար),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Ուրուգվայական պեսո),
				'one' => q(Ուրուգվայական պեսո),
				'other' => q(Ուրուգվայական պեսո),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Ուզբեկական սում),
				'one' => q(Ուզբեկական սում),
				'other' => q(Ուզբեկական սում),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Վենեսուելական բոլիվար),
				'one' => q(Վենեսուելական բոլիվար),
				'other' => q(Վենեսուելական բոլիվար),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Վիետնամական դոնգ),
				'one' => q(Վիետնամական դոնգ),
				'other' => q(Վիետնամական դոնգ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Վանուատուի վատու),
				'one' => q(Վանուատուի վատու),
				'other' => q(Վանուատուի վատու),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Սամոական տալա),
				'one' => q(Սամոական տալա),
				'other' => q(Սամոական տալա),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Աֆրիկական ֆինանսական համայնքի ֆրանկ BEAC),
				'one' => q(Աֆրիկական ֆինանսական համայնքի ֆրանկ BEAC),
				'other' => q(Աֆրիկական ֆինանսական համայնքի ֆրանկ BEAC),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Արևելակարիբյան դոլար),
				'one' => q(Արևելակարիբյան դոլար),
				'other' => q(Արևելակարիբյան դոլար),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Աֆրիկական ֆինանսական համայնքի ֆրանկ BCEAO),
				'one' => q(Աֆրիկական ֆինանսական համայնքի ֆրանկ BCEAO),
				'other' => q(Աֆրիկական ֆինանսական համայնքի ֆրանկ BCEAO),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ԿՊՖ ֆրանկ),
				'one' => q(ԿՊՖ ֆրանկ),
				'other' => q(ԿՊՖ ֆրանկ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Անհայտ արժույթ),
				'one' => q(\(անհայտ արժույթ\)),
				'other' => q(\(անհայտ արժույթ\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Եմենական ռիալ),
				'one' => q(Եմենական ռիալ),
				'other' => q(Եմենական ռիալ),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Հարավաֆրիկական ռենդ),
				'one' => q(Հարավաֆրիկական ռենդ),
				'other' => q(Հարավաֆրիկական ռենդ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Զամբիական կվաչա \(1968–2012\)),
				'one' => q(Զամբիական կվաչա \(1968–2012\)),
				'other' => q(Զամբիական կվաչա \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Զամբիական կվաչա),
				'one' => q(Զամբիական կվաչա),
				'other' => q(Զամբիական կվաչա),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'հնվ',
							'փտվ',
							'մրտ',
							'ապր',
							'մյս',
							'հնս',
							'հլս',
							'օգս',
							'սպտ',
							'հկտ',
							'նյմ',
							'դկտ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Հ',
							'Փ',
							'Մ',
							'Ա',
							'Մ',
							'Հ',
							'Հ',
							'Օ',
							'Ս',
							'Հ',
							'Ն',
							'Դ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'հունվարի',
							'փետրվարի',
							'մարտի',
							'ապրիլի',
							'մայիսի',
							'հունիսի',
							'հուլիսի',
							'օգոստոսի',
							'սեպտեմբերի',
							'հոկտեմբերի',
							'նոյեմբերի',
							'դեկտեմբերի'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'հնվ',
							'փտվ',
							'մրտ',
							'ապր',
							'մյս',
							'հնս',
							'հլս',
							'օգս',
							'սպտ',
							'հկտ',
							'նյմ',
							'դկտ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Հ',
							'Փ',
							'Մ',
							'Ա',
							'Մ',
							'Հ',
							'Հ',
							'Օ',
							'Ս',
							'Հ',
							'Ն',
							'Դ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'հունվար',
							'փետրվար',
							'մարտ',
							'ապրիլ',
							'մայիս',
							'հունիս',
							'հուլիս',
							'օգոստոս',
							'սեպտեմբեր',
							'հոկտեմբեր',
							'նոյեմբեր',
							'դեկտեմբեր'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'երկ',
						tue => 'երք',
						wed => 'չրք',
						thu => 'հնգ',
						fri => 'ուր',
						sat => 'շբթ',
						sun => 'կիր'
					},
					narrow => {
						mon => 'Ե',
						tue => 'Ե',
						wed => 'Չ',
						thu => 'Հ',
						fri => 'Ու',
						sat => 'Շ',
						sun => 'Կ'
					},
					short => {
						mon => 'երկ',
						tue => 'երք',
						wed => 'չրք',
						thu => 'հնգ',
						fri => 'ուր',
						sat => 'շբթ',
						sun => 'կիր'
					},
					wide => {
						mon => 'երկուշաբթի',
						tue => 'երեքշաբթի',
						wed => 'չորեքշաբթի',
						thu => 'հինգշաբթի',
						fri => 'ուրբաթ',
						sat => 'շաբաթ',
						sun => 'կիրակի'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'երկ',
						tue => 'երք',
						wed => 'չրք',
						thu => 'հնգ',
						fri => 'ուր',
						sat => 'շբթ',
						sun => 'կիր'
					},
					narrow => {
						mon => 'Ե',
						tue => 'Ե',
						wed => 'Չ',
						thu => 'Հ',
						fri => 'Ու',
						sat => 'Շ',
						sun => 'Կ'
					},
					short => {
						mon => 'եկ',
						tue => 'եք',
						wed => 'չր',
						thu => 'հգ',
						fri => 'ուր',
						sat => 'շբ',
						sun => 'կր'
					},
					wide => {
						mon => 'երկուշաբթի',
						tue => 'երեքշաբթի',
						wed => 'չորեքշաբթի',
						thu => 'հինգշաբթի',
						fri => 'ուրբաթ',
						sat => 'շաբաթ',
						sun => 'կիրակի'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-ին եռմս.',
						1 => '2-րդ եռմս.',
						2 => '3-րդ եռմս.',
						3 => '4-րդ եռմս.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-ին եռամսյակ',
						1 => '2-րդ եռամսյակ',
						2 => '3-րդ եռամսյակ',
						3 => '4-րդ եռամսյակ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-ին եռմս.',
						1 => '2-րդ եռմս.',
						2 => '3-րդ եռմս.',
						3 => '4-րդ եռմս.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-ին եռամսյակ',
						1 => '2-րդ եռամսյակ',
						2 => '3-րդ եռամսյակ',
						3 => '4-րդ եռամսյակ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'pm' => q{կեսօրից հետո},
					'am' => q{կեսօրից առաջ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'մ.թ.ա.',
				'1' => 'մ.թ.'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{d MMMM, y թ. G, EEEE},
			'long' => q{dd MMMM, y թ. G},
			'medium' => q{dd MMM, y թ. G},
			'short' => q{dd.MM.y GGGGG},
		},
		'gregorian' => {
			'full' => q{yթ. MMMM d, EEEE},
			'long' => q{dd MMMM, yթ.},
			'medium' => q{dd MMM, y թ.},
			'short' => q{dd.MM.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H:mm:ss, zzzz},
			'long' => q{H:mm:ss, z},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ed => q{d, ccc},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{G yթ.},
			GyMMM => q{G yթ. LLL},
			GyMMMEd => q{G yթ. MMM d, E},
			GyMMMd => q{d MMM, yթ.,},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{dd.MM, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM.y},
			yMEd => q{d.MM.yթ., E},
			yMMM => q{yթ. LLL},
			yMMMEd => q{yթ. MMM d, E},
			yMMMd => q{d MMM, yթ.},
			yMd => q{dd.MM.y},
			yQQQ => q{y թ, QQQ},
			yQQQQ => q{y թ, QQQQ},
		},
		'generic' => {
			Ed => q{d, ccc},
			Gy => q{G yթ.},
			GyMMM => q{G yթ. LLL},
			GyMMMEd => q{G yթ. MMM d, E},
			GyMMMd => q{G yթ. MMM d},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{dd.MM, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y, G},
			yyyy => q{y, G},
			yyyyM => q{G yթ. MM},
			yyyyMEd => q{d.MM.y թ., G, E},
			yyyyMMM => q{G y թ. LLL},
			yyyyMMMEd => q{d MMM, y թ. G, E},
			yyyyMMMd => q{d MMM, y թ., G},
			yyyyMd => q{d.M.yթ., G},
			yyyyQQQ => q{G y թ, QQQ},
			yyyyQQQQ => q{G y թ, QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0}, {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{H-H},
			},
			Hm => {
				H => q{H:mm-H:mm},
				m => q{H:mm-H:mm},
			},
			Hmv => {
				H => q{H:mm-H:mm, v},
				m => q{H:mm-H:mm, v},
			},
			Hv => {
				H => q{H-H, v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, dd.MM - E, dd.MM},
				d => q{E, dd.MM - E, dd.MM},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, MMM dd - E, MMM dd},
				d => q{E, MMM dd - E, MMM dd},
			},
			MMMd => {
				M => q{MMM dd - MMM dd},
				d => q{MMM dd-dd},
			},
			Md => {
				M => q{dd.MM - dd.MM},
				d => q{dd.MM - dd.MM},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a, v},
				h => q{h:mm-h:mm a, v},
				m => q{h:mm-h:mm a, v},
			},
			hv => {
				a => q{h a – h a, v},
				h => q{h-h a, v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{MM.y - MM.y},
				y => q{MM.y - MM.y},
			},
			yMEd => {
				M => q{ccc, dd.MM.y - ccc, dd.MM.y},
				d => q{ccc, dd.MM.y - ccc, dd.MM.y},
				y => q{ccc, dd.MM.y - ccc, dd.MM.y},
			},
			yMMM => {
				M => q{MMM-MMM yթ.},
				y => q{MMM y - MMM yթ.},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM, yթ.},
				d => q{E, d MMM - E, d MMM, yթ.},
				y => q{E, d MMM, y - E, d MMM, yթ.},
			},
			yMMMM => {
				M => q{yթ. MMM – MMM},
				y => q{MMM y - MMM yթ.},
			},
			yMMMd => {
				M => q{dd MMM - dd MMM, yթ.},
				d => q{dd-dd MMM, yթ.},
				y => q{dd MMM, y - dd MMM, yթ.},
			},
			yMd => {
				M => q{dd.MM.y - dd.MM.y},
				d => q{dd.MM.y - dd.MM.y},
				y => q{dd.MM.y - dd.MM.y},
			},
		},
		'generic' => {
			H => {
				H => q{H-H},
			},
			Hm => {
				H => q{H:mm-H:mm},
				m => q{H:mm-H:mm},
			},
			Hmv => {
				H => q{H:mm-H:mm v},
				m => q{H:mm-H:mm v},
			},
			Hv => {
				H => q{H-H v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, dd.MM - E, dd.MM},
				d => q{E, dd.MM - E, dd.MM},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, MMM dd - E, MMM dd},
				d => q{E, MMM dd - E, MMM dd},
			},
			MMMd => {
				M => q{MMM dd - MMM dd},
				d => q{MMM dd-dd},
			},
			Md => {
				M => q{dd.MM - dd.MM},
				d => q{dd.MM - dd.MM},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y G},
			},
			yM => {
				M => q{MM.y - MM.y G},
				y => q{MM.y - MM.y G},
			},
			yMEd => {
				M => q{ccc, dd.MM.y - ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y - ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y - ccc, dd.MM.y G},
			},
			yMMM => {
				M => q{MMM-MMM y թ. G},
				y => q{MMM y - MMM y թ. G},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM, y թ. G},
				d => q{E, d MMM - E, d MMM, y թ. G},
				y => q{E, d MMM, y - E, d MMM, y թ. G},
			},
			yMMMM => {
				M => q{G y թ. MMM – MMM},
				y => q{MMM y - MMM y թ G},
			},
			yMMMd => {
				M => q{dd MMM - dd MMM, y թ. G},
				d => q{dd-dd MMM, y թ. G},
				y => q{dd MMM, y - dd MMM, y թ. G},
			},
			yMd => {
				M => q{dd.MM.y - dd.MM.y G},
				d => q{dd.MM.y - dd.MM.y G},
				y => q{dd.MM.y - dd.MM.y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(Ժամանակ՝ {0}),
		regionFormat => q({0}, ամառային ժամանակ),
		regionFormat => q({0}, ստանդարտ ժամանակ),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(Աֆղանստանի ժամանակ),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Աբիջան#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Ակրա#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Ադիս Աբեբա#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Ալժիր#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Ասմարա#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Բամակո#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Բանգի#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Բանժուլ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Բիսաու#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Բլանթայր#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Բրազավիլ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Բուժումբուրա#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Կահիրե#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Կասաբլանկա#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Սեուտա#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Կոնակրի#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Դակար#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Դար-Էս-Սալամ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Ջիբութի#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Դուալա#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Էլ Այուն#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Ֆրիթաուն#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Գաբորոնե#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Հարարե#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Յոհանեսբուրգ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Ջուբա#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Կամպալա#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Խարթում#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Կիգալի#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Կինշասա#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Լագոս#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Լիբրևիլ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Լոմե#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Լուանդա#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Լուբումբաշի#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Լուսակա#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Մալաբո#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Մապուտու#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Մասերու#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Մբաբանե#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Մոգադիշո#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Մոնրովիա#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Նայրոբի#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Նջամենա#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Նիամեյ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Նուակշոտ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Ուագադուգու#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Պորտո Նովո#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Սան Տոմե#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Տրիպոլի#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Թունիս#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Վինդհուկ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Կենտրոնաաֆրիկյան ժամանակ),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Արևելաաֆրիկյան ժամանակ),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Հարավաֆրիկյան ժամանակ),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Արևմտաաֆրիկյան ամառային ժամանակ),
				'generic' => q(Արևմտաաֆրիկյան ժամանակ),
				'standard' => q(Արևմտաաֆրիկյան ստանդարտ ժամանակ),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Ալյասկայի ամառային ժամանակ),
				'generic' => q(Ալյասկայի ժամանակ),
				'standard' => q(Ալյասկայի ստանդարտ ժամանակ),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Ամազոնյան ամառային ժամանակ),
				'generic' => q(Ամազոնյան ժամանակ),
				'standard' => q(Ամազոնյան ստանդարտ ժամանակ),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Ադակ կղզի#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Անքորիջ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Անգիլիա#,
		},
		'America/Antigua' => {
			exemplarCity => q#Անտիգուա#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Արագուայնա#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Լա-Ռիոխա#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Ռիո Գալյեգոս#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Սալտա#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Սան Խուան#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Սան Լուիս#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Տուկուման#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ուշուայա#,
		},
		'America/Aruba' => {
			exemplarCity => q#Արուբա#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Ասունսյոն#,
		},
		'America/Bahia' => {
			exemplarCity => q#Բայա#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Բայա Բանդերաս#,
		},
		'America/Barbados' => {
			exemplarCity => q#Բարբադոս#,
		},
		'America/Belem' => {
			exemplarCity => q#Բելեմ#,
		},
		'America/Belize' => {
			exemplarCity => q#Բելիզ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Բլան-Սաբլոն#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Բոա-Վիստա#,
		},
		'America/Bogota' => {
			exemplarCity => q#Բոգոտա#,
		},
		'America/Boise' => {
			exemplarCity => q#Բոյսե#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Բուենոս Այրես#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Քեմբրիջ-Բեյ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Կամպո Գրանգե#,
		},
		'America/Cancun' => {
			exemplarCity => q#Կանկուն#,
		},
		'America/Caracas' => {
			exemplarCity => q#Կարակաս#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Կատամարկա#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Կայեն#,
		},
		'America/Cayman' => {
			exemplarCity => q#Կայմանի կղզիներ#,
		},
		'America/Chicago' => {
			exemplarCity => q#Չիկագո#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Չիուաուա#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Ատիկոկան#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Կորդովա#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Կոստա Ռիկա#,
		},
		'America/Creston' => {
			exemplarCity => q#Քրեսթոն#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Կույաբա#,
		},
		'America/Curacao' => {
			exemplarCity => q#Կյուրասաո#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Դենմարքսհավն#,
		},
		'America/Dawson' => {
			exemplarCity => q#Դոուսոն#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Դոուսոն Կրիկ#,
		},
		'America/Denver' => {
			exemplarCity => q#Դենվեր#,
		},
		'America/Detroit' => {
			exemplarCity => q#Դետրոյթ#,
		},
		'America/Dominica' => {
			exemplarCity => q#Դոմինիկա#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Էդմոնտոն#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Էյրունեպե#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Սալվադոր#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Ֆորտալեզա#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Գլեյս Բեյ#,
		},
		'America/Godthab' => {
			exemplarCity => q#Նուուկ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Գուս Բեյ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Գրանդ Տուրկ#,
		},
		'America/Grenada' => {
			exemplarCity => q#Գրենադա#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Գվադելուպա#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Գվատեմալա#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Գուայակիլ#,
		},
		'America/Guyana' => {
			exemplarCity => q#Գայանա#,
		},
		'America/Halifax' => {
			exemplarCity => q#Հալիֆաքս#,
		},
		'America/Havana' => {
			exemplarCity => q#Հավանա#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Էրմոսիլյո#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Նոքս, Ինդիանա#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Մարենգո, Ինդիանա#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Պետերսբուրգ, Ինդիանա#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Թել-Սիթի, Ինդիանա#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Վիվեյ, Ինդիանա#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Վինսենս, Ինդիանա#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Վինամակ, Ինդիանա#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Ինդիանապոլիս#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Ինուվիկ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Իկալուիտ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ջամայկա#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Ժուժույ#,
		},
		'America/Juneau' => {
			exemplarCity => q#Ջունո#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Մոնտիսելո, Կենտուկի#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Կրալենդեյկ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Լա Պաս#,
		},
		'America/Lima' => {
			exemplarCity => q#Լիմա#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Լոս Անջելես#,
		},
		'America/Louisville' => {
			exemplarCity => q#Լուիսվիլ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Լոուեր Պրինսես Քվորթեր#,
		},
		'America/Maceio' => {
			exemplarCity => q#Մասեյո#,
		},
		'America/Managua' => {
			exemplarCity => q#Մանագուա#,
		},
		'America/Manaus' => {
			exemplarCity => q#Մանաուս#,
		},
		'America/Marigot' => {
			exemplarCity => q#Մարիգո#,
		},
		'America/Martinique' => {
			exemplarCity => q#Մարտինիկա#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Մատամորոս#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Մազաթլան#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Մենդոսա#,
		},
		'America/Menominee' => {
			exemplarCity => q#Մենոմինի#,
		},
		'America/Merida' => {
			exemplarCity => q#Մերիդա#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Մետլակատլա#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Մեխիկո#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Միքելոն#,
		},
		'America/Moncton' => {
			exemplarCity => q#Մոնկտոն#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Մոնտերեյ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Մոնտեվիդեո#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Մոնտսեռատ#,
		},
		'America/Nassau' => {
			exemplarCity => q#Նասաու#,
		},
		'America/New_York' => {
			exemplarCity => q#Նյու Յորք#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Նիպիգոն#,
		},
		'America/Nome' => {
			exemplarCity => q#Նոմ#,
		},
		'America/Noronha' => {
			exemplarCity => q#Նորոնխա#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Բոյլա, Հյուսիսային Դակոտա#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Հյուսիսային Դակոտա - Կենտրոն#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Նյու Սալեմ, Հյուսիսային Դակոտա#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Օխինագա#,
		},
		'America/Panama' => {
			exemplarCity => q#Պանամա#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Պանգնիրտանգ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Պարամարիբո#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Ֆինիքս#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Պորտ-օ-Պրենս#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Պորտ-օֆ-Սփեյն#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Պորտու Վելյու#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Պուերտո Ռիկո#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Ռեյնի-Ռիվեր#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ռանկին-Ինլետ#,
		},
		'America/Recife' => {
			exemplarCity => q#Ռեսիֆի#,
		},
		'America/Regina' => {
			exemplarCity => q#Ռեջայնա#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ռեզոլյուտ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Ռիո Բրանկու#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Սանտա Իսաբել#,
		},
		'America/Santarem' => {
			exemplarCity => q#Սանտարեմ#,
		},
		'America/Santiago' => {
			exemplarCity => q#Սանտյագո#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Սանտո Դոմինգո#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Սան Պաուլու#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Սկորսբիսուն#,
		},
		'America/Sitka' => {
			exemplarCity => q#Սիտկա#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Սեն Բարտելմի#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Սենթ-Ջոնս#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Սենթ Քիթս#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Սենթ Լյուսիա#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Սենթ Թոմաս#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Սենթ Վինսենթ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Սվիֆթ-Քարենտ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Տեգուսիգալպա#,
		},
		'America/Thule' => {
			exemplarCity => q#Տուլե#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Տանդեր-Բեյ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Տիխուանա#,
		},
		'America/Toronto' => {
			exemplarCity => q#Տորոնտո#,
		},
		'America/Tortola' => {
			exemplarCity => q#Տորտոլա#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Վանկուվեր#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Ուայթհորս#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Վինիպեգ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Յակուտատ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Յելոունայֆ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Միջին ամերիկյան ամառային ժամանակ),
				'generic' => q(Միջին ամերիկյան ժամանակ),
				'standard' => q(Միջին ամերիկյան ստանդարտ ժամանակ),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Արևելաամերիկյան ամառային ժամանակ),
				'generic' => q(Արևելաամերիկյան ժամանակ),
				'standard' => q(Արևելաամերիկյան ստանդարտ ժամանակ),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Լեռնային ամառային ժամանակ (Հյուսիսային Ամերիկա)),
				'generic' => q(Լեռնային ժամանակ (Հյուսիսային Ամերիկա)),
				'standard' => q(Լեռնային ստանդարտ ժամանակ (Հյուսիսային Ամերիկա)),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Խաղաղօվկիանոսային ամառային ժամանակ (Հյուսիսային Ամերիկա)),
				'generic' => q(Խաղաղօվկիանոսային ժամանակ (Հյուսիսային Ամերիկա)),
				'standard' => q(Խաղաղօվկիանոսային ստանդարտ ժամանակ (Հյուսիսային Ամերիկա)),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Քեյսի#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Դեյվիս#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Դյումոն դ'Յուրվիլ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Մակկուորի կղզի#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Մոուսոն#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Մակ-Մերդո#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Պալմեր#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ռոտերա#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Սյովա#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Վոստոկ#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(Սաուդյան Արաբիայի ամառային ժամանակ),
				'generic' => q(Սաուդյան Արաբիայի ժամանակ),
				'standard' => q(Սաուդյան Արաբիայի ստանդարտ ժամանակ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Լոնգյիր#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Արգենտինայի ամառային ժամանակ),
				'generic' => q(Արգենտինայի ժամանակ),
				'standard' => q(Արգենտինայի ստնադարտ ժամանակ),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Արևմտյան Արգենտինայի ամառային ժամանակ),
				'generic' => q(Արևմտյան Արգենտինայի ժամանակ),
				'standard' => q(Արևմտյան Արգենտինայի ստնադարտ ժամանակ),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Հայաստանի ամառային ժամանակ),
				'generic' => q(Հայաստանի ժամանակ),
				'standard' => q(Հայաստանի ստանդարտ ժամանակ),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Ադեն#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Ալմաթի#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Ամման#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Անադիր#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Ակտաու#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Ակտոբե#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Աշխաբադ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Բաղդադ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Բահրեյն#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Բաքու#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Բանգկոկ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Բեյրութ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Բիշքեկ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Բրունեյ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Կալկուտա#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Չոյբալսան#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Չունցին#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Կոլոմբո#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Դամասկոս#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Դաքքա#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Դիլի#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Դուբայ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Դուշանբե#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Գազա#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Հարբին#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Հեբրոն#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Հոնկոնգ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Հովդ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Իրկուտսկ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Ջակարտա#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Ջայպուրա#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Երուսաղեմ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Կաբուլ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Կամչատկա#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Կարաչի#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Քաշգար#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Կատմանդու#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Խանդիգա#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Կրասնոյարսկ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Կուալա Լումպուր#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Կուչինգ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Քուվեյթ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Մակաո#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Մագադան#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Մակասար#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Մանիլա#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Մուսկատ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Նիկոսիա#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Նովոկուզնեցկ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Նովոսիբիրսկ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Օմսկ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Օրալ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Պնոմպեն#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Պոնտիանակ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Փխենյան#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Կատար#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Քիզիլօրդա#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Ռանգուն#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Էր Ռիադ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Հոշիմին#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Սախալին#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Սամարղանդ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Սեուլ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Շանխայ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Սինգապուր#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Թայպեյ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Տաշքենդ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Թբիլիսի#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Թեհրան#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Թիմփու#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Տոկիո#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Ուլան Բատոր#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Ուրումչի#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Ուստ-Ներա#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Վյենտյան#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Վլադիվոստոկ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Յակուտսկ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Եկատերինբուրգ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Երևան#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Ատլատյան ամառային ժամանակ),
				'generic' => q(Ատլատյան ժամանակ),
				'standard' => q(Ատլատյան ստանդարտ ժամանակ),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Ազորյան կղզիներ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Բերմուդյան կղզիներ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Կանարյան կղզիներ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Կաբո Վերդե#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Ֆարերյան կղզիներ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Մադեյրա#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Ռեյկյավիկ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Հարավային Ջորջիա#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Սուրբ Հեղինեի կղզի#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Սթենլի#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Ադելաիդա#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Բրիսբեն#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Բրոքեն Հիլ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Քերի#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Դարվին#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Յուկլա#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Հոբարտ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Լինդեման#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Լորդ Հաու#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Մելբուրն#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Պերթ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Սիդնեյ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Կենտրոնաավստրալիական ամառային ժամանակ),
				'generic' => q(Կենտրոնաավստրալիական ժամանակ),
				'standard' => q(Կենտրոնաավստրալիական ստանդարտ ժամանակ),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Կենտրոնաավստրալիական արևմտյան ամառային ժամանակ),
				'generic' => q(Կենտրոնաավստրալիական արևմտյան ժամանակ),
				'standard' => q(Կենտրոնաավստրալիական արևմտյան ստանդարտ ժամանակ),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Արևելաավստրալիական ամառային ժամանակ),
				'generic' => q(Արևելաավստրալիական ժամանակ),
				'standard' => q(Արևելաավստրալիական ստանդարտ ժամանակ),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Արևմտաավստրալիական ամառային ժամանակ),
				'generic' => q(Արևմտաավստրալիական ժամանակ),
				'standard' => q(Արևմտաավստրալիական ստանդարտ ժամանակ),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Ադրբեջանի ամառային ժամանակ),
				'generic' => q(Ադրբեջանի ժամանակ),
				'standard' => q(Ադրբեջանի ստանդարտ ժամանակ),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Ազորյան կղզիների ամառային ժամանակ),
				'generic' => q(Ազորյան կղզիների ժամանակ),
				'standard' => q(Ազորյան կղզիների ստանդարտ ժամանակ),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Բանգլադեշի ամառային ժամանակ),
				'generic' => q(Բանգլադեշի ժամանակ),
				'standard' => q(Բանգլադեշի ստանդարտ ժամանակ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Բութանի ժամանակ),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Բոլիվիայի ժամանակ),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Բրազիլիայի ամառային ժամանակ),
				'generic' => q(Բրազիլիայի ժամանակ),
				'standard' => q(Բրազիլիայի ստանդարտ ժամանակ),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Բրունեյի ժամանակ),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Կաբո Վերդեի ամառային ժամանակ),
				'generic' => q(Կաբո Վերդեի ժամանակ),
				'standard' => q(Կաբո Վերդեի ստանդարտ ժամանակ),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Չամորոյի ժամանակ),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Չաթեմ կղզու ամառային ժամանակ),
				'generic' => q(Չաթեմ կղզու ժամանակ),
				'standard' => q(Չաթեմ կղզու ստանդարտ ժամանակ),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Չիլիի ամառային ժամանակ),
				'generic' => q(Չիլիի ժամանակ),
				'standard' => q(Չիլիի ստանդարտ ժամանակ),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Չինաստանի ամառային ժամանակ),
				'generic' => q(Չինաստանի ժամանակ),
				'standard' => q(Չինաստանի ստանդարտ ժամանակ),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Չոյբալսանի ամառային ժամանակ),
				'generic' => q(Չոյբալսանի ժամանակ),
				'standard' => q(Չոյբալսանի ստանդարտ ժամանակ),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Ծննդյան կղզու ժամանակ),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Կոկոսյան կղզիների ժամանակ),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Կոլումբիայի ամառային ժամանակ),
				'generic' => q(Կոլումբիայի ժամանակ),
				'standard' => q(Կոլումբիայի ստանդարտ ժամանակ),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Կուկի կղզիների կիսաամառային ժամանակ),
				'generic' => q(Կուկի կղզիների ժամանակ),
				'standard' => q(Կուկի կղզիների ստանդարտ ժամանակ),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Կուբայի ամառային ժամանակ),
				'generic' => q(Կուբայի ժամանակ),
				'standard' => q(Կուբայի ստանդարտ ժամանակ),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Դեյվիսի ժամանակ),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Դյումոն դ'Յուրվիլի ժամանակ),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Արևելյան Թիմորի ժամանակ),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Զատկի կղզու ամառային ժամանակ),
				'generic' => q(Զատկի կղզու ժամանակ),
				'standard' => q(Զատկի կղզու ստանդարտ ժամանակ),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Էկվադորի ժամանակ),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Անհայտ քաղաք#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Ամստերդամ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Անդորա#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Աթենք#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Բելգրադ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Բեռլին#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Բրատիսլավա#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Բրյուսել#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Բուխարեստ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Բուդապեշտ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Բյուզինգեն#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Քիշնև#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Կոպենհագեն#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Դուբլին#,
			long => {
				'daylight' => q(Իռլանդական ամառային ժամանակ),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Ջիբրալթար#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Գերնսի#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Հելսինկի#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Մեն կղզի#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Ստամբուլ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Ջերսի#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Կալինինգրադ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Կիև#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Լիսաբոն#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Լյուբլյանա#,
		},
		'Europe/London' => {
			exemplarCity => q#Լոնդոն#,
			long => {
				'daylight' => q(Բրիտանական ամառային ժամանակ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Լյուքսեմբուրգ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Մադրիդ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Մալթա#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Մարիեհամն#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Մինսկ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Մոնակո#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Մոսկվա#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Օսլո#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Փարիզ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Պոդգորիցա#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Պրահա#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Ռիգա#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Հռոմ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Սամարա#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Սան Մարինո#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Սարաևո#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Սիմֆերոպոլ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Սկոպյե#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Սոֆիա#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Ստոքհոլմ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Տալլին#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Տիրանա#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ուժգորոդ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Վադուց#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Վատիկան#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Վիեննա#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Վիլնյուս#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Վոլգոգրադ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Վարշավա#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Զագրեբ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Զապորոժյե#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Ցյուրիխ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Կենտրոնաևրոպական ամառային ժամանակ),
				'generic' => q(Կենտրոնաևրոպական ժամանակ),
				'standard' => q(Կենտրոնաևրոպական ստանդարտ ժամանակ),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Արևելաևրոպական ամառային ժամանակ),
				'generic' => q(Արևելաևրոպական ժամանակ),
				'standard' => q(Արևելաևրոպական ստանդարտ ժամանակ),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Արևմտաևրոպական ամառային ժամանակ),
				'generic' => q(Արևմտաևրոպական ժամանակ),
				'standard' => q(Արևմտաևրոպական ստանդարտ ժամանակ),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Ֆոլկլենդյան կղզիների ամառային ժամանակ),
				'generic' => q(Ֆոլկլենդյան կղզիների ժամանակ),
				'standard' => q(Ֆոլկլենդյան կղզիների ստանդարտ ժամանակ),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Ֆիջիի ամառային ժամանակ),
				'generic' => q(Ֆիջիի ժամանակ),
				'standard' => q(Ֆիջիի ստանդարտ ժամանակ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Ֆրանսիական Գվիանայի ժամանակ),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Ֆրանսիական հարավային և անտարկտիդյան ժամանակ),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Գրինվիչի ժամանակ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Գալապագոսյան կղզիների ժամանակ),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Գամբյե կղզիների ժամանակ),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Վրաստանի ամառային ժամանակ),
				'generic' => q(Վրաստանի ժամանակ),
				'standard' => q(Վրաստանի ստանդարտ ժամանակ),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Ջիլբերթի կղզիների ժամանակ),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Արևելյան Գրենլանդիայի ամառային ժամանակ),
				'generic' => q(Արևելյան Գրենլանդիայի ժամանակ),
				'standard' => q(Արևելյան Գրենլանդիայի ստանդարտ ժամանակ),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Արևմտյան Գրենլանդիայի ամառային ժամանակ),
				'generic' => q(Արևմտյան Գրենլանդիայի ժամանակ),
				'standard' => q(Արևմտյան Գրենլանդիայի ստանդարտ ժամանակ),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Պարսից ծոցի ժամանակ),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Գայանայի ժամանակ),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Հավայան-ալեուտյան ամառային ժամանակ),
				'generic' => q(Հավայան-ալեուտյան ժամանակ),
				'standard' => q(Հավայան-ալեուտյան ստանդարտ ժամանակ),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Հոնկոնգի ամառային ժամանակ),
				'generic' => q(Հոնկոնգի ժամանակ),
				'standard' => q(Հոնկոնգի ստանդարտ ժամանակ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Հովդի ամառային ժամանակ),
				'generic' => q(Հովդի ժամանակ),
				'standard' => q(Հովդի ստանդարտ ժամանակ),
			},
		},
		'India' => {
			long => {
				'standard' => q(Հնդկաստանի ժամանակ),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Անտանանարիվու#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Չագոս#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Ծննդյան կղզի#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Կոկոսյան կղզիներ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Կոմորյան կղզիներ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Կերգելեն#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Մաէ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Մալդիվյան կղզիներ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Մավրիկիոս#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Մայոտ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Ռեյունիոն#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Հնդկական օվկիանոսի ժամանակ),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Հնդկաչինական ժամանակ),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Կենտրոնական Ինդոնեզիայի ժամանակ),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Արևելյան Ինդոնեզիայի ժամանակ),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Արևմտյան Ինդոնեզիայի ժամանակ),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Պարսկաստանի ամառային ժամանակ),
				'generic' => q(Պարսկաստանի ժամանակ),
				'standard' => q(Պարսկաստանի ստանդարտ ժամանակ),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Իրկուտսկի ամառային ժամանակ),
				'generic' => q(Իրկուտսկի ժամանակ),
				'standard' => q(Իրկուտսկի ստանդարտ ժամանակ),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Իսրայելի ամառային ժամանակ),
				'generic' => q(Իսրայելի ժամանակ),
				'standard' => q(Իսրայելի ստանդարտ ժամանակ),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Ճապոնիայի ամառային ժամանակ),
				'generic' => q(Ճապոնիայի ժամանակ),
				'standard' => q(Ճապոնիայի ստանդարտ ժամանակ),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Արևելյան Ղազախստանի ժամանակ),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Արևմտյան Ղազախստանի ժամանակ),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Կորեայի ամառային ժամանակ),
				'generic' => q(Կորեայի ժամանակ),
				'standard' => q(Կորեայի ստանդարտ ժամանակ),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Կոսրաեյի ժամանակ),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Կրասնոյարսկի ամառային ժամանակ),
				'generic' => q(Կրասնոյարսկի ժամանակ),
				'standard' => q(Կրասնոյարսկի ստանդարտ ժամանակ),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Ղրղզստանի ժամանակ),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Լայն կղզիների ժամանակ),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Լորդ Հաուի ամառային ժամանակ),
				'generic' => q(Լորդ Հաուի ժամանակ),
				'standard' => q(Լորդ Հաուի ստանդարտ ժամանակ),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Մակկուորի կղզու ժամանակ),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Մագադանի ամառային ժամանակ),
				'generic' => q(Մագադանի ժամանակ),
				'standard' => q(Մագադանի ստանդարտ ժամանակ),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Մալայզիայի ժամանակ),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Մալդիվյան կղզիների ժամանակ),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Մարկիզյան կղզիների ժամանակ),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Մարշալյան կղզիների ժամանակ),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Մավրիկիոսի ամառային ժամանակ),
				'generic' => q(Մավրիկիոսի ժամանակ),
				'standard' => q(Մավրիկիոսի ստանդարտ ժամանակ),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Մոուսոնի ժամանակ),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Ուլան-Բատորի ամառային ժամանակ),
				'generic' => q(Ուլան-Բատորի ժամանակ),
				'standard' => q(Ուլան-Բատորի ստանդարտ ժամանակ),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Մոսկվայի ամառային ժամանակ),
				'generic' => q(Մոսկվայի ժամանակ),
				'standard' => q(Մոսկվայի ստանդարտ ժամանակ),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Մյանմայի ժամանակ),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Նաուրուի ժամանակ),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Նեպալի ժամանակ),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Նոր Կալեդոնիայի ամառային ժամանակ),
				'generic' => q(Նոր Կալեդոնիայի ժամանակ),
				'standard' => q(Նոր Կալեդոնիայի ստանդարտ ժամանակ),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Նոր Զելանդիայի ամառային ժամանակ),
				'generic' => q(Նոր Զելանդիայի ժամանակ),
				'standard' => q(Նոր Զելանդիայի ստանդարտ ժամանակ),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Նյուֆաունդլենդի ամառային ժամանակ),
				'generic' => q(Նյուֆաունդլենդի ժամանակ),
				'standard' => q(Նյուֆաունդլենդի ստանդարտ ժամանակ),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Նիուեյի ժամանակ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Նորֆոլկ կղզու ժամանակ),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Ֆերնանդու դի Նորոնյայի ամառային ժամանակ),
				'generic' => q(Ֆերնանդու դի Նորոնյայի ժամանակ),
				'standard' => q(Ֆերնանդու դի Նորոնյայի ստանդարտ ժամանակ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Նովոսիբիրսկի ամառային ժամանակ),
				'generic' => q(Նովոսիբիրսկի ժամանակ),
				'standard' => q(Նովոսիբիրսկի ստանդարտ ժամանակ),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Օմսկի ամառային ժամանակ),
				'generic' => q(Օմսկի ժամանակ),
				'standard' => q(Օմսկի ստանդարտ ժամանակ),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Ապիա#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Օկլենդ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Չաթեմ կղզի#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Զատիկի կղզի#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Էֆատե#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Էնդերբերի կղզի#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Ֆակաոֆո#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Ֆիջի#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Ֆունաֆուտի#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Գալապագոսյան կղզիներ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Գամբյե կղզիներ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Գուադալկանալ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Գուամ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Հոնոլուլու#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Ջոնսթոն ատոլ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Կիրիտիմատի#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Կոսրաե#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Քվաջալեյն#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Մաջուրո#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Մարկիզյան կղզիներ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Միդուեյ կղզի#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Նաուրու#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Նիուե#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Նորֆոլկ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Նումեա#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Պագո Պագո#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Պալաու#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Պիտկեռն#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Պոնպեի#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Պորտ Մորսբի#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Ռառատոնգա#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Սայպան#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Թաիթի#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Տարավա#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Տոնգատապու#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Չուուկ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Ուեյք կղզի#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Ուոլլիս#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Պակիստանի ամառային ժամանակ),
				'generic' => q(Պակիստանի ժամանակ),
				'standard' => q(Պակիստանի ստանդարտ ժամանակ),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Պալաույի ժամանակ),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Պապուա Նոր Գվինեայի ժամանակ),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Պարագվայի ամառային ժամանակ),
				'generic' => q(Պարագվայի ժամանակ),
				'standard' => q(Պարագվայի ստանդարտ ժամանակ),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Պերուի ամառային ժամանակ),
				'generic' => q(Պերուի ժամանակ),
				'standard' => q(Պերուի ստանդարտ ժամանակ),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Ֆիլիպինների ամառային ժամանակ),
				'generic' => q(Ֆիլիպինների ժամանակ),
				'standard' => q(Ֆիլիպինների ստանդարտ ժամանակ),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Ֆինիքս կղզիների ժամանակ),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Սեն Պիեր և Միկելոնի ամառային ժամանակ),
				'generic' => q(Սեն Պիեր և Միկելոնի ժամանակ),
				'standard' => q(Սեն Պիեր և Միկելոնի ստանդարտ ժամանակ),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Պիտկեռնի ժամանակ),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Պոնապե կղզու ժամանակ),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Ռեյունիոնի ժամանակ),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ռոտերայի ժամանակ),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Սախալինի ամառային ժամանակ),
				'generic' => q(Սախալինի ժամանակ),
				'standard' => q(Սախալինի ստանդարտ ժամանակ),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Սամոայի ամառային ժամանակ),
				'generic' => q(Սամոայի ժամանակ),
				'standard' => q(Սամոայի ստանդարտ ժամանակ),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Սեյշելյան կղզիների ժամանակ),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Սինգապուրի ժամանակ),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Սողոմոնյան կղզիների ժամանակ),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Հարավային Ջորջիայի ժամանակ),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Սուրինամի ժամանակ),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Սյովայի ժամանակ),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Թաիթիի ժամանակ),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Թայպեյի ամառային ժամանակ),
				'generic' => q(Թայպեյի ժամանակ),
				'standard' => q(Թայպեյի ստանդարտ ժամանակ),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Տաջիկստանի ժամանակ),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Տոկելաույի ժամանակ),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Տոնգայի ամառային ժամանակ),
				'generic' => q(Տոնգայի ժամանակ),
				'standard' => q(Տոնգայի ստանդարտ ժամանակ),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Չուուկի ժամանակ),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Թուրքմենստանի ամառային ժամանակ),
				'generic' => q(Թուրքմենստանի ժամանակ),
				'standard' => q(Թուրքմենստանի ստանդարտ ժամանակ),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Տուվալույի ժամանակ),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Ուրուգվայի ամառային ժամանակ),
				'generic' => q(Ուրուգվայի ժամանակ),
				'standard' => q(Ուրուգվայի ստանդարտ ժամանակ),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Ուզբեկստանի ամառային ժամանակ),
				'generic' => q(Ուզբեկստանի ժամանակ),
				'standard' => q(Ուզբեկստանի ստանդարտ ժամանակ),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Վանուատույի ամառային ժամանակ),
				'generic' => q(Վանուատույի ժամանակ),
				'standard' => q(Վանուատույի ստանդարտ ժամանակ),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Վենեսուելայի ժամանակ),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Վլադիվոստոկի ամառային ժամանակ),
				'generic' => q(Վլադիվոստոկի ժամանակ),
				'standard' => q(Վլադիվոստոկի ստանդարտ ժամանակ),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Վոլգոգրադի ամառային ժամանակ),
				'generic' => q(Վոլգոգրադի ժամանակ),
				'standard' => q(Վոլգոգրադի ստանդարտ ժամանակ),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Վոստոկի ժամանակ),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Ուեյք կղզու ժամանակ),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Ուոլիս և Ֆուտունայի ժամանակ),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Յակուտսկի ամառային ժամանակ),
				'generic' => q(Յակուտսկի ժամանակ),
				'standard' => q(Յակուտսկի ստանդարտ ժամանակ),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Եկատերինբուրգի ամառային ժամանակ),
				'generic' => q(Եկատերինբուրգի ժամանակ),
				'standard' => q(Եկատերինբուրգի ստանդարտ ժամանակ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
