package Locale::CLDR::Transformations::Bgn::Ar::Ar_latn;
# This file auto generated from Data\common\transforms\Arabic-Latin-BGN.xml
#	on Mon  1 Jan 10:25:01 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G(?:[\p{arabic}\p{block=ARABIC}]|[ءآابةتثجحخدذرزسشصضطظعغفقكلمنهوىيًٌٍَُِّْ٠١٢٣٤٥٦٧٨٩ٱ]))/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFKD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(\p{Nd}),
					after   => q(\p{Nd}),
					replace => q(٫),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(\p{Nd}),
					after   => q(\p{Nd}),
					replace => q(٬),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٫),
					result  => q(\'̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٬),
					result  => q(\'̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(،),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(؛),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(؟),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٪),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۰),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۱),
					result  => q(1̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۲),
					result  => q(2̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۳),
					result  => q(3̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۴),
					result  => q(4̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۵),
					result  => q(5̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۶),
					result  => q(6̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۷),
					result  => q(7̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۸),
					result  => q(8̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(۹),
					result  => q(9̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٠),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(١),
					result  => q(1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٢),
					result  => q(2),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٣),
					result  => q(3),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٤),
					result  => q(4),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٥),
					result  => q(5),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٦),
					result  => q(6),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٧),
					result  => q(7),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٨),
					result  => q(8),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(٩),
					result  => q(9),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ته),
					result  => q(t·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(كه),
					result  => q(k·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ده),
					result  => q(d·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(سه),
					result  => q(s·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(بّ),
					result  => q(bb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(تّ),
					result  => q(tt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ثّ),
					result  => q(thth),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(جّ),
					result  => q(jj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(حّ),
					result  => q(ḥḥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(خّ),
					result  => q(khkh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(دّ),
					result  => q(dd),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ذّ),
					result  => q(dhdh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(رّ),
					result  => q(rr),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(زّ),
					result  => q(zz),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(سّ),
					result  => q(ss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(شّ),
					result  => q(shsh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(صّ),
					result  => q(ṣṣ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ضّ),
					result  => q(ḍḍ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(طّ),
					result  => q(ṭṭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ظّ),
					result  => q(ẓẓ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(عّ),
					result  => q(‘‘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(غّ),
					result  => q(ghgh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(فّ),
					result  => q(ff),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(قّ),
					result  => q(qq),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(كّ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(لّ),
					result  => q(ll),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(مّ),
					result  => q(mm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(نّ),
					result  => q(nn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(هّ),
					result  => q(hh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(وّ),
					result  => q(ww),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ىّ),
					result  => q(yy),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ء),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ء),
					result  => q(’),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ا),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ٱ),
					result  => q(’),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(آ),
					result  => q(ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(آ),
					result  => q(’ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ب),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ت),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ة),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ث),
					result  => q(th),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ج),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ح),
					result  => q(ḩ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(خ),
					result  => q(kh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(د),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ذ),
					result  => q(dh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ر),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ز),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(س),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ش),
					result  => q(sh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ص),
					result  => q(ş),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ض),
					result  => q(ḑ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ط),
					result  => q(ţ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ظ),
					result  => q(z̧),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ع),
					result  => q(‘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(غ),
					result  => q(gh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ف),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ق),
					result  => q(q),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ک),
					result  => q(ḵ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ك),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ل),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(م),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ن),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ه),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(و),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ى),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(َا),
					result  => q(ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(َى),
					result  => q(á),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(َيْ),
					result  => q(ay),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(َوْ),
					result  => q(aw),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(َ),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ِي),
					result  => q(ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ِ),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ُو),
					result  => q(ū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ُ),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ْ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ً),
					result  => q(aⁿ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ٍ),
					result  => q(iⁿ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ٌ),
					result  => q(uⁿ),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
